/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tess4j;

import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.sourceforge.lept4j.Boxa;
import net.sourceforge.lept4j.Leptonica1;
import net.sourceforge.lept4j.Pix;
import net.sourceforge.lept4j.util.LeptUtils;
import net.sourceforge.tess4j.ITessAPI;
import net.sourceforge.tess4j.ITesseract;
import net.sourceforge.tess4j.OCRResult;
import net.sourceforge.tess4j.TessAPI;
import net.sourceforge.tess4j.TesseractException;
import net.sourceforge.tess4j.Word;
import net.sourceforge.tess4j.util.ImageIOHelper;
import net.sourceforge.tess4j.util.LoggHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tesseract
implements ITesseract {
    private String language = "eng";
    private String datapath;
    private int psm = -1;
    private int ocrEngineMode = 3;
    private final Properties prop = new Properties();
    private final List<String> configList = new ArrayList<String>();
    private TessAPI api;
    private ITessAPI.TessBaseAPI handle;
    private boolean alreadyInvoked;
    private static final Logger logger = LoggerFactory.getLogger((String)new LoggHelper().toString());

    public Tesseract() {
        try {
            this.datapath = System.getenv("TESSDATA_PREFIX");
        }
        catch (Exception exception) {
        }
        finally {
            if (this.datapath == null) {
                this.datapath = "./";
            }
        }
    }

    protected TessAPI getAPI() {
        return this.api;
    }

    protected ITessAPI.TessBaseAPI getHandle() {
        return this.handle;
    }

    @Override
    public void setDatapath(String string) {
        this.datapath = string;
    }

    @Override
    public void setLanguage(String string) {
        this.language = string;
    }

    @Override
    public void setOcrEngineMode(int n) {
        this.ocrEngineMode = n;
    }

    @Override
    public void setPageSegMode(int n) {
        this.psm = n;
    }

    @Override
    @Deprecated
    public void setTessVariable(String string, String string2) {
        this.setVariable(string, string2);
    }

    @Override
    public void setVariable(String string, String string2) {
        this.prop.setProperty(string, string2);
    }

    @Override
    public void setConfigs(List<String> list) {
        this.configList.clear();
        if (list != null) {
            this.configList.addAll(list);
        }
    }

    @Override
    public String doOCR(File file) throws TesseractException {
        return this.doOCR(file, (List<Rectangle>)null);
    }

    @Override
    @Deprecated
    public String doOCR(File file, Rectangle rectangle) throws TesseractException {
        return this.doOCR(file, Arrays.asList(rectangle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doOCR(File file, List<Rectangle> list) throws TesseractException {
        try {
            File file2 = ImageIOHelper.getImageFile(file);
            String string = ImageIOHelper.getImageFileFormat(file2);
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string);
            if (!iterator.hasNext()) {
                throw new RuntimeException("Unsupported image format. May need to install JAI Image I/O package.\nhttps://github.com/jai-imageio/jai-imageio-core");
            }
            ImageReader imageReader = iterator.next();
            StringBuilder stringBuilder = new StringBuilder();
            try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(file2);){
                imageReader.setInput(imageInputStream);
                int n = imageReader.getNumImages(true);
                this.init();
                this.setVariables();
                for (int i = 0; i < n; ++i) {
                    IIOImage iIOImage = imageReader.readAll(i, imageReader.getDefaultReadParam());
                    stringBuilder.append(this.doOCR(iIOImage, file.getPath(), list, i + 1));
                }
                if (String.valueOf(1).equals(this.prop.getProperty("tessedit_create_hocr"))) {
                    stringBuilder.insert(0, "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n<title></title>\n<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\" />\n<meta name='ocr-system' content='tesseract'/>\n</head>\n<body>\n").append("</body>\n</html>\n");
                }
            }
            finally {
                if (file2 != null && file2.exists() && file2 != file && file2.getName().startsWith("multipage") && file2.getName().endsWith(".tif")) {
                    file2.delete();
                }
                imageReader.dispose();
                this.dispose();
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), (Throwable)exception);
            throw new TesseractException(exception);
        }
    }

    @Override
    public String doOCR(BufferedImage bufferedImage) throws TesseractException {
        return this.doOCR(bufferedImage, null, (List<Rectangle>)null);
    }

    @Override
    @Deprecated
    public String doOCR(BufferedImage bufferedImage, Rectangle rectangle) throws TesseractException {
        return this.doOCR(bufferedImage, null, Arrays.asList(rectangle));
    }

    @Override
    public String doOCR(BufferedImage bufferedImage, String string, List<Rectangle> list) throws TesseractException {
        return this.doOCR(Arrays.asList(ImageIOHelper.getIIOImage(bufferedImage)), string, Arrays.asList(list));
    }

    @Override
    @Deprecated
    public String doOCR(List<IIOImage> list, Rectangle rectangle) throws TesseractException {
        return this.doOCR(list, null, Arrays.asList(Arrays.asList(rectangle)));
    }

    @Override
    @Deprecated
    public String doOCR(List<IIOImage> list, String string, Rectangle rectangle) throws TesseractException {
        return this.doOCR(list, string, Arrays.asList(Arrays.asList(rectangle)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doOCR(List<IIOImage> list, String string, List<List<Rectangle>> list2) throws TesseractException {
        this.init();
        this.setVariables();
        try {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            for (IIOImage iIOImage : list) {
                List<Rectangle> list3 = list2 == null || list2.isEmpty() || n >= list2.size() ? null : list2.get(n);
                stringBuilder.append(this.doOCR(iIOImage, string, list3, ++n));
            }
            if (String.valueOf(1).equals(this.prop.getProperty("tessedit_create_hocr"))) {
                stringBuilder.insert(0, "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n<title></title>\n<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\" />\n<meta name='ocr-system' content='tesseract'/>\n</head>\n<body>\n").append("</body>\n</html>\n");
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        finally {
            this.dispose();
        }
    }

    private String doOCR(IIOImage iIOImage, String string, List<Rectangle> list, int n) throws TesseractException {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            this.setImage(iIOImage.getRenderedImage());
            if (list != null && !list.isEmpty()) {
                for (Rectangle rectangle : list) {
                    this.setROI(rectangle);
                    stringBuilder.append(this.getOCRText(string, n));
                }
            } else {
                stringBuilder.append(this.getOCRText(string, n));
            }
        }
        catch (IOException iOException) {
            logger.warn(iOException.getMessage(), (Throwable)iOException);
        }
        return stringBuilder.toString();
    }

    @Override
    @Deprecated
    public String doOCR(int n, int n2, ByteBuffer byteBuffer, Rectangle rectangle, int n3) throws TesseractException {
        return this.doOCR(n, n2, byteBuffer, n3, null, Arrays.asList(rectangle));
    }

    @Override
    @Deprecated
    public String doOCR(int n, int n2, ByteBuffer byteBuffer, String string, Rectangle rectangle, int n3) throws TesseractException {
        return this.doOCR(n, n2, byteBuffer, n3, string, Arrays.asList(rectangle));
    }

    @Override
    public String doOCR(int n, int n2, ByteBuffer byteBuffer, int n3, String string, List<Rectangle> list) throws TesseractException {
        this.init();
        this.setVariables();
        try {
            StringBuilder stringBuilder = new StringBuilder();
            this.setImage(n, n2, byteBuffer, n3);
            if (list != null && !list.isEmpty()) {
                for (Rectangle rectangle : list) {
                    this.setROI(rectangle);
                    stringBuilder.append(this.getOCRText(string, 1));
                }
            } else {
                stringBuilder.append(this.getOCRText(string, 1));
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), (Throwable)exception);
            throw new TesseractException(exception);
        }
        finally {
            this.dispose();
        }
    }

    protected void init() {
        this.api = TessAPI.INSTANCE;
        this.handle = this.api.TessBaseAPICreate();
        StringArray stringArray = new StringArray(this.configList.toArray(new String[0]));
        PointerByReference pointerByReference = new PointerByReference();
        pointerByReference.setPointer((Pointer)stringArray);
        this.api.TessBaseAPIInit1(this.handle, this.datapath, this.language, this.ocrEngineMode, pointerByReference, this.configList.size());
        if (this.psm > -1) {
            this.api.TessBaseAPISetPageSegMode(this.handle, this.psm);
        }
    }

    protected void setVariables() {
        Enumeration<?> enumeration = this.prop.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.api.TessBaseAPISetVariable(this.handle, string, this.prop.getProperty(string));
        }
    }

    protected void setImage(RenderedImage renderedImage) throws IOException {
        ByteBuffer byteBuffer = ImageIOHelper.getImageByteBuffer(renderedImage);
        DataBuffer dataBuffer = renderedImage.getData(new Rectangle(1, 1)).getDataBuffer();
        int n = dataBuffer instanceof DataBufferByte ? renderedImage.getColorModel().getPixelSize() : 8;
        this.setImage(renderedImage.getWidth(), renderedImage.getHeight(), byteBuffer, n);
    }

    protected void setImage(int n, int n2, ByteBuffer byteBuffer, int n3) {
        int n4 = n3 / 8;
        int n5 = (int)Math.ceil((double)(n * n3) / 8.0);
        this.api.TessBaseAPISetImage(this.handle, byteBuffer, n, n2, n4, n5);
    }

    protected void setROI(Rectangle rectangle) {
        if (rectangle != null && !rectangle.isEmpty()) {
            this.api.TessBaseAPISetRectangle(this.handle, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected String getOCRText(String string, int n) {
        if (string != null && !string.isEmpty()) {
            this.api.TessBaseAPISetInputName(this.handle, string);
        }
        Pointer pointer = String.valueOf(1).equals(this.prop.getProperty("tessedit_create_hocr")) ? this.api.TessBaseAPIGetHOCRText(this.handle, n - 1) : (String.valueOf(1).equals(this.prop.getProperty("tessedit_write_unlv")) ? this.api.TessBaseAPIGetUNLVText(this.handle) : (String.valueOf(1).equals(this.prop.getProperty("tessedit_create_alto")) ? this.api.TessBaseAPIGetAltoText(this.handle, n - 1) : (String.valueOf(1).equals(this.prop.getProperty("tessedit_create_lstmbox")) ? this.api.TessBaseAPIGetLSTMBoxText(this.handle, n - 1) : (String.valueOf(1).equals(this.prop.getProperty("tessedit_create_tsv")) ? this.api.TessBaseAPIGetTsvText(this.handle, n - 1) : (String.valueOf(1).equals(this.prop.getProperty("tessedit_create_wordstrbox")) ? this.api.TessBaseAPIGetWordStrBoxText(this.handle, n - 1) : this.api.TessBaseAPIGetUTF8Text(this.handle))))));
        String string2 = pointer.getString(0L);
        this.api.TessDeleteText(pointer);
        return string2;
    }

    private ITessAPI.TessResultRenderer createRenderers(String string, List<ITesseract.RenderedFormat> list) {
        ITessAPI.TessResultRenderer tessResultRenderer = null;
        for (ITesseract.RenderedFormat renderedFormat : list) {
            switch (renderedFormat) {
                case TEXT: {
                    if (tessResultRenderer == null) {
                        tessResultRenderer = this.api.TessTextRendererCreate(string);
                        break;
                    }
                    this.api.TessResultRendererInsert(tessResultRenderer, this.api.TessTextRendererCreate(string));
                    break;
                }
                case HOCR: {
                    if (tessResultRenderer == null) {
                        tessResultRenderer = this.api.TessHOcrRendererCreate(string);
                        break;
                    }
                    this.api.TessResultRendererInsert(tessResultRenderer, this.api.TessHOcrRendererCreate(string));
                    break;
                }
                case PDF: 
                case PDF_TEXTONLY: {
                    boolean bl;
                    String string2 = this.api.TessBaseAPIGetDatapath(this.handle);
                    boolean bl2 = bl = String.valueOf(1).equals(this.prop.getProperty("textonly_pdf")) || renderedFormat == ITesseract.RenderedFormat.PDF_TEXTONLY;
                    if (tessResultRenderer == null) {
                        tessResultRenderer = this.api.TessPDFRendererCreate(string, string2, bl ? 1 : 0);
                        break;
                    }
                    this.api.TessResultRendererInsert(tessResultRenderer, this.api.TessPDFRendererCreate(string, string2, bl ? 1 : 0));
                    break;
                }
                case BOX: {
                    if (tessResultRenderer == null) {
                        tessResultRenderer = this.api.TessBoxTextRendererCreate(string);
                        break;
                    }
                    this.api.TessResultRendererInsert(tessResultRenderer, this.api.TessBoxTextRendererCreate(string));
                    break;
                }
                case UNLV: {
                    if (tessResultRenderer == null) {
                        tessResultRenderer = this.api.TessUnlvRendererCreate(string);
                        break;
                    }
                    this.api.TessResultRendererInsert(tessResultRenderer, this.api.TessUnlvRendererCreate(string));
                    break;
                }
                case ALTO: {
                    if (tessResultRenderer == null) {
                        tessResultRenderer = this.api.TessAltoRendererCreate(string);
                        break;
                    }
                    this.api.TessResultRendererInsert(tessResultRenderer, this.api.TessAltoRendererCreate(string));
                    break;
                }
                case TSV: {
                    if (tessResultRenderer == null) {
                        tessResultRenderer = this.api.TessTsvRendererCreate(string);
                        break;
                    }
                    this.api.TessResultRendererInsert(tessResultRenderer, this.api.TessTsvRendererCreate(string));
                    break;
                }
                case LSTMBOX: {
                    if (tessResultRenderer == null) {
                        tessResultRenderer = this.api.TessLSTMBoxRendererCreate(string);
                        break;
                    }
                    this.api.TessResultRendererInsert(tessResultRenderer, this.api.TessLSTMBoxRendererCreate(string));
                    break;
                }
                case WORDSTRBOX: {
                    if (tessResultRenderer == null) {
                        tessResultRenderer = this.api.TessWordStrBoxRendererCreate(string);
                        break;
                    }
                    this.api.TessResultRendererInsert(tessResultRenderer, this.api.TessWordStrBoxRendererCreate(string));
                }
            }
        }
        return tessResultRenderer;
    }

    @Override
    public void createDocuments(String string, String string2, List<ITesseract.RenderedFormat> list) throws TesseractException {
        this.createDocuments(new String[]{string}, new String[]{string2}, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDocuments(String[] stringArray, String[] stringArray2, List<ITesseract.RenderedFormat> list) throws TesseractException {
        if (stringArray.length != stringArray2.length) {
            throw new RuntimeException("The two arrays must match in length.");
        }
        this.init();
        this.setVariables();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(stringArray[i]);
                File file2 = null;
                try {
                    file2 = ImageIOHelper.getImageFile(file);
                    ITessAPI.TessResultRenderer tessResultRenderer = this.createRenderers(stringArray2[i], list);
                    this.createDocuments(file2.getPath(), tessResultRenderer);
                    this.api.TessDeleteResultRenderer(tessResultRenderer);
                    continue;
                }
                catch (Exception exception) {
                    logger.warn(exception.getMessage(), (Throwable)exception);
                    continue;
                }
                finally {
                    if (file2 != null && file2.exists() && file2 != file && file2.getName().startsWith("multipage") && file2.getName().endsWith(".tif")) {
                        file2.delete();
                    }
                }
            }
        }
        finally {
            this.dispose();
        }
    }

    private int createDocuments(String string, ITessAPI.TessResultRenderer tessResultRenderer) throws TesseractException {
        this.api.TessBaseAPISetInputName(this.handle, string);
        int n = this.api.TessBaseAPIProcessPages(this.handle, string, null, 0, tessResultRenderer);
        return this.api.TessBaseAPIMeanTextConf(this.handle);
    }

    private int createDocuments(BufferedImage bufferedImage, String string, ITessAPI.TessResultRenderer tessResultRenderer) throws Exception {
        Pix pix = LeptUtils.convertImageToPix((BufferedImage)bufferedImage);
        String string2 = this.api.TessBaseAPIGetStringVariable(this.handle, "document_title");
        this.api.TessResultRendererBeginDocument(tessResultRenderer, string2);
        int n = this.api.TessBaseAPIProcessPage(this.handle, pix, 0, string, null, 0, tessResultRenderer);
        this.api.TessResultRendererEndDocument(tessResultRenderer);
        LeptUtils.dispose((Structure)pix);
        return this.api.TessBaseAPIMeanTextConf(this.handle);
    }

    @Override
    public List<Rectangle> getSegmentedRegions(BufferedImage bufferedImage, int n) throws TesseractException {
        this.init();
        this.setVariables();
        try {
            Object object;
            ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
            this.setImage(bufferedImage);
            Boxa boxa = this.api.TessBaseAPIGetComponentImages(this.handle, n, 1, null, null);
            int n2 = Leptonica1.boxaGetCount((Boxa)boxa);
            for (int i = 0; i < n2; ++i) {
                object = Leptonica1.boxaGetBox((Boxa)boxa, (int)i, (int)2);
                if (object == null) continue;
                arrayList.add(new Rectangle(object.x, object.y, object.w, object.h));
                PointerByReference pointerByReference = new PointerByReference();
                pointerByReference.setValue(object.getPointer());
                Leptonica1.boxDestroy((PointerByReference)pointerByReference);
            }
            PointerByReference pointerByReference = new PointerByReference();
            pointerByReference.setValue(boxa.getPointer());
            Leptonica1.boxaDestroy((PointerByReference)pointerByReference);
            object = arrayList;
            return object;
        }
        catch (IOException iOException) {
            logger.warn(iOException.getMessage(), (Throwable)iOException);
            throw new TesseractException(iOException);
        }
        finally {
            this.dispose();
        }
    }

    @Override
    public List<Word> getWords(BufferedImage bufferedImage, int n) {
        return this.getWords(Arrays.asList(bufferedImage), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Word> getWords(List<BufferedImage> list, int n) {
        if (!this.alreadyInvoked) {
            this.init();
            this.setVariables();
        }
        String string = this.api.TessBaseAPIGetStringVariable(this.handle, "page_separator");
        ArrayList<Word> arrayList = new ArrayList<Word>();
        try {
            for (BufferedImage bufferedImage : list) {
                this.setImage(bufferedImage);
                this.api.TessBaseAPIRecognize(this.handle, null);
                ITessAPI.TessResultIterator tessResultIterator = this.api.TessBaseAPIGetIterator(this.handle);
                ITessAPI.TessPageIterator tessPageIterator = this.api.TessResultIteratorGetPageIterator(tessResultIterator);
                this.api.TessPageIteratorBegin(tessPageIterator);
                do {
                    Pointer pointer;
                    if ((pointer = this.api.TessResultIteratorGetUTF8Text(tessResultIterator, n)) == null) continue;
                    String string2 = pointer.getString(0L);
                    this.api.TessDeleteText(pointer);
                    float f = this.api.TessResultIteratorConfidence(tessResultIterator, n);
                    IntBuffer intBuffer = IntBuffer.allocate(1);
                    IntBuffer intBuffer2 = IntBuffer.allocate(1);
                    IntBuffer intBuffer3 = IntBuffer.allocate(1);
                    IntBuffer intBuffer4 = IntBuffer.allocate(1);
                    this.api.TessPageIteratorBoundingBox(tessPageIterator, n, intBuffer, intBuffer2, intBuffer3, intBuffer4);
                    int n2 = intBuffer.get();
                    int n3 = intBuffer2.get();
                    int n4 = intBuffer3.get();
                    int n5 = intBuffer4.get();
                    Word word = new Word(string2, f, new Rectangle(n2, n3, n4 - n2, n5 - n3));
                    arrayList.add(word);
                } while (this.api.TessPageIteratorNext(tessPageIterator, n) == 1);
                this.api.TessResultIteratorDelete(tessResultIterator);
                arrayList.add(new Word(string, 100.0f, new Rectangle()));
            }
            if (!arrayList.isEmpty()) {
                arrayList.remove(arrayList.size() - 1);
            }
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage(), (Throwable)exception);
        }
        finally {
            if (!this.alreadyInvoked) {
                this.dispose();
            }
        }
        return arrayList;
    }

    @Override
    public OCRResult createDocumentsWithResults(BufferedImage bufferedImage, String string, String string2, List<ITesseract.RenderedFormat> list, int n) throws TesseractException {
        List<OCRResult> list2 = this.createDocumentsWithResults(new BufferedImage[]{bufferedImage}, new String[]{string}, new String[]{string2}, list, n);
        if (!list2.isEmpty()) {
            return list2.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OCRResult> createDocumentsWithResults(BufferedImage[] bufferedImageArray, String[] stringArray, String[] stringArray2, List<ITesseract.RenderedFormat> list, int n) throws TesseractException {
        if (bufferedImageArray.length != stringArray.length || bufferedImageArray.length != stringArray2.length) {
            throw new RuntimeException("The three arrays must match in length.");
        }
        this.init();
        this.setVariables();
        ArrayList<OCRResult> arrayList = new ArrayList<OCRResult>();
        try {
            for (int i = 0; i < bufferedImageArray.length; ++i) {
                try {
                    ITessAPI.TessResultRenderer tessResultRenderer = this.createRenderers(stringArray2[i], list);
                    int n2 = this.createDocuments(bufferedImageArray[i], stringArray[i], tessResultRenderer);
                    this.api.TessDeleteResultRenderer(tessResultRenderer);
                    ArrayList<Word> arrayList2 = n2 > 0 ? this.getRecognizedWords(n) : new ArrayList();
                    arrayList.add(new OCRResult(n2, arrayList2));
                    continue;
                }
                catch (Exception exception) {
                    logger.warn(exception.getMessage(), (Throwable)exception);
                }
            }
        }
        finally {
            this.dispose();
        }
        return arrayList;
    }

    @Override
    public OCRResult createDocumentsWithResults(String string, String string2, List<ITesseract.RenderedFormat> list, int n) throws TesseractException {
        List<OCRResult> list2 = this.createDocumentsWithResults(new String[]{string}, new String[]{string2}, list, n);
        if (!list2.isEmpty()) {
            return list2.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OCRResult> createDocumentsWithResults(String[] stringArray, String[] stringArray2, List<ITesseract.RenderedFormat> list, int n) throws TesseractException {
        if (stringArray.length != stringArray2.length) {
            throw new RuntimeException("The two arrays must match in length.");
        }
        this.init();
        this.setVariables();
        ArrayList<OCRResult> arrayList = new ArrayList<OCRResult>();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(stringArray[i]);
                File file2 = null;
                try {
                    file2 = ImageIOHelper.getImageFile(file);
                    ITessAPI.TessResultRenderer tessResultRenderer = this.createRenderers(stringArray2[i], list);
                    int n2 = this.createDocuments(file2.getPath(), tessResultRenderer);
                    this.api.TessDeleteResultRenderer(tessResultRenderer);
                    ArrayList<Word> arrayList2 = n2 > 0 ? this.getRecognizedWords(file2, n) : new ArrayList();
                    arrayList.add(new OCRResult(n2, arrayList2));
                    continue;
                }
                catch (Exception exception) {
                    logger.warn(exception.getMessage(), (Throwable)exception);
                    continue;
                }
                finally {
                    if (file2 != null && file2.exists() && file2 != file && file2.getName().startsWith("multipage") && file2.getName().endsWith(".tif")) {
                        file2.delete();
                    }
                }
            }
        }
        finally {
            this.dispose();
        }
        return arrayList;
    }

    private List<Word> getRecognizedWords(int n) {
        ArrayList<Word> arrayList = new ArrayList<Word>();
        try {
            ITessAPI.TessResultIterator tessResultIterator = this.api.TessBaseAPIGetIterator(this.handle);
            ITessAPI.TessPageIterator tessPageIterator = this.api.TessResultIteratorGetPageIterator(tessResultIterator);
            this.api.TessPageIteratorBegin(tessPageIterator);
            do {
                Pointer pointer;
                if ((pointer = this.api.TessResultIteratorGetUTF8Text(tessResultIterator, n)) == null) continue;
                String string = pointer.getString(0L);
                this.api.TessDeleteText(pointer);
                float f = this.api.TessResultIteratorConfidence(tessResultIterator, n);
                IntBuffer intBuffer = IntBuffer.allocate(1);
                IntBuffer intBuffer2 = IntBuffer.allocate(1);
                IntBuffer intBuffer3 = IntBuffer.allocate(1);
                IntBuffer intBuffer4 = IntBuffer.allocate(1);
                this.api.TessPageIteratorBoundingBox(tessPageIterator, n, intBuffer, intBuffer2, intBuffer3, intBuffer4);
                int n2 = intBuffer.get();
                int n3 = intBuffer2.get();
                int n4 = intBuffer3.get();
                int n5 = intBuffer4.get();
                Word word = new Word(string, f, new Rectangle(n2, n3, n4 - n2, n5 - n3));
                arrayList.add(word);
            } while (this.api.TessPageIteratorNext(tessPageIterator, n) == 1);
            this.api.TessResultIteratorDelete(tessResultIterator);
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage(), (Throwable)exception);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Word> getRecognizedWords(File file, int n) {
        ArrayList<Word> arrayList = new ArrayList<Word>();
        try {
            List<BufferedImage> list = ImageIOHelper.getImageList(file);
            if (list.isEmpty()) {
                ArrayList<Word> arrayList2 = arrayList;
                return arrayList2;
            }
            if (list.size() == 1) {
                List<Word> list2 = this.getRecognizedWords(n);
                return list2;
            }
            this.alreadyInvoked = true;
            List<Word> list3 = this.getWords(list, n);
            return list3;
        }
        catch (IOException iOException) {
            logger.warn(iOException.getMessage(), (Throwable)iOException);
        }
        finally {
            this.alreadyInvoked = false;
        }
        return arrayList;
    }

    protected void dispose() {
        if (this.api != null && this.handle != null) {
            this.api.TessBaseAPIDelete(this.handle);
        }
    }
}

