/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency;

import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="display-ancestors", threadSafe=true, requiresProject=true, defaultPhase=LifecyclePhase.VALIDATE)
public class DisplayAncestorsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArrayList<String> ancestors = this.collectAncestors();
        if (ancestors.isEmpty()) {
            this.getLog().info((CharSequence)"No Ancestor POMs!");
        } else {
            this.getLog().info((CharSequence)String.format(Locale.US, "Ancestor POMs: %s", StringUtils.join(ancestors, (String)" <- ")));
        }
    }

    private ArrayList<String> collectAncestors() {
        ArrayList<String> ancestors = new ArrayList<String>();
        for (MavenProject currentAncestor = this.project.getParent(); currentAncestor != null; currentAncestor = currentAncestor.getParent()) {
            String gav = String.format(Locale.US, "%s:%s:%s", currentAncestor.getGroupId(), currentAncestor.getArtifactId(), currentAncestor.getVersion());
            ancestors.add(gav);
        }
        return ancestors;
    }
}

