/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.statistics;

import java.util.concurrent.TimeUnit;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.spi.service.StatisticsServiceConfiguration;

public class DefaultStatisticsServiceConfiguration
implements StatisticsServiceConfiguration {
    private long latencyHistoryWindow = 500L;
    private TimeUnit latencyHistoryWindowUnit = TimeUnit.MILLISECONDS;
    private int latencyHistorySize = 3600000 / (int)this.latencyHistoryWindow;

    @Override
    public long getLatencyHistoryWindowInterval() {
        return this.latencyHistoryWindow;
    }

    @Override
    public TimeUnit getLatencyHistoryWindowUnit() {
        return this.latencyHistoryWindowUnit;
    }

    @Override
    public int getLatencyHistorySize() {
        return this.latencyHistorySize;
    }

    public DefaultStatisticsServiceConfiguration withLatencyHistoryWindow(long duration, TimeUnit unit) {
        if (duration <= 0L) {
            throw new IllegalArgumentException("Window must be a positive integer");
        }
        this.latencyHistoryWindow = duration;
        this.latencyHistoryWindowUnit = unit;
        return this;
    }

    public DefaultStatisticsServiceConfiguration withLatencyHistorySize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Latency history size must be a positive integer");
        }
        this.latencyHistorySize = size;
        return this;
    }

    @Override
    public Class<StatisticsService> getServiceType() {
        return StatisticsService.class;
    }
}

