/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.impl.Parser;
import com.sonar.sslr.impl.ast.AstWalker;
import java.io.File;
import java.io.InterruptedIOException;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.squidbridge.AstScannerExceptionHandler;
import org.sonar.squidbridge.CommentAnalyser;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.SquidAstVisitorContextImpl;
import org.sonar.squidbridge.api.AnalysisException;
import org.sonar.squidbridge.api.SourceCodeSearchEngine;
import org.sonar.squidbridge.api.SourceCodeTreeDecorator;
import org.sonar.squidbridge.api.SourceProject;
import org.sonar.squidbridge.indexer.SquidIndex;
import org.sonar.squidbridge.measures.MetricDef;

public class AstScanner<G extends Grammar> {
    private static final Logger LOG = LoggerFactory.getLogger(AstScanner.class);
    private final List<SquidAstVisitor<G>> visitors;
    private final Parser<G> parser;
    private final SquidAstVisitorContextImpl<G> context;
    private final SquidIndex indexer = new SquidIndex();
    private final MetricDef[] metrics;
    private final MetricDef filesMetric;

    protected AstScanner(Builder<G> builder) {
        this.visitors = Lists.newArrayList((Iterable)((Builder)builder).visitors);
        this.parser = ((Builder)builder).baseParser;
        this.context = ((Builder)builder).context;
        this.context.setGrammar(this.parser.getGrammar());
        this.context.getProject().setSourceCodeIndexer(this.indexer);
        this.context.setCommentAnalyser(((Builder)builder).commentAnalyser);
        this.metrics = ((Builder)builder).metrics;
        this.filesMetric = ((Builder)builder).filesMetric;
        this.indexer.index(this.context.getProject());
    }

    public SourceCodeSearchEngine getIndex() {
        return this.indexer;
    }

    public void scanFile(File file) {
        this.scanFiles((Collection<File>)ImmutableList.of((Object)file));
    }

    public void scanFiles(Collection<File> files) {
        for (SquidAstVisitor<G> visitor : this.visitors) {
            visitor.init();
        }
        AstWalker astWalker = new AstWalker(this.visitors);
        for (File file : files) {
            AstScanner.checkCancel();
            this.context.setFile(file, this.filesMetric);
            Throwable parseException = null;
            AstNode ast = null;
            try {
                ast = this.parser.parse(file);
            }
            catch (RecognitionException e) {
                AstScanner.checkInterrupted((Exception)((Object)e));
                parseException = e;
                LOG.error("Unable to parse file: " + file.getAbsolutePath());
                LOG.error(e.getMessage());
            }
            catch (Exception e) {
                AstScanner.checkInterrupted(e);
                parseException = e;
                LOG.error("Unable to parse file: " + file.getAbsolutePath(), (Throwable)e);
            }
            catch (Throwable e) {
                throw new AnalysisException("Unable to parse file: " + file.getAbsolutePath(), e);
            }
            try {
                if (parseException == null) {
                    astWalker.walkAndVisit(ast);
                } else {
                    for (SquidAstVisitor<G> visitor : this.visitors) {
                        visitor.visitFile(ast);
                    }
                    for (SquidAstVisitor<G> visitor : this.visitors) {
                        if (!(visitor instanceof AstScannerExceptionHandler)) continue;
                        if (parseException instanceof RecognitionException) {
                            ((AstScannerExceptionHandler)((Object)visitor)).processRecognitionException((RecognitionException)parseException);
                            continue;
                        }
                        ((AstScannerExceptionHandler)((Object)visitor)).processException((Exception)parseException);
                    }
                    for (SquidAstVisitor<G> visitor : this.visitors) {
                        visitor.leaveFile(ast);
                    }
                }
                this.context.popTillSourceProject();
            }
            catch (Throwable e) {
                throw new AnalysisException("Unable to analyze file: " + file.getAbsolutePath(), e);
            }
        }
        for (SquidAstVisitor squidAstVisitor : this.visitors) {
            squidAstVisitor.destroy();
        }
        this.decorateSquidTree();
    }

    private static void checkInterrupted(Exception e) {
        Throwable cause = Throwables.getRootCause((Throwable)e);
        if (cause instanceof InterruptedException || cause instanceof InterruptedIOException) {
            throw new AnalysisException("Analysis cancelled", e);
        }
    }

    private static void checkCancel() {
        if (Thread.interrupted()) {
            throw new AnalysisException("Analysis cancelled");
        }
    }

    protected void decorateSquidTree() {
        if (this.metrics != null && this.metrics.length > 0) {
            SourceProject project = this.context.getProject();
            SourceCodeTreeDecorator decorator = new SourceCodeTreeDecorator(project);
            decorator.decorateWith(this.metrics);
        }
    }

    public static <G extends Grammar> Builder<G> builder(SquidAstVisitorContextImpl<G> context) {
        return new Builder<G>(context);
    }

    public static class Builder<G extends Grammar> {
        private Parser<G> baseParser;
        private final List<SquidAstVisitor<G>> visitors = Lists.newArrayList();
        private final SquidAstVisitorContextImpl<G> context;
        private CommentAnalyser commentAnalyser;
        private MetricDef[] metrics;
        private MetricDef filesMetric;

        public Builder(SquidAstVisitorContextImpl<G> context) {
            Preconditions.checkNotNull(context, (Object)"context cannot be null");
            this.context = context;
        }

        public Builder<G> setBaseParser(Parser<G> baseParser) {
            Preconditions.checkNotNull(baseParser, (Object)"baseParser cannot be null");
            this.baseParser = baseParser;
            return this;
        }

        public Builder<G> setCommentAnalyser(CommentAnalyser commentAnalyser) {
            Preconditions.checkNotNull((Object)commentAnalyser, (Object)"commentAnalyser cannot be null");
            this.commentAnalyser = commentAnalyser;
            return this;
        }

        public Builder<G> withSquidAstVisitor(SquidAstVisitor<G> visitor) {
            Preconditions.checkNotNull(visitor, (Object)"visitor cannot be null");
            visitor.setContext(this.context);
            this.visitors.add(visitor);
            return this;
        }

        public Builder<G> withMetrics(MetricDef ... metrics) {
            for (MetricDef metric : metrics) {
                Preconditions.checkNotNull((Object)metric, (Object)"metrics cannot be null");
            }
            this.metrics = metrics;
            return this;
        }

        public Builder<G> setFilesMetric(MetricDef filesMetric) {
            Preconditions.checkNotNull((Object)filesMetric, (Object)"filesMetric cannot be null");
            this.filesMetric = filesMetric;
            return this;
        }

        public AstScanner<G> build() {
            Preconditions.checkState((this.baseParser != null ? 1 : 0) != 0, (Object)"baseParser must be set");
            Preconditions.checkState((this.commentAnalyser != null ? 1 : 0) != 0, (Object)"commentAnalyser must be set");
            Preconditions.checkState((this.filesMetric != null ? 1 : 0) != 0, (Object)"filesMetric must be set");
            return new AstScanner(this);
        }
    }
}

