/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.checks;

import com.google.common.base.Preconditions;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import java.util.regex.Pattern;
import org.sonar.api.utils.SonarException;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

public abstract class AbstractNamingCheck<G extends Grammar>
extends SquidCheck<G> {
    private Pattern pattern;

    public abstract AstNodeType[] getRules();

    public abstract String getName(AstNode var1);

    public abstract String getRegexp();

    public abstract String getMessage(String var1);

    public abstract boolean isExcluded(AstNode var1);

    @Override
    public void init() {
        AstNodeType[] rules = this.getRules();
        Preconditions.checkNotNull((Object)rules, (Object)"getRules() must not return null");
        Preconditions.checkArgument((rules.length > 0 ? 1 : 0) != 0, (Object)"getRules() must return at least one rule");
        this.subscribeTo(this.getRules());
        String regexp = this.getRegexp();
        Preconditions.checkNotNull((Object)regexp, (Object)"getRegexp() must not return null");
        try {
            this.pattern = Pattern.compile(regexp);
        }
        catch (Exception e) {
            throw new SonarException("Unable to compile regular expression: " + regexp, (Throwable)e);
        }
    }

    @Override
    public void visitNode(AstNode astNode) {
        if (!this.isExcluded(astNode)) {
            String name = this.getName(astNode);
            Preconditions.checkNotNull((Object)name, (Object)"getName() must not return null");
            if (!this.pattern.matcher(name).matches()) {
                this.getContext().createLineViolation((CodeCheck)this, this.getMessage(name), astNode, new Object[0]);
            }
        }
    }
}

