/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.checks;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import org.sonar.squidbridge.api.CheckMessage;
import org.sonar.squidbridge.checks.SquidCheck;

public abstract class AbstractNoSonarCheck<G extends Grammar>
extends SquidCheck<G>
implements AstAndTokenVisitor {
    public void visitToken(Token token) {
        for (Trivia trivia : token.getTrivia()) {
            if (!trivia.isComment()) continue;
            String[] commentLines = this.getContext().getCommentAnalyser().getContents(trivia.getToken().getOriginalValue()).split("(\r)?\n|\r", -1);
            int line = trivia.getToken().getLine();
            for (String commentLine : commentLines) {
                if (commentLine.contains("NOSONAR")) {
                    CheckMessage violation = new CheckMessage((Object)this, "Is NOSONAR usage acceptable or does it hide a real quality flaw?", new Object[0]);
                    violation.setLine(line);
                    violation.setBypassExclusion(true);
                    this.getContext().log(violation);
                }
                ++line;
            }
        }
    }
}

