/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.checks;

import com.google.common.base.Strings;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.xpath.api.AstNodeXPathQuery;
import java.util.List;
import org.sonar.api.utils.SonarException;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

public abstract class AbstractXPathCheck<G extends Grammar>
extends SquidCheck<G> {
    private AstNodeXPathQuery<Object> query = null;

    public abstract String getXPathQuery();

    public abstract String getMessage();

    @Override
    public void init() {
        String xpath = this.getXPathQuery();
        if (!Strings.isNullOrEmpty((String)xpath)) {
            try {
                this.query = AstNodeXPathQuery.create((String)this.getXPathQuery());
            }
            catch (RuntimeException e) {
                throw new SonarException("Unable to initialize the XPath engine, perhaps because of an invalid query: " + xpath, (Throwable)e);
            }
        }
    }

    @Override
    public void visitFile(AstNode fileNode) {
        if (this.query != null && fileNode != null) {
            List objects = this.query.selectNodes(fileNode);
            for (Object object : objects) {
                if (object instanceof AstNode) {
                    AstNode astNode = (AstNode)object;
                    this.getContext().createLineViolation((CodeCheck)this, this.getMessage(), astNode.getTokenLine(), new Object[0]);
                    continue;
                }
                if (!(object instanceof Boolean) || !((Boolean)object).booleanValue()) continue;
                this.getContext().createFileViolation(this, this.getMessage(), new Object[0]);
            }
        }
    }
}

