/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.checks;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultiset;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.api.CheckMessage;

public class ViolationCounterCheck<G extends Grammar>
extends SquidAstVisitor<G> {
    private final ViolationCounter violationCounter;
    private final String projectsDirCanonicalPath;

    public ViolationCounterCheck(String projectsDir, ViolationCounter violationCounter) {
        try {
            this.projectsDirCanonicalPath = new File(projectsDir).getCanonicalPath();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.violationCounter = violationCounter;
    }

    @Override
    public void leaveFile(AstNode node) {
        HashSet<CheckMessage> violationsOnCurrentFile = new HashSet<CheckMessage>(this.getContext().peekSourceCode().getCheckMessages());
        for (CheckMessage violation : violationsOnCurrentFile) {
            this.violationCounter.increment(this.getRelativePath(this.getContext().getFile()), violation.getChecker().getClass().getSimpleName(), violation.getLine() == null ? -1 : violation.getLine());
        }
    }

    private String getRelativePath(File file) {
        String canonicalPath;
        if (!file.exists()) {
            throw new IllegalArgumentException("The file located at \"" + file.getAbsolutePath() + "\" does not exist.");
        }
        try {
            canonicalPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        if (!canonicalPath.startsWith(this.projectsDirCanonicalPath)) {
            throw new IllegalArgumentException("The file located at \"" + canonicalPath + "\" is not within projectsDir (\"" + this.projectsDirCanonicalPath + "\").");
        }
        return canonicalPath.substring(this.projectsDirCanonicalPath.length()).replace('\\', '/');
    }

    public static class ViolationDifferenceAnalyzer {
        private final ViolationCounter expected;
        private final ViolationCounter actual;
        private boolean hasDifferences = false;

        public ViolationDifferenceAnalyzer(ViolationCounter expected, ViolationCounter actual) {
            this.expected = expected;
            this.actual = actual;
        }

        private static void println() {
            System.out.println();
        }

        private static void println(String msg) {
            System.out.println(msg);
        }

        public void printReport() {
            ViolationDifferenceAnalyzer.println();
            ViolationDifferenceAnalyzer.println();
            ViolationDifferenceAnalyzer.println("********************************");
            ViolationDifferenceAnalyzer.println("* Violation differences report *");
            ViolationDifferenceAnalyzer.println("********************************");
            ViolationDifferenceAnalyzer.println();
            ViolationDifferenceAnalyzer.println();
            this.printDifferencesByFile();
            ViolationDifferenceAnalyzer.println();
            ViolationDifferenceAnalyzer.println();
            this.printDifferencesByRule();
            ViolationDifferenceAnalyzer.println();
            ViolationDifferenceAnalyzer.println();
            ViolationDifferenceAnalyzer.println("*****************");
            ViolationDifferenceAnalyzer.println("* End of report *");
            ViolationDifferenceAnalyzer.println("*****************");
            ViolationDifferenceAnalyzer.println();
            ViolationDifferenceAnalyzer.println();
        }

        private void printDifferencesByFile() {
            boolean shouldPrintHeader;
            ViolationDifferenceAnalyzer.println("Differences by file:");
            HashSet handledFilesRules = Sets.newHashSet();
            for (String file : this.expected.violationsByFileAndRule.keySet()) {
                shouldPrintHeader = true;
                for (String rule : ((Map)this.expected.violationsByFileAndRule.get(file)).keySet()) {
                    handledFilesRules.add(Maps.immutableEntry((Object)file, (Object)rule));
                    shouldPrintHeader = this.printDifferencesByFileAndRule(shouldPrintHeader, file, rule);
                }
            }
            for (String file : this.actual.violationsByFileAndRule.keySet()) {
                shouldPrintHeader = true;
                for (String rule : ((Map)this.actual.violationsByFileAndRule.get(file)).keySet()) {
                    if (handledFilesRules.contains(Maps.immutableEntry((Object)file, (Object)rule))) continue;
                    shouldPrintHeader = this.printDifferencesByFileAndRule(shouldPrintHeader, file, rule);
                }
            }
            ViolationDifferenceAnalyzer.println("End of differences by file.");
        }

        private static void printDifferencesByFileHeader(String file) {
            ViolationDifferenceAnalyzer.println("  File " + file + ":");
        }

        private boolean printDifferencesByFileAndRule(boolean shouldPrintHeader, String file, String rule) {
            TreeMultiset<Integer> linesActual;
            TreeMultiset<Integer> linesExpected = ViolationDifferenceAnalyzer.getLines(this.expected, file, rule);
            if (!linesExpected.equals(linesActual = ViolationDifferenceAnalyzer.getLines(this.actual, file, rule))) {
                this.hasDifferences = true;
                if (shouldPrintHeader) {
                    ViolationDifferenceAnalyzer.printDifferencesByFileHeader(file);
                }
                ViolationDifferenceAnalyzer.println("    " + rule + ", (difference only) expected (" + StringUtils.join(ViolationDifferenceAnalyzer.setDifference(linesExpected, linesActual), (String)",") + "), actual (" + StringUtils.join(ViolationDifferenceAnalyzer.setDifference(linesActual, linesExpected), (String)",") + ").");
                return false;
            }
            return shouldPrintHeader;
        }

        private static TreeMultiset<Integer> getLines(ViolationCounter counter, String file, String rule) {
            if (!counter.violationsByFileAndRule.containsKey(file) || !((Map)counter.violationsByFileAndRule.get(file)).containsKey(rule)) {
                return TreeMultiset.create();
            }
            return (TreeMultiset)((Map)counter.violationsByFileAndRule.get(file)).get(rule);
        }

        private static TreeMultiset<Integer> setDifference(TreeMultiset<Integer> a, TreeMultiset<Integer> b) {
            TreeMultiset aMinusB = TreeMultiset.create(a);
            aMinusB.removeAll(b);
            return aMinusB;
        }

        private void printDifferencesByRule() {
            ViolationDifferenceAnalyzer.println("Differences by rule:");
            for (String rule : this.getRules()) {
                int expectedViolations = ViolationDifferenceAnalyzer.getViolationsByRule(this.expected, rule);
                int actualViolations = ViolationDifferenceAnalyzer.getViolationsByRule(this.actual, rule);
                ViolationDifferenceAnalyzer.println("  " + rule + " expected: " + expectedViolations + ", actual: " + actualViolations + ": " + (expectedViolations == actualViolations ? "OK" : "*** FAILURE ***"));
            }
            ViolationDifferenceAnalyzer.println("End of differences by rule.");
        }

        private Set<String> getRules() {
            HashSet<String> rules = new HashSet<String>();
            for (String file : this.expected.violationsByFileAndRule.keySet()) {
                rules.addAll(((Map)this.expected.violationsByFileAndRule.get(file)).keySet());
            }
            for (String file : this.actual.violationsByFileAndRule.keySet()) {
                rules.addAll(((Map)this.actual.violationsByFileAndRule.get(file)).keySet());
            }
            return rules;
        }

        private static int getViolationsByRule(ViolationCounter counter, String rule) {
            int violations = 0;
            for (String file : counter.violationsByFileAndRule.keySet()) {
                if (!((Map)counter.violationsByFileAndRule.get(file)).containsKey(rule)) continue;
                violations += ((TreeMultiset)((Map)counter.violationsByFileAndRule.get(file)).get(rule)).size();
            }
            return violations;
        }

        public boolean hasDifferences() {
            return this.hasDifferences;
        }
    }

    public static class ViolationCounter {
        private final Map<String, Map<String, TreeMultiset<Integer>>> violationsByFileAndRule;

        public ViolationCounter() {
            this.violationsByFileAndRule = new HashMap<String, Map<String, TreeMultiset<Integer>>>();
        }

        private ViolationCounter(Map<String, Map<String, TreeMultiset<Integer>>> violationsByFileAndRule) {
            this.violationsByFileAndRule = violationsByFileAndRule;
        }

        public void increment(String fileRelativePath, String rule, int line) {
            Map<String, TreeMultiset<Integer>> violationsByRule;
            if (!this.violationsByFileAndRule.containsKey(fileRelativePath)) {
                this.violationsByFileAndRule.put(fileRelativePath, new HashMap());
            }
            if (!(violationsByRule = this.violationsByFileAndRule.get(fileRelativePath)).containsKey(rule)) {
                violationsByRule.put(rule, (TreeMultiset<Integer>)TreeMultiset.create());
            }
            TreeMultiset<Integer> violations = violationsByRule.get(rule);
            violations.add((Object)line);
        }

        public void saveToFile(String destinationFilePath) {
            FileOutputStream fos = null;
            ObjectOutputStream oos = null;
            try {
                fos = new FileOutputStream(destinationFilePath);
                oos = new ObjectOutputStream(fos);
                oos.writeObject(this.violationsByFileAndRule);
            }
            catch (Exception e) {
                try {
                    throw Throwables.propagate((Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fos);
                    IOUtils.closeQuietly(oos);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)fos);
            IOUtils.closeQuietly((OutputStream)oos);
        }

        public static ViolationCounter loadFromFile(File sourceFile) {
            ViolationCounter violationCounter;
            if (!sourceFile.exists() || sourceFile.length() == 0L) {
                return new ViolationCounter();
            }
            FileInputStream fis = null;
            ObjectInputStream ois = null;
            try {
                fis = new FileInputStream(sourceFile);
                ois = new ObjectInputStream(fis);
                violationCounter = new ViolationCounter((Map)ois.readObject());
            }
            catch (Exception e) {
                try {
                    throw Throwables.propagate((Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    IOUtils.closeQuietly(ois);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)fis);
            IOUtils.closeQuietly((InputStream)ois);
            return violationCounter;
        }
    }
}

