/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.commonrules.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.check.Rule;
import org.sonar.squidbridge.annotations.AnnotationBasedRulesDefinition;
import org.sonar.squidbridge.commonrules.api.CommonRulesRepository;
import org.sonar.squidbridge.commonrules.internal.checks.BranchCoverageCheck;
import org.sonar.squidbridge.commonrules.internal.checks.CommentDensityCheck;
import org.sonar.squidbridge.commonrules.internal.checks.DuplicatedBlocksCheck;
import org.sonar.squidbridge.commonrules.internal.checks.FailedUnitTestsCheck;
import org.sonar.squidbridge.commonrules.internal.checks.LineCoverageCheck;
import org.sonar.squidbridge.commonrules.internal.checks.SkippedUnitTestsCheck;

public class DefaultCommonRulesRepository
implements RulesDefinition,
CommonRulesRepository {
    private List<Class> enabledChecks = new ArrayList<Class>();
    private String language;
    private Double minimumBranchCoverageRatio;
    private Double minimumLineCoverageRatio;
    private Double minimumCommentDensity;

    public DefaultCommonRulesRepository(String language) {
        this.language = language;
    }

    public void define(RulesDefinition.Context context) {
        RulesDefinition.NewRepository repo = context.createRepository(DefaultCommonRulesRepository.keyForLanguage(this.language), this.language).setName("Common SonarQube");
        AnnotationBasedRulesDefinition.load(repo, this.language, this.enabledChecks);
        this.setParamValue(repo.rule("InsufficientBranchCoverage"), "minimumBranchCoverageRatio", this.minimumBranchCoverageRatio);
        this.setParamValue(repo.rule("InsufficientLineCoverage"), "minimumLineCoverageRatio", this.minimumLineCoverageRatio);
        this.setParamValue(repo.rule("InsufficientCommentDensity"), "minimumCommentDensity", this.minimumCommentDensity);
        repo.done();
    }

    private void setParamValue(@Nullable RulesDefinition.NewRule rule, String paramName, @Nullable Double paramValue) {
        if (rule != null && paramValue != null) {
            DefaultCommonRulesRepository.ruleParam(rule, paramName).setDefaultValue("" + paramValue);
        }
    }

    @VisibleForTesting
    protected static RulesDefinition.NewParam ruleParam(RulesDefinition.NewRule rule, String paramName) {
        RulesDefinition.NewParam param = rule.param(paramName);
        if (param == null) {
            throw new IllegalStateException(paramName + " should be a valid parameter name on " + rule);
        }
        return param;
    }

    public static String keyForLanguage(String language) {
        return "common-" + language;
    }

    @Override
    public DefaultCommonRulesRepository enableInsufficientBranchCoverageRule(@Nullable Double minimumBranchCoverageRatio) {
        this.minimumBranchCoverageRatio = minimumBranchCoverageRatio;
        this.enabledChecks.add(BranchCoverageCheck.class);
        return this;
    }

    @Override
    public DefaultCommonRulesRepository enableInsufficientLineCoverageRule(@Nullable Double minimumLineCoverageRatio) {
        this.minimumLineCoverageRatio = minimumLineCoverageRatio;
        this.enabledChecks.add(LineCoverageCheck.class);
        return this;
    }

    @Override
    public DefaultCommonRulesRepository enableInsufficientCommentDensityRule(@Nullable Double minimumCommentDensity) {
        this.minimumCommentDensity = minimumCommentDensity;
        this.enabledChecks.add(CommentDensityCheck.class);
        return this;
    }

    @Override
    public DefaultCommonRulesRepository enableDuplicatedBlocksRule() {
        this.enabledChecks.add(DuplicatedBlocksCheck.class);
        return this;
    }

    @Override
    public DefaultCommonRulesRepository enableSkippedUnitTestsRule() {
        this.enabledChecks.add(SkippedUnitTestsCheck.class);
        return this;
    }

    @Override
    public DefaultCommonRulesRepository enableFailedUnitTestsRule() {
        this.enabledChecks.add(FailedUnitTestsCheck.class);
        return this;
    }

    @Override
    public Set<String> enabledRuleKeys() {
        HashSet keys = Sets.newHashSet();
        for (Class clazz : this.enabledChecks) {
            keys.add(((Rule)AnnotationUtils.getAnnotation((Object)clazz, Rule.class)).key());
        }
        return keys;
    }
}

