/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.commonrules.internal.checks;

import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.resources.Resource;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.squidbridge.annotations.SqaleLinearRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.commonrules.internal.checks.CommonCheck;

@Rule(key="InsufficientBranchCoverage", name="Branches should have sufficient coverage by unit tests", priority=Priority.MAJOR, tags={"bad-practice"}, description="<p>An issue is created on a file as soon as the branch coverage on this file is less than the required threshold.It gives the number of branches to be covered in order to reach the required threshold.</p>")
@SqaleSubCharacteristic(value="UNIT_TESTABILITY")
@SqaleLinearRemediation(coeff="5min", effortToFixDescription="number of uncovered conditions")
public class BranchCoverageCheck
extends CommonCheck {
    private static final double DEFAULT_RATIO = 65.0;
    @RuleProperty(key="minimumBranchCoverageRatio", description="The minimum required branch coverage ratio.", defaultValue="65.0")
    private double minimumBranchCoverageRatio = 65.0;

    @Override
    public void checkResource(Resource resource, DecoratorContext context, RuleKey rule, ResourcePerspectives perspectives) {
        double lineCoverage = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.BRANCH_COVERAGE), (Double)0.0);
        if (context.getMeasure(CoreMetrics.BRANCH_COVERAGE) != null && lineCoverage < this.minimumBranchCoverageRatio) {
            double uncoveredConditions = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.UNCOVERED_CONDITIONS), (Double)0.0);
            double conditionsToCover = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.CONDITIONS_TO_COVER), (Double)0.0);
            double conditionsToCoverToReachThreshold = Math.ceil(conditionsToCover * this.minimumBranchCoverageRatio / 100.0 - (conditionsToCover - uncoveredConditions));
            this.createIssue(resource, rule, conditionsToCoverToReachThreshold, perspectives);
        }
    }

    private void createIssue(Resource resource, RuleKey ruleKey, double conditionsToCoverToReachThreshold, ResourcePerspectives perspectives) {
        this.createIssue(resource, perspectives, ruleKey, conditionsToCoverToReachThreshold, (int)conditionsToCoverToReachThreshold + " more branches need to be covered by unit tests to reach the minimum threshold of " + this.minimumBranchCoverageRatio + "% branch coverage.");
    }

    public void setMinimumBranchCoverageRatio(int threshold) {
        this.minimumBranchCoverageRatio = threshold;
    }
}

