/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.commonrules.internal.checks;

import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.resources.Resource;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.squidbridge.annotations.SqaleLinearRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.commonrules.internal.checks.CommonCheck;

@Rule(key="InsufficientCommentDensity", name="Source files should have a sufficient density of comment lines", priority=Priority.MAJOR, tags={"convention"}, description="<p>An issue is created on a file as soon as the density of comment lines on this file is less than the required threshold. The number of comment lines to be written in order to reach the required threshold is provided by each issue message.</p>")
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleLinearRemediation(coeff="2min", effortToFixDescription="number of lines required to meet minimum density")
public class CommentDensityCheck
extends CommonCheck {
    private static final double DEFAULT_MIN_DENSITY = 25.0;
    @RuleProperty(key="minimumCommentDensity", description="The minimum required comment density.", defaultValue="25.0")
    private double minimumCommentDensity = 25.0;

    @Override
    public void checkResource(Resource resource, DecoratorContext context, RuleKey rule, ResourcePerspectives perspectives) {
        if (this.minimumCommentDensity < 0.0 || this.minimumCommentDensity >= 100.0) {
            throw new IllegalArgumentException(this.minimumCommentDensity + " is not a valid value for minimum required comment density for rule 'CommentDensityCheck' (must be >= 0 and < 100).");
        }
        double commentDensity = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.COMMENT_LINES_DENSITY), (Double)0.0);
        double linesOfCode = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.NCLOC), (Double)0.0);
        if (commentDensity < this.minimumCommentDensity && Double.doubleToRawLongBits(linesOfCode) != 0L) {
            double commentLines = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.COMMENT_LINES), (Double)0.0);
            double missingCommentLines = Math.ceil(this.minimumCommentDensity * linesOfCode / (100.0 - this.minimumCommentDensity) - commentLines);
            this.createIssue(resource, rule, missingCommentLines, perspectives);
        }
    }

    private void createIssue(Resource resource, RuleKey ruleKey, double missingCommentLines, ResourcePerspectives perspectives) {
        this.createIssue(resource, perspectives, ruleKey, missingCommentLines, (int)missingCommentLines + " more comment lines need to be written to reach the minimum threshold of " + this.minimumCommentDensity + "% comment density.");
    }

    public void setMinimumCommentDensity(int threshold) {
        this.minimumCommentDensity = threshold;
    }
}

