/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.commonrules.internal.checks;

import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.squidbridge.annotations.SqaleLinearRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.commonrules.internal.checks.CommonCheck;

@Rule(key="SkippedUnitTests", name="Skipped unit tests should be either removed or fixed", priority=Priority.MAJOR, tags={"pitfall"}, description="<p>Skipped unit tests are considered as dead code. Either they should be activated again (and updated) or they should be removed.</p>")
@SqaleSubCharacteristic(value="UNIT_TESTABILITY")
@SqaleLinearRemediation(coeff="10min", effortToFixDescription="number of skipped tests")
public class SkippedUnitTestsCheck
extends CommonCheck {
    @Override
    public void checkResource(Resource resource, DecoratorContext context, RuleKey ruleKey, ResourcePerspectives perspectives) {
        double skippedTests = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.SKIPPED_TESTS), (Double)0.0);
        if (ResourceUtils.isUnitTestClass((Resource)resource) && skippedTests > 0.0) {
            this.createIssue(resource, ruleKey, skippedTests, perspectives);
        }
    }

    private void createIssue(Resource resource, RuleKey ruleKey, double skippedTests, ResourcePerspectives perspectives) {
        String fileName = resource.getName();
        this.createIssue(resource, perspectives, ruleKey, skippedTests, "Fix or remove skipped unit tests in file \"" + fileName + "\".");
    }
}

