/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.indexer;

import org.apache.commons.lang.math.NumberUtils;
import org.sonar.squidbridge.api.Query;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.measures.Metric;
import org.sonar.squidbridge.measures.MetricDef;

public class QueryByMeasure
implements Query {
    private final MetricDef metric;
    private final Operator operator;
    private final double value;

    @Deprecated
    public QueryByMeasure(Metric metric, Operator operator, double value) {
        this((MetricDef)metric, operator, value);
    }

    public QueryByMeasure(MetricDef metric, Operator operator, double value) {
        this.metric = metric;
        this.operator = operator;
        this.value = value;
    }

    @Override
    public boolean match(SourceCode unit) {
        switch (this.operator) {
            case EQUALS: {
                return NumberUtils.compare((double)unit.getDouble(this.metric), (double)this.value) == 0;
            }
            case GREATER_THAN: {
                return unit.getDouble(this.metric) > this.value;
            }
            case GREATER_THAN_EQUALS: {
                return unit.getDouble(this.metric) >= this.value;
            }
            case LESS_THAN_EQUALS: {
                return unit.getDouble(this.metric) <= this.value;
            }
            case LESS_THAN: {
                return unit.getDouble(this.metric) < this.value;
            }
        }
        throw new IllegalStateException("The operator value '" + (Object)((Object)this.operator) + "' is unknown.");
    }

    public static enum Operator {
        GREATER_THAN,
        EQUALS,
        GREATER_THAN_EQUALS,
        LESS_THAN,
        LESS_THAN_EQUALS;

    }
}

