/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.recognizer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sonar.squidbridge.recognizer.Detector;
import org.sonar.squidbridge.recognizer.LanguageFootprint;

public class CodeRecognizer {
    private final LanguageFootprint language;
    private final double threshold;

    public CodeRecognizer(double threshold, LanguageFootprint language) {
        this.language = language;
        this.threshold = threshold;
    }

    public final double recognition(String line) {
        double probability = 0.0;
        for (Detector pattern : this.language.getDetectors()) {
            probability = 1.0 - (1.0 - probability) * (1.0 - pattern.recognition(line));
        }
        return probability;
    }

    public final List<String> extractCodeLines(List<String> lines) {
        ArrayList codeLines = Lists.newArrayList();
        for (String line : lines) {
            if (!(this.recognition(line) >= this.threshold)) continue;
            codeLines.add(line);
        }
        return codeLines;
    }

    public final boolean isLineOfCode(String line) {
        return this.recognition(line) - this.threshold > 0.0;
    }
}

