/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.text;

import javax.annotation.Nullable;
import org.sonar.squidbridge.text.Line;
import org.sonar.squidbridge.text.LineContextHandler;

public class SingleLineCommentHandler
extends LineContextHandler {
    private StringBuilder comment;
    private final String commentStartTag;
    private final String commentNotStartTag;

    public SingleLineCommentHandler(String commentStartTag) {
        this(commentStartTag, null);
    }

    public SingleLineCommentHandler(String commentStartTag, @Nullable String commentNotStartTag) {
        this.commentStartTag = commentStartTag;
        this.commentNotStartTag = commentNotStartTag;
    }

    @Override
    boolean matchToEnd(Line line, StringBuilder pendingLine) {
        if (this.comment == null) {
            throw new IllegalStateException("Method doContextBegin(StringBuilder pendingLine) has not been called.");
        }
        this.comment.append(SingleLineCommentHandler.getLastCharacter(pendingLine));
        return false;
    }

    @Override
    boolean matchToBegin(Line line, StringBuilder pendingLine) {
        boolean doContextBegin;
        boolean bl = doContextBegin = SingleLineCommentHandler.matchEndOfString(pendingLine, this.commentStartTag) && (this.commentNotStartTag == null || !SingleLineCommentHandler.matchEndOfString(pendingLine, this.commentNotStartTag));
        if (doContextBegin) {
            this.comment = new StringBuilder(this.commentStartTag);
        }
        return doContextBegin;
    }

    @Override
    boolean matchWithEndOfLine(Line line, StringBuilder pendingLine) {
        line.setComment(this.comment.toString());
        this.comment = null;
        return true;
    }
}

