/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.MetricsIO;
import org.apache.hadoop.hbase.io.MetricsIOWrapperImpl;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.CorruptHFileException;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFilePrettyPrinter;
import org.apache.hadoop.hbase.io.hfile.HFileReaderImpl;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.HFileWriterImpl;
import org.apache.hadoop.hbase.io.hfile.InlineBlockWriter;
import org.apache.hadoop.hbase.protobuf.ProtobufMagic;
import org.apache.hadoop.hbase.regionserver.CellSink;
import org.apache.hadoop.hbase.regionserver.ShipperListener;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HFileProtos;
import org.apache.hadoop.hbase.util.BloomFilterWriter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HFile {
    static final Logger LOG = LoggerFactory.getLogger(HFile.class);
    public static final int MAXIMUM_KEY_LENGTH = Integer.MAX_VALUE;
    public static final Compression.Algorithm DEFAULT_COMPRESSION_ALGORITHM = Compression.Algorithm.NONE;
    public static final int MIN_FORMAT_VERSION = 2;
    public static final int MAX_FORMAT_VERSION = 3;
    public static final int MIN_FORMAT_VERSION_WITH_TAGS = 3;
    public static final String DEFAULT_COMPRESSION = DEFAULT_COMPRESSION_ALGORITHM.getName();
    public static final String BLOOM_FILTER_DATA_KEY = "BLOOM_FILTER_DATA";
    public static final int MIN_NUM_HFILE_PATH_LEVELS = 5;
    public static final int DEFAULT_BYTES_PER_CHECKSUM = 16384;
    static final LongAdder CHECKSUM_FAILURES = new LongAdder();
    public static final LongAdder DATABLOCK_READ_COUNT = new LongAdder();
    static final MetricsIO metrics = new MetricsIO(new MetricsIOWrapperImpl());
    public static final String FORMAT_VERSION_KEY = "hfile.format.version";

    public static final long getAndResetChecksumFailuresCount() {
        return CHECKSUM_FAILURES.sumThenReset();
    }

    public static final long getChecksumFailuresCount() {
        return CHECKSUM_FAILURES.sum();
    }

    public static final void updateReadLatency(long latencyMillis, boolean pread) {
        if (pread) {
            metrics.updateFsPreadTime(latencyMillis);
        } else {
            metrics.updateFsReadTime(latencyMillis);
        }
    }

    public static final void updateWriteLatency(long latencyMillis) {
        metrics.updateFsWriteTime(latencyMillis);
    }

    public static int getFormatVersion(Configuration conf) {
        int version = conf.getInt(FORMAT_VERSION_KEY, 3);
        HFile.checkFormatVersion(version);
        return version;
    }

    public static final WriterFactory getWriterFactoryNoCache(Configuration conf) {
        Configuration tempConf = new Configuration(conf);
        tempConf.setFloat("hfile.block.cache.size", 0.0f);
        return HFile.getWriterFactory(conf, new CacheConfig(tempConf));
    }

    public static final WriterFactory getWriterFactory(Configuration conf, CacheConfig cacheConf) {
        int version = HFile.getFormatVersion(conf);
        switch (version) {
            case 2: {
                throw new IllegalArgumentException("This should never happen. Did you change hfile.format.version to read v2? This version of the software writes v3 hfiles only (but it can read v2 files without having to update hfile.format.version in hbase-site.xml)");
            }
            case 3: {
                return new WriterFactory(conf, cacheConf);
            }
        }
        throw new IllegalArgumentException("Cannot create writer for HFile format version " + version);
    }

    @SuppressWarnings(value={"SF_SWITCH_FALLTHROUGH"}, justification="Intentional")
    private static Reader openReader(Path path, FSDataInputStreamWrapper fsdis, long size, CacheConfig cacheConf, HFileSystem hfs, boolean primaryReplicaReader, Configuration conf) throws IOException {
        FixedFileTrailer trailer = null;
        try {
            boolean isHBaseChecksum = fsdis.shouldUseHBaseChecksum();
            assert (!isHBaseChecksum);
            trailer = FixedFileTrailer.readFromStream(fsdis.getStream(isHBaseChecksum), size);
            switch (trailer.getMajorVersion()) {
                case 2: {
                    LOG.debug("Opening HFile v2 with v3 reader");
                }
                case 3: {
                    HFileReaderImpl hFileReaderImpl = new HFileReaderImpl(path, trailer, fsdis, size, cacheConf, hfs, primaryReplicaReader, conf);
                    return hFileReaderImpl;
                }
            }
            try {
                throw new IllegalArgumentException("Invalid HFile version " + trailer.getMajorVersion());
            }
            catch (Throwable t) {
                IOUtils.closeQuietly((Closeable)fsdis);
                throw new CorruptHFileException("Problem reading HFile Trailer from file " + path, t);
            }
        }
        finally {
            fsdis.unbuffer();
        }
    }

    public static Reader createReader(FileSystem fs, Path path, FSDataInputStreamWrapper fsdis, long size, CacheConfig cacheConf, boolean primaryReplicaReader, Configuration conf) throws IOException {
        HFileSystem hfs = null;
        hfs = !(fs instanceof HFileSystem) ? new HFileSystem(fs) : (HFileSystem)fs;
        return HFile.openReader(path, fsdis, size, cacheConf, hfs, primaryReplicaReader, conf);
    }

    public static Reader createReader(FileSystem fs, Path path, Configuration conf) throws IOException {
        return HFile.createReader(fs, path, CacheConfig.DISABLED, true, conf);
    }

    public static Reader createReader(FileSystem fs, Path path, CacheConfig cacheConf, boolean primaryReplicaReader, Configuration conf) throws IOException {
        Preconditions.checkNotNull((Object)cacheConf, (Object)"Cannot create Reader with null CacheConf");
        FSDataInputStreamWrapper stream = new FSDataInputStreamWrapper(fs, path);
        return HFile.openReader(path, stream, fs.getFileStatus(path).getLen(), cacheConf, stream.getHfs(), primaryReplicaReader, conf);
    }

    @VisibleForTesting
    static Reader createReaderFromStream(Path path, FSDataInputStream fsdis, long size, CacheConfig cacheConf, Configuration conf) throws IOException {
        FSDataInputStreamWrapper wrapper = new FSDataInputStreamWrapper(fsdis);
        return HFile.openReader(path, wrapper, size, cacheConf, null, true, conf);
    }

    public static boolean isHFileFormat(FileSystem fs, Path path) throws IOException {
        return HFile.isHFileFormat(fs, fs.getFileStatus(path));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isHFileFormat(FileSystem fs, FileStatus fileStatus) throws IOException {
        Path path = fileStatus.getPath();
        long size = fileStatus.getLen();
        try (FSDataInputStreamWrapper fsdis = new FSDataInputStreamWrapper(fs, path);){
            boolean isHBaseChecksum = fsdis.shouldUseHBaseChecksum();
            assert (!isHBaseChecksum);
            FixedFileTrailer.readFromStream(fsdis.getStream(isHBaseChecksum), size);
            boolean bl = true;
            return bl;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isReservedFileInfoKey(byte[] key) {
        return Bytes.startsWith((byte[])key, (byte[])FileInfo.RESERVED_PREFIX_BYTES);
    }

    public static String[] getSupportedCompressionAlgorithms() {
        return Compression.getSupportedAlgorithms();
    }

    static int longToInt(long l) {
        return (int)(l & 0xFFFFFFFFL);
    }

    static List<Path> getStoreFiles(FileSystem fs, Path regionDir) throws IOException {
        FileStatus[] familyDirs;
        ArrayList<Path> regionHFiles = new ArrayList<Path>();
        FSUtils.DirFilter dirFilter = new FSUtils.DirFilter(fs);
        for (FileStatus dir : familyDirs = fs.listStatus(regionDir, (PathFilter)dirFilter)) {
            FileStatus[] files;
            for (FileStatus file : files = fs.listStatus(dir.getPath())) {
                if (file.isDirectory() || file.getPath().toString().contains("oldWALs") || file.getPath().toString().contains("recovered.edits")) continue;
                regionHFiles.add(file.getPath());
            }
        }
        return regionHFiles;
    }

    public static void checkFormatVersion(int version) throws IllegalArgumentException {
        if (version < 2 || version > 3) {
            throw new IllegalArgumentException("Invalid HFile version: " + version + " (expected to be between " + 2 + " and " + 3 + ")");
        }
    }

    public static void checkHFileVersion(Configuration c) {
        int version = c.getInt(FORMAT_VERSION_KEY, 3);
        if (version < 3 || version > 3) {
            throw new IllegalArgumentException("The setting for hfile.format.version (in your hbase-*.xml files) is " + version + " which does not match " + 3 + "; are you running with a configuration from an older or newer hbase install (an incompatible hbase-default.xml or hbase-site.xml on your CLASSPATH)?");
        }
    }

    public static void main(String[] args) throws Exception {
        HFilePrettyPrinter.main(args);
    }

    public static class FileInfo
    implements SortedMap<byte[], byte[]> {
        static final String RESERVED_PREFIX = "hfile.";
        static final byte[] RESERVED_PREFIX_BYTES = Bytes.toBytes((String)"hfile.");
        static final byte[] LASTKEY = Bytes.toBytes((String)"hfile.LASTKEY");
        static final byte[] AVG_KEY_LEN = Bytes.toBytes((String)"hfile.AVG_KEY_LEN");
        static final byte[] AVG_VALUE_LEN = Bytes.toBytes((String)"hfile.AVG_VALUE_LEN");
        static final byte[] CREATE_TIME_TS = Bytes.toBytes((String)"hfile.CREATE_TIME_TS");
        static final byte[] COMPARATOR = Bytes.toBytes((String)"hfile.COMPARATOR");
        static final byte[] TAGS_COMPRESSED = Bytes.toBytes((String)"hfile.TAGS_COMPRESSED");
        public static final byte[] MAX_TAGS_LEN = Bytes.toBytes((String)"hfile.MAX_TAGS_LEN");
        private final SortedMap<byte[], byte[]> map = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);

        public FileInfo append(byte[] k, byte[] v, boolean checkPrefix) throws IOException {
            if (k == null || v == null) {
                throw new NullPointerException("Key nor value may be null");
            }
            if (checkPrefix && HFile.isReservedFileInfoKey(k)) {
                throw new IOException("Keys with a hfile. are reserved");
            }
            this.put(k, v);
            return this;
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Comparator<? super byte[]> comparator() {
            return this.map.comparator();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public Set<Map.Entry<byte[], byte[]>> entrySet() {
            return this.map.entrySet();
        }

        @Override
        public boolean equals(Object o) {
            return this.map.equals(o);
        }

        @Override
        public byte[] firstKey() {
            return this.map.firstKey();
        }

        @Override
        public byte[] get(Object key) {
            return (byte[])this.map.get(key);
        }

        @Override
        public int hashCode() {
            return this.map.hashCode();
        }

        @Override
        public SortedMap<byte[], byte[]> headMap(byte[] toKey) {
            return this.map.headMap(toKey);
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Set<byte[]> keySet() {
            return this.map.keySet();
        }

        @Override
        public byte[] lastKey() {
            return this.map.lastKey();
        }

        @Override
        public byte[] put(byte[] key, byte[] value) {
            return this.map.put(key, value);
        }

        @Override
        public void putAll(Map<? extends byte[], ? extends byte[]> m) {
            this.map.putAll(m);
        }

        @Override
        public byte[] remove(Object key) {
            return (byte[])this.map.remove(key);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public SortedMap<byte[], byte[]> subMap(byte[] fromKey, byte[] toKey) {
            return this.map.subMap(fromKey, toKey);
        }

        @Override
        public SortedMap<byte[], byte[]> tailMap(byte[] fromKey) {
            return this.map.tailMap(fromKey);
        }

        @Override
        public Collection<byte[]> values() {
            return this.map.values();
        }

        void write(DataOutputStream out) throws IOException {
            HFileProtos.FileInfoProto.Builder builder = HFileProtos.FileInfoProto.newBuilder();
            for (Map.Entry<byte[], byte[]> e : this.map.entrySet()) {
                HBaseProtos.BytesBytesPair.Builder bbpBuilder = HBaseProtos.BytesBytesPair.newBuilder();
                bbpBuilder.setFirst(UnsafeByteOperations.unsafeWrap((byte[])e.getKey()));
                bbpBuilder.setSecond(UnsafeByteOperations.unsafeWrap((byte[])e.getValue()));
                builder.addMapEntry(bbpBuilder.build());
            }
            out.write(ProtobufMagic.PB_MAGIC);
            builder.build().writeDelimitedTo((OutputStream)out);
        }

        void read(DataInputStream in) throws IOException {
            int read;
            int pblen = ProtobufUtil.lengthOfPBMagic();
            byte[] pbuf = new byte[pblen];
            if (in.markSupported()) {
                in.mark(pblen);
            }
            if ((read = in.read(pbuf)) != pblen) {
                throw new IOException("read=" + read + ", wanted=" + pblen);
            }
            if (ProtobufUtil.isPBMagicPrefix((byte[])pbuf)) {
                this.parsePB(HFileProtos.FileInfoProto.parseDelimitedFrom((InputStream)in));
            } else if (in.markSupported()) {
                in.reset();
                this.parseWritable(in);
            } else {
                ByteArrayInputStream bais = new ByteArrayInputStream(pbuf);
                SequenceInputStream sis = new SequenceInputStream(bais, in);
                this.parseWritable(new DataInputStream(sis));
            }
        }

        void parseWritable(DataInputStream in) throws IOException {
            this.map.clear();
            int entries = in.readInt();
            for (int i = 0; i < entries; ++i) {
                byte[] key = Bytes.readByteArray((DataInput)in);
                in.readByte();
                byte[] value = Bytes.readByteArray((DataInput)in);
                this.map.put(key, value);
            }
        }

        void parsePB(HFileProtos.FileInfoProto fip) {
            this.map.clear();
            for (HBaseProtos.BytesBytesPair pair : fip.getMapEntryList()) {
                this.map.put(pair.getFirst().toByteArray(), pair.getSecond().toByteArray());
            }
        }
    }

    public static interface Reader
    extends Closeable,
    CachingBlockReader {
        public String getName();

        public CellComparator getComparator();

        public HFileScanner getScanner(boolean var1, boolean var2, boolean var3);

        public HFileBlock getMetaBlock(String var1, boolean var2) throws IOException;

        public Map<byte[], byte[]> loadFileInfo() throws IOException;

        public Optional<Cell> getLastKey();

        public Optional<Cell> midKey() throws IOException;

        public long length();

        public long getEntries();

        public Optional<Cell> getFirstKey();

        public long indexSize();

        public Optional<byte[]> getFirstRowKey();

        public Optional<byte[]> getLastRowKey();

        public FixedFileTrailer getTrailer();

        public HFileBlockIndex.BlockIndexReader getDataBlockIndexReader();

        public HFileScanner getScanner(boolean var1, boolean var2);

        public Compression.Algorithm getCompressionAlgorithm();

        public DataInput getGeneralBloomFilterMetadata() throws IOException;

        public DataInput getDeleteBloomFilterMetadata() throws IOException;

        public Path getPath();

        public void close(boolean var1) throws IOException;

        public DataBlockEncoding getDataBlockEncoding();

        public boolean hasMVCCInfo();

        public HFileContext getFileContext();

        public boolean isPrimaryReplicaReader();

        public boolean shouldIncludeMemStoreTS();

        public boolean isDecodeMemStoreTS();

        public DataBlockEncoding getEffectiveEncodingInCache(boolean var1);

        @VisibleForTesting
        public HFileBlock.FSReader getUncachedBlockReader();

        @VisibleForTesting
        public boolean prefetchComplete();

        public void unbufferStream();
    }

    public static interface CachingBlockReader {
        public HFileBlock readBlock(long var1, long var3, boolean var5, boolean var6, boolean var7, boolean var8, BlockType var9, DataBlockEncoding var10) throws IOException;

        public void returnBlock(HFileBlock var1);
    }

    public static class WriterFactory {
        protected final Configuration conf;
        protected final CacheConfig cacheConf;
        protected FileSystem fs;
        protected Path path;
        protected FSDataOutputStream ostream;
        protected CellComparator comparator = CellComparator.getInstance();
        protected InetSocketAddress[] favoredNodes;
        private HFileContext fileContext;
        protected boolean shouldDropBehind = false;

        WriterFactory(Configuration conf, CacheConfig cacheConf) {
            this.conf = conf;
            this.cacheConf = cacheConf;
        }

        public WriterFactory withPath(FileSystem fs, Path path) {
            Preconditions.checkNotNull((Object)fs);
            Preconditions.checkNotNull((Object)path);
            this.fs = fs;
            this.path = path;
            return this;
        }

        public WriterFactory withOutputStream(FSDataOutputStream ostream) {
            Preconditions.checkNotNull((Object)ostream);
            this.ostream = ostream;
            return this;
        }

        public WriterFactory withComparator(CellComparator comparator) {
            Preconditions.checkNotNull((Object)comparator);
            this.comparator = comparator;
            return this;
        }

        public WriterFactory withFavoredNodes(InetSocketAddress[] favoredNodes) {
            this.favoredNodes = favoredNodes;
            return this;
        }

        public WriterFactory withFileContext(HFileContext fileContext) {
            this.fileContext = fileContext;
            return this;
        }

        public WriterFactory withShouldDropCacheBehind(boolean shouldDropBehind) {
            this.shouldDropBehind = shouldDropBehind;
            return this;
        }

        public Writer create() throws IOException {
            block5: {
                if ((this.path != null ? 1 : 0) + (this.ostream != null ? 1 : 0) != 1) {
                    throw new AssertionError((Object)"Please specify exactly one of filesystem/path or path");
                }
                if (this.path != null) {
                    this.ostream = HFileWriterImpl.createOutputStream(this.conf, this.fs, this.path, this.favoredNodes);
                    try {
                        this.ostream.setDropBehind(Boolean.valueOf(this.shouldDropBehind && this.cacheConf.shouldDropBehindCompaction()));
                    }
                    catch (UnsupportedOperationException uoe) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Unable to set drop behind on " + this.path, (Throwable)uoe);
                        }
                        if (!LOG.isDebugEnabled()) break block5;
                        LOG.debug("Unable to set drop behind on " + this.path);
                    }
                }
            }
            return new HFileWriterImpl(this.conf, this.cacheConf, this.path, this.ostream, this.comparator, this.fileContext);
        }
    }

    public static interface Writer
    extends Closeable,
    CellSink,
    ShipperListener {
        public static final byte[] MAX_MEMSTORE_TS_KEY = Bytes.toBytes((String)"MAX_MEMSTORE_TS_KEY");

        public void appendFileInfo(byte[] var1, byte[] var2) throws IOException;

        public Path getPath();

        public void addInlineBlockWriter(InlineBlockWriter var1);

        public void appendMetaBlock(String var1, Writable var2);

        public void addGeneralBloomFilter(BloomFilterWriter var1);

        public void addDeleteFamilyBloomFilter(BloomFilterWriter var1) throws IOException;

        public HFileContext getFileContext();
    }
}

