/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Descriptors;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Service;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ServiceException;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public interface Table
extends Closeable {
    public TableName getName();

    public Configuration getConfiguration();

    public HTableDescriptor getTableDescriptor() throws IOException;

    public boolean exists(Get var1) throws IOException;

    public boolean[] existsAll(List<Get> var1) throws IOException;

    public void batch(List<? extends Row> var1, Object[] var2) throws IOException, InterruptedException;

    @Deprecated
    public Object[] batch(List<? extends Row> var1) throws IOException, InterruptedException;

    public <R> void batchCallback(List<? extends Row> var1, Object[] var2, Batch.Callback<R> var3) throws IOException, InterruptedException;

    @Deprecated
    public <R> Object[] batchCallback(List<? extends Row> var1, Batch.Callback<R> var2) throws IOException, InterruptedException;

    public Result get(Get var1) throws IOException;

    public Result[] get(List<Get> var1) throws IOException;

    public ResultScanner getScanner(Scan var1) throws IOException;

    public ResultScanner getScanner(byte[] var1) throws IOException;

    public ResultScanner getScanner(byte[] var1, byte[] var2) throws IOException;

    public void put(Put var1) throws IOException;

    public void put(List<Put> var1) throws IOException;

    public boolean checkAndPut(byte[] var1, byte[] var2, byte[] var3, byte[] var4, Put var5) throws IOException;

    public boolean checkAndPut(byte[] var1, byte[] var2, byte[] var3, CompareFilter.CompareOp var4, byte[] var5, Put var6) throws IOException;

    public void delete(Delete var1) throws IOException;

    public void delete(List<Delete> var1) throws IOException;

    public boolean checkAndDelete(byte[] var1, byte[] var2, byte[] var3, byte[] var4, Delete var5) throws IOException;

    public boolean checkAndDelete(byte[] var1, byte[] var2, byte[] var3, CompareFilter.CompareOp var4, byte[] var5, Delete var6) throws IOException;

    public void mutateRow(RowMutations var1) throws IOException;

    public Result append(Append var1) throws IOException;

    public Result increment(Increment var1) throws IOException;

    public long incrementColumnValue(byte[] var1, byte[] var2, byte[] var3, long var4) throws IOException;

    public long incrementColumnValue(byte[] var1, byte[] var2, byte[] var3, long var4, Durability var6) throws IOException;

    @Override
    public void close() throws IOException;

    public CoprocessorRpcChannel coprocessorService(byte[] var1);

    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> var1, byte[] var2, byte[] var3, Batch.Call<T, R> var4) throws ServiceException, Throwable;

    public <T extends Service, R> void coprocessorService(Class<T> var1, byte[] var2, byte[] var3, Batch.Call<T, R> var4, Batch.Callback<R> var5) throws ServiceException, Throwable;

    @Deprecated
    public long getWriteBufferSize();

    @Deprecated
    public void setWriteBufferSize(long var1) throws IOException;

    public <R extends Message> Map<byte[], R> batchCoprocessorService(Descriptors.MethodDescriptor var1, Message var2, byte[] var3, byte[] var4, R var5) throws ServiceException, Throwable;

    public <R extends Message> void batchCoprocessorService(Descriptors.MethodDescriptor var1, Message var2, byte[] var3, byte[] var4, R var5, Batch.Callback<R> var6) throws ServiceException, Throwable;

    public boolean checkAndMutate(byte[] var1, byte[] var2, byte[] var3, CompareFilter.CompareOp var4, byte[] var5, RowMutations var6) throws IOException;

    public void setOperationTimeout(int var1);

    public int getOperationTimeout();

    public void setRpcTimeout(int var1);

    public int getRpcTimeout();
}

