/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.distsql.handler.update;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.distsql.parser.statement.DropEncryptRuleStatement;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RuleDefinitionViolationException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;

public final class DropEncryptRuleStatementUpdater
implements RuleDefinitionDropUpdater<DropEncryptRuleStatement, EncryptRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereMetaData shardingSphereMetaData, DropEncryptRuleStatement sqlStatement, EncryptRuleConfiguration currentRuleConfig) throws RuleDefinitionViolationException {
        String schemaName = shardingSphereMetaData.getName();
        this.checkCurrentRuleConfiguration(schemaName, currentRuleConfig);
        this.checkToBeDroppedEncryptTableNames(schemaName, sqlStatement, currentRuleConfig);
    }

    private void checkCurrentRuleConfiguration(String schemaName, EncryptRuleConfiguration currentRuleConfig) throws RequiredRuleMissedException {
        if (null == currentRuleConfig) {
            throw new RequiredRuleMissedException("Encrypt", schemaName);
        }
    }

    private void checkToBeDroppedEncryptTableNames(String schemaName, DropEncryptRuleStatement sqlStatement, EncryptRuleConfiguration currentRuleConfig) throws RequiredRuleMissedException {
        Collection currentEncryptTableNames = currentRuleConfig.getTables().stream().map(EncryptTableRuleConfiguration::getName).collect(Collectors.toList());
        Collection notExistedTableNames = sqlStatement.getTables().stream().filter(each -> !currentEncryptTableNames.contains(each)).collect(Collectors.toList());
        if (!notExistedTableNames.isEmpty()) {
            throw new RequiredRuleMissedException("Encrypt", schemaName, notExistedTableNames);
        }
    }

    public boolean updateCurrentRuleConfiguration(DropEncryptRuleStatement sqlStatement, EncryptRuleConfiguration currentRuleConfig) {
        for (String each : sqlStatement.getTables()) {
            this.dropRule(currentRuleConfig, each);
        }
        return currentRuleConfig.getTables().isEmpty();
    }

    private void dropRule(EncryptRuleConfiguration currentRuleConfig, String ruleName) {
        Optional<EncryptTableRuleConfiguration> encryptTableRuleConfig = currentRuleConfig.getTables().stream().filter(tableRule -> tableRule.getName().equals(ruleName)).findAny();
        Preconditions.checkState((boolean)encryptTableRuleConfig.isPresent());
        currentRuleConfig.getTables().remove(encryptTableRuleConfig.get());
        encryptTableRuleConfig.get().getColumns().stream().filter(column -> !this.isEncryptorInUse(currentRuleConfig, column.getEncryptorName())).forEach(column -> {
            ShardingSphereAlgorithmConfiguration cfr_ignored_0 = (ShardingSphereAlgorithmConfiguration)currentRuleConfig.getEncryptors().remove(column.getEncryptorName());
        });
    }

    private boolean isEncryptorInUse(EncryptRuleConfiguration currentRuleConfig, String toBeDroppedEncryptorName) {
        for (EncryptTableRuleConfiguration each : currentRuleConfig.getTables()) {
            if (!each.getColumns().stream().anyMatch(column -> column.getEncryptorName().equals(toBeDroppedEncryptorName))) continue;
            return true;
        }
        return false;
    }

    public Class<EncryptRuleConfiguration> getRuleConfigurationClass() {
        return EncryptRuleConfiguration.class;
    }

    public String getType() {
        return DropEncryptRuleStatement.class.getName();
    }
}

