/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.pool.metadata.type.hikari;

import com.zaxxer.hikari.HikariDataSource;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.datasource.pool.metadata.DataSourcePoolMetaData;
import org.apache.shardingsphere.infra.datasource.pool.metadata.type.hikari.HikariDataSourceJdbcUrlMetaData;

public final class HikariDataSourcePoolMetaData
implements DataSourcePoolMetaData<HikariDataSource> {
    private final Map<String, Object> defaultProperties = new HashMap<String, Object>(6, 1.0f);
    private final Map<String, Object> invalidProperties = new HashMap<String, Object>(2, 1.0f);
    private final Map<String, String> propertySynonyms = new HashMap<String, String>(6, 1.0f);
    private final Collection<String> transientFieldNames = new LinkedList<String>();

    public HikariDataSourcePoolMetaData() {
        this.buildDefaultProperties();
        this.buildInvalidProperties();
        this.buildPropertySynonyms();
        this.buildTransientFieldNames();
    }

    private void buildDefaultProperties() {
        this.defaultProperties.put("connectionTimeout", 30000L);
        this.defaultProperties.put("idleTimeout", 60000L);
        this.defaultProperties.put("maxLifetime", 0x200B20L);
        this.defaultProperties.put("maximumPoolSize", 50);
        this.defaultProperties.put("minimumIdle", 1);
        this.defaultProperties.put("readOnly", false);
    }

    private void buildInvalidProperties() {
        this.invalidProperties.put("minimumIdle", -1);
        this.invalidProperties.put("maximumPoolSize", -1);
    }

    private void buildPropertySynonyms() {
        this.propertySynonyms.put("url", "jdbcUrl");
        this.propertySynonyms.put("connectionTimeoutMilliseconds", "connectionTimeout");
        this.propertySynonyms.put("idleTimeoutMilliseconds", "idleTimeout");
        this.propertySynonyms.put("maxLifetimeMilliseconds", "maxLifetime");
        this.propertySynonyms.put("maxPoolSize", "maximumPoolSize");
        this.propertySynonyms.put("minPoolSize", "minimumIdle");
    }

    private void buildTransientFieldNames() {
        this.transientFieldNames.add("running");
        this.transientFieldNames.add("poolName");
        this.transientFieldNames.add("registerMbeans");
        this.transientFieldNames.add("closed");
    }

    public HikariDataSourceJdbcUrlMetaData getJdbcUrlMetaData() {
        return new HikariDataSourceJdbcUrlMetaData();
    }

    public String getType() {
        return HikariDataSource.class.getName();
    }

    @Override
    @Generated
    public Map<String, Object> getDefaultProperties() {
        return this.defaultProperties;
    }

    @Override
    @Generated
    public Map<String, Object> getInvalidProperties() {
        return this.invalidProperties;
    }

    @Override
    @Generated
    public Map<String, String> getPropertySynonyms() {
        return this.propertySynonyms;
    }

    @Override
    @Generated
    public Collection<String> getTransientFieldNames() {
        return this.transientFieldNames;
    }
}

