/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.resource;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.DataSourcePoolDestroyerFactory;
import org.apache.shardingsphere.infra.metadata.resource.CachedDatabaseMetaData;
import org.apache.shardingsphere.infra.metadata.resource.DataSourcesMetaData;

public final class ShardingSphereResource {
    private final Map<String, DataSource> dataSources;
    private final DataSourcesMetaData dataSourcesMetaData;
    private final CachedDatabaseMetaData cachedDatabaseMetaData;
    private final DatabaseType databaseType;

    public Collection<DataSource> getAllInstanceDataSources() {
        return this.dataSources.entrySet().stream().filter(entry -> this.dataSourcesMetaData.getAllInstanceDataSourceNames().contains(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    public Collection<String> getNotExistedResources(Collection<String> resourceNames) {
        return resourceNames.stream().filter(each -> !this.dataSources.containsKey(each)).collect(Collectors.toSet());
    }

    public void close(Collection<String> dataSources) throws SQLException {
        for (String each : dataSources) {
            this.close(this.dataSources.get(each));
        }
    }

    public void close(DataSource dataSource) throws SQLException {
        DataSourcePoolDestroyerFactory.destroy(dataSource);
    }

    @Generated
    public ShardingSphereResource(Map<String, DataSource> dataSources, DataSourcesMetaData dataSourcesMetaData, CachedDatabaseMetaData cachedDatabaseMetaData, DatabaseType databaseType) {
        this.dataSources = dataSources;
        this.dataSourcesMetaData = dataSourcesMetaData;
        this.cachedDatabaseMetaData = cachedDatabaseMetaData;
        this.databaseType = databaseType;
    }

    @Generated
    public Map<String, DataSource> getDataSources() {
        return this.dataSources;
    }

    @Generated
    public DataSourcesMetaData getDataSourcesMetaData() {
        return this.dataSourcesMetaData;
    }

    @Generated
    public CachedDatabaseMetaData getCachedDatabaseMetaData() {
        return this.cachedDatabaseMetaData;
    }

    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }
}

