/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema.builder;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.schema.builder.SchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.schema.builder.spi.RuleBasedTableMetaDataBuilder;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.rule.identifier.type.TableContainedRule;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.ordered.OrderedSPIRegistry;

public final class TableMetaDataBuilder {
    public static Map<String, TableMetaData> load(Collection<String> tableNames, SchemaBuilderMaterials materials) throws SQLException {
        LinkedHashMap<String, TableMetaData> tableMetaDataMap = new LinkedHashMap<String, TableMetaData>();
        for (Map.Entry entry : OrderedSPIRegistry.getRegisteredServices(RuleBasedTableMetaDataBuilder.class, materials.getRules()).entrySet()) {
            if (!(entry.getKey() instanceof TableContainedRule)) continue;
            TableContainedRule rule = (TableContainedRule)entry.getKey();
            RuleBasedTableMetaDataBuilder builder = (RuleBasedTableMetaDataBuilder)entry.getValue();
            Collection needLoadTables = tableNames.stream().filter(each -> rule.getTables().contains(each)).filter(each -> !tableMetaDataMap.containsKey(each)).collect(Collectors.toList());
            if (needLoadTables.isEmpty()) continue;
            tableMetaDataMap.putAll(builder.load(needLoadTables, rule, materials));
        }
        return TableMetaDataBuilder.decorate(tableMetaDataMap, materials);
    }

    private static Map<String, TableMetaData> decorate(Map<String, TableMetaData> tableMetaDataMap, SchemaBuilderMaterials materials) throws SQLException {
        LinkedHashMap<String, TableMetaData> result = new LinkedHashMap<String, TableMetaData>(tableMetaDataMap);
        for (Map.Entry entry : OrderedSPIRegistry.getRegisteredServices(RuleBasedTableMetaDataBuilder.class, materials.getRules()).entrySet()) {
            if (!(entry.getKey() instanceof TableContainedRule)) continue;
            result.putAll(((RuleBasedTableMetaDataBuilder)entry.getValue()).decorate(result, (TableContainedRule)entry.getKey(), materials));
        }
        return result;
    }

    @Generated
    private TableMetaDataBuilder() {
    }

    static {
        ShardingSphereServiceLoader.register(RuleBasedTableMetaDataBuilder.class);
    }
}

