/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema.builder.loader.dialect;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.metadata.schema.builder.loader.DataTypeLoader;
import org.apache.shardingsphere.infra.metadata.schema.builder.spi.DialectTableMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.schema.model.ColumnMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.IndexMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;

public final class PostgreSQLTableMetaDataLoader
implements DialectTableMetaDataLoader {
    private static final String BASIC_TABLE_META_DATA_SQL = "SELECT table_name, column_name, ordinal_position, data_type, udt_name, column_default FROM information_schema.columns WHERE table_schema = ?";
    private static final String TABLE_META_DATA_SQL_IN_TABLES = "SELECT table_name, column_name, ordinal_position, data_type, udt_name, column_default FROM information_schema.columns WHERE table_schema = ? AND table_name IN (%s)";
    private static final String PRIMARY_KEY_META_DATA_SQL = "SELECT tc.table_name, kc.column_name FROM information_schema.table_constraints tc JOIN information_schema.key_column_usage kc ON kc.table_schema = tc.table_schema AND kc.table_name = tc.table_name AND kc.constraint_name = tc.constraint_name WHERE tc.constraint_type = 'PRIMARY KEY' AND kc.ordinal_position IS NOT NULL AND kc.table_schema = ?";
    private static final String BASIC_INDEX_META_DATA_SQL = "SELECT tablename, indexname FROM pg_indexes WHERE schemaname = ?";
    private static final String LOAD_ALL_ROLE_TABLE_GRANTS_SQL = "SELECT table_name FROM information_schema.role_table_grants";
    private static final String LOAD_FILTED_ROLE_TABLE_GRANTS_SQL = "SELECT table_name FROM information_schema.role_table_grants WHERE table_name IN (%s)";

    @Override
    public Map<String, TableMetaData> load(DataSource dataSource, Collection<String> tables) throws SQLException {
        LinkedHashMap<String, TableMetaData> result = new LinkedHashMap<String, TableMetaData>();
        Map<String, Collection<IndexMetaData>> indexMetaDataMap = this.loadIndexMetaDataMap(dataSource);
        for (Map.Entry<String, Collection<ColumnMetaData>> entry : this.loadColumnMetaDataMap(dataSource, tables).entrySet()) {
            Collection<IndexMetaData> indexMetaDataList = indexMetaDataMap.get(entry.getKey());
            if (null == indexMetaDataList) {
                indexMetaDataList = Collections.emptyList();
            }
            result.put(entry.getKey(), new TableMetaData(entry.getKey(), entry.getValue(), indexMetaDataList));
        }
        return result;
    }

    private Map<String, Collection<ColumnMetaData>> loadColumnMetaDataMap(DataSource dataSource, Collection<String> tables) throws SQLException {
        HashMap<String, SortedMap> result = new HashMap<String, SortedMap>();
        Collection<String> roleTableGrants = this.loadRoleTableGrants(dataSource, tables);
        try (Connection connection = dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.getTableMetaDataSQL(tables));){
            Map<String, Integer> dataTypes = DataTypeLoader.load(connection.getMetaData());
            Set<String> primaryKeys = this.loadPrimaryKeys(connection);
            preparedStatement.setString(1, connection.getSchema());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("table_name");
                    if (!roleTableGrants.contains(tableName)) continue;
                    SortedMap columns = result.computeIfAbsent(tableName, key -> new TreeMap());
                    ColumnMetaData columnMetaData = this.loadColumnMetaData(dataTypes, primaryKeys, resultSet);
                    columns.put(resultSet.getInt("ordinal_position"), columnMetaData);
                }
            }
        }
        return result.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((SortedMap)entry.getValue()).values()));
    }

    private Set<String> loadPrimaryKeys(Connection connection) throws SQLException {
        HashSet<String> result = new HashSet<String>();
        try (PreparedStatement preparedStatement = connection.prepareStatement(PRIMARY_KEY_META_DATA_SQL);){
            preparedStatement.setString(1, connection.getSchema());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("table_name");
                    String columnName = resultSet.getString("column_name");
                    result.add(tableName + "," + columnName);
                }
            }
        }
        return result;
    }

    private ColumnMetaData loadColumnMetaData(Map<String, Integer> dataTypeMap, Set<String> primaryKeys, ResultSet resultSet) throws SQLException {
        String tableName = resultSet.getString("table_name");
        String columnName = resultSet.getString("column_name");
        String dataType = resultSet.getString("udt_name");
        boolean isPrimaryKey = primaryKeys.contains(tableName + "," + columnName);
        String columnDefault = resultSet.getString("column_default");
        boolean generated = null != columnDefault && columnDefault.startsWith("nextval(");
        boolean caseSensitive = true;
        return new ColumnMetaData(columnName, dataTypeMap.get(dataType), isPrimaryKey, generated, caseSensitive);
    }

    private String getTableMetaDataSQL(Collection<String> tables) {
        return tables.isEmpty() ? BASIC_TABLE_META_DATA_SQL : String.format(TABLE_META_DATA_SQL_IN_TABLES, tables.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    private Map<String, Collection<IndexMetaData>> loadIndexMetaDataMap(DataSource dataSource) throws SQLException {
        HashMap<String, Collection<IndexMetaData>> result = new HashMap<String, Collection<IndexMetaData>>();
        try (Connection connection = dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(BASIC_INDEX_META_DATA_SQL);){
            preparedStatement.setString(1, connection.getSchema());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("tablename");
                    Collection indexes = result.computeIfAbsent(tableName, k -> new LinkedList());
                    String indexName = resultSet.getString("indexname");
                    indexes.add(new IndexMetaData(indexName));
                }
            }
        }
        return result;
    }

    private Collection<String> loadRoleTableGrants(DataSource dataSource, Collection<String> tables) throws SQLException {
        LinkedList<String> result = new LinkedList<String>();
        try (Connection connection = dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.getLoadRoleTableGrantsSQL(tables));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                result.add(resultSet.getString("table_name"));
            }
        }
        return result;
    }

    private String getLoadRoleTableGrantsSQL(Collection<String> tables) {
        return tables.isEmpty() ? LOAD_ALL_ROLE_TABLE_GRANTS_SQL : String.format(LOAD_FILTED_ROLE_TABLE_GRANTS_SQL, tables.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    @Override
    public String getDatabaseType() {
        return "PostgreSQL";
    }
}

