/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher.type;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContext;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContextFactory;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationSchemaMetaData;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.schema.event.SchemaAlteredEvent;
import org.apache.shardingsphere.infra.rule.identifier.type.MutableDataNodeRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropTableStatement;

public final class DropTableStatementSchemaRefresher
implements MetaDataRefresher<DropTableStatement> {
    private static final String TYPE = DropTableStatement.class.getName();

    @Override
    public void refresh(ShardingSphereMetaData schemaMetaData, FederationSchemaMetaData schema, Map<String, OptimizerPlannerContext> optimizerPlanners, Collection<String> logicDataSourceNames, DropTableStatement sqlStatement, ConfigurationProperties props) throws SQLException {
        SchemaAlteredEvent event = new SchemaAlteredEvent(schemaMetaData.getName());
        sqlStatement.getTables().forEach(each -> {
            schemaMetaData.getSchema().remove(each.getTableName().getIdentifier().getValue());
            schema.remove(each.getTableName().getIdentifier().getValue());
            optimizerPlanners.put(schema.getName(), OptimizerPlannerContextFactory.create((FederationSchemaMetaData)schema));
            event.getDroppedTables().add(each.getTableName().getIdentifier().getValue());
        });
        Collection rules = schemaMetaData.getRuleMetaData().findRules(MutableDataNodeRule.class);
        for (SimpleTableSegment each2 : sqlStatement.getTables()) {
            rules.forEach(rule -> rule.remove(each2.getTableName().getIdentifier().getValue()));
        }
        ShardingSphereEventBus.getInstance().post((Object)event);
    }

    public String getType() {
        return TYPE;
    }
}

