/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher.type;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContext;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContextFactory;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationSchemaMetaData;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.schema.builder.SchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.schema.builder.TableMetaDataBuilder;
import org.apache.shardingsphere.infra.metadata.schema.event.SchemaAlteredEvent;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.MutableDataNodeRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.table.RenameTableDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.RenameTableStatement;

public final class RenameTableStatementSchemaRefresher
implements MetaDataRefresher<RenameTableStatement> {
    private static final String TYPE = RenameTableStatement.class.getName();

    @Override
    public void refresh(ShardingSphereMetaData schemaMetaData, FederationSchemaMetaData schema, Map<String, OptimizerPlannerContext> optimizerPlanners, Collection<String> logicDataSourceNames, RenameTableStatement sqlStatement, ConfigurationProperties props) throws SQLException {
        SchemaAlteredEvent event = new SchemaAlteredEvent(schemaMetaData.getName());
        for (RenameTableDefinitionSegment each : sqlStatement.getRenameTables()) {
            String tableName = each.getTable().getTableName().getIdentifier().getValue();
            String renameTable = each.getRenameTable().getTableName().getIdentifier().getValue();
            this.putTableMetaData(schemaMetaData, schema, optimizerPlanners, logicDataSourceNames, renameTable, props);
            this.removeTableMetaData(schemaMetaData, schema, optimizerPlanners, tableName);
            event.getAlteredTables().add(schemaMetaData.getSchema().get(renameTable));
            event.getDroppedTables().add(tableName);
        }
        ShardingSphereEventBus.getInstance().post((Object)event);
    }

    private void removeTableMetaData(ShardingSphereMetaData schemaMetaData, FederationSchemaMetaData schema, Map<String, OptimizerPlannerContext> optimizerPlanners, String tableName) {
        schemaMetaData.getSchema().remove(tableName);
        schemaMetaData.getRuleMetaData().findRules(MutableDataNodeRule.class).forEach(each -> each.remove(tableName));
        schema.remove(tableName);
        optimizerPlanners.put(schema.getName(), OptimizerPlannerContextFactory.create((FederationSchemaMetaData)schema));
    }

    private void putTableMetaData(ShardingSphereMetaData schemaMetaData, FederationSchemaMetaData schema, Map<String, OptimizerPlannerContext> optimizerPlanners, Collection<String> logicDataSourceNames, String tableName, ConfigurationProperties props) throws SQLException {
        if (!this.containsInDataNodeContainedRule(tableName, schemaMetaData)) {
            schemaMetaData.getRuleMetaData().findRules(MutableDataNodeRule.class).forEach(each -> each.put(tableName, (String)logicDataSourceNames.iterator().next()));
        }
        SchemaBuilderMaterials materials = new SchemaBuilderMaterials(schemaMetaData.getResource().getDatabaseType(), schemaMetaData.getResource().getDataSources(), schemaMetaData.getRuleMetaData().getRules(), props);
        Optional actualTableMetaData = Optional.ofNullable(TableMetaDataBuilder.load(Collections.singletonList(tableName), (SchemaBuilderMaterials)materials).get(tableName));
        actualTableMetaData.ifPresent(tableMetaData -> {
            schemaMetaData.getSchema().put(tableName, tableMetaData);
            schema.put(tableMetaData);
            optimizerPlanners.put(schema.getName(), OptimizerPlannerContextFactory.create((FederationSchemaMetaData)schema));
        });
    }

    private boolean containsInDataNodeContainedRule(String tableName, ShardingSphereMetaData schemaMetaData) {
        return schemaMetaData.getRuleMetaData().findRules(DataNodeContainedRule.class).stream().anyMatch(each -> each.getAllTables().contains(tableName));
    }

    public String getType() {
        return TYPE;
    }
}

