/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import java.util.Collections;
import org.apache.http.Header;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeRequest;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeResponse;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheResponse;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.action.admin.indices.close.CloseIndexResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.flush.FlushResponse;
import org.elasticsearch.action.admin.indices.flush.SyncedFlushRequest;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.action.admin.indices.open.OpenIndexResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverResponse;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsResponse;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeResponse;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesRequest;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateResponse;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryRequest;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryResponse;
import org.elasticsearch.client.GetAliasesResponse;
import org.elasticsearch.client.RequestConverters;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.SyncedFlushResponse;
import org.elasticsearch.rest.RestStatus;

public final class IndicesClient {
    private final RestHighLevelClient restHighLevelClient;

    IndicesClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public DeleteIndexResponse delete(DeleteIndexRequest deleteIndexRequest, RequestOptions options) throws IOException {
        return (DeleteIndexResponse)this.restHighLevelClient.performRequestAndParseEntity(deleteIndexRequest, RequestConverters::deleteIndex, options, DeleteIndexResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public DeleteIndexResponse delete(DeleteIndexRequest deleteIndexRequest, Header ... headers) throws IOException {
        return (DeleteIndexResponse)this.restHighLevelClient.performRequestAndParseEntity(deleteIndexRequest, RequestConverters::deleteIndex, DeleteIndexResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void deleteAsync(DeleteIndexRequest deleteIndexRequest, RequestOptions options, ActionListener<DeleteIndexResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(deleteIndexRequest, RequestConverters::deleteIndex, options, DeleteIndexResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public void deleteAsync(DeleteIndexRequest deleteIndexRequest, ActionListener<DeleteIndexResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(deleteIndexRequest, RequestConverters::deleteIndex, DeleteIndexResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public CreateIndexResponse create(CreateIndexRequest createIndexRequest, RequestOptions options) throws IOException {
        return (CreateIndexResponse)this.restHighLevelClient.performRequestAndParseEntity(createIndexRequest, RequestConverters::createIndex, options, CreateIndexResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public CreateIndexResponse create(CreateIndexRequest createIndexRequest, Header ... headers) throws IOException {
        return (CreateIndexResponse)this.restHighLevelClient.performRequestAndParseEntity(createIndexRequest, RequestConverters::createIndex, CreateIndexResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void createAsync(CreateIndexRequest createIndexRequest, RequestOptions options, ActionListener<CreateIndexResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(createIndexRequest, RequestConverters::createIndex, options, CreateIndexResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public void createAsync(CreateIndexRequest createIndexRequest, ActionListener<CreateIndexResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(createIndexRequest, RequestConverters::createIndex, CreateIndexResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public PutMappingResponse putMapping(PutMappingRequest putMappingRequest, RequestOptions options) throws IOException {
        return (PutMappingResponse)this.restHighLevelClient.performRequestAndParseEntity(putMappingRequest, RequestConverters::putMapping, options, PutMappingResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public PutMappingResponse putMapping(PutMappingRequest putMappingRequest, Header ... headers) throws IOException {
        return (PutMappingResponse)this.restHighLevelClient.performRequestAndParseEntity(putMappingRequest, RequestConverters::putMapping, PutMappingResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void putMappingAsync(PutMappingRequest putMappingRequest, RequestOptions options, ActionListener<PutMappingResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(putMappingRequest, RequestConverters::putMapping, options, PutMappingResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public void putMappingAsync(PutMappingRequest putMappingRequest, ActionListener<PutMappingResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(putMappingRequest, RequestConverters::putMapping, PutMappingResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public GetMappingsResponse getMapping(GetMappingsRequest getMappingsRequest, RequestOptions options) throws IOException {
        return (GetMappingsResponse)this.restHighLevelClient.performRequestAndParseEntity(getMappingsRequest, RequestConverters::getMappings, options, GetMappingsResponse::fromXContent, Collections.emptySet());
    }

    public void getMappingAsync(GetMappingsRequest getMappingsRequest, RequestOptions options, ActionListener<GetMappingsResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(getMappingsRequest, RequestConverters::getMappings, options, GetMappingsResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetFieldMappingsResponse getFieldMapping(GetFieldMappingsRequest getFieldMappingsRequest, RequestOptions options) throws IOException {
        return (GetFieldMappingsResponse)this.restHighLevelClient.performRequestAndParseEntity(getFieldMappingsRequest, RequestConverters::getFieldMapping, options, GetFieldMappingsResponse::fromXContent, Collections.emptySet());
    }

    public void getFieldMappingAsync(GetFieldMappingsRequest getFieldMappingsRequest, RequestOptions options, ActionListener<GetFieldMappingsResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(getFieldMappingsRequest, RequestConverters::getFieldMapping, options, GetFieldMappingsResponse::fromXContent, listener, Collections.emptySet());
    }

    public IndicesAliasesResponse updateAliases(IndicesAliasesRequest indicesAliasesRequest, RequestOptions options) throws IOException {
        return (IndicesAliasesResponse)this.restHighLevelClient.performRequestAndParseEntity(indicesAliasesRequest, RequestConverters::updateAliases, options, IndicesAliasesResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public IndicesAliasesResponse updateAliases(IndicesAliasesRequest indicesAliasesRequest, Header ... headers) throws IOException {
        return (IndicesAliasesResponse)this.restHighLevelClient.performRequestAndParseEntity(indicesAliasesRequest, RequestConverters::updateAliases, IndicesAliasesResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void updateAliasesAsync(IndicesAliasesRequest indicesAliasesRequest, RequestOptions options, ActionListener<IndicesAliasesResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(indicesAliasesRequest, RequestConverters::updateAliases, options, IndicesAliasesResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public void updateAliasesAsync(IndicesAliasesRequest indicesAliasesRequest, ActionListener<IndicesAliasesResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(indicesAliasesRequest, RequestConverters::updateAliases, IndicesAliasesResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public OpenIndexResponse open(OpenIndexRequest openIndexRequest, RequestOptions options) throws IOException {
        return (OpenIndexResponse)this.restHighLevelClient.performRequestAndParseEntity(openIndexRequest, RequestConverters::openIndex, options, OpenIndexResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public OpenIndexResponse open(OpenIndexRequest openIndexRequest, Header ... headers) throws IOException {
        return (OpenIndexResponse)this.restHighLevelClient.performRequestAndParseEntity(openIndexRequest, RequestConverters::openIndex, OpenIndexResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void openAsync(OpenIndexRequest openIndexRequest, RequestOptions options, ActionListener<OpenIndexResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(openIndexRequest, RequestConverters::openIndex, options, OpenIndexResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public void openAsync(OpenIndexRequest openIndexRequest, ActionListener<OpenIndexResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(openIndexRequest, RequestConverters::openIndex, OpenIndexResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public CloseIndexResponse close(CloseIndexRequest closeIndexRequest, RequestOptions options) throws IOException {
        return (CloseIndexResponse)this.restHighLevelClient.performRequestAndParseEntity(closeIndexRequest, RequestConverters::closeIndex, options, CloseIndexResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public CloseIndexResponse close(CloseIndexRequest closeIndexRequest, Header ... headers) throws IOException {
        return (CloseIndexResponse)this.restHighLevelClient.performRequestAndParseEntity(closeIndexRequest, RequestConverters::closeIndex, CloseIndexResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void closeAsync(CloseIndexRequest closeIndexRequest, RequestOptions options, ActionListener<CloseIndexResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(closeIndexRequest, RequestConverters::closeIndex, options, CloseIndexResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public void closeAsync(CloseIndexRequest closeIndexRequest, ActionListener<CloseIndexResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(closeIndexRequest, RequestConverters::closeIndex, CloseIndexResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public boolean existsAlias(GetAliasesRequest getAliasesRequest, RequestOptions options) throws IOException {
        return (Boolean)this.restHighLevelClient.performRequest(getAliasesRequest, RequestConverters::existsAlias, options, RestHighLevelClient::convertExistsResponse, Collections.emptySet());
    }

    @Deprecated
    public boolean existsAlias(GetAliasesRequest getAliasesRequest, Header ... headers) throws IOException {
        return (Boolean)this.restHighLevelClient.performRequest(getAliasesRequest, RequestConverters::existsAlias, RestHighLevelClient::convertExistsResponse, Collections.emptySet(), headers);
    }

    public void existsAliasAsync(GetAliasesRequest getAliasesRequest, RequestOptions options, ActionListener<Boolean> listener) {
        this.restHighLevelClient.performRequestAsync(getAliasesRequest, RequestConverters::existsAlias, options, RestHighLevelClient::convertExistsResponse, listener, Collections.emptySet());
    }

    @Deprecated
    public void existsAliasAsync(GetAliasesRequest getAliasesRequest, ActionListener<Boolean> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsync(getAliasesRequest, RequestConverters::existsAlias, RestHighLevelClient::convertExistsResponse, listener, Collections.emptySet(), headers);
    }

    public RefreshResponse refresh(RefreshRequest refreshRequest, RequestOptions options) throws IOException {
        return (RefreshResponse)this.restHighLevelClient.performRequestAndParseEntity(refreshRequest, RequestConverters::refresh, options, RefreshResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public RefreshResponse refresh(RefreshRequest refreshRequest, Header ... headers) throws IOException {
        return (RefreshResponse)this.restHighLevelClient.performRequestAndParseEntity(refreshRequest, RequestConverters::refresh, RefreshResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void refreshAsync(RefreshRequest refreshRequest, RequestOptions options, ActionListener<RefreshResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(refreshRequest, RequestConverters::refresh, options, RefreshResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public void refreshAsync(RefreshRequest refreshRequest, ActionListener<RefreshResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(refreshRequest, RequestConverters::refresh, RefreshResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public FlushResponse flush(FlushRequest flushRequest, RequestOptions options) throws IOException {
        return (FlushResponse)this.restHighLevelClient.performRequestAndParseEntity(flushRequest, RequestConverters::flush, options, FlushResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public FlushResponse flush(FlushRequest flushRequest, Header ... headers) throws IOException {
        return (FlushResponse)this.restHighLevelClient.performRequestAndParseEntity(flushRequest, RequestConverters::flush, FlushResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void flushAsync(FlushRequest flushRequest, RequestOptions options, ActionListener<FlushResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(flushRequest, RequestConverters::flush, options, FlushResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public void flushAsync(FlushRequest flushRequest, ActionListener<FlushResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(flushRequest, RequestConverters::flush, FlushResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public SyncedFlushResponse flushSynced(SyncedFlushRequest syncedFlushRequest, RequestOptions options) throws IOException {
        return (SyncedFlushResponse)((Object)this.restHighLevelClient.performRequestAndParseEntity(syncedFlushRequest, RequestConverters::flushSynced, options, SyncedFlushResponse::fromXContent, Collections.emptySet()));
    }

    public void flushSyncedAsync(SyncedFlushRequest syncedFlushRequest, RequestOptions options, ActionListener<SyncedFlushResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(syncedFlushRequest, RequestConverters::flushSynced, options, SyncedFlushResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetSettingsResponse getSettings(GetSettingsRequest getSettingsRequest, RequestOptions options) throws IOException {
        return (GetSettingsResponse)this.restHighLevelClient.performRequestAndParseEntity(getSettingsRequest, RequestConverters::getSettings, options, GetSettingsResponse::fromXContent, Collections.emptySet());
    }

    public void getSettingsAsync(GetSettingsRequest getSettingsRequest, RequestOptions options, ActionListener<GetSettingsResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(getSettingsRequest, RequestConverters::getSettings, options, GetSettingsResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetIndexResponse get(GetIndexRequest getIndexRequest, RequestOptions options) throws IOException {
        return (GetIndexResponse)this.restHighLevelClient.performRequestAndParseEntity(getIndexRequest, RequestConverters::getIndex, options, GetIndexResponse::fromXContent, Collections.emptySet());
    }

    public void getAsync(GetIndexRequest getIndexRequest, RequestOptions options, ActionListener<GetIndexResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(getIndexRequest, RequestConverters::getIndex, options, GetIndexResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public ForceMergeResponse forceMerge(ForceMergeRequest forceMergeRequest, RequestOptions options) throws IOException {
        return this.forcemerge(forceMergeRequest, options);
    }

    public ForceMergeResponse forcemerge(ForceMergeRequest forceMergeRequest, RequestOptions options) throws IOException {
        return (ForceMergeResponse)this.restHighLevelClient.performRequestAndParseEntity(forceMergeRequest, RequestConverters::forceMerge, options, ForceMergeResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public ForceMergeResponse forceMerge(ForceMergeRequest forceMergeRequest, Header ... headers) throws IOException {
        return (ForceMergeResponse)this.restHighLevelClient.performRequestAndParseEntity(forceMergeRequest, RequestConverters::forceMerge, ForceMergeResponse::fromXContent, Collections.emptySet(), headers);
    }

    @Deprecated
    public void forceMergeAsync(ForceMergeRequest forceMergeRequest, RequestOptions options, ActionListener<ForceMergeResponse> listener) {
        this.forcemergeAsync(forceMergeRequest, options, listener);
    }

    public void forcemergeAsync(ForceMergeRequest forceMergeRequest, RequestOptions options, ActionListener<ForceMergeResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(forceMergeRequest, RequestConverters::forceMerge, options, ForceMergeResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public void forceMergeAsync(ForceMergeRequest forceMergeRequest, ActionListener<ForceMergeResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(forceMergeRequest, RequestConverters::forceMerge, ForceMergeResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public ClearIndicesCacheResponse clearCache(ClearIndicesCacheRequest clearIndicesCacheRequest, RequestOptions options) throws IOException {
        return (ClearIndicesCacheResponse)this.restHighLevelClient.performRequestAndParseEntity(clearIndicesCacheRequest, RequestConverters::clearCache, options, ClearIndicesCacheResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public ClearIndicesCacheResponse clearCache(ClearIndicesCacheRequest clearIndicesCacheRequest, Header ... headers) throws IOException {
        return (ClearIndicesCacheResponse)this.restHighLevelClient.performRequestAndParseEntity(clearIndicesCacheRequest, RequestConverters::clearCache, ClearIndicesCacheResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void clearCacheAsync(ClearIndicesCacheRequest clearIndicesCacheRequest, RequestOptions options, ActionListener<ClearIndicesCacheResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(clearIndicesCacheRequest, RequestConverters::clearCache, options, ClearIndicesCacheResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public void clearCacheAsync(ClearIndicesCacheRequest clearIndicesCacheRequest, ActionListener<ClearIndicesCacheResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(clearIndicesCacheRequest, RequestConverters::clearCache, ClearIndicesCacheResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public boolean exists(GetIndexRequest request, RequestOptions options) throws IOException {
        return (Boolean)this.restHighLevelClient.performRequest(request, RequestConverters::indicesExist, options, RestHighLevelClient::convertExistsResponse, Collections.emptySet());
    }

    @Deprecated
    public boolean exists(GetIndexRequest request, Header ... headers) throws IOException {
        return (Boolean)this.restHighLevelClient.performRequest(request, RequestConverters::indicesExist, RestHighLevelClient::convertExistsResponse, Collections.emptySet(), headers);
    }

    public void existsAsync(GetIndexRequest request, RequestOptions options, ActionListener<Boolean> listener) {
        this.restHighLevelClient.performRequestAsync(request, RequestConverters::indicesExist, options, RestHighLevelClient::convertExistsResponse, listener, Collections.emptySet());
    }

    @Deprecated
    public void existsAsync(GetIndexRequest request, ActionListener<Boolean> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsync(request, RequestConverters::indicesExist, RestHighLevelClient::convertExistsResponse, listener, Collections.emptySet(), headers);
    }

    public ResizeResponse shrink(ResizeRequest resizeRequest, RequestOptions options) throws IOException {
        return (ResizeResponse)this.restHighLevelClient.performRequestAndParseEntity(resizeRequest, RequestConverters::shrink, options, ResizeResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public ResizeResponse shrink(ResizeRequest resizeRequest, Header ... headers) throws IOException {
        return (ResizeResponse)this.restHighLevelClient.performRequestAndParseEntity(resizeRequest, RequestConverters::shrink, ResizeResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void shrinkAsync(ResizeRequest resizeRequest, RequestOptions options, ActionListener<ResizeResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(resizeRequest, RequestConverters::shrink, options, ResizeResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public void shrinkAsync(ResizeRequest resizeRequest, ActionListener<ResizeResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(resizeRequest, RequestConverters::shrink, ResizeResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public ResizeResponse split(ResizeRequest resizeRequest, RequestOptions options) throws IOException {
        return (ResizeResponse)this.restHighLevelClient.performRequestAndParseEntity(resizeRequest, RequestConverters::split, options, ResizeResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public ResizeResponse split(ResizeRequest resizeRequest, Header ... headers) throws IOException {
        return (ResizeResponse)this.restHighLevelClient.performRequestAndParseEntity(resizeRequest, RequestConverters::split, ResizeResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void splitAsync(ResizeRequest resizeRequest, RequestOptions options, ActionListener<ResizeResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(resizeRequest, RequestConverters::split, options, ResizeResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public void splitAsync(ResizeRequest resizeRequest, ActionListener<ResizeResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(resizeRequest, RequestConverters::split, ResizeResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public RolloverResponse rollover(RolloverRequest rolloverRequest, RequestOptions options) throws IOException {
        return (RolloverResponse)this.restHighLevelClient.performRequestAndParseEntity(rolloverRequest, RequestConverters::rollover, options, RolloverResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public RolloverResponse rollover(RolloverRequest rolloverRequest, Header ... headers) throws IOException {
        return (RolloverResponse)this.restHighLevelClient.performRequestAndParseEntity(rolloverRequest, RequestConverters::rollover, RolloverResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void rolloverAsync(RolloverRequest rolloverRequest, RequestOptions options, ActionListener<RolloverResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(rolloverRequest, RequestConverters::rollover, options, RolloverResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public void rolloverAsync(RolloverRequest rolloverRequest, ActionListener<RolloverResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(rolloverRequest, RequestConverters::rollover, RolloverResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public GetAliasesResponse getAlias(GetAliasesRequest getAliasesRequest, RequestOptions options) throws IOException {
        return (GetAliasesResponse)((Object)this.restHighLevelClient.performRequestAndParseEntity(getAliasesRequest, RequestConverters::getAlias, options, GetAliasesResponse::fromXContent, Collections.singleton(RestStatus.NOT_FOUND.getStatus())));
    }

    public void getAliasAsync(GetAliasesRequest getAliasesRequest, RequestOptions options, ActionListener<GetAliasesResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(getAliasesRequest, RequestConverters::getAlias, options, GetAliasesResponse::fromXContent, listener, Collections.singleton(RestStatus.NOT_FOUND.getStatus()));
    }

    public UpdateSettingsResponse putSettings(UpdateSettingsRequest updateSettingsRequest, RequestOptions options) throws IOException {
        return (UpdateSettingsResponse)this.restHighLevelClient.performRequestAndParseEntity(updateSettingsRequest, RequestConverters::indexPutSettings, options, UpdateSettingsResponse::fromXContent, Collections.emptySet());
    }

    @Deprecated
    public UpdateSettingsResponse putSettings(UpdateSettingsRequest updateSettingsRequest, Header ... headers) throws IOException {
        return (UpdateSettingsResponse)this.restHighLevelClient.performRequestAndParseEntity(updateSettingsRequest, RequestConverters::indexPutSettings, UpdateSettingsResponse::fromXContent, Collections.emptySet(), headers);
    }

    public void putSettingsAsync(UpdateSettingsRequest updateSettingsRequest, RequestOptions options, ActionListener<UpdateSettingsResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(updateSettingsRequest, RequestConverters::indexPutSettings, options, UpdateSettingsResponse::fromXContent, listener, Collections.emptySet());
    }

    @Deprecated
    public void putSettingsAsync(UpdateSettingsRequest updateSettingsRequest, ActionListener<UpdateSettingsResponse> listener, Header ... headers) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(updateSettingsRequest, RequestConverters::indexPutSettings, UpdateSettingsResponse::fromXContent, listener, Collections.emptySet(), headers);
    }

    public PutIndexTemplateResponse putTemplate(PutIndexTemplateRequest putIndexTemplateRequest, RequestOptions options) throws IOException {
        return (PutIndexTemplateResponse)this.restHighLevelClient.performRequestAndParseEntity(putIndexTemplateRequest, RequestConverters::putTemplate, options, PutIndexTemplateResponse::fromXContent, Collections.emptySet());
    }

    public void putTemplateAsync(PutIndexTemplateRequest putIndexTemplateRequest, RequestOptions options, ActionListener<PutIndexTemplateResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(putIndexTemplateRequest, RequestConverters::putTemplate, options, PutIndexTemplateResponse::fromXContent, listener, Collections.emptySet());
    }

    public ValidateQueryResponse validateQuery(ValidateQueryRequest validateQueryRequest, RequestOptions options) throws IOException {
        return (ValidateQueryResponse)this.restHighLevelClient.performRequestAndParseEntity(validateQueryRequest, RequestConverters::validateQuery, options, ValidateQueryResponse::fromXContent, Collections.emptySet());
    }

    public void validateQueryAsync(ValidateQueryRequest validateQueryRequest, RequestOptions options, ActionListener<ValidateQueryResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(validateQueryRequest, RequestConverters::validateQuery, options, ValidateQueryResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetIndexTemplatesResponse getTemplate(GetIndexTemplatesRequest getIndexTemplatesRequest, RequestOptions options) throws IOException {
        return (GetIndexTemplatesResponse)this.restHighLevelClient.performRequestAndParseEntity(getIndexTemplatesRequest, RequestConverters::getTemplates, options, GetIndexTemplatesResponse::fromXContent, Collections.emptySet());
    }

    public void getTemplateAsync(GetIndexTemplatesRequest getIndexTemplatesRequest, RequestOptions options, ActionListener<GetIndexTemplatesResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(getIndexTemplatesRequest, RequestConverters::getTemplates, options, GetIndexTemplatesResponse::fromXContent, listener, Collections.emptySet());
    }

    public AnalyzeResponse analyze(AnalyzeRequest request, RequestOptions options) throws IOException {
        return (AnalyzeResponse)this.restHighLevelClient.performRequestAndParseEntity(request, RequestConverters::analyze, options, AnalyzeResponse::fromXContent, Collections.emptySet());
    }

    public void analyzeAsync(AnalyzeRequest request, RequestOptions options, ActionListener<AnalyzeResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RequestConverters::analyze, options, AnalyzeResponse::fromXContent, listener, Collections.emptySet());
    }
}

