/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_2.planner.logical.steps;

import org.neo4j.cypher.internal.compiler.v3_2.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.compiler.v3_2.planner.logical.PlanTransformer;
import org.neo4j.cypher.internal.compiler.v3_2.planner.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.compiler.v3_2.spi.PlanContext;
import org.neo4j.cypher.internal.frontend.v3_2.HintException;
import org.neo4j.cypher.internal.frontend.v3_2.HintException$;
import org.neo4j.cypher.internal.frontend.v3_2.IndexHintException;
import org.neo4j.cypher.internal.frontend.v3_2.InternalException;
import org.neo4j.cypher.internal.frontend.v3_2.InternalException$;
import org.neo4j.cypher.internal.frontend.v3_2.JoinHintException;
import org.neo4j.cypher.internal.frontend.v3_2.ast.Hint;
import org.neo4j.cypher.internal.frontend.v3_2.ast.LabelName;
import org.neo4j.cypher.internal.frontend.v3_2.ast.PropertyKeyName;
import org.neo4j.cypher.internal.frontend.v3_2.ast.UsingIndexHint;
import org.neo4j.cypher.internal.frontend.v3_2.ast.UsingJoinHint;
import org.neo4j.cypher.internal.frontend.v3_2.ast.Variable;
import org.neo4j.cypher.internal.frontend.v3_2.notification.IndexHintUnfulfillableNotification;
import org.neo4j.cypher.internal.frontend.v3_2.notification.InternalNotification;
import org.neo4j.cypher.internal.frontend.v3_2.notification.JoinHintUnfulfillableNotification;
import org.neo4j.cypher.internal.ir.v3_2.PlannerQuery;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;

public final class verifyBestPlan$
implements PlanTransformer<PlannerQuery> {
    public static final verifyBestPlan$ MODULE$;

    static {
        new verifyBestPlan$();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LogicalPlan apply(LogicalPlan plan2, PlannerQuery expected, LogicalPlanningContext context) {
        void var4_4;
        block5: {
            block4: {
                PlannerQuery expectedWithoutHints;
                PlannerQuery constructed = plan2.solved();
                PlannerQuery plannerQuery = expected;
                PlannerQuery plannerQuery2 = constructed;
                if (!(plannerQuery == null ? plannerQuery2 != null : !plannerQuery.equals(plannerQuery2))) break block4;
                Set<UsingIndexHint> unfulfillableIndexHints = this.findUnfulfillableIndexHints(expected, context.planContext());
                Set<UsingJoinHint> unfulfillableJoinHints = this.findUnfulfillableJoinHints(expected, context.planContext());
                PlannerQuery plannerQuery3 = expectedWithoutHints = expected.withoutHints((GenTraversableOnce)unfulfillableIndexHints.$plus$plus(unfulfillableJoinHints, Set$.MODULE$.canBuildFrom()));
                PlannerQuery plannerQuery4 = constructed;
                if (plannerQuery3 != null ? !plannerQuery3.equals(plannerQuery4) : plannerQuery4 != null) break block5;
                this.processUnfulfilledIndexHints(context, unfulfillableIndexHints);
                this.processUnfulfilledJoinHints(context, unfulfillableJoinHints);
            }
            return plan2;
        }
        PlannerQuery a = expected.withoutHints((GenTraversableOnce)expected.allHints());
        PlannerQuery b = var4_4.withoutHints((GenTraversableOnce)var4_4.allHints());
        PlannerQuery plannerQuery = a;
        PlannerQuery plannerQuery5 = b;
        if (!(plannerQuery != null ? !plannerQuery.equals(plannerQuery5) : plannerQuery5 != null)) {
            Set actualHints;
            Set expectedHints = expected.allHints();
            Set missing = (Set)expectedHints.$minus$minus((GenTraversableOnce)(actualHints = var4_4.allHints()));
            String details2 = missing.isEmpty() ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected:\n               |", "\n               |\n               |Instead, got:\n               |", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.out$1(expectedHints), this.out$1(actualHints)})))).stripMargin() : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not solve these hints: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.out$1(missing)}));
            String message = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to fulfil the hints of the query.\n               |", "\n               |\n               |Plan ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{details2, plan2})))).stripMargin();
            throw new HintException(message, HintException$.MODULE$.$lessinit$greater$default$2());
        }
        throw new InternalException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected \\n", " \\n\\n\\nInstead, got: \\n", "\\nPlan: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expected, var4_4, plan2})), InternalException$.MODULE$.$lessinit$greater$default$2());
    }

    private void processUnfulfilledIndexHints(LogicalPlanningContext context, Set<UsingIndexHint> hints) {
        if (hints.nonEmpty()) {
            if (context.useErrorsOverWarnings()) {
                UsingIndexHint firstIndexHint = (UsingIndexHint)hints.head();
                throw new IndexHintException(firstIndexHint.variable().name(), firstIndexHint.label().name(), (Seq)firstIndexHint.properties().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(PropertyKeyName x$1) {
                        return x$1.name();
                    }
                }, Seq$.MODULE$.canBuildFrom()), "No such index");
            }
            hints.foreach((Function1)new Serializable(context){
                public static final long serialVersionUID = 0L;
                private final LogicalPlanningContext context$1;

                public final void apply(UsingIndexHint hint) {
                    this.context$1.notificationLogger().log((InternalNotification)new IndexHintUnfulfillableNotification(hint.label().name(), (Seq)hint.properties().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(PropertyKeyName x$2) {
                            return x$2.name();
                        }
                    }, Seq$.MODULE$.canBuildFrom())));
                }
                {
                    this.context$1 = context$1;
                }
            });
        }
    }

    private void processUnfulfilledJoinHints(LogicalPlanningContext context, Set<UsingJoinHint> hints) {
        if (hints.nonEmpty()) {
            if (context.useErrorsOverWarnings()) {
                UsingJoinHint firstJoinHint = (UsingJoinHint)hints.head();
                throw new JoinHintException((String)firstJoinHint.variables().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Variable x$3) {
                        return x$3.name();
                    }
                }).reduceLeft((Function2)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$4, String x$5) {
                        return new StringBuilder().append((Object)x$4).append((Object)", ").append((Object)x$5).toString();
                    }
                }), "Unable to plan hash join");
            }
            hints.foreach((Function1)new Serializable(context){
                public static final long serialVersionUID = 0L;
                private final LogicalPlanningContext context$2;

                public final void apply(UsingJoinHint hint) {
                    this.context$2.notificationLogger().log((InternalNotification)new JoinHintUnfulfillableNotification(hint.variables().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Variable x$6) {
                            return x$6.name();
                        }
                    }).toIndexedSeq()));
                }
                {
                    this.context$2 = context$2;
                }
            });
        }
    }

    private Set<UsingIndexHint> findUnfulfillableIndexHints(PlannerQuery query, PlanContext planContext) {
        return (Set)query.allHints().flatMap((Function1)new Serializable(planContext){
            public static final long serialVersionUID = 0L;
            private final PlanContext planContext$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Iterable<UsingIndexHint> apply(Hint x0$1) {
                boolean bl = false;
                UsingIndexHint usingIndexHint = null;
                Hint hint = x0$1;
                if (hint instanceof UsingIndexHint) {
                    bl = true;
                    usingIndexHint = (UsingIndexHint)hint;
                    LabelName labelName = usingIndexHint.label();
                    Seq properties = usingIndexHint.properties();
                    if (labelName != null) {
                        String label = labelName.name();
                        if (this.planContext$1.indexGet(label, (Seq<String>)((Seq)properties.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(PropertyKeyName x$7) {
                                return x$7.name();
                            }
                        }, Seq$.MODULE$.canBuildFrom()))).isDefined()) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                        if (this.planContext$1.uniqueIndexGet(label, (Seq<String>)((Seq)properties.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(PropertyKeyName x$8) {
                                return x$8.name();
                            }
                        }, Seq$.MODULE$.canBuildFrom()))).isDefined()) {
                            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                        }
                    }
                }
                if (!bl) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)usingIndexHint));
            }
            {
                this.planContext$1 = planContext$1;
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    private Set<UsingJoinHint> findUnfulfillableJoinHints(PlannerQuery query, PlanContext planContext) {
        return (Set)query.allHints().collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Hint, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof UsingJoinHint) {
                    UsingJoinHint usingJoinHint = (UsingJoinHint)A1;
                    object = usingJoinHint;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Hint x1) {
                Hint hint = x1;
                boolean bl = hint instanceof UsingJoinHint;
                return bl;
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    private final String out$1(Set h) {
        return h.mkString("`", ", ", "`");
    }

    private verifyBestPlan$() {
        MODULE$ = this;
    }
}

