/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Logger;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.AbstractHttpResponseCodec;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.internal.JsonToWebElementConverter;

public class W3CHttpResponseCodec
extends AbstractHttpResponseCodec {
    private static final Logger log = Logger.getLogger(W3CHttpResponseCodec.class.getName());
    private final ErrorCodes errorCodes = new ErrorCodes();
    private final JsonToBeanConverter jsonToBeanConverter = new JsonToBeanConverter();
    private final Function<Object, Object> elementConverter = new JsonToWebElementConverter(null);

    @Override
    public Response decode(HttpResponse encodedResponse) {
        String content = encodedResponse.getContentString().trim();
        log.fine(String.format("Decoding response. Response code was: %d and content: %s", encodedResponse.getStatus(), content));
        String contentType = Strings.nullToEmpty((String)encodedResponse.getHeader("Content-Type"));
        Response response = new Response();
        if (200 != encodedResponse.getStatus()) {
            log.fine("Processing an error");
            JsonObject obj = new JsonParser().parse(content).getAsJsonObject();
            JsonElement w3cWrappedValue = obj.get("value");
            if (w3cWrappedValue instanceof JsonObject && ((JsonObject)w3cWrappedValue).has("error")) {
                obj = (JsonObject)w3cWrappedValue;
            }
            String message = "An unknown error has occurred";
            if (obj.has("message")) {
                message = obj.get("message").getAsString();
            }
            String error = "unknown error";
            if (obj.has("error")) {
                error = obj.get("error").getAsString();
            }
            response.setState(error);
            response.setStatus(this.errorCodes.toStatus(error, Optional.of(encodedResponse.getStatus())));
            if ("unexpected alert open".equals(error) && 500 == encodedResponse.getStatus()) {
                JsonElement rawText;
                String text = "";
                JsonElement data = obj.get("data");
                if (data != null && (rawText = data.getAsJsonObject().get("text")) != null) {
                    text = rawText.getAsString();
                }
                response.setValue(new UnhandledAlertException(message, text));
            } else {
                response.setValue((Object)this.createException(error, message));
            }
            return response;
        }
        response.setState("success");
        response.setStatus(0);
        if (encodedResponse.getContent().length > 0 && (contentType.startsWith("application/json") || Strings.isNullOrEmpty((String)""))) {
            JsonObject parsed = new JsonParser().parse(content).getAsJsonObject();
            if (parsed.has("value")) {
                Object value = this.jsonToBeanConverter.convert(Object.class, parsed.get("value"));
                response.setValue(value);
            } else {
                response.setValue(this.jsonToBeanConverter.convert(Object.class, content));
            }
        }
        if (response.getValue() instanceof String) {
            response.setValue(((String)response.getValue()).replace("\r\n", "\n"));
        }
        return response;
    }

    @Override
    protected Object getValueToEncode(Response response) {
        HashMap toReturn = new HashMap();
        HashMap<String, Object> value = response.getValue();
        if (value instanceof WebDriverException) {
            HashMap<String, Object> exception = new HashMap<String, Object>();
            exception.put("error", response.getState() != null ? response.getState() : this.errorCodes.toState(response.getStatus()));
            exception.put("message", ((WebDriverException)((Object)value)).getMessage());
            exception.put("stacktrace", Throwables.getStackTraceAsString((Throwable)((WebDriverException)((Object)value))));
            if (value instanceof UnhandledAlertException) {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("text", ((UnhandledAlertException)value).getAlertText());
                exception.put("data", data);
            }
            value = exception;
        }
        toReturn.put("value", value);
        return toReturn;
    }

    @Override
    protected Response reconstructValue(Response response) {
        response.setValue(this.elementConverter.apply(response.getValue()));
        return response;
    }

    private WebDriverException createException(String error, String message) {
        Class<? extends WebDriverException> clazz = this.errorCodes.getExceptionType(error);
        try {
            Constructor<? extends WebDriverException> constructor = clazz.getConstructor(String.class);
            return constructor.newInstance(message);
        }
        catch (ReflectiveOperationException e) {
            throw new WebDriverException(message);
        }
    }
}

