/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AssertStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3346")
public class AssertOnBooleanVariableCheck
extends IssuableSubscriptionVisitor {
    private static final List<Tree.Kind> SIDE_EFFECT_KIND = ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION, (Object)Tree.Kind.ASSIGNMENT, (Object)Tree.Kind.MULTIPLY_ASSIGNMENT, (Object)Tree.Kind.DIVIDE_ASSIGNMENT, (Object)Tree.Kind.REMAINDER_ASSIGNMENT, (Object)Tree.Kind.PLUS_ASSIGNMENT, (Object)Tree.Kind.MINUS_ASSIGNMENT, (Object)Tree.Kind.LEFT_SHIFT_ASSIGNMENT, (Object)Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, (Object)Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, (Object)Tree.Kind.AND_ASSIGNMENT, (Object)Tree.Kind.XOR_ASSIGNMENT, (Object[])new Tree.Kind[]{Tree.Kind.OR_ASSIGNMENT, Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT});
    private boolean withinAssert;
    private boolean containsSideEffect;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().add((Object)Tree.Kind.ASSERT_STATEMENT).addAll(SIDE_EFFECT_KIND).build();
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.ASSERT_STATEMENT})) {
            this.withinAssert = true;
            this.containsSideEffect = false;
        } else if (this.withinAssert && !this.containsSideEffect) {
            this.containsSideEffect = true;
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.ASSERT_STATEMENT})) {
            if (this.containsSideEffect) {
                this.reportIssue((Tree)((AssertStatementTree)tree).condition(), "Move this \"assert\" side effect to another statement.");
            }
            this.withinAssert = false;
        }
    }
}

