/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1258")
public class AtLeastOneConstructorCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        this.checkClassTree((ClassTree)tree);
    }

    private void checkClassTree(ClassTree tree) {
        IdentifierTree simpleName = tree.simpleName();
        if (simpleName != null && !ModifiersUtils.hasModifier((ModifiersTree)tree.modifiers(), (Modifier)Modifier.ABSTRACT)) {
            boolean hasPrivateMember = false;
            for (Tree member : tree.members()) {
                if (member.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})) {
                    return;
                }
                if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) continue;
                VariableTree variable = (VariableTree)member;
                Symbol symbol = variable.symbol();
                hasPrivateMember |= variable.initializer() == null && symbol.isPrivate() && !symbol.isStatic();
            }
            if (hasPrivateMember) {
                this.reportIssue((Tree)simpleName, "Add a constructor to the " + tree.declarationKeyword().text() + ".");
            }
        }
    }
}

