/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.RspecKey;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="CallToDeprecatedMethod")
@RspecKey(value="S1874")
public class CallToDeprecatedMethodCheck
extends IssuableSubscriptionVisitor {
    private int nestedDeprecationLevel = 0;

    public void scanFile(JavaFileScannerContext context) {
        super.scanFile(context);
        this.nestedDeprecationLevel = 0;
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.IDENTIFIER, (Object)Tree.Kind.CLASS, (Object)Tree.Kind.ENUM, (Object)Tree.Kind.INTERFACE, (Object)Tree.Kind.ANNOTATION_TYPE, (Object)Tree.Kind.METHOD, (Object)Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            Symbol symbol = ((IdentifierTree)tree).symbol();
            if (CallToDeprecatedMethodCheck.isDeprecated(symbol) && this.nestedDeprecationLevel == 0) {
                String name = CallToDeprecatedMethodCheck.isConstructor(symbol) ? symbol.owner().name() : symbol.name();
                this.reportIssue(tree, "Remove this use of \"" + name + "\"; it is deprecated.");
            }
        } else if (CallToDeprecatedMethodCheck.isDeprecatedMethod(tree) || CallToDeprecatedMethodCheck.isDeprecatedClassTree(tree)) {
            ++this.nestedDeprecationLevel;
        }
    }

    private static boolean isDeprecated(Symbol symbol) {
        return symbol.isDeprecated() || CallToDeprecatedMethodCheck.isConstructor(symbol) && symbol.owner().isDeprecated();
    }

    private static boolean isConstructor(Symbol symbol) {
        return symbol.isMethodSymbol() && "<init>".equals(symbol.name());
    }

    public void leaveNode(Tree tree) {
        if (this.hasSemantic() && (CallToDeprecatedMethodCheck.isDeprecatedMethod(tree) || CallToDeprecatedMethodCheck.isDeprecatedClassTree(tree))) {
            --this.nestedDeprecationLevel;
        }
    }

    private static boolean isDeprecatedMethod(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR}) && ((MethodTree)tree).symbol().isDeprecated();
    }

    private static boolean isDeprecatedClassTree(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE}) && ((ClassTree)tree).symbol().isDeprecated();
    }
}

