/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.resolve.JavaType;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;

@Rule(key="S2185")
public class ConstantMathCheck
extends IssuableSubscriptionVisitor {
    private static final String ABS = "abs";
    private static final String CEIL = "ceil";
    private static final String DOUBLE = "double";
    private static final String FLOAT = "float";
    private static final String FLOOR = "floor";
    private static final String MATH_PACKAGE_NAME = "java.lang.Math";
    private static final String ROUND = "round";
    private static final MethodMatcherCollection CONSTANT_WITH_LITERAL_METHODS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().typeDefinition("java.lang.Math").name("abs").addParameter("double"), MethodMatcher.create().typeDefinition("java.lang.Math").name("abs").addParameter("float"), MethodMatcher.create().typeDefinition("java.lang.Math").name("abs").addParameter("int"), MethodMatcher.create().typeDefinition("java.lang.Math").name("abs").addParameter("long")});
    private static final MethodMatcherCollection TRUNCATION_METHODS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().typeDefinition("java.lang.Math").name("ceil").addParameter("double"), MethodMatcher.create().typeDefinition("java.lang.Math").name("ceil").addParameter("float"), MethodMatcher.create().typeDefinition("java.lang.Math").name("floor").addParameter("double"), MethodMatcher.create().typeDefinition("java.lang.Math").name("floor").addParameter("float"), MethodMatcher.create().typeDefinition("java.lang.Math").name("rint").addParameter("double"), MethodMatcher.create().typeDefinition("java.lang.Math").name("round").addParameter("double"), MethodMatcher.create().typeDefinition("java.lang.Math").name("round").addParameter("float")});
    private static final MethodMatcherCollection CONSTANT_WITH_ZERO_METHODS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().typeDefinition("java.lang.Math").name("atan2").addParameter("double").addParameter("double"), MethodMatcher.create().typeDefinition("java.lang.Math").name("cos").addParameter("double"), MethodMatcher.create().typeDefinition("java.lang.Math").name("cosh").addParameter("double"), MethodMatcher.create().typeDefinition("java.lang.Math").name("expm1").addParameter("double"), MethodMatcher.create().typeDefinition("java.lang.Math").name("sin").addParameter("double"), MethodMatcher.create().typeDefinition("java.lang.Math").name("sinh").addParameter("double"), MethodMatcher.create().typeDefinition("java.lang.Math").name("tan").addParameter("double"), MethodMatcher.create().typeDefinition("java.lang.Math").name("tanh").addParameter("double"), MethodMatcher.create().typeDefinition("java.lang.Math").name("toRadians").addParameter("double")});
    private static final MethodMatcherCollection CONSTANT_WITH_ZERO_OR_ONE_METHODS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().typeDefinition("java.lang.Math").name("acos").addParameter("double"), MethodMatcher.create().typeDefinition("java.lang.Math").name("asin").addParameter("double"), MethodMatcher.create().typeDefinition("java.lang.Math").name("atan").addParameter("double"), MethodMatcher.create().typeDefinition("java.lang.Math").name("cbrt").addParameter("double"), MethodMatcher.create().typeDefinition("java.lang.Math").name("exp").addParameter("double"), MethodMatcher.create().typeDefinition("java.lang.Math").name("log").addParameter("double"), MethodMatcher.create().typeDefinition("java.lang.Math").name("log10").addParameter("double"), MethodMatcher.create().typeDefinition("java.lang.Math").name("sqrt").addParameter("double"), MethodMatcher.create().typeDefinition("java.lang.Math").name("toDegrees").addParameter("double"), MethodMatcher.create().typeDefinition("java.lang.Math").name("exp").addParameter("double")});

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.REMAINDER, (Object)Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.REMAINDER})) {
                BinaryExpressionTree remainderTree = (BinaryExpressionTree)tree;
                if (ConstantMathCheck.isIntegralOne(remainderTree.rightOperand()) && ConstantMathCheck.isIntOrLong(remainderTree.leftOperand())) {
                    this.reportIssue((Tree)remainderTree.operatorToken(), "Remove this computation of % 1, which always evaluates to zero.");
                }
            } else {
                MethodInvocationTree mit = (MethodInvocationTree)tree;
                if (ConstantMathCheck.isConstantWithLiteral(mit) || ConstantMathCheck.isTruncation(mit) || ConstantMathCheck.isConstantWithZero(mit) || ConstantMathCheck.isConstantWithZeroOrOne(mit)) {
                    this.reportIssue((Tree)mit.methodSelect(), String.format("Remove this silly call to \"Math.%s\"", mit.symbol().name()));
                }
            }
        }
    }

    private static boolean isIntOrLong(ExpressionTree expression) {
        JavaType type = (JavaType)expression.symbolType();
        return ConstantMathCheck.isIntegral((Type)type) || type.isPrimitiveWrapper() && ConstantMathCheck.isIntegral((Type)type.primitiveType());
    }

    private static boolean isTruncation(MethodInvocationTree methodTree) {
        return TRUNCATION_METHODS.anyMatch(methodTree) && ConstantMathCheck.isCastFromIntegralToFloating(ExpressionsHelper.skipParentheses((ExpressionTree)methodTree.arguments().get(0)));
    }

    private static boolean isConstantWithLiteral(MethodInvocationTree methodTree) {
        return CONSTANT_WITH_LITERAL_METHODS.anyMatch(methodTree) && ConstantMathCheck.isConstant((ExpressionTree)methodTree.arguments().get(0));
    }

    private static boolean isConstantWithZero(MethodInvocationTree methodTree) {
        return CONSTANT_WITH_ZERO_METHODS.anyMatch(methodTree) && ConstantMathCheck.isFloatingZero((ExpressionTree)methodTree.arguments().get(0));
    }

    private static boolean isConstantWithZeroOrOne(MethodInvocationTree methodTree) {
        return CONSTANT_WITH_ZERO_OR_ONE_METHODS.anyMatch(methodTree) && ConstantMathCheck.isFloatingZeroOrOne((ExpressionTree)methodTree.arguments().get(0));
    }

    private static boolean isCastFromIntegralToFloating(ExpressionTree tree) {
        Type resultType = tree.symbolType();
        if (tree.is(new Tree.Kind[]{Tree.Kind.TYPE_CAST}) && ConstantMathCheck.isIntegral(ConstantMathCheck.getInnerType(((TypeCastTree)tree).expression())) && (resultType.is(DOUBLE) || resultType.is(FLOAT))) {
            return true;
        }
        return ConstantMathCheck.isIntegral(resultType);
    }

    private static boolean isConstant(ExpressionTree tree) {
        return ConstantMathCheck.getInnerExpression(tree).is(new Tree.Kind[]{Tree.Kind.CHAR_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL});
    }

    private static boolean isIntegral(Type type) {
        return type.isPrimitive() && !type.is(DOUBLE) && !type.is(FLOAT);
    }

    private static boolean isIntegralOne(ExpressionTree tree) {
        Long value = LiteralUtils.longLiteralValue((ExpressionTree)tree);
        return value != null && value == 1L;
    }

    private static ExpressionTree getInnerExpression(ExpressionTree tree) {
        ExpressionTree result = ExpressionsHelper.skipParentheses(tree);
        while (result.is(new Tree.Kind[]{Tree.Kind.TYPE_CAST})) {
            result = ExpressionsHelper.skipParentheses(((TypeCastTree)result).expression());
        }
        return result;
    }

    private static Type getInnerType(ExpressionTree tree) {
        return ConstantMathCheck.getInnerExpression(tree).symbolType();
    }

    private static boolean isFloatingZero(ExpressionTree tree) {
        Integer value = ConstantMathCheck.getFloatingZeroOrOne(tree);
        return value != null && value == 0;
    }

    private static boolean isFloatingZeroOrOne(ExpressionTree tree) {
        return ConstantMathCheck.getFloatingZeroOrOne(tree) != null;
    }

    @CheckForNull
    private static Integer getFloatingZeroOrOne(ExpressionTree tree) {
        ExpressionTree expressionTree = ExpressionsHelper.skipParentheses(tree);
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL})) {
            String value = ((LiteralTree)expressionTree).value();
            if ("0.0".equals(value) || "0.0d".equalsIgnoreCase(value) || "0.0f".equalsIgnoreCase(value)) {
                return 0;
            }
            if ("1.0".equals(value) || "1.0d".equalsIgnoreCase(value) || "1.0f".equalsIgnoreCase(value)) {
                return 1;
            }
        }
        return null;
    }
}

