/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ReassignmentFinder;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.matcher.NameCriteria;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3318")
public class DataStoredInSessionCheck
extends AbstractMethodDetection {
    private Set<IdentifierTree> identifiersUsedToSetAttribute;
    private static final MethodMatcherCollection REQUEST_OR_COOKIE_DATA_RETRIEVAL = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().typeDefinition("javax.servlet.http.Cookie").name(NameCriteria.startsWith((String)"get")).withNoParameterConstraint(), MethodMatcher.create().callSite(TypeCriteria.is((String)"javax.servlet.http.HttpServletRequest")).name(NameCriteria.startsWith((String)"get")).withNoParameterConstraint()});
    private static final MethodMatcherCollection NO_EFFECT_OPERATION = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().typeDefinition("java.net.URLDecoder").name("decode").withNoParameterConstraint(), MethodMatcher.create().typeDefinition("org.apache.commons.lang.StringEscapeUtils").name("escapeHtml").withNoParameterConstraint()});

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition("javax.servlet.http.HttpSession").name("setAttribute").addParameter(TypeCriteria.anyType()).addParameter(TypeCriteria.anyType()), (Object)MethodMatcher.create().typeDefinition("javax.servlet.http.HttpSession").name("putValue").addParameter(TypeCriteria.anyType()).addParameter(TypeCriteria.anyType()));
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        for (ExpressionTree argument : mit.arguments()) {
            this.checkArgument(argument, (ExpressionTree)mit, mit);
        }
    }

    private void checkArgument(ExpressionTree argument, ExpressionTree startPoint, MethodInvocationTree reportTree) {
        MethodInvocationTree mit;
        ExpressionTree expressionToEvaluate = argument;
        if (expressionToEvaluate.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree identifier = (IdentifierTree)expressionToEvaluate;
            this.identifiersUsedToSetAttribute.add(identifier);
            Symbol variable = identifier.symbol();
            ExpressionTree lastAssignmentOrDeclaration = ReassignmentFinder.getClosestReassignmentOrDeclarationExpression((Tree)startPoint, variable);
            if (lastAssignmentOrDeclaration != null && !this.usedBetween(variable, (Tree)lastAssignmentOrDeclaration, (Tree)startPoint)) {
                expressionToEvaluate = lastAssignmentOrDeclaration;
            }
        }
        if (DataStoredInSessionCheck.isRequestOrCookieDataRetrieval(expressionToEvaluate)) {
            this.reportIssue((Tree)reportTree.methodSelect(), "Make sure the user is authenticated before this data is stored in the session.");
        } else if (expressionToEvaluate.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && NO_EFFECT_OPERATION.anyMatch(mit = (MethodInvocationTree)expressionToEvaluate)) {
            this.checkArgument((ExpressionTree)mit.arguments().get(0), (ExpressionTree)mit, reportTree);
        }
    }

    private boolean usedBetween(Symbol variable, Tree start, Tree end) {
        SyntaxToken startToken = start.lastToken();
        SyntaxToken endToken = end.firstToken();
        for (IdentifierTree identifier : variable.usages()) {
            SyntaxToken identifierToken = identifier.identifierToken();
            if (!DataStoredInSessionCheck.isAfterFirstToken(identifierToken, startToken) || !DataStoredInSessionCheck.isBeforeLastToken(identifierToken, endToken) || this.identifiersUsedToSetAttribute.contains(identifier)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAfterFirstToken(SyntaxToken token, SyntaxToken firstToken) {
        int firstTokenLine = firstToken.line();
        int tokenLine = token.line();
        return tokenLine > firstTokenLine || tokenLine == firstTokenLine && firstToken.column() < token.column();
    }

    private static boolean isBeforeLastToken(SyntaxToken token, SyntaxToken lastToken) {
        int lastTokenLine = lastToken.line();
        int tokenLine = token.line();
        return tokenLine < lastTokenLine || tokenLine == lastTokenLine && lastToken.column() > token.column();
    }

    private static boolean isRequestOrCookieDataRetrieval(ExpressionTree expr) {
        return expr.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && REQUEST_OR_COOKIE_DATA_RETRIEVAL.anyMatch((MethodInvocationTree)expr);
    }

    public void scanFile(JavaFileScannerContext context) {
        this.identifiersUsedToSetAttribute = Sets.newHashSet();
        super.scanFile(context);
        this.identifiersUsedToSetAttribute.clear();
    }
}

