/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.NameCriteria;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S899")
public class IgnoredOperationStatusCheck
extends AbstractMethodDetection {
    private static final String FILE = "java.io.File";
    private static final TypeCriteria SUBTYPE_OF_CONDITION = TypeCriteria.subtypeOf((String)"java.util.concurrent.locks.Condition");
    private static final TypeCriteria SUBTYPE_OF_BLOCKING_QUEUE = TypeCriteria.subtypeOf((String)"java.util.concurrent.BlockingQueue");

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.util.concurrent.locks.Lock")).name("tryLock"), (Object)MethodMatcher.create().typeDefinition(FILE).name("delete"), (Object)MethodMatcher.create().typeDefinition(FILE).name("exists"), (Object)MethodMatcher.create().typeDefinition(FILE).name("createNewFile"), (Object)MethodMatcher.create().typeDefinition(FILE).name("renameTo").addParameter(FILE), (Object)MethodMatcher.create().typeDefinition(FILE).name(NameCriteria.startsWith((String)"can")), (Object)MethodMatcher.create().typeDefinition(FILE).name(NameCriteria.startsWith((String)"is")), (Object)MethodMatcher.create().typeDefinition(FILE).name(NameCriteria.startsWith((String)"set")).withNoParameterConstraint(), (Object)MethodMatcher.create().callSite(TypeCriteria.subtypeOf((String)"java.util.Iterator")).name("hasNext"), (Object)MethodMatcher.create().callSite(TypeCriteria.subtypeOf((String)"java.util.Enumeration")).name("hasMoreElements"), (Object)MethodMatcher.create().callSite(SUBTYPE_OF_CONDITION).name("await").addParameter("long").addParameter("java.util.concurrent.TimeUnit"), (Object)MethodMatcher.create().callSite(SUBTYPE_OF_CONDITION).name("awaitUntil").addParameter("java.util.Date"), (Object[])new MethodMatcher[]{MethodMatcher.create().callSite(SUBTYPE_OF_CONDITION).name("awaitNanos").addParameter("long"), MethodMatcher.create().typeDefinition("java.util.concurrent.CountDownLatch").name("await").addParameter("long").addParameter("java.util.concurrent.TimeUnit"), MethodMatcher.create().typeDefinition("java.util.concurrent.Semaphore").name("tryAcquire").withNoParameterConstraint(), MethodMatcher.create().callSite(SUBTYPE_OF_BLOCKING_QUEUE).name("offer").withNoParameterConstraint(), MethodMatcher.create().callSite(SUBTYPE_OF_BLOCKING_QUEUE).name("drainTo").withNoParameterConstraint(), MethodMatcher.create().callSite(SUBTYPE_OF_BLOCKING_QUEUE).name("remove").withNoParameterConstraint()});
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        Tree parent = mit.parent();
        if (parent.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT}) || parent.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && ((VariableTree)parent).symbol().usages().isEmpty()) {
            this.reportIssue(parent, "Do something with the \"" + mit.symbolType().name() + "\" value returned by \"" + mit.symbol().name() + "\".");
        }
    }
}

