/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2176")
public class InterfaceOrSuperclassShadowingCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.INTERFACE);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (this.hasSemantic()) {
            Symbol.TypeSymbol classSymbol = classTree.symbol();
            this.checkSuperType(classTree, classSymbol.superClass());
            for (Type interfaceType : classSymbol.interfaces()) {
                this.checkSuperType(classTree, interfaceType);
            }
        }
    }

    private void checkSuperType(ClassTree tree, Type superType) {
        if (superType != null && superType.symbol().name().equals(tree.symbol().name())) {
            String classOrInterface = tree.is(new Tree.Kind[]{Tree.Kind.CLASS}) ? "class" : "interface";
            this.reportIssue((Tree)tree.simpleName(), "Rename this " + classOrInterface + ".");
        }
    }
}

