/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Deque;
import java.util.LinkedList;
import org.sonar.check.Rule;
import org.sonar.java.RspecKey;
import org.sonar.java.ast.visitors.PublicApiChecker;
import org.sonar.java.checks.AbstractDeprecatedChecker;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="MissingDeprecatedCheck")
@RspecKey(value="S1123")
public class MissingDeprecatedCheck
extends AbstractDeprecatedChecker {
    private static final Tree.Kind[] CLASS_KINDS = PublicApiChecker.classKinds();
    private static final Tree.Kind[] METHOD_KINDS = PublicApiChecker.methodKinds();
    private final Deque<Tree> currentParent = new LinkedList<Tree>();
    private final Deque<Boolean> classOrInterfaceIsDeprecated = new LinkedList<Boolean>();

    public void visitNode(Tree tree) {
        boolean isLocalVar = false;
        if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            isLocalVar = this.currentParent.peek().is(METHOD_KINDS);
        } else {
            this.currentParent.push(tree);
        }
        boolean hasDeprecatedAnnotation = MissingDeprecatedCheck.hasDeprecatedAnnotation(tree);
        boolean hasJavadocDeprecatedTag = MissingDeprecatedCheck.hasJavadocDeprecatedTag(tree);
        if (this.currentClassNotDeprecated() && !isLocalVar) {
            if (hasDeprecatedAnnotation && !hasJavadocDeprecatedTag) {
                this.reportIssue(MissingDeprecatedCheck.getReportTree(tree), "Add the missing @deprecated Javadoc tag.");
            } else if (hasJavadocDeprecatedTag && !hasDeprecatedAnnotation) {
                this.reportIssue(MissingDeprecatedCheck.getReportTree(tree), "Add the missing @Deprecated annotation.");
            }
        }
        if (tree.is(CLASS_KINDS)) {
            this.classOrInterfaceIsDeprecated.push(hasDeprecatedAnnotation || hasJavadocDeprecatedTag);
        }
    }

    private boolean currentClassNotDeprecated() {
        return this.classOrInterfaceIsDeprecated.isEmpty() || this.classOrInterfaceIsDeprecated.peek() == false;
    }

    public void leaveNode(Tree tree) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            this.currentParent.pop();
        }
        if (tree.is(CLASS_KINDS)) {
            this.classOrInterfaceIsDeprecated.pop();
        }
    }
}

