/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;

@Rule(key="S1228")
public class PackageInfoCheck
implements JavaFileScanner {
    Set<File> directoriesWithoutPackageFile = Sets.newHashSet();

    public void scanFile(JavaFileScannerContext context) {
        File parentFile = context.getFile().getParentFile();
        if (!new File(parentFile, "package-info.java").isFile() && !this.directoriesWithoutPackageFile.contains(parentFile)) {
            context.addIssue(parentFile, (JavaCheck)this, -1, "Add a 'package-info.java' file to document the '" + parentFile.getName() + "' package");
            this.directoriesWithoutPackageFile.add(parentFile);
        }
    }
}

