/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.helpers.ReassignmentFinder;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.NameCriteria;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2695")
public class PreparedStatementAndResultSetCheck
extends AbstractMethodDetection {
    private static final String INT = "int";
    private static final String JAVA_SQL_RESULTSET = "java.sql.ResultSet";

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition("java.sql.PreparedStatement").name(NameCriteria.startsWith((String)"set")).addParameter(INT).addParameter(TypeCriteria.anyType()), (Object)MethodMatcher.create().typeDefinition(JAVA_SQL_RESULTSET).name(NameCriteria.startsWith((String)"get")).addParameter(INT), (Object)MethodMatcher.create().typeDefinition(JAVA_SQL_RESULTSET).name(NameCriteria.startsWith((String)"get")).addParameter(INT).addParameter(TypeCriteria.anyType()));
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree firstArgument = (ExpressionTree)mit.arguments().get(0);
        Integer methodFirstArgumentAsInteger = LiteralUtils.intLiteralValue((ExpressionTree)firstArgument);
        if (methodFirstArgumentAsInteger == null) {
            return;
        }
        boolean isMethodFromJavaSqlResultSet = mit.symbol().owner().type().is(JAVA_SQL_RESULTSET);
        int methodFirstArgumentValue = methodFirstArgumentAsInteger;
        if (isMethodFromJavaSqlResultSet && methodFirstArgumentValue == 0) {
            this.reportIssue((Tree)firstArgument, "ResultSet indices start at 1.");
        } else if (!isMethodFromJavaSqlResultSet) {
            if (methodFirstArgumentValue == 0) {
                this.reportIssue((Tree)firstArgument, "PreparedStatement indices start at 1.");
            } else {
                ExpressionTree preparedStatementReference = PreparedStatementAndResultSetCheck.getPreparedStatementReference(mit);
                Integer numberParameters = PreparedStatementAndResultSetCheck.getPreparedStatementNumberOfParameters(preparedStatementReference);
                if (numberParameters != null && methodFirstArgumentValue > numberParameters) {
                    this.reportIssue((Tree)firstArgument, "This \"PreparedStatement\" " + (numberParameters == 0 ? "has no" : "only has " + numberParameters) + " parameters.");
                }
            }
        }
    }

    @CheckForNull
    private static ExpressionTree getPreparedStatementReference(MethodInvocationTree mit) {
        ExpressionTree methodSelect = mit.methodSelect();
        if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            ExpressionTree expression = ((MemberSelectExpressionTree)methodSelect).expression();
            if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                Symbol referenceSymbol = ((IdentifierTree)expression).symbol();
                return ReassignmentFinder.getClosestReassignmentOrDeclarationExpression((Tree)mit, referenceSymbol);
            }
        }
        return null;
    }

    @CheckForNull
    private static Integer getPreparedStatementNumberOfParameters(@Nullable ExpressionTree tree) {
        Arguments arguments;
        if (tree != null && tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && !(arguments = ((MethodInvocationTree)tree).arguments()).isEmpty()) {
            return PreparedStatementAndResultSetCheck.getNumberQuery((ExpressionTree)arguments.get(0));
        }
        return null;
    }

    @CheckForNull
    private static Integer getNumberQuery(ExpressionTree expression) {
        ExpressionTree expr = ExpressionsHelper.skipParentheses(expression);
        if (expr.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return PreparedStatementAndResultSetCheck.handleVariableUsedAsQuery((IdentifierTree)expr);
        }
        if (expr.is(new Tree.Kind[]{Tree.Kind.PLUS})) {
            return PreparedStatementAndResultSetCheck.handleStringConcatenation((BinaryExpressionTree)expr);
        }
        return PreparedStatementAndResultSetCheck.countQuery(expr);
    }

    private static Integer handleVariableUsedAsQuery(IdentifierTree identifier) {
        ExpressionTree lastAssignment = ReassignmentFinder.getClosestReassignmentOrDeclarationExpression((Tree)identifier, identifier.symbol());
        if (lastAssignment != null) {
            return PreparedStatementAndResultSetCheck.getNumberQuery(lastAssignment);
        }
        return null;
    }

    private static Integer handleStringConcatenation(BinaryExpressionTree expr) {
        Integer left = PreparedStatementAndResultSetCheck.getNumberQuery(expr.leftOperand());
        Integer right = PreparedStatementAndResultSetCheck.getNumberQuery(expr.rightOperand());
        return left == null && right == null ? null : Integer.valueOf(PreparedStatementAndResultSetCheck.zeroIfNull(left) + PreparedStatementAndResultSetCheck.zeroIfNull(right));
    }

    private static int zeroIfNull(@Nullable Integer intValue) {
        return intValue == null ? 0 : intValue;
    }

    @CheckForNull
    private static Integer countQuery(ExpressionTree expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) ? Integer.valueOf(StringUtils.countMatches((String)((LiteralTree)expression).value(), (String)"?")) : null;
    }
}

