/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.CharsetAwareVisitor;
import org.sonar.java.RspecKey;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S00105")
@RspecKey(value="S105")
public class TabCharacterCheck
extends IssuableSubscriptionVisitor
implements CharsetAwareVisitor {
    private Charset charset;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public List<Tree.Kind> nodesToVisit() {
        return Collections.emptyList();
    }

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.visitFile(context.getFile());
    }

    public void visitFile(File file) {
        List lines;
        try {
            lines = Files.readLines((File)file, (Charset)this.charset);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        for (String line : lines) {
            if (!line.contains("\t")) continue;
            this.addIssueOnFile("Replace all tab characters in this file by sequences of white-spaces.");
            break;
        }
    }
}

