/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1201")
public class MethodNamedEqualsCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if ("equals".equalsIgnoreCase(methodTree.simpleName().name()) && !MethodNamedEqualsCheck.hasSingleObjectParameter(methodTree) && !MethodNamedEqualsCheck.isOverriding(methodTree)) {
            this.reportIssue((Tree)methodTree.simpleName(), "Either override Object.equals(Object), or totally rename the method to prevent any confusion.");
        }
    }

    private static boolean hasSingleObjectParameter(MethodTree methodTree) {
        List parameters = methodTree.parameters();
        if (parameters.size() != 1) {
            return false;
        }
        return MethodNamedEqualsCheck.isObjectType((VariableTree)parameters.get(0));
    }

    private static boolean isObjectType(VariableTree variableTree) {
        String type = ExpressionsHelper.concatenate((ExpressionTree)variableTree.type());
        return "Object".equals(type) || "java.lang.Object".equals(type);
    }

    private static boolean isOverriding(MethodTree methodTree) {
        return BooleanUtils.isTrue((Boolean)((MethodTreeImpl)methodTree).isOverriding());
    }
}

