/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.ebaiyihui.dto.BusinessTrendsDTO;
import com.ebaiyihui.mapper.db1.WisdomMedicalMapper;
import com.ebaiyihui.mapper.db2.OnlineOutpatientMapper;
import com.ebaiyihui.mapper.db3.PrescriptionCirculationMapper;
import com.ebaiyihui.service.BusinessTrendsService;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class BusinessTrendsServiceImpl
implements BusinessTrendsService {
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    @Autowired
    private WisdomMedicalMapper wisdomMedicalMapper;
    @Autowired
    private OnlineOutpatientMapper onlineOutpatientMapper;
    @Autowired
    private PrescriptionCirculationMapper prescriptionCirculationMapper;

    public BusinessTrendsDTO getBusinessTrends() {
        BusinessTrendsDTO businessTrendsDTO = new BusinessTrendsDTO();
        ArrayList<String> months = new ArrayList<String>();
        for (int i = 1; i < 7; ++i) {
            DateTime newDate2 = DateUtil.offsetDay((Date)new Date(), (int)(-(7 - i)));
            String format = DateUtil.format((Date)newDate2, (String)"M.d");
            months.add(format);
        }
        businessTrendsDTO.setMonths(months);
        ArrayList<Long> medical = new ArrayList<Long>();
        ArrayList<Long> online = new ArrayList<Long>();
        ArrayList<Long> circulation = new ArrayList<Long>();
        for (int i = 1; i < 7; ++i) {
            DateTime newDate2 = DateUtil.offsetDay((Date)new Date(), (int)(-(7 - i)));
            String format = DateUtil.format((Date)newDate2, (String)YYYY_MM_DD);
            long medicalCount = this.wisdomMedicalMapper.getMedical(format);
            medical.add(medicalCount);
            long onlineCount = this.onlineOutpatientMapper.getOnline(format);
            online.add(onlineCount);
            long circulationCount = this.prescriptionCirculationMapper.getCirculation(format);
            circulation.add(circulationCount);
        }
        ArrayList<ArrayList<Long>> datas = new ArrayList<ArrayList<Long>>();
        datas.add(medical);
        datas.add(online);
        datas.add(circulation);
        businessTrendsDTO.setDatas(datas);
        return businessTrendsDTO;
    }
}

