/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.ebaiyihui.dto.IncomeStatisticsDTO;
import com.ebaiyihui.mapper.db1.WisdomMedicalMapper;
import com.ebaiyihui.mapper.db2.OnlineOutpatientMapper;
import com.ebaiyihui.mapper.db3.PrescriptionCirculationMapper;
import com.ebaiyihui.service.IncomeStatisticsService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class IncomeStatisticsServiceImpl
implements IncomeStatisticsService {
    private static final String YYYY_MM = "yyyy-MM";
    @Autowired
    private WisdomMedicalMapper wisdomMedicalMapper;
    @Autowired
    private OnlineOutpatientMapper onlineOutpatientMapper;
    @Autowired
    private PrescriptionCirculationMapper prescriptionCirculationMapper;
    @Value(value="${hospital.code}")
    private String hospitalCode;

    public IncomeStatisticsDTO getIncomeStatistics() {
        IncomeStatisticsDTO incomeStatisticsDTO = new IncomeStatisticsDTO();
        ArrayList datas = new ArrayList();
        ArrayList<Double> lastMonth = new ArrayList<Double>();
        DateTime lastDateTime = DateUtil.offsetMonth((Date)new Date(), (int)-1);
        String lastMonStr = DateUtil.format((Date)lastDateTime, (String)YYYY_MM);
        Double lastRegister = this.wisdomMedicalMapper.getRegister(this.hospitalCode, lastMonStr);
        Double lastVisit = this.onlineOutpatientMapper.getVisit(lastMonStr);
        Double lastDrugs = this.prescriptionCirculationMapper.getDrugs(lastMonStr);
        lastMonth.add(this.millionYuan(lastRegister));
        lastMonth.add(this.millionYuan(lastVisit));
        lastMonth.add(this.millionYuan(lastDrugs));
        ArrayList<Double> nowMonth = new ArrayList<Double>();
        DateTime nowDateTime = DateUtil.offsetMonth((Date)new Date(), (int)0);
        String nowMonStr = DateUtil.format((Date)nowDateTime, (String)YYYY_MM);
        Double nowRegister = this.wisdomMedicalMapper.getRegister(this.hospitalCode, nowMonStr);
        Double nowVisit = this.onlineOutpatientMapper.getVisit(nowMonStr);
        Double nowDrugs = this.prescriptionCirculationMapper.getDrugs(nowMonStr);
        nowMonth.add(this.millionYuan(nowRegister));
        nowMonth.add(this.millionYuan(nowVisit));
        nowMonth.add(this.millionYuan(nowDrugs));
        datas.add(lastMonth);
        datas.add(nowMonth);
        incomeStatisticsDTO.setDatas(datas);
        return incomeStatisticsDTO;
    }

    private double millionYuan(Double money) {
        if (Objects.isNull(money)) {
            return 0.0;
        }
        BigDecimal two = new BigDecimal(money / 10000.0);
        return two.setScale(2, 4).doubleValue();
    }
}

