/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.impl;

import cn.hutool.core.date.DateUtil;
import com.ebaiyihui.dto.CoreDataDTO;
import com.ebaiyihui.mapper.db1.WisdomMedicalMapper;
import com.ebaiyihui.mapper.db2.OnlineOutpatientMapper;
import com.ebaiyihui.mapper.db3.PrescriptionCirculationMapper;
import com.ebaiyihui.mapper.db4.UserCenterMapper;
import com.ebaiyihui.service.CoreDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class CoreDataServiceImpl
implements CoreDataService {
    private static final Logger log = LoggerFactory.getLogger(CoreDataServiceImpl.class);
    @Autowired
    private WisdomMedicalMapper wisdomMedicalMapper;
    @Autowired
    private OnlineOutpatientMapper onlineOutpatientMapper;
    @Autowired
    private PrescriptionCirculationMapper prescriptionCirculationMapper;
    @Autowired
    private UserCenterMapper userCenterMapper;

    public CoreDataDTO getCoreData(String appCode) {
        CoreDataDTO coreDataDTO = new CoreDataDTO();
        log.info("CoreDataServiceImpl 1: {}", (Object)DateUtil.now());
        long newAddUserCount = this.userCenterMapper.getAddUserCount(appCode);
        log.info("CoreDataServiceImpl 2: {}", (Object)DateUtil.now());
        long totalRegisterCount = this.wisdomMedicalMapper.getRegisterCount();
        log.info("CoreDataServiceImpl 3: {}", (Object)DateUtil.now());
        long totalConsultCount = this.onlineOutpatientMapper.getConsultCount(appCode);
        log.info("CoreDataServiceImpl 4: {}", (Object)DateUtil.now());
        long totalFollowupCount = this.onlineOutpatientMapper.getFollowupCount(appCode);
        log.info("CoreDataServiceImpl 5: {}", (Object)DateUtil.now());
        long totalPrescribeCount = this.prescriptionCirculationMapper.getPrescribeCount();
        log.info("CoreDataServiceImpl 6: {}", (Object)DateUtil.now());
        coreDataDTO.setNewAddUserCount(Long.valueOf(newAddUserCount));
        coreDataDTO.setTotalRegisterCount(Long.valueOf(totalRegisterCount));
        coreDataDTO.setTotalConsultCount(Long.valueOf(totalConsultCount));
        coreDataDTO.setTotalFollowupCount(Long.valueOf(totalFollowupCount));
        coreDataDTO.setTotalPrescribeCount(Long.valueOf(totalPrescribeCount));
        return coreDataDTO;
    }
}

