/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.ebaiyihui.dto.MonthOnMonthDTO;
import com.ebaiyihui.mapper.db2.OnlineOutpatientMapper;
import com.ebaiyihui.service.MonthOnMonthService;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class MonthOnMonthServiceImpl
implements MonthOnMonthService {
    private static final String YYYY_MM = "yyyy-MM";
    @Autowired
    private OnlineOutpatientMapper onlineOutpatientMapper;

    public MonthOnMonthDTO getMonthOnMonth(String appCode) {
        MonthOnMonthDTO monthOnMonthDTO = new MonthOnMonthDTO();
        DateTime lastDateTime = DateUtil.offsetMonth((Date)new Date(), (int)-1);
        String lastMonStr = DateUtil.format((Date)lastDateTime, (String)YYYY_MM);
        DateTime yearDateTime = DateUtil.offsetMonth((Date)new Date(), (int)-13);
        String yearLastMonStr = DateUtil.format((Date)yearDateTime, (String)YYYY_MM);
        DateTime monthDateTime = DateUtil.offsetMonth((Date)new Date(), (int)-2);
        String monthLastMonStr = DateUtil.format((Date)monthDateTime, (String)YYYY_MM);
        long totalOrderCount = this.onlineOutpatientMapper.getLastTotalOrderCount(appCode, lastMonStr);
        long finishOrderCount = this.onlineOutpatientMapper.getFinishOrderCount(lastMonStr);
        long refundOrderCount = this.onlineOutpatientMapper.getRefundOrderCount(lastMonStr);
        long unFinishOrderCount = this.onlineOutpatientMapper.getUnFinishOrderCount(lastMonStr);
        long yearFinishOrderCount = this.onlineOutpatientMapper.getFinishOrderCount(yearLastMonStr);
        long monthFinishOrderCount = this.onlineOutpatientMapper.getFinishOrderCount(monthLastMonStr);
        NumberFormat numberformat = NumberFormat.getInstance();
        numberformat.setMaximumFractionDigits(2);
        String finishOrderCountPer = numberformat.format(this.getPer(finishOrderCount, totalOrderCount) * 100.0f);
        String refundOrderCountPer = numberformat.format(this.getPer(refundOrderCount, totalOrderCount) * 100.0f);
        String unFinishOrderCountPer = numberformat.format(this.getPer(unFinishOrderCount, totalOrderCount) * 100.0f);
        ArrayList<String> data = new ArrayList<String>();
        data.add(finishOrderCountPer + "%");
        data.add(refundOrderCountPer + "%");
        data.add(unFinishOrderCountPer + "%");
        monthOnMonthDTO.setData(data);
        monthOnMonthDTO.setTotalOrderCount(Long.valueOf(totalOrderCount));
        String yearFinishOrderCountPer = numberformat.format(this.getPer(finishOrderCount - yearFinishOrderCount, yearFinishOrderCount) * 100.0f);
        String monthFinishOrderCountPer = numberformat.format(this.getPer(finishOrderCount - monthFinishOrderCount, monthFinishOrderCount) * 100.0f);
        monthOnMonthDTO.setCompleteOrderGrew(yearFinishOrderCountPer + "%");
        monthOnMonthDTO.setCompleteOrderPercent(monthFinishOrderCountPer + "%");
        return monthOnMonthDTO;
    }

    private float getPer(long num1, long num2) {
        float v = num2 == 0L ? 0.0f : (float)(num1 - num2) / (float)num2;
        return Math.abs(v);
    }
}

