/*
 * Decompiled with CFR 0.152.
 */
package com.byh.hs.web.mvc.controller;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.byh.hs.api.exception.BusinessException;
import com.byh.hs.api.model.entity.HsConfigEntity;
import com.byh.hs.api.model.generalLedger.GeneralLedgerDetailsDTO;
import com.byh.hs.api.model.generalLedger.QueryCashPayAmtDTO;
import com.byh.hs.api.model.generalLedger.QueryGeneralLedgerDetailDTO;
import com.byh.hs.api.model.generalLedger.QueryGeneralLedgerRequest;
import com.byh.hs.api.model.generalLedger.QueryGeneralLedgerResponse;
import com.byh.hs.api.model.generalLedger.SettleInfo;
import com.byh.hs.api.model.request.ReconciliationTotalRequest;
import com.byh.hs.api.util.DateUtils;
import com.byh.hs.api.util.ResponseData;
import com.byh.hs.api.util.SigNayureUtil;
import com.byh.hs.data.repository.HsConfigMapper;
import com.byh.hs.data.repository.HsGeneralLedgerMapper;
import com.byh.hs.web.service.HsBusinessService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/hsGeneralLedger"})
@Api(tags={"\u533b\u4fdd\u5bf9\u603b\u8d26\u76f8\u5173api"})
public class HsGeneralLedgerController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    HsGeneralLedgerMapper hsGeneralLedgerMapper;
    @Autowired
    HsBusinessService hsBusinessService;
    @Autowired
    private HsConfigMapper hsConfigMapper;

    public ResponseData<HsConfigEntity> getHsConfig(Integer tenantId) {
        HsConfigEntity hsConfigEntity = (HsConfigEntity)this.hsConfigMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"tenant_id", (Object)tenantId));
        if (Objects.isNull(hsConfigEntity)) {
            return ResponseData.error((String)"\u83b7\u53d6\u533b\u4fdd\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
        }
        return ResponseData.success((Object)hsConfigEntity);
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u67e5\u8be2\u603b\u8d26\u6570\u636e")
    public ResponseData list(@RequestBody QueryGeneralLedgerRequest generalLedgerRequest) {
        return ResponseData.success((Object)this.hsGeneralLedgerMapper.getList(generalLedgerRequest));
    }

    @PostMapping(value={"/doGeneralLedger"})
    @ApiOperation(value="\u5bf9\u603b\u8d26")
    public ResponseData doGeneralLedger(@RequestBody ReconciliationTotalRequest inParm) {
        inParm.setTenantId(Integer.valueOf(1));
        return this.hsBusinessService.reconciliationTotal(inParm);
    }

    @PostMapping(value={"/detail/list"})
    @ApiOperation(value="\u67e5\u8be2\u660e\u7ec6\u8d26\u6570\u636e")
    public ResponseData detail(@RequestBody QueryGeneralLedgerDetailDTO inParm) {
        return ResponseData.success((Object)this.hsGeneralLedgerMapper.getGeneralLedgerDetails(inParm));
    }

    @PostMapping(value={"/getCashPayAmt"})
    @ApiOperation(value="\u83b7\u53d6\u73b0\u91d1\u652f\u4ed8\u91d1\u989d")
    public ResponseData getCashPayAmt(@RequestBody QueryCashPayAmtDTO inparam) {
        QueryGeneralLedgerResponse theCashPaymentAmount = this.hsGeneralLedgerMapper.getTheCashPaymentAmount(inparam);
        return ResponseData.success((Object)theCashPaymentAmount);
    }

    @PostMapping(value={"/doGeneralLedgerDetails"})
    @ApiOperation(value="\u5bf9\u660e\u7ec6\u8d26")
    public ResponseData doGeneralLedgerDetails(@RequestBody GeneralLedgerDetailsDTO inParm) {
        if (inParm.getList() == null || inParm.getList().isEmpty()) {
            return ResponseData.error((String)"\u9700\u8981\u4e0a\u4f20\u7684\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String replace = UUID.randomUUID().toString().replace("-", "");
        byte[] zipBytes = HsGeneralLedgerController.listToZip((List)inParm.getList(), (String)(replace + ".txt"));
        String hsFileUploadString = "{\n  \"fsUploadIn\": {\n    \"in\": " + Arrays.toString(zipBytes) + ",\n    \"filename\": \"20240819.zip\",\n    \"fixmedins_code\": \"H36010300622\"\n  }\n}";
        JSONObject hsFileUploadRequest = JSON.parseObject((String)hsFileUploadString);
        hsFileUploadRequest.getJSONObject("fsUploadIn").put("filename", (Object)(replace + ".zip"));
        JSONObject uploadRes = this.sendHttpWebClient((Object)hsFileUploadRequest, "9101", inParm.getInRecoBySettle().getSetl_optins());
        if (uploadRes.getInteger("infcode") == -1) {
            return ResponseData.error((String)uploadRes.getString("err_msg"));
        }
        String uploadFileQuryNo = uploadRes.getJSONObject("output").getString("file_qury_no");
        JSONObject data = new JSONObject();
        JSONObject dataInparm = new JSONObject();
        dataInparm.put("setl_optins", (Object)inParm.getInRecoBySettle().getSetl_optins());
        dataInparm.put("file_qury_no", (Object)uploadFileQuryNo);
        dataInparm.put("stmt_begndate", (Object)inParm.getInRecoBySettle().getStmt_begndate());
        dataInparm.put("stmt_enddate", (Object)inParm.getInRecoBySettle().getStmt_enddate());
        dataInparm.put("medfee_sumamt", (Object)inParm.getInRecoBySettle().getMedfee_sumamt());
        dataInparm.put("fund_pay_sumamt", (Object)inParm.getInRecoBySettle().getFund_pay_sumamt());
        dataInparm.put("cash_payamt", (Object)inParm.getInRecoBySettle().getCash_payamt());
        dataInparm.put("fixmedins_setl_cnt", (Object)inParm.getInRecoBySettle().getFixmedins_setl_cnt());
        dataInparm.put("clr_type", (Object)inParm.getInRecoBySettle().getClr_type());
        dataInparm.put("refd_setl_flag", (Object)"");
        data.put("data", (Object)dataInparm);
        JSONObject insurGeneralLedgerRes = this.sendHttpWebClient((Object)data, "3202", inParm.getInRecoBySettle().getSetl_optins());
        if (insurGeneralLedgerRes.getInteger("infcode") == -1) {
            return ResponseData.error((String)insurGeneralLedgerRes.getString("errMsg"));
        }
        JSONObject fileinfo = insurGeneralLedgerRes.getJSONObject("output").getJSONObject("fileinfo");
        String downloadFileName = fileinfo.getString("filename");
        String downloadFileQuryNo = fileinfo.getString("file_qury_no");
        JSONObject fsDownloadIn = new JSONObject();
        JSONObject fsDownloadInInparm = new JSONObject();
        fsDownloadInInparm.put("file_qury_no", (Object)downloadFileQuryNo);
        fsDownloadInInparm.put("filename", (Object)downloadFileName);
        fsDownloadInInparm.put("fixmedins_code", (Object)"H36010300622");
        fsDownloadInInparm.put("dld_endtime", (Object)"");
        fsDownloadIn.put("fsDownloadIn", (Object)fsDownloadInInparm);
        JSONObject fsDownload = this.sendHttpWebClient((Object)fsDownloadIn, "9102", inParm.getInRecoBySettle().getSetl_optins());
        if (fsDownload.getInteger("infcode") != 1) {
            return ResponseData.error((String)("\u4e0b\u8f7d\u5931\u8d25!" + fsDownload.getString("err_msg")));
        }
        return ResponseData.success((Object)fsDownload.getJSONArray("output"));
    }

    public JSONObject sendHttpWebClient(Object input, String serviceId) {
        return this.sendHttpWebClient(input, serviceId, null);
    }

    public JSONObject sendHttpWebClient(Object input, String serviceId, String admvs) {
        ResponseData hsConfigResponse = this.getHsConfig(Integer.valueOf(1));
        if (!hsConfigResponse.isSuccess()) {
            JSONObject errorJson = new JSONObject();
            errorJson.put("err_msg", (Object)hsConfigResponse.getMsg());
            errorJson.put("infcode", (Object)-1);
        }
        HsConfigEntity hsConfigEntity = (HsConfigEntity)hsConfigResponse.getData();
        String url = hsConfigEntity.getInsuranceUrl();
        JSONObject bodyValue = new JSONObject();
        bodyValue.put("infno", (Object)serviceId);
        bodyValue.put("msgid", (Object)SigNayureUtil.getMsgId());
        bodyValue.put("mdtrtarea_admvs", (Object)hsConfigEntity.getCityCode());
        bodyValue.put("insuplc_admdvs", (Object)admvs);
        bodyValue.put("recer_sys_code", (Object)hsConfigEntity.getHsCzyh());
        bodyValue.put("dev_no", (Object)hsConfigEntity.getHsCzyh());
        bodyValue.put("dev_safe_info", (Object)"");
        bodyValue.put("cainfo", (Object)"");
        bodyValue.put("signtype", (Object)hsConfigEntity.getSignType());
        bodyValue.put("infver", (Object)hsConfigEntity.getInfver());
        bodyValue.put("opter_type", (Object)"1");
        bodyValue.put("opter", (Object)"000001");
        bodyValue.put("opter_name", (Object)"\u8d85\u7ea7\u7ba1\u7406\u5458");
        bodyValue.put("inf_time", (Object)DateUtils.getTime());
        bodyValue.put("fixmedins_code", (Object)hsConfigEntity.getInsuranceCode());
        bodyValue.put("fixmedins_name", (Object)hsConfigEntity.getOrganName());
        bodyValue.put("sign_no", (Object)"3900479442");
        bodyValue.put("input", input);
        this.logger.info("\u8c03\u7528\u533b\u4fdd\u63a5\u53e3:{},\u5165\u53c2:{}", (Object)serviceId, (Object)bodyValue.toJSONString());
        String timeStamp = String.valueOf(Instant.now().toEpochMilli());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("_api_access_key=").append(hsConfigEntity.getAccessKey());
        stringBuilder.append("&_api_name=hsa-fsi-").append(serviceId);
        stringBuilder.append("&_api_timestamp=").append(timeStamp);
        stringBuilder.append("&_api_version=").append(hsConfigEntity.getApiVersion());
        try {
            String apiSignaTrue = HsGeneralLedgerController.calculateHmacSHA1((String)stringBuilder.toString(), (String)hsConfigEntity.getSecretKey());
            HttpResponse httpResponse = ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)(url + serviceId)).contentType("application/json").header("_api_timestamp", timeStamp)).header("_api_name", "hsa-fsi-" + serviceId)).header("_api_version", hsConfigEntity.getApiVersion())).header("_api_access_key", hsConfigEntity.getAccessKey())).header("_api_signature", apiSignaTrue)).body(bodyValue.toJSONString()).execute();
            if (serviceId.equals("9102")) {
                JSONArray jsonArray = HsGeneralLedgerController.zipToList((byte[])httpResponse.bodyBytes());
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("infcode", (Object)1);
                jsonObject.put("output", (Object)jsonArray);
                return jsonObject;
            }
            String response = httpResponse.body();
            this.logger.info("\u8c03\u7528\u533b\u4fdd\u63a5\u53e3:{},\u51fa\u53c2:{}", (Object)serviceId, (Object)response);
            JSONObject resJson = JSON.parseObject((String)response);
            Integer infcode = resJson.getInteger("infcode");
            if (infcode != 0) {
                throw new BusinessException(resJson.getString("err_msg"));
            }
            return resJson;
        }
        catch (Exception e) {
            this.logger.info("\u8c03\u7528\u533b\u4fdd\u63a5\u53e3:{},\u5931\u8d25:{}", (Object)serviceId, (Object)e.getMessage());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("infcode", (Object)-1);
            jsonObject.put("errMsg", (Object)e.getMessage());
            return jsonObject;
        }
    }

    public static String calculateHmacSHA1(String data, String key) throws Exception {
        SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(signingKey);
        byte[] rawHmac = mac.doFinal(data.getBytes());
        return Base64.getEncoder().encodeToString(rawHmac);
    }

    public static byte[] listToZip(List<SettleInfo> list, String fileName) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);){
            ZipEntry zipEntry = new ZipEntry(fileName);
            zipOutputStream.putNextEntry(zipEntry);
            for (SettleInfo obj : list) {
                String line = obj.getSetlId() + "\t" + obj.getMdtrtId() + "\t" + obj.getPsnNo() + "\t" + obj.getMedfeeSumamt() + "\t" + obj.getFundPaySumamt() + "\t" + obj.getAcctPay() + "\t" + obj.getRefdSetlFlag() + "\n";
                zipOutputStream.write(line.getBytes());
            }
            zipOutputStream.closeEntry();
        }
        catch (Exception e) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static JSONArray zipToList(byte[] zipBytes) {
        JSONArray jsonArray = new JSONArray();
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(zipBytes);
             ZipInputStream zipInputStream = new ZipInputStream(byteArrayInputStream);){
            ZipEntry entry = zipInputStream.getNextEntry();
            if (entry != null && entry.getName().equals("result.txt")) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(zipInputStream));
                while ((line = reader.readLine()) != null) {
                    String[] fields = line.split("\t");
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("psnNo", (Object)fields[0]);
                    jsonObject.put("mdtrtId", (Object)fields[1]);
                    jsonObject.put("setlId", (Object)fields[2]);
                    jsonObject.put("msgid", (Object)fields[3]);
                    jsonObject.put("stmtRslt", (Object)(fields[4].equals("0") ? "\u5e73" : "\u4e0d\u5e73"));
                    jsonObject.put("refdSetlFlag", (Object)fields[5]);
                    jsonObject.put("memo", (Object)fields[6]);
                    jsonObject.put("medfeeSumamt", (Object)fields[7]);
                    jsonObject.put("fundPaySumamt", (Object)fields[8]);
                    jsonObject.put("acctPay", (Object)fields[9]);
                    jsonArray.add((Object)jsonObject);
                }
            }
        }
        catch (Exception e) {
            JSONObject object = new JSONObject();
            object.put("errorMsg", (Object)e.getMessage());
            jsonArray.add((Object)object);
        }
        return jsonArray;
    }
}

