/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.dto.outRevenueSummary.GetRevenueSummaryDto;
import com.byh.outpatient.api.dto.outRevenueSummary.UpdateRevenueSummaryDto;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutRevenueSummaryService;
import io.swagger.annotations.ApiOperation;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/outRevenueSummary"})
public class OutRevenueSummaryController {
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private OutRevenueSummaryService outRevenueSummaryService;

    @ApiOperation(value="\u66f4\u65b0\u8425\u6536\u6c47\u603b")
    @PostMapping(value={"/updateRevenueSummary"})
    public ResponseData updateRevenueSummary(@RequestBody LinkedHashMap<String, Object> map) {
        UpdateRevenueSummaryDto dto = new UpdateRevenueSummaryDto();
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setCreateId(this.commonRequest.getUserId());
        dto.setCreateName(this.commonRequest.getUserName());
        this.outRevenueSummaryService.updateRevenueSummary(map, dto);
        return ResponseData.success((Object)"\u66f4\u65b0\u5b8c\u6210");
    }

    @ApiOperation(value="\u5bfc\u51fa\u6307\u5b9a\u65f6\u95f4\u8303\u56f4\u5185\u7684\u533b\u9662\u95e8\u8bca\u8425\u6536\u6c47\u603b")
    @PostMapping(value={"/exportRevenueSummary"})
    public void exportRevenueSummary(HttpServletResponse response, @RequestBody GetRevenueSummaryDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.outRevenueSummaryService.exportRevenueSummary(response, dto);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e1a\u52a1\u540d\u79f0\u5206\u7ec4")
    @PostMapping(value={"/selectBusinessNameGroup"})
    public ResponseData selectBusinessNameGroup() {
        return ResponseData.success((Object)this.outRevenueSummaryService.selectBusinessNameGroup(this.commonRequest.getTenant()));
    }

    @ApiOperation(value="\u67e5\u8be2\u672c\u5e74\u7684\u95e8\u8bca\u8425\u6536\u6c47\u603b")
    @PostMapping(value={"/selectRevenueSummaryListAllYear"})
    public ResponseData selectRevenueSummaryListAllYear() {
        return ResponseData.success((Object)this.outRevenueSummaryService.selectRevenueSummaryListAllYear(this.commonRequest.getTenant()));
    }

    @ApiOperation(value="\u67e5\u8be2\u6307\u5b9a\u65f6\u95f4\u8303\u56f4\u5185\u7684\u95e8\u8bca\u533b\u9662\u8425\u6536\u6c47\u603b")
    @PostMapping(value={"/selectRevenueSummaryList"})
    public ResponseData selectRevenueSummaryList(@RequestBody GetRevenueSummaryDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.outRevenueSummaryService.selectRevenueSummaryList(dto));
    }

    @ApiOperation(value="\u91c7\u96c6\u6307\u5b9a\u65f6\u95f4\u5185\u7684\u533b\u9662\u95e8\u8bca\u8425\u6536")
    @PostMapping(value={"/getRevenueSummary"})
    public ResponseData getRevenueSummary(@RequestBody GetRevenueSummaryDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setCreateId(this.commonRequest.getUserId());
        dto.setCreateName(this.commonRequest.getUserName());
        this.outRevenueSummaryService.getRevenueSummary(dto);
        return ResponseData.success((Object)"\u91c7\u96c6\u5b8c\u6bd5");
    }
}

