/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.outpatient.api.constants.BusinessConstant;
import com.byh.outpatient.api.dto.order.HsPayDto;
import com.byh.outpatient.api.dto.order.HsPreparePayDto;
import com.byh.outpatient.api.dto.order.OnlineHsPayDto;
import com.byh.outpatient.api.dto.pay.CancelPaymentDto;
import com.byh.outpatient.api.dto.pay.Caseinfo;
import com.byh.outpatient.api.dto.pay.CheckItemStatusDto;
import com.byh.outpatient.api.dto.pay.DiseInfo;
import com.byh.outpatient.api.dto.pay.FeeBillCreationDto;
import com.byh.outpatient.api.dto.pay.Feedetail;
import com.byh.outpatient.api.dto.pay.HsCodeDto;
import com.byh.outpatient.api.dto.pay.HsRefundDto;
import com.byh.outpatient.api.dto.pay.HsUploadLog;
import com.byh.outpatient.api.dto.pay.ICBCOrderEntity;
import com.byh.outpatient.api.dto.pay.ICBCPayDto;
import com.byh.outpatient.api.dto.pay.IcbcRefundDto;
import com.byh.outpatient.api.dto.pay.MedicalRecordRequest;
import com.byh.outpatient.api.dto.pay.OnlineHsRefundDto;
import com.byh.outpatient.api.dto.pay.PayByICBC;
import com.byh.outpatient.api.dto.pay.PayDto;
import com.byh.outpatient.api.dto.pay.PayHsUploadRequest;
import com.byh.outpatient.api.dto.pay.PayReFundByICBC;
import com.byh.outpatient.api.dto.pay.PayRefundDto;
import com.byh.outpatient.api.dto.pay.Rgstinfo;
import com.byh.outpatient.api.dto.pay.RxInfo;
import com.byh.outpatient.api.dto.prescription.GetDrugStatusDto;
import com.byh.outpatient.api.dto.prescription.OutPrescriptionDto;
import com.byh.outpatient.api.dto.treatment.GetTreatmentItemStatusDto;
import com.byh.outpatient.api.enums.AdmissionStatusEnum;
import com.byh.outpatient.api.enums.DeliveryStatusEnum;
import com.byh.outpatient.api.enums.DrugStatusEnum;
import com.byh.outpatient.api.enums.HsOrderTypeEnum;
import com.byh.outpatient.api.enums.MedicalInsuranceTypeEnum;
import com.byh.outpatient.api.enums.OperationTypeEnum;
import com.byh.outpatient.api.enums.OrderSettleTypeEnum;
import com.byh.outpatient.api.enums.OrderTypeEnum;
import com.byh.outpatient.api.enums.OutpatientDataStatusEnum;
import com.byh.outpatient.api.enums.PaymentMethodEnum;
import com.byh.outpatient.api.enums.PaymentRecordsStatusEnum;
import com.byh.outpatient.api.enums.PaymentStatusEnum;
import com.byh.outpatient.api.enums.PaymentTypeEnum;
import com.byh.outpatient.api.enums.PrescriptionStatusEnum;
import com.byh.outpatient.api.enums.RefundMethodEnum;
import com.byh.outpatient.api.enums.SettlementMethodEnum;
import com.byh.outpatient.api.enums.SourceEnum;
import com.byh.outpatient.api.enums.TreatmentItemStatusEnum;
import com.byh.outpatient.api.exception.BusinessException;
import com.byh.outpatient.api.hsModel.BaseinfoEntity;
import com.byh.outpatient.api.hsModel.request.DiseinfoRequest;
import com.byh.outpatient.api.hsModel.request.MdtrtinfoRequest;
import com.byh.outpatient.api.hsModel.request.MoveMdtrtinfoRequest;
import com.byh.outpatient.api.hsModel.request.MoveOrderInfoRequest;
import com.byh.outpatient.api.hsModel.request.MoveUploadInfoDiseinfoListRequest;
import com.byh.outpatient.api.hsModel.request.MoveUploadInfoFeedetailListRequest;
import com.byh.outpatient.api.hsModel.request.OutpatientsettlementRequest;
import com.byh.outpatient.api.hsModel.request.PatientInfoRequest;
import com.byh.outpatient.api.hsModel.request.RefundRequest;
import com.byh.outpatient.api.hsModel.request.RegMovePayInfoRequest;
import com.byh.outpatient.api.hsModel.request.RegPayInfoRequest;
import com.byh.outpatient.api.hsModel.request.RegistrationRequest;
import com.byh.outpatient.api.hsModel.request.UploadInfoDetailRequest;
import com.byh.outpatient.api.hsModel.respones.HsBaseResponse;
import com.byh.outpatient.api.hsModel.respones.HsPatientInfoResponse;
import com.byh.outpatient.api.hsModel.respones.Insuinfo;
import com.byh.outpatient.api.hsModel.respones.MoveCreateOrderResponse;
import com.byh.outpatient.api.hsModel.respones.MoveOrderInfoResponse;
import com.byh.outpatient.api.hsModel.respones.MoveSetlinfo;
import com.byh.outpatient.api.hsModel.respones.PaymentResponse;
import com.byh.outpatient.api.hsModel.respones.Setlinfo;
import com.byh.outpatient.api.model.OutIcdItem;
import com.byh.outpatient.api.model.admission.AdmissionEntity;
import com.byh.outpatient.api.model.hsSettlement.HsSettlementInfoEntity;
import com.byh.outpatient.api.model.hsSettlement.OutHsSettlementInfoDetaiEntity;
import com.byh.outpatient.api.model.medicalRecord.OutMedicalRecord;
import com.byh.outpatient.api.model.medicalRecord.OutMedicalRecordDiagnosis;
import com.byh.outpatient.api.model.order.OutOrder;
import com.byh.outpatient.api.model.order.OutOrderPayment;
import com.byh.outpatient.api.model.order.OutOrderPaymentRecord;
import com.byh.outpatient.api.model.outpatienType.OutpatientTypeEntity;
import com.byh.outpatient.api.model.patient.PatientEntity;
import com.byh.outpatient.api.model.prescription.OutPrescription;
import com.byh.outpatient.api.model.prescription.OutPrescriptionDrug;
import com.byh.outpatient.api.model.treatment.OutTreatmentDetails;
import com.byh.outpatient.api.sysModel.request.SysDictValueDTO;
import com.byh.outpatient.api.sysModel.request.SysDoctorDto;
import com.byh.outpatient.api.sysModel.request.SysDrugEntity;
import com.byh.outpatient.api.sysModel.request.SysEasyEntity;
import com.byh.outpatient.api.sysModel.respones.SysDictValueVo;
import com.byh.outpatient.api.sysModel.respones.SysDoctorIdVo;
import com.byh.outpatient.api.util.BaseResponse;
import com.byh.outpatient.api.util.DateUtils;
import com.byh.outpatient.api.util.ExceptionUtils;
import com.byh.outpatient.api.util.RandomCodeUtils;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.UUIDUtils;
import com.byh.outpatient.api.vo.order.PayRefundVo;
import com.byh.outpatient.api.vo.order.PayVo;
import com.byh.outpatient.api.vo.pay.CheckItemStatusVo;
import com.byh.outpatient.api.vo.pay.FeeBillCreationVo;
import com.byh.outpatient.api.vo.pay.PayNotifyReqVO;
import com.byh.outpatient.api.vo.pay.RefundCallBackReqVo;
import com.byh.outpatient.data.repository.AdmissionMapper;
import com.byh.outpatient.data.repository.OutEtubePatientDossierMapper;
import com.byh.outpatient.data.repository.OutEtubePatientInfoMapper;
import com.byh.outpatient.data.repository.OutHsSettlementInfoDetailMapper;
import com.byh.outpatient.data.repository.OutHsSettlementInfoMapper;
import com.byh.outpatient.data.repository.OutIcdItemMapper;
import com.byh.outpatient.data.repository.OutMedicalRecordDiagnosisMapper;
import com.byh.outpatient.data.repository.OutMedicalRecordMapper;
import com.byh.outpatient.data.repository.OutOrderMapper;
import com.byh.outpatient.data.repository.OutOrderPaymentMapper;
import com.byh.outpatient.data.repository.OutOrderPaymentRecordMapper;
import com.byh.outpatient.data.repository.OutPrescriptionDrugMapper;
import com.byh.outpatient.data.repository.OutPrescriptionMapper;
import com.byh.outpatient.data.repository.OutTreatmentDetailsMapper;
import com.byh.outpatient.data.repository.OutTreatmentItemsMapper;
import com.byh.outpatient.data.repository.OutpatientTypeMapper;
import com.byh.outpatient.data.repository.PatientMapper;
import com.byh.outpatient.web.factroy.PayFactory;
import com.byh.outpatient.web.feign.HsServiceFeign;
import com.byh.outpatient.web.feign.SdkServiceFeign;
import com.byh.outpatient.web.feign.SysServiceFeign;
import com.byh.outpatient.web.mvc.config.NodeConfig;
import com.byh.outpatient.web.mvc.controller.RocketMQProducerController;
import com.byh.outpatient.web.mvc.exception.RunDisplayException;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.mvc.utils.RabbitMqUtils;
import com.byh.outpatient.web.mvc.utils.RedisUtil;
import com.byh.outpatient.web.rocket.RocketMQProducer;
import com.byh.outpatient.web.service.ExpertStudioService;
import com.byh.outpatient.web.service.OutInvoiceService;
import com.byh.outpatient.web.service.OutMedicalRecordDiagnosisService;
import com.byh.outpatient.web.service.OutPayService;
import com.byh.outpatient.web.service.OutPrescriptionService;
import com.byh.outpatient.web.service.PayService;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class OutPayServiceImpl
implements OutPayService {
    private static final Logger logger = LoggerFactory.getLogger(RocketMQProducerController.class);
    private static final String topic = "rocketMQ-out-doctor";
    private static final String patientTopic = "rocketMQ-out-patientTopic";
    private static final String patientPaymentTopic = "rocketMQ-out-patientPaymentTopic";
    private static final String prescriptionDetailTopic = "rocketMQ-out-prescriptionDetailTopic";
    private static final String treatmentItemsTopic = "rocketMQ-out-treatmentItemsTopic";
    @Resource
    private RocketMQProducer rocketMQProducer;
    @Resource
    private OutHsSettlementInfoDetailMapper outHsSettlementInfoDetailMapper;
    @Autowired
    private ExpertStudioService expertStudioService;
    @Autowired
    private OutEtubePatientDossierMapper outEtubePatientDossierMapper;
    @Resource
    private OutEtubePatientInfoMapper outEtubePatientInfoMapper;
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private OutOrderPaymentMapper outOrderPaymentMapper;
    @Autowired
    private OutTreatmentDetailsMapper outTreatmentDetailsMapper;
    @Autowired
    private OutMedicalRecordDiagnosisService outMedicalRecordDiagnosisService;
    @Autowired
    private OutOrderMapper outOrderMapper;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private OutpatientTypeMapper outpatientTypeMapper;
    @Autowired
    private OutIcdItemMapper outIcdItemMapper;
    @Autowired
    private HsServiceFeign hsServiceFeign;
    @Autowired
    private SysServiceFeign sysServiceFeign;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private OutPrescriptionDrugMapper outPrescriptionDrugMapper;
    @Resource
    private OutMedicalRecordMapper outMedicalRecordMapper;
    @Resource
    private OutMedicalRecordDiagnosisMapper outMedicalRecordDiagnosisMapper;
    @Autowired
    private OutPrescriptionMapper outPrescriptionMapper;
    @Autowired
    private OutOrderPaymentRecordMapper outOrderPaymentRecordMapper;
    @Autowired
    private OutHsSettlementInfoMapper outHsSettlementInfoMapper;
    @Autowired
    private OutPrescriptionService outPrescriptionService;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private SdkServiceFeign sdkServiceFeign;
    @Resource
    private OutTreatmentItemsMapper outTreatmentItemsMapper;
    @Autowired
    private OutInvoiceService outInvoiceService;
    private static final String SOURCE = "outpatient-service:pay:order:";
    private static Logger log = LoggerFactory.getLogger(OutPayServiceImpl.class);
    public static final int EXPIRATION_TIME = 30;

    public CheckItemStatusVo checkItemStatus(List<CheckItemStatusDto> dtoList, Integer tenantId) {
        GetDrugStatusDto dto2;
        boolean paymentStatusFlag;
        if (dtoList.isEmpty()) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u5f85\u7f34\u8d39\u660e\u7ec6\u5217\u8868\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (paymentStatusFlag = dtoList.stream().anyMatch(dto -> dto.getPaymentStatus() != 10)) {
            ExceptionUtils.createException((Logger)logger, (boolean)true, (String)"500", (String)"\u5f85\u7f34\u8d39\u72b6\u6001\u5f02\u5e38!");
        }
        List<String> drugOrderTypes = Arrays.asList(OrderTypeEnum.PRESCRIPTION_WESTERN_MEDICINE_ORDERS.getValue(), OrderTypeEnum.CLOUD_PRESCRIPTION_WESTERN_MEDICINE_ORDERS.getValue(), OrderTypeEnum.REGISTERED_TRADITIONAL_ORDERS.getValue(), OrderTypeEnum.CLOUD_REGISTERED_TRADITIONAL_ORDERS.getValue(), OrderTypeEnum.CLOUD_REGISTERED_PREPARED_TRADITIONAL_ORDERS.getValue(), OrderTypeEnum.REGISTERED_CHINESE_PATENT_DRUG_ORDERS.getValue(), OrderTypeEnum.CLOUD_REGISTERED_CHINESE_PATENT_DRUG_ORDERS.getValue());
        List drugPrescNoList = dtoList.stream().filter(dto -> drugOrderTypes.contains(dto.getOrderType())).map(CheckItemStatusDto::getPrescriptionNo).collect(Collectors.toList());
        List<String> treatmentOrdertypes = Arrays.asList(OrderTypeEnum.DIAGNOSIS_TREATMENT_ORDERS.getValue(), OrderTypeEnum.REGISTERED_INSPECTION_ORDERS.getValue(), OrderTypeEnum.REGISTERED_INSPECT_ORDERS.getValue(), OrderTypeEnum.REGISTERED_TREATMENT_ORDERS.getValue(), OrderTypeEnum.REGISTERED_OPERATION_ORDERS.getValue(), OrderTypeEnum.REGISTERED_ANAESTHESIA_ORDERS.getValue(), OrderTypeEnum.REGISTERED_NURSING_ORDERS.getValue(), OrderTypeEnum.REGISTERED_DIET_ORDERS.getValue(), OrderTypeEnum.REGISTERED_OXYGEN_THERAPY_ORDERS.getValue(), OrderTypeEnum.REGISTERED_MATERIAL_ORDERS.getValue(), OrderTypeEnum.REGISTERED_PATROL_VEHICLE_ORDERS.getValue(), OrderTypeEnum.REGISTERED_BLOOD_TRANSFUSION_ORDERS.getValue(), OrderTypeEnum.REGISTERED_SERVICER_ORDERS.getValue(), OrderTypeEnum.REGISTERED_MATERIAL_PROJECTS_ORDERS.getValue(), OrderTypeEnum.REGISTERED_OTHER_PROJECTS_ORDERS.getValue());
        List outTreatmentItemNoList = dtoList.stream().filter(dto -> treatmentOrdertypes.contains(dto.getOrderType())).map(CheckItemStatusDto::getPrescriptionNo).collect(Collectors.toList());
        StringBuilder errorInfoBuilder = new StringBuilder("");
        if (!drugPrescNoList.isEmpty()) {
            dto2 = new GetDrugStatusDto();
            dto2.setPrescNos(drugPrescNoList);
            dto2.setTenantId(tenantId);
            List drugStatusList = this.outPrescriptionDrugMapper.getDrugStatus(dto2);
            drugStatusList.stream().filter(statusVo -> StrUtil.isNotEmpty((CharSequence)statusVo.getDrugNo()) && StrUtil.isNotEmpty((CharSequence)statusVo.getStatus()) && DrugStatusEnum.UN_ENDBLED.getValue().equals(statusVo.getStatus())).forEach(statusVo -> errorInfoBuilder.append("\uff08").append(statusVo.getDrugNo()).append("\uff09").append(statusVo.getDrugName()).append("\uff0c"));
        }
        if (!outTreatmentItemNoList.isEmpty()) {
            dto2 = new GetTreatmentItemStatusDto();
            dto2.setTenantId(tenantId);
            dto2.setItemNos(outTreatmentItemNoList);
            List treatmentItemStatusList = this.outTreatmentItemsMapper.getTreatmentItemStatus((GetTreatmentItemStatusDto)dto2);
            treatmentItemStatusList.stream().filter(statusVo -> StrUtil.isNotEmpty((CharSequence)statusVo.getItemCode()) && StrUtil.isNotEmpty((CharSequence)statusVo.getStatusCode()) && TreatmentItemStatusEnum.UNENABLED.getValue().equals(statusVo.getStatusCode())).forEach(statusVo -> errorInfoBuilder.append("\uff08").append(statusVo.getItemCode()).append("\uff09").append(statusVo.getItemName()).append("\uff0c"));
        }
        CheckItemStatusVo checkItemStatusVo = new CheckItemStatusVo();
        String errorInfo = errorInfoBuilder.toString();
        if (StrUtil.isNotEmpty((CharSequence)errorInfo)) {
            errorInfo = "\u4ee5\u4e0b\u9879\u76ee\u5904\u4e8e\u672a\u542f\u7528\u72b6\u6001\uff1a" + errorInfo;
            errorInfo = errorInfo.substring(0, errorInfo.length() - 1);
            checkItemStatusVo.setFlag(true);
            checkItemStatusVo.setRemark(errorInfo);
        }
        return checkItemStatusVo;
    }

    public String checkMedicalInsuranceFlag(List<String> orderNos, Integer tenantId) {
        String resultInfo = "\u5ba1\u6838\u901a\u8fc7";
        if (!orderNos.isEmpty()) {
            LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(tenantId != null, OutOrder::getTenantId, (Object)tenantId);
            queryWrapper.in(OutOrder::getOrderNo, orderNos);
            List outOrderList = this.outOrderMapper.selectList((Wrapper)queryWrapper);
            List prescNos = outOrderList.stream().map(OutOrder::getPrescriptionNo).distinct().filter(Objects::nonNull).collect(Collectors.toList());
            if (!prescNos.isEmpty()) {
                LambdaQueryWrapper prescDrugWrapper = Wrappers.lambdaQuery();
                prescDrugWrapper.eq(tenantId != null, OutPrescriptionDrug::getTenantId, (Object)tenantId);
                prescDrugWrapper.eq(OutPrescriptionDrug::getStatus, (Object)PrescriptionStatusEnum.STATUS_NORMAL.getValue());
                prescDrugWrapper.in(OutPrescriptionDrug::getPrescriptionNo, prescNos);
                List prescDrugList = this.outPrescriptionDrugMapper.selectList((Wrapper)prescDrugWrapper);
                String drugNames = prescDrugList.stream().filter(drug -> "2".equals(drug.getMedicalInsuranceAuditFlag())).map(drug -> {
                    BigDecimal totalAmount = drug.getDrugPriceAmount().multiply(drug.getQuantity());
                    return "\u836f\u54c1\u540d\u79f0\uff1a" + drug.getDrugName() + "<br>\u6570\u91cf\uff1a" + drug.getQuantity().stripTrailingZeros().toPlainString() + "\uff0c\u5355\u4ef7\uff1a" + drug.getDrugPriceAmount().stripTrailingZeros().toPlainString() + "\uff0c\u836f\u54c1\u91d1\u989d\uff1a" + totalAmount.stripTrailingZeros().toPlainString();
                }).collect(Collectors.joining("<br>"));
                if (StrUtil.isNotEmpty((CharSequence)drugNames)) {
                    resultInfo = "\u4ee5\u4e0b\u836f\u54c1\u533b\u4fdd\u5ba1\u6838\u672a\u901a\u8fc7\uff1a<br>" + drugNames + "<br>\u5c06\u6309\u7167\u836f\u54c1\u539f\u4ef7\u8fdb\u884c\u8d2d\u4e70\uff01";
                }
            }
        }
        return resultInfo;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public PayVo orderPayByICBC(PayByICBC param) {
        ICBCOrderEntity paymentResponse;
        if (param.getTotalAmount() == null || param.getTotalAmount().compareTo(BigDecimal.ZERO) <= 0) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u8ba2\u5355\u652f\u4ed8\u91d1\u989d\u4e0d\u53ef\u5c0f\u4e8e0\uff01");
        }
        LambdaQueryWrapper outOrderPaymentQuery = Wrappers.lambdaQuery();
        outOrderPaymentQuery.eq(OutOrderPayment::getStatus, (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
        outOrderPaymentQuery.eq(OutOrderPayment::getPayOrderNo, (Object)param.getPayOrderNo());
        outOrderPaymentQuery.eq(OutOrderPayment::getTenantId, (Object)param.getTenantId());
        OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)outOrderPaymentQuery);
        if (outOrderPayment == null) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u652f\u4ed8\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        LambdaQueryWrapper outOrderQuery = Wrappers.lambdaQuery();
        outOrderQuery.eq(OutOrder::getPayOrderNo, (Object)outOrderPayment.getPayOrderNo());
        outOrderQuery.eq(OutOrder::getStatus, (Object)OutpatientDataStatusEnum.NORMAL.getValue());
        outOrderQuery.eq(OutOrder::getPaymentStatus, (Object)PaymentStatusEnum.PAYMENT_PENDING.getValue());
        outOrderQuery.eq(OutOrder::getTenantId, (Object)param.getTenantId());
        List outOrderList = this.outOrderMapper.selectList((Wrapper)outOrderQuery);
        if (outOrderList.isEmpty()) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u4e0d\u5b58\u5728\u5f85\u652f\u4ed8\u8ba2\u5355\uff01");
        }
        ICBCPayDto payDto = new ICBCPayDto();
        payDto.setOrderNo(outOrderPayment.getPayOrderNo());
        payDto.setOutUserId(String.valueOf(outOrderPayment.getPatientId()));
        payDto.setAuthCode(param.getAuthCode());
        String orderTypeName = outOrderList.stream().map(OutOrder::getOrderEntryName).distinct().collect(Collectors.joining("\u3001"));
        payDto.setSubject(orderTypeName);
        payDto.setDescribe(orderTypeName);
        Integer amount = outOrderPayment.getTotalAmount().multiply(new BigDecimal(100)).intValue();
        payDto.setAmount(amount);
        ResponseData responseData = this.sdkServiceFeign.microPay(payDto);
        if (!responseData.isSuccess()) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)("\u8ba2\u5355\u652f\u4ed8\u5931\u8d25: " + responseData.getMsg()));
        }
        if (!"1".equals((paymentResponse = (ICBCOrderEntity)JSON.parseObject((String)JSON.toJSONString((Object)responseData.getData()), ICBCOrderEntity.class)).getSettleStatus())) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u8ba2\u5355\u652f\u4ed8\u5931\u8d25");
        }
        outOrderPayment.setPaymentType(Integer.valueOf(param.getPaymentType()));
        outOrderPayment.setActualPayment(outOrderPayment.getTotalAmount());
        outOrderPayment.setPaymentStatus(PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        outOrderPayment.setPaymentMethod(PaymentMethodEnum.PAY_ICBC.getValue());
        outOrderPayment.setPaymentTime(new Date());
        outOrderPayment.setPaymentExpirationTime(null);
        outOrderPayment.setCheckerId(param.getUserId());
        outOrderPayment.setCheckerName(param.getUserName());
        outOrderPayment.setPaymentTransactionNo(paymentResponse.getBankOrderid());
        int size = this.outOrderPaymentMapper.updateById((Object)outOrderPayment);
        if (size == 0) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u53d8\u66f4\u652f\u4ed8\u4fe1\u606f\u5931\u8d25");
        }
        ArrayList<OutOrderPaymentRecord> outOrderPaymentRecords = new ArrayList<OutOrderPaymentRecord>();
        String transactionNo = UUIDUtils.getTransactionNo();
        for (OutOrder order : outOrderList) {
            order.setPayOrderNo(outOrderPayment.getPayOrderNo());
            order.setActualPayment(order.getTotalAmount());
            order.setPaymentStatus(PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
            int num = this.outOrderMapper.updateById((Object)order);
            if (num == 0) {
                ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u53d8\u66f4\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
            }
            OutOrderPaymentRecord outOrderPaymentRecord = new OutOrderPaymentRecord();
            BeanUtils.copyProperties((Object)outOrderPayment, (Object)outOrderPaymentRecord);
            outOrderPaymentRecord.setDeliveryStatus(order.getDeliveryStatus());
            outOrderPaymentRecord.setOrderNo(order.getOrderNo());
            outOrderPaymentRecord.setStatus(PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
            outOrderPaymentRecord.setAmount(order.getAmount());
            outOrderPaymentRecord.setTotalAmount(order.getAmount());
            outOrderPaymentRecord.setActualPayment(outOrderPaymentRecord.getTotalAmount());
            outOrderPaymentRecord.setPaymentStatus(outOrderPayment.getPaymentStatus());
            outOrderPaymentRecord.setQuantity(Integer.valueOf(1));
            outOrderPaymentRecord.setOperationType(OperationTypeEnum.PAYMENT.getValue());
            outOrderPaymentRecord.setTransactionNumber(transactionNo);
            outOrderPaymentRecords.add(outOrderPaymentRecord);
        }
        Integer recordSize = this.outOrderPaymentRecordMapper.batchInsert(outOrderPaymentRecords);
        if (recordSize.intValue() != outOrderList.size()) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u8bb0\u5f55\u652f\u4ed8\u8bb0\u5f55\u5931\u8d25");
        }
        PayVo payVo = new PayVo();
        BeanUtils.copyProperties((Object)outOrderPayment, (Object)payVo);
        payVo.setName(outOrderPayment.getPatientName());
        payVo.setTransactionNumber(transactionNo);
        payVo.setOperationType(OperationTypeEnum.PAYMENT.getValue());
        return payVo;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public PayVo payRefundByICBC(PayReFundByICBC param) {
        ICBCOrderEntity refundResData;
        ResponseData drugResponseData;
        List drugOrderList;
        ResponseData responseData;
        boolean key;
        if (param.getRefundableAmount() == null || param.getRefundableAmount().compareTo(BigDecimal.ZERO) <= 0) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u8ba2\u5355\u652f\u4ed8\u91d1\u989d\u4e0d\u53ef\u5c0f\u4e8e0\uff01");
        }
        if (key = this.redisUtil.hasKey("outpatient-service:pay:order:Refund" + param.getPayOrderNo())) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u9000\u8d39\u4e2d\uff01\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4!");
        }
        this.redisUtil.set("outpatient-service:pay:order:Refund" + param.getPayOrderNo(), (Object)param.getPayOrderNo(), 30L);
        LambdaQueryWrapper outOrderQuery = Wrappers.lambdaQuery();
        outOrderQuery.in(OutOrder::getOrderNo, (Collection)param.getOrderNoList());
        outOrderQuery.eq(OutOrder::getStatus, (Object)OutpatientDataStatusEnum.NORMAL.getValue());
        outOrderQuery.eq(OutOrder::getPaymentStatus, (Object)PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        outOrderQuery.eq(OutOrder::getTenantId, (Object)param.getTenantId());
        List outOrderList = this.outOrderMapper.selectList((Wrapper)outOrderQuery);
        if (CollectionUtils.isEmpty((Collection)outOrderList) || outOrderList.size() != param.getOrderNoList().size()) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u5df2\u652f\u4ed8\u8ba2\u5355\u4e0e\u9000\u6b3e\u8ba2\u5355\u6570\u91cf\u4e0d\u7b26\uff01\u8bf7\u91cd\u8bd5!");
        }
        LambdaQueryWrapper outOrderPaymentQuery = Wrappers.lambdaQuery();
        outOrderPaymentQuery.eq(OutOrderPayment::getStatus, (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
        outOrderPaymentQuery.eq(OutOrderPayment::getPayOrderNo, (Object)param.getPayOrderNo());
        outOrderPaymentQuery.eq(OutOrderPayment::getTenantId, (Object)param.getTenantId());
        OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)outOrderPaymentQuery);
        if (outOrderPayment == null) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u652f\u4ed8\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        if (!(responseData = this.checkOrderList(outOrderList)).isSuccess()) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)responseData.getMsg());
        }
        BigDecimal amount = outOrderList.stream().map(OutOrder::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal actualPayment = outOrderList.stream().map(OutOrder::getActualPayment).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (actualPayment.compareTo(param.getRefundableAmount()) != 0) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u5b9e\u4ed8\u91d1\u989d\u4e0e\u5e94\u9000\u91d1\u989d\u4e0d\u4e00\u81f4\uff01");
        }
        if (amount.compareTo(param.getRefundAmount()) != 0) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u8ba2\u5355\u603b\u91d1\u989d\u4e0e\u9000\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4\uff01");
        }
        if (outOrderPayment.getActualPayment().compareTo(param.getRefundAmount()) < 0) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u603b\u652f\u4ed8\u91d1\u989d\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)(drugOrderList = (List)responseData.getData())) && !(drugResponseData = this.outPrescriptionService.returnOfDrugInventoryQuantity(param.getTenantId(), drugOrderList, param.getUserName(), param.getUserId())).isSuccess()) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)drugResponseData.getMsg());
        }
        if (!RefundMethodEnum.ORIGINAL_REFUND.getValue().equals(param.getRefundMethod())) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u5f53\u524d\u652f\u4ed8\u65b9\u5f0f\u53ea\u5141\u8bb8\u539f\u8def\u9000\u6b3e\uff01");
        }
        IcbcRefundDto icbcRefundDto = new IcbcRefundDto();
        icbcRefundDto.setOriOrderNo(outOrderPayment.getPayOrderNo());
        String oriTxDate = DateUtil.format((Date)outOrderPayment.getPaymentTime(), (String)"yyyyMMddHHmmss");
        icbcRefundDto.setOriTxDate(DateUtil.format((Date)outOrderPayment.getPaymentTime(), (String)"yyyyMMddHHmmss"));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        LocalDateTime orderTime = LocalDateTime.parse(oriTxDate, formatter);
        long daysBetween = ChronoUnit.DAYS.between(orderTime.toLocalDate(), orderTime.plusMonths(3L).toLocalDate());
        long daysSinceOrder = ChronoUnit.DAYS.between(orderTime.toLocalDate(), LocalDateTime.now().toLocalDate());
        long finalResult = daysBetween - daysSinceOrder;
        icbcRefundDto.setPayDays(Integer.valueOf(Math.toIntExact(finalResult)));
        Integer refundAmount = param.getRefundableAmount().multiply(new BigDecimal(100)).intValue();
        icbcRefundDto.setRefundFee(refundAmount);
        ResponseData refundRes = this.sdkServiceFeign.refund(icbcRefundDto);
        if (!refundRes.isSuccess()) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)("\u8ba2\u5355\u9000\u6b3e\u5931\u8d25: " + refundRes.getMsg()));
        }
        if (!"2".equals((refundResData = (ICBCOrderEntity)JSON.parseObject((String)JSON.toJSONString((Object)refundRes.getData()), ICBCOrderEntity.class)).getSettleStatus())) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u8ba2\u5355\u9000\u6b3e\u5931\u8d25");
        }
        QueryWrapper queryOrder = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryOrder.eq((Object)"pay_order_no", (Object)outOrderPayment.getPayOrderNo())).eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"payment_status", (Object)PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        Integer refundableOrders = this.outOrderMapper.selectCount((Wrapper)queryOrder);
        PaymentStatusEnum paymentStatusEnum = refundableOrders > outOrderList.size() ? PaymentStatusEnum.PAYMENT_PARTIAL_REFUND : PaymentStatusEnum.PAYMENT_REFUNDED;
        outOrderPayment.setRefundAmount(outOrderPayment.getRefundAmount() == null ? new BigDecimal(0) : outOrderPayment.getRefundAmount());
        outOrderPayment.setRefundAmount(outOrderPayment.getRefundAmount().add(param.getRefundableAmount()));
        outOrderPayment.setActualPayment(outOrderPayment.getActualPayment().subtract(param.getRefundableAmount()));
        outOrderPayment.setPaymentStatus(paymentStatusEnum.getValue());
        outOrderPayment.setRefundTime(new Date());
        outOrderPayment.setRefundTransactionNo(outOrderPayment.getPayOrderNo());
        outOrderPayment.setRefundCheckerId(param.getUserId());
        outOrderPayment.setRefundCheckerName(param.getUserName());
        int size = this.outOrderPaymentMapper.updateById((Object)outOrderPayment);
        if (size == 0) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u53d8\u66f4\u652f\u4ed8\u4fe1\u606f\u5931\u8d25");
        }
        String transactionNo = UUIDUtils.getTransactionNo();
        ArrayList<OutOrderPaymentRecord> outOrderPaymentRecords = new ArrayList<OutOrderPaymentRecord>();
        for (OutOrder order : outOrderList) {
            int num;
            order.setRefundAmount(param.getRefundAmount());
            order.setPaymentStatus(PaymentStatusEnum.PAYMENT_REFUNDED.getValue());
            if (order.getDeliveryStatus().equals(DeliveryStatusEnum.DELIVERY_SHIPPED.getValue())) {
                order.setDeliveryStatus(DeliveryStatusEnum.DELIVERY_REQUIRED.getValue());
            }
            if ((num = this.outOrderMapper.updateById((Object)order)) == 0) {
                throw new RunDisplayException("\u53d8\u66f4\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
            }
            OutOrderPaymentRecord outOrderPaymentRecord = new OutOrderPaymentRecord();
            BeanUtils.copyProperties((Object)outOrderPayment, (Object)outOrderPaymentRecord);
            outOrderPaymentRecord.setPaymentTime(new Date());
            outOrderPaymentRecord.setOrderNo(order.getOrderNo());
            outOrderPaymentRecord.setStatus(PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
            outOrderPaymentRecord.setAmount(order.getAmount().negate());
            outOrderPaymentRecord.setDeliveryStatus(order.getDeliveryStatus());
            outOrderPaymentRecord.setTotalAmount(order.getAmount());
            outOrderPaymentRecord.setActualPayment(param.getRefundAmount().negate());
            outOrderPaymentRecord.setPaymentStatus(PaymentStatusEnum.PAYMENT_REFUNDED.getValue());
            outOrderPaymentRecord.setQuantity(Integer.valueOf(-1));
            outOrderPaymentRecord.setOperationType(OperationTypeEnum.PAYMENT_REFUND.getValue());
            outOrderPaymentRecord.setTransactionNumber(transactionNo);
            outOrderPaymentRecords.add(outOrderPaymentRecord);
        }
        Integer recordSize = this.outOrderPaymentRecordMapper.batchInsert(outOrderPaymentRecords);
        if (recordSize.intValue() != outOrderList.size()) {
            throw new RunDisplayException("\u8bb0\u5f55\u652f\u4ed8\u8bb0\u5f55\u5931\u8d25");
        }
        this.redisUtil.del(new String[]{"outpatient-service:pay:order:Refund" + param.getPayOrderNo()});
        PayVo payVo = new PayVo();
        BeanUtils.copyProperties((Object)outOrderPayment, (Object)payVo);
        payVo.setName(outOrderPayment.getPatientName());
        payVo.setTransactionNumber(transactionNo);
        payVo.setOperationType(OperationTypeEnum.PAYMENT.getValue());
        return payVo;
    }

    public PayVo payFullRefundByICBC(IcbcRefundDto param) {
        ICBCOrderEntity refundResData;
        ResponseData refundRes;
        ResponseData drugResponseData;
        List drugOrderList;
        ResponseData responseData;
        boolean key;
        if (param.getRefundFee() == null || param.getRefundFee().compareTo(0) <= 0) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u8ba2\u5355\u652f\u4ed8\u91d1\u989d\u4e0d\u53ef\u5c0f\u4e8e0\uff01");
        }
        if (key = this.redisUtil.hasKey("outpatient-service:pay:order:Refund" + param.getOriOrderNo())) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u9000\u8d39\u4e2d\uff01\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4!");
        }
        this.redisUtil.set("outpatient-service:pay:order:Refund" + param.getOriOrderNo(), (Object)param.getOriOrderNo(), 30L);
        LambdaQueryWrapper outOrderQuery = Wrappers.lambdaQuery();
        outOrderQuery.eq(OutOrder::getStatus, (Object)OutpatientDataStatusEnum.NORMAL.getValue());
        outOrderQuery.eq(OutOrder::getPayOrderNo, (Object)param.getOriOrderNo());
        outOrderQuery.eq(OutOrder::getPaymentStatus, (Object)PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        outOrderQuery.eq(OutOrder::getTenantId, (Object)param.getTenantId());
        List outOrderList = this.outOrderMapper.selectList((Wrapper)outOrderQuery);
        if (CollectionUtils.isEmpty((Collection)outOrderList)) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u672a\u627e\u5230\u6536\u8d39\u9879\u76ee\uff01\u8bf7\u91cd\u8bd5!");
        }
        LambdaQueryWrapper outOrderPaymentQuery = Wrappers.lambdaQuery();
        outOrderPaymentQuery.eq(OutOrderPayment::getStatus, (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
        outOrderPaymentQuery.eq(OutOrderPayment::getPayOrderNo, (Object)param.getOriOrderNo());
        outOrderPaymentQuery.eq(OutOrderPayment::getTenantId, (Object)param.getTenantId());
        OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)outOrderPaymentQuery);
        if (outOrderPayment == null) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u652f\u4ed8\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        if (!(responseData = this.checkOrderList(outOrderList)).isSuccess()) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)responseData.getMsg());
        }
        Integer amount = outOrderList.stream().map(OutOrder::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add).multiply(new BigDecimal(100)).intValue();
        Integer actualPayment = outOrderList.stream().map(OutOrder::getActualPayment).reduce(BigDecimal.ZERO, BigDecimal::add).multiply(new BigDecimal(100)).intValue();
        Integer actualAmt = outOrderPayment.getActualPayment().multiply(new BigDecimal(100)).intValue();
        if (actualPayment.compareTo(param.getRefundFee()) != 0) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u5b9e\u4ed8\u91d1\u989d\u4e0e\u5e94\u9000\u91d1\u989d\u4e0d\u4e00\u81f4\uff01");
        }
        if (amount.compareTo(param.getRefundFee()) != 0) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u8ba2\u5355\u603b\u91d1\u989d\u4e0e\u9000\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4\uff01");
        }
        if (actualAmt.compareTo(param.getRefundFee()) < 0) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u603b\u652f\u4ed8\u91d1\u989d\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)(drugOrderList = (List)responseData.getData())) && !(drugResponseData = this.outPrescriptionService.returnOfDrugInventoryQuantity(param.getTenantId(), drugOrderList, param.getUserName(), param.getUserId())).isSuccess()) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)drugResponseData.getMsg());
        }
        if (!(refundRes = this.sdkServiceFeign.refund(param)).isSuccess()) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)("\u8ba2\u5355\u9000\u6b3e\u5931\u8d25: " + refundRes.getMsg()));
        }
        if (!"2".equals((refundResData = (ICBCOrderEntity)JSON.parseObject((String)JSON.toJSONString((Object)refundRes.getData()), ICBCOrderEntity.class)).getSettleStatus())) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u8ba2\u5355\u9000\u6b3e\u5931\u8d25");
        }
        outOrderPayment.setRefundAmount(outOrderPayment.getActualPayment());
        outOrderPayment.setActualPayment(outOrderPayment.getActualPayment());
        outOrderPayment.setPaymentStatus(PaymentStatusEnum.PAYMENT_REFUNDED.getValue());
        outOrderPayment.setRefundTime(new Date());
        outOrderPayment.setRefundTransactionNo(outOrderPayment.getPayOrderNo());
        outOrderPayment.setRefundCheckerId(param.getUserId());
        outOrderPayment.setRefundCheckerName(param.getUserName());
        int size = this.outOrderPaymentMapper.updateById((Object)outOrderPayment);
        if (size == 0) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u53d8\u66f4\u652f\u4ed8\u4fe1\u606f\u5931\u8d25");
        }
        String transactionNo = UUIDUtils.getTransactionNo();
        ArrayList<OutOrderPaymentRecord> outOrderPaymentRecords = new ArrayList<OutOrderPaymentRecord>();
        for (OutOrder order : outOrderList) {
            int num;
            order.setRefundAmount(outOrderPayment.getActualPayment());
            order.setPaymentStatus(PaymentStatusEnum.PAYMENT_REFUNDED.getValue());
            if (order.getDeliveryStatus().equals(DeliveryStatusEnum.DELIVERY_SHIPPED.getValue())) {
                order.setDeliveryStatus(DeliveryStatusEnum.DELIVERY_REQUIRED.getValue());
            }
            if ((num = this.outOrderMapper.updateById((Object)order)) == 0) {
                throw new RunDisplayException("\u53d8\u66f4\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
            }
            OutOrderPaymentRecord outOrderPaymentRecord = new OutOrderPaymentRecord();
            BeanUtils.copyProperties((Object)outOrderPayment, (Object)outOrderPaymentRecord);
            outOrderPaymentRecord.setPaymentTime(new Date());
            outOrderPaymentRecord.setOrderNo(order.getOrderNo());
            outOrderPaymentRecord.setStatus(PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
            outOrderPaymentRecord.setAmount(order.getAmount().negate());
            outOrderPaymentRecord.setDeliveryStatus(order.getDeliveryStatus());
            outOrderPaymentRecord.setTotalAmount(order.getAmount());
            outOrderPaymentRecord.setActualPayment(outOrderPayment.getActualPayment().negate());
            outOrderPaymentRecord.setPaymentStatus(PaymentStatusEnum.PAYMENT_REFUNDED.getValue());
            outOrderPaymentRecord.setQuantity(Integer.valueOf(-1));
            outOrderPaymentRecord.setOperationType(OperationTypeEnum.PAYMENT_REFUND.getValue());
            outOrderPaymentRecord.setTransactionNumber(transactionNo);
            outOrderPaymentRecords.add(outOrderPaymentRecord);
        }
        Integer recordSize = this.outOrderPaymentRecordMapper.batchInsert(outOrderPaymentRecords);
        if (recordSize.intValue() != outOrderList.size()) {
            throw new RunDisplayException("\u8bb0\u5f55\u652f\u4ed8\u8bb0\u5f55\u5931\u8d25");
        }
        this.redisUtil.del(new String[]{"outpatient-service:pay:order:Refund" + param.getOriOrderNo()});
        PayVo payVo = new PayVo();
        BeanUtils.copyProperties((Object)outOrderPayment, (Object)payVo);
        payVo.setName(outOrderPayment.getPatientName());
        payVo.setTransactionNumber(transactionNo);
        payVo.setOperationType(OperationTypeEnum.PAYMENT.getValue());
        return payVo;
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public ResponseData<FeeBillCreationVo> orderCharge(FeeBillCreationDto parameter) {
        int size;
        boolean key = this.redisUtil.hasKey("outpatient-service:pay:order:" + parameter.getOutpatientNo());
        if (key) {
            return ResponseData.error((String)"\u8bf7\u52ff\u91cd\u590d\u6536\u8d39!\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        this.redisUtil.set("outpatient-service:pay:order:" + parameter.getOutpatientNo(), (Object)parameter.getOutpatientNo(), 30L);
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.in((Object)"order_no", (Collection)parameter.getOrderNoList())).eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"payment_status", (Object)PaymentStatusEnum.PAYMENT_PENDING.getValue());
        List outOrderList = this.outOrderMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)outOrderList) || outOrderList.size() != parameter.getOrderNoList().size()) {
            return ResponseData.error((String)"\u8ba2\u5355\u5f85\u652f\u4ed8\u6570\u91cf\u4e0d\u7b26\uff01\u8bf7\u5237\u65b0\u91cd\u8bd5!");
        }
        ResponseData responseData = this.checkOnLineOFFLineList(outOrderList, parameter.getOperatorSource());
        if (!responseData.isSuccess()) {
            return responseData;
        }
        QueryWrapper queryWrapperAdmission = new QueryWrapper();
        queryWrapperAdmission.eq((Object)"outpatient_no", (Object)parameter.getOutpatientNo());
        AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)queryWrapperAdmission);
        if (ObjectUtils.isEmpty((Object)admissionEntity)) {
            return ResponseData.error((String)"\u6302\u53f7\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01");
        }
        BigDecimal amount = outOrderList.stream().map(OutOrder::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalAmount = outOrderList.stream().map(OutOrder::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (amount.compareTo(parameter.getAmount()) != 0 || totalAmount.compareTo(parameter.getTotalAmount()) != 0) {
            return ResponseData.error((String)"\u652f\u4ed8\u91d1\u989d\u4e0d\u5339\u914d\uff01");
        }
        if (parameter.getPendingAmount() != null && totalAmount.compareTo(parameter.getPendingAmount()) != 0) {
            return ResponseData.error((String)"\u6302\u8d26\u91d1\u989d\u4e0d\u5339\u914d\uff01");
        }
        List paymentNos = outOrderList.stream().filter(s -> StringUtils.isNotEmpty((CharSequence)s.getPayOrderNo())).map(OutOrder::getPayOrderNo).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(paymentNos)) {
            QueryWrapper queryWrapper1 = new QueryWrapper();
            queryWrapper1.in((Object)"pay_order_no", paymentNos);
            queryWrapper1.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
            List outOrderPayments = this.outOrderPaymentMapper.selectList((Wrapper)queryWrapper1);
            if (!CollectionUtils.isEmpty((Collection)outOrderPayments)) {
                List payIds = outOrderPayments.stream().map(x -> x.getId()).distinct().collect(Collectors.toList());
                this.outOrderPaymentMapper.updateStatusByIds(payIds, PaymentRecordsStatusEnum.STATUS_VOID.getValue());
            }
        }
        OutOrderPayment outOrderPayment = OutPayServiceImpl.getOutOrderPaymentRecord((AdmissionEntity)admissionEntity, (FeeBillCreationDto)parameter, (List)outOrderList);
        if (SettlementMethodEnum.STATUS_PENDING_ACCOUNT.getValue().equals(parameter.getSettlementMethod())) {
            if (StringUtils.isEmpty((CharSequence)parameter.getProjectNo())) {
                return ResponseData.error((String)(SettlementMethodEnum.STATUS_PENDING_ACCOUNT.getDesc() + "-\u9879\u76ee\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            outOrderPayment.setPaymentMethod(PaymentMethodEnum.PAY_PENDINGACCOUNT.getValue());
            outOrderPayment.setPaymentType(PaymentTypeEnum.ONLINE_PAYMENT.getValue());
        }
        if ((size = this.outOrderPaymentMapper.insert((Object)outOrderPayment)) != 1) {
            log.error("\u652f\u4ed8\u8ba2\u5355\u521b\u5efa\u5931\u8d25");
            throw new RunDisplayException("\u652f\u4ed8\u8ba2\u5355\u521b\u5efa\u5931\u8d25\uff01");
        }
        this.pushEtube(outOrderPayment);
        for (OutOrder order : outOrderList) {
            order.setPayOrderNo(outOrderPayment.getPayOrderNo());
            int num = this.outOrderMapper.updateById((Object)order);
            if (num == 1) continue;
            log.error("\u8ba2\u5355\u53d8\u66f4\u5931\u8d25");
            throw new RunDisplayException("\u652f\u4ed8\u8ba2\u5355\u521b\u5efa\u5931\u8d25\uff01");
        }
        RabbitMqUtils.sendOrderTimeoutAndUnpaid((RabbitTemplate)this.rabbitTemplate, (String)outOrderPayment.getPayOrderNo());
        this.redisUtil.del(new String[]{"outpatient-service:pay:order:" + parameter.getOutpatientNo()});
        FeeBillCreationVo feeBillCreationVo = new FeeBillCreationVo();
        feeBillCreationVo.setPayOrderNo(outOrderPayment.getPayOrderNo());
        if (SettlementMethodEnum.STATUS_PENDING_ACCOUNT.getValue().equals(parameter.getSettlementMethod())) {
            PaymentMethodEnum paymentMethodEnum = PaymentMethodEnum.getEnum((Integer)outOrderPayment.getPaymentMethod());
            if (paymentMethodEnum == null) {
                return ResponseData.error((String)(paymentMethodEnum.getDesc() + "-\u6ca1\u6709\u5f53\u524d\u652f\u4ed8\u65b9\u5f0f\uff01"));
            }
            PayService paymentService = PayFactory.getPaymentService((Integer)outOrderPayment.getPaymentMethod());
            if (paymentService == null) {
                return ResponseData.error((String)(paymentMethodEnum.getDesc() + "-\u5f53\u524d\u652f\u4ed8\u65b9\u5f0f\u6682\u4e0d\u53ef\u7528\uff01"));
            }
            PayDto payDto = new PayDto();
            payDto.setOperatorId(parameter.getOperatorId());
            payDto.setOperatorName(parameter.getOperatorName());
            payDto.setTenantId(parameter.getTenantId());
            payDto.setAmount(amount);
            payDto.setProjectNo(parameter.getProjectNo());
            payDto.setTotalAmount(totalAmount);
            payDto.setPendingAmount(parameter.getPendingAmount());
            payDto.setPaymentType(PaymentTypeEnum.ONLINE_PAYMENT.getValue());
            payDto.setPaymentMethod(paymentMethodEnum.getValue());
            payDto.setMedicalRecordNo(admissionEntity.getMedicalRecordNo());
            payDto.setPatientSex(Integer.valueOf(admissionEntity.getPatientSex()));
            payDto.setPatientCardNo(admissionEntity.getPatientCardNo());
            payDto.setPhone(admissionEntity.getPhone());
            ResponseData payVoResponseData = paymentService.firstPayment(payDto, paymentMethodEnum, outOrderPayment, outOrderList);
            if (!payVoResponseData.isSuccess()) {
                throw new RunDisplayException(payVoResponseData.getMsg());
            }
            feeBillCreationVo.setTransactionNumber(((PayVo)payVoResponseData.getData()).getTransactionNumber());
        }
        return ResponseData.success((Object)feeBillCreationVo);
    }

    private ResponseData checkOnLineOFFLineList(List<OutOrder> outOrderList, String operatorSource) {
        if (SourceEnum.IHOS_ONLINE.getValue().equals(operatorSource)) {
            return ResponseData.success();
        }
        List offlineList = outOrderList.stream().filter(x -> StringUtils.isEmpty((CharSequence)x.getSource()) || !SourceEnum.ONLINE.getValue().equals(x.getSource())).collect(Collectors.toList());
        List onlineList = outOrderList.stream().filter(x -> SourceEnum.ONLINE.getValue().equals(x.getSource())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(offlineList) && !CollectionUtils.isEmpty(onlineList)) {
            return ResponseData.error((String)"\u7ebf\u4e0b\u7ebf\u4e0a\u8ba2\u5355\u4e0d\u5141\u8bb8\u540c\u65f6\u64cd\u4f5c!");
        }
        if (SourceEnum.ONLINE.getValue().equals(operatorSource) && !CollectionUtils.isEmpty(offlineList)) {
            return ResponseData.error((String)"\u7ebf\u4e0a\u64cd\u4f5c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u7ebf\u4e0b\u5355!");
        }
        if ((StringUtils.isEmpty((CharSequence)operatorSource) || SourceEnum.OFFLINE.getValue().equals(operatorSource)) && !CollectionUtils.isEmpty(onlineList)) {
            return ResponseData.error((String)"\u7ebf\u4e0b\u64cd\u4f5c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u7ebf\u4e0a\u5355\uff01");
        }
        return ResponseData.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<String> cancelPayment(CancelPaymentDto parameter) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"pay_order_no", (Object)parameter.getPayOrderNo());
        OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)queryWrapper);
        if (ObjectUtils.isEmpty((Object)outOrderPayment)) {
            return ResponseData.error((String)"\u652f\u4ed8\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        if (SettlementMethodEnum.STATUS_MEDICARE_STTLE.getValue().equals(outOrderPayment.getSettlementMethod())) {
            this.cancelHsPrePay(outOrderPayment);
        }
        if (!(PaymentStatusEnum.PAYMENT_PENDING.getValue().equals(outOrderPayment.getPaymentStatus()) || PaymentStatusEnum.PAYMENT_CONFIRMED.getValue().equals(outOrderPayment.getPaymentStatus()) || PaymentStatusEnum.PAYMENT_REQUIRE_CUSTOMER_PASSWORD.getValue().equals(outOrderPayment.getPaymentStatus()))) {
            return ResponseData.error((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u53d6\u6d88\uff01");
        }
        if (!(parameter.getIsTimeout() == null || parameter.getIsTimeout() != false)) {
            outOrderPayment.setStatus(PaymentRecordsStatusEnum.STATUS_VOID.getValue());
        } else {
            outOrderPayment.setStatus(PaymentRecordsStatusEnum.STATUS_EXPIRED.getValue());
        }
        int szie = this.outOrderPaymentMapper.updateById((Object)outOrderPayment);
        if (szie != 1) {
            return ResponseData.error((String)"\u53d6\u6d88\u5931\u8d25\uff01");
        }
        QueryWrapper queryOrder = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryOrder.eq((Object)"pay_order_no", (Object)outOrderPayment.getPayOrderNo())).eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).in((Object)"payment_status", Arrays.asList(PaymentStatusEnum.PAYMENT_PENDING.getValue(), PaymentStatusEnum.PAYMENT_REQUIRE_CUSTOMER_PASSWORD.getValue()));
        List outOrderList = this.outOrderMapper.selectList((Wrapper)queryOrder);
        if (CollectionUtils.isEmpty((Collection)outOrderList)) {
            return ResponseData.error((String)"\u6ca1\u6709\u8ba2\u5355\uff01");
        }
        for (OutOrder order : outOrderList) {
            order.setActualPayment(order.getTotalAmount());
            order.setPaymentStatus(PaymentStatusEnum.PAYMENT_PENDING.getValue());
            int num = this.outOrderMapper.updateById((Object)order);
            if (num != 0) continue;
            throw new RunDisplayException("\u53d8\u66f4\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
        }
        return ResponseData.success((Object)"\u53d6\u6d88\u5b8c\u6210");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<String> recharge(CancelPaymentDto parameter) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"pay_order_no", (Object)parameter.getPayOrderNo());
        OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)queryWrapper);
        if (ObjectUtils.isEmpty((Object)outOrderPayment)) {
            return ResponseData.error((String)"\u652f\u4ed8\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        outOrderPayment.setNumberCharges(BusinessConstant.TWO);
        this.outOrderPaymentMapper.updateById((Object)outOrderPayment);
        QueryWrapper query = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)query.in((Object)"pay_order_no", new Object[]{parameter.getPayOrderNo()})).eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"payment_status", (Object)PaymentStatusEnum.PAYMENT_REFUNDED.getValue());
        List outOrderList = this.outOrderMapper.selectList((Wrapper)query);
        for (OutOrder order : outOrderList) {
            order.setCreateTime(new Date());
            order.setCreateId(parameter.getOperatorId());
            order.setUpdateTime(null);
            order.setUpdateId(null);
            order.setTenantId(parameter.getTenantId());
            order.setActualPayment(null);
            order.setCreditAmount(null);
            order.setRefundAmount(null);
            order.setPaymentStatus(PaymentStatusEnum.PAYMENT_PENDING.getValue());
            order.setInvoiceNo(null);
            order.setInvoiceTime(null);
            order.setRemark(null);
            order.setNumberCharges(outOrderPayment.getNumberCharges());
            order.setPayOrderNo(null);
            log.info("\u8ba2\u5355\u521b\u5efa-->\u65b0\u589e\u8ba2\u5355[\u5f00\u59cb]");
            String orderNo = UUIDUtils.getOrderNo();
            log.info("\u8ba2\u5355\u521b\u5efa-->>\u751f\u6210\u7684\u8ba2\u5355\u7f16\u53f7:{}", (Object)orderNo);
            order.setOrderNo(orderNo);
            order.setId(null);
            Integer size = this.outOrderMapper.insert((Object)order);
            if (size >= 1) continue;
            throw new RunDisplayException("\u65b0\u589e\u8ba2\u5355\u5931\u8d25");
        }
        return ResponseData.success((Object)"\u64cd\u4f5c\u5b8c\u6210!");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<PayVo> firstPayment(PayDto parameter) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"pay_order_no", (Object)parameter.getPayOrderNo());
        OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)queryWrapper);
        if (ObjectUtils.isEmpty((Object)outOrderPayment)) {
            return ResponseData.error((String)"\u652f\u4ed8\u8ba2\u5355\u67e5\u8be2\u5f02\u5e38\uff01");
        }
        QueryWrapper queryOrder = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryOrder.eq((Object)"pay_order_no", (Object)outOrderPayment.getPayOrderNo())).eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"payment_status", (Object)PaymentStatusEnum.PAYMENT_PENDING.getValue());
        List outOrderList = this.outOrderMapper.selectList((Wrapper)queryOrder);
        if (CollectionUtils.isEmpty((Collection)outOrderList)) {
            return ResponseData.error((String)"\u6ca1\u6709\u5f85\u652f\u4ed8\u8ba2\u5355\uff01");
        }
        ResponseData responseData = this.checkOnLineOFFLineList(outOrderList, parameter.getOperatorSource());
        if (!responseData.isSuccess()) {
            return responseData;
        }
        BigDecimal amount = outOrderList.stream().map(OutOrder::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalAmount = outOrderList.stream().map(OutOrder::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (outOrderPayment.getAmount().compareTo(parameter.getAmount()) != 0 || outOrderPayment.getTotalAmount().compareTo(parameter.getTotalAmount()) != 0) {
            return ResponseData.error((String)("\u652f\u4ed8\u91d1\u989d\u5f02\u5e38\uff01\u8ba2\u5355\u5e94\u6536\u91d1\u989d:" + outOrderPayment.getTotalAmount()));
        }
        if (amount.compareTo(outOrderPayment.getAmount()) != 0 || totalAmount.compareTo(outOrderPayment.getTotalAmount()) != 0) {
            return ResponseData.error((String)("\u8ba2\u5355\u91d1\u989d\u5f02\u5e38\uff01\u8ba2\u5355\u5e94\u6536\u91d1\u989d:" + totalAmount));
        }
        PaymentMethodEnum paymentMethodEnum = PaymentMethodEnum.getEnum((Integer)parameter.getPaymentMethod());
        if (paymentMethodEnum == null) {
            return ResponseData.error((String)"\u6ca1\u6709\u5f53\u524d\u652f\u4ed8\u65b9\u5f0f\uff01");
        }
        PayService paymentService = PayFactory.getPaymentService((Integer)paymentMethodEnum.getValue());
        if (paymentService == null) {
            return ResponseData.error((String)"\u5f53\u524d\u652f\u4ed8\u65b9\u5f0f\u6682\u4e0d\u53ef\u7528\uff01");
        }
        ResponseData payVoResponseData = paymentService.firstPayment(parameter, paymentMethodEnum, outOrderPayment, outOrderList);
        if (payVoResponseData.isSuccess()) {
            CompletableFuture.runAsync(() -> this.uploadHsFee(outOrderPayment, outOrderList));
        }
        return payVoResponseData;
    }

    private void uploadHsFee(OutOrderPayment outOrderPayment, List<OutOrder> outOrderList) {
        LambdaQueryWrapper admissionWrapper = Wrappers.lambdaQuery();
        admissionWrapper.eq(outOrderPayment.getTenantId() != null, AdmissionEntity::getTenantId, (Object)outOrderPayment.getTenantId());
        admissionWrapper.eq(AdmissionEntity::getOutpatientNo, (Object)outOrderPayment.getOutpatientNo());
        AdmissionEntity admission = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)admissionWrapper);
        if (admission == null) {
            return;
        }
        List prescNos = outOrderList.stream().filter(outOrder -> this.isPrescriptionOrder(outOrder.getOrderType())).map(OutOrder::getPrescriptionNo).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List treatmentNos = outOrderList.stream().filter(outOrder -> this.isTreatmentOrder(outOrder.getOrderType())).map(OutOrder::getPrescriptionNo).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        OutOrder outVisitOrder = new OutOrder();
        Integer visitCount = 0;
        for (OutOrder outOrder2 : outOrderList) {
            if (this.isPrescriptionOrder(outOrder2.getOrderType()) || this.isTreatmentOrder(outOrder2.getOrderType())) continue;
            Integer n = visitCount;
            Integer n2 = visitCount = Integer.valueOf(visitCount + 1);
            outVisitOrder = outOrder2;
        }
        LinkedHashMap codeMap = new LinkedHashMap();
        List dbPrescDrugs = new ArrayList();
        if (!prescNos.isEmpty()) {
            LambdaQueryWrapper prescDrugQuery = Wrappers.lambdaQuery();
            prescDrugQuery.eq(outOrderPayment.getTenantId() != null, OutPrescriptionDrug::getTenantId, (Object)outOrderPayment.getTenantId());
            prescDrugQuery.eq(OutPrescriptionDrug::getStatus, (Object)OutpatientDataStatusEnum.NORMAL.getValue());
            prescDrugQuery.in(OutPrescriptionDrug::getPrescriptionNo, prescNos);
            List list = this.outPrescriptionDrugMapper.selectList((Wrapper)prescDrugQuery);
            dbPrescDrugs = list;
            codeMap.putAll(list.stream().collect(Collectors.groupingBy(OutPrescriptionDrug::getPrescriptionNo, Collectors.mapping(prescDrug -> {
                HsCodeDto hsCodeDto = new HsCodeDto();
                hsCodeDto.setMedicalInsuranceCode(prescDrug.getMedicalInsuranceCode());
                hsCodeDto.setMedicalInsuranceName(prescDrug.getMedicalInsuranceName());
                hsCodeDto.setInternalCode(prescDrug.getInternalCode());
                hsCodeDto.setInternalName(prescDrug.getDrugName());
                hsCodeDto.setDoseUsage(prescDrug.getDrugUsage());
                return hsCodeDto;
            }, Collectors.toList()))));
        }
        if (!treatmentNos.isEmpty()) {
            LambdaQueryWrapper treatmentDetailQuery = Wrappers.lambdaQuery();
            treatmentDetailQuery.eq(outOrderPayment.getTenantId() != null, OutTreatmentDetails::getTenantId, (Object)outOrderPayment.getTenantId());
            treatmentDetailQuery.in(OutTreatmentDetails::getOutTreatmentId, treatmentNos);
            List list = this.outTreatmentDetailsMapper.selectList((Wrapper)treatmentDetailQuery);
            codeMap.putAll(list.stream().collect(Collectors.groupingBy(detail -> String.valueOf(detail.getOutTreatmentId()), Collectors.mapping(detail -> {
                HsCodeDto hsCodeDto = new HsCodeDto();
                hsCodeDto.setMedicalInsuranceCode(detail.getMedicalInsuranceCode());
                hsCodeDto.setMedicalInsuranceName(detail.getMedicalInsuranceName());
                hsCodeDto.setInternalCode(detail.getTreatmentCode());
                hsCodeDto.setInternalName(detail.getTreatmentName());
                return hsCodeDto;
            }, Collectors.toList()))));
        }
        for (Map.Entry entry : codeMap.entrySet()) {
            List hsCodeDtos = (List)entry.getValue();
            visitCount = visitCount + hsCodeDtos.size();
        }
        if (SettlementMethodEnum.STATUS_SELF_FUNDED.getValue().equals(outOrderPayment.getSettlementMethod()) || SettlementMethodEnum.STATUS_PENDING_ACCOUNT.getValue().equals(outOrderPayment.getSettlementMethod())) {
            PayHsUploadRequest request = new PayHsUploadRequest();
            request.setOpter_type("1");
            request.setOpter(String.valueOf(outOrderPayment.getCheckerId()));
            request.setOpter_name(outOrderPayment.getCheckerName());
            request.setTenantId(outOrderPayment.getTenantId());
            ArrayList<Feedetail> arrayList = new ArrayList<Feedetail>();
            for (OutOrder outOrder3 : outOrderList) {
                if (this.isPrescriptionOrder(outOrder3.getOrderType()) || this.isTreatmentOrder(outOrder3.getOrderType())) {
                    List hsCodeDtos = Optional.ofNullable(codeMap.get(outOrder3.getPrescriptionNo())).orElse(new ArrayList());
                    if (hsCodeDtos.isEmpty()) continue;
                    for (HsCodeDto hsCodeDto : hsCodeDtos) {
                        Feedetail detail2 = new Feedetail();
                        detail2 = this.setCommcon(admission, Integer.valueOf(codeMap.size() + visitCount), outOrderPayment, outOrder3, detail2);
                        detail2.setMed_list_codg(hsCodeDto.getMedicalInsuranceCode());
                        detail2.setMedins_list_codg(hsCodeDto.getInternalCode());
                        detail2.setMedins_list_name(hsCodeDto.getInternalName());
                        detail2.setProdname(hsCodeDto.getInternalName());
                        detail2.setTcmdrug_used_way(hsCodeDto.getDoseUsage());
                        arrayList.add(detail2);
                    }
                    continue;
                }
                Feedetail detail3 = new Feedetail();
                detail3 = this.setCommcon(admission, Integer.valueOf(codeMap.size() + visitCount), outOrderPayment, outOrder3, detail3);
                detail3.setMed_list_codg("001101000010000-110100001");
                detail3.setMedins_list_codg("000001");
                detail3.setMedins_list_name("\u95e8\u8bca\u6302\u53f7\u8d39");
                detail3.setProdname("\u95e8\u8bca\u6302\u53f7\u8d39");
                detail3.setTcmdrug_used_way("\u95e8\u8bca\u6302\u53f7\u8d39");
                arrayList.add(detail3);
            }
            request.setFeedetail(arrayList);
            ResponseData responseData = this.hsServiceFeign.selfPatientDetailUpload(request);
            HsUploadLog hsUploadLog = new HsUploadLog();
            hsUploadLog.setHsUploadId(outOrderPayment.getPayOrderNo());
            hsUploadLog.setHsUploadType("4201");
            hsUploadLog.setTenantId(outOrderPayment.getTenantId());
            hsUploadLog.setCreateId(outOrderPayment.getCheckerId());
            hsUploadLog.setCreateName(outOrderPayment.getCheckerName());
            hsUploadLog.setCreateTime(new Date());
            hsUploadLog.setUpdateTime(new Date());
            hsUploadLog.setParam(JSONObject.toJSONString((Object)request));
            hsUploadLog.setLogMessage(responseData.getMsg());
            hsUploadLog.setStatusCode(Integer.valueOf(responseData.isSuccess() ? 1 : 0));
            this.hsServiceFeign.hsUploadLogSave(hsUploadLog);
            System.out.println();
        } else if (SettlementMethodEnum.STATUS_MEDICARE_STTLE.getValue().equals(outOrderPayment.getSettlementMethod()) || SettlementMethodEnum.STATUS_MEDICARE_STTLE_PRVN.getValue().equals(outOrderPayment.getSettlementMethod()) || SettlementMethodEnum.STATUS_MEDICARE_STTLE_PRVN_OTHER.getValue().equals(outOrderPayment.getSettlementMethod()) || SettlementMethodEnum.STATUS_MEDICARE_STTLE_OUT_PRVN_OTHER.getValue().equals(outOrderPayment.getSettlementMethod())) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            MedicalRecordRequest medicalRecordRequest = new MedicalRecordRequest();
            medicalRecordRequest.setOpter_type("1");
            medicalRecordRequest.setOpter(String.valueOf(outOrderPayment.getCheckerId()));
            medicalRecordRequest.setOpter_name(outOrderPayment.getCheckerName());
            medicalRecordRequest.setTenantId(outOrderPayment.getTenantId());
            LambdaQueryWrapper medicalRecordQuery = Wrappers.lambdaQuery();
            medicalRecordQuery.eq(outOrderPayment.getTenantId() != null, OutMedicalRecord::getTenantId, (Object)outOrderPayment.getTenantId());
            medicalRecordQuery.eq(OutMedicalRecord::getStatus, (Object)OutpatientDataStatusEnum.NORMAL.getValue());
            medicalRecordQuery.eq(OutMedicalRecord::getOutpatientNo, (Object)admission.getOutpatientNo());
            OutMedicalRecord medicalRecord = (OutMedicalRecord)this.outMedicalRecordMapper.selectOne((Wrapper)medicalRecordQuery);
            if (medicalRecord != null) {
                ArrayList<Caseinfo> caseinfoList = new ArrayList<Caseinfo>();
                Caseinfo caseinfo = new Caseinfo();
                caseinfo.setAlgs(medicalRecord.getAllergyHistoryText());
                caseinfo.setChfcomp(medicalRecord.getChiefComplaint());
                caseinfo.setDspo_opnn(medicalRecord.getHandleOpinion());
                caseinfo.setDept_code(String.valueOf(admission.getDeptId()));
                caseinfo.setDept_name(admission.getDeptName());
                String visitTimeStr = dateFormat.format(admission.getVisitTime());
                caseinfo.setMdtrt_date(visitTimeStr);
                caseinfo.setVali_flag("1");
                caseinfoList.add(caseinfo);
                medicalRecordRequest.setCaseinfo(caseinfoList);
            }
            LambdaQueryWrapper diagQuery = Wrappers.lambdaQuery();
            diagQuery.eq(outOrderPayment.getTenantId() != null, OutMedicalRecordDiagnosis::getTenantId, (Object)outOrderPayment.getTenantId());
            diagQuery.eq(OutMedicalRecordDiagnosis::getOutpatientNo, (Object)admission.getOutpatientNo());
            List diagList = this.outMedicalRecordDiagnosisMapper.selectList((Wrapper)diagQuery);
            ArrayList<DiseInfo> diseInfoList = new ArrayList<DiseInfo>();
            Integer diagCount = 0;
            for (OutMedicalRecordDiagnosis diag : diagList) {
                Integer n = diagCount;
                diagCount = diagCount + 1;
                Integer n2 = diagCount;
                DiseInfo diseInfo = new DiseInfo();
                diseInfo.setDiag_code(diag.getHsIcdCode());
                diseInfo.setDiag_name(diag.getHsDiagnosis());
                if (diagCount == 1) {
                    diseInfo.setMaindiag_flag("1");
                } else {
                    diseInfo.setMaindiag_flag("0");
                }
                if (diag.getDiagnosticType() == 1) {
                    diseInfo.setTcm_diag_flag("1");
                    diseInfo.setTcm_dise_code(diag.getHsIcdCode());
                    diseInfo.setTcm_dise_name(diag.getHsDiagnosis());
                } else {
                    diseInfo.setTcm_diag_flag("0");
                }
                diseInfo.setVali_flag("1");
                diseInfoList.add(diseInfo);
            }
            medicalRecordRequest.setDiseInfo(diseInfoList);
            Rgstinfo rgstinfo = new Rgstinfo();
            rgstinfo.setFstdiag_flag("0");
            rgstinfo.setMdtrt_flag("1");
            rgstinfo.setMdtrt_id(outOrderPayment.getMdtrtId());
            rgstinfo.setMdtrt_sn(admission.getOutpatientNo());
            rgstinfo.setPsn_no(outOrderPayment.getPsnNo());
            rgstinfo.setMedfee_paymtd_code(String.valueOf(outOrderPayment.getPaymentMethod()));
            rgstinfo.setRetnr_flag("0");
            String registTimeStr = dateFormat.format(admission.getCreateTime());
            rgstinfo.setRgst_retnr_time(registTimeStr);
            rgstinfo.setRgst_serv_fee(outVisitOrder.getTotalAmount() == null ? BigDecimal.ZERO : outVisitOrder.getTotalAmount().setScale(2, RoundingMode.HALF_UP));
            rgstinfo.setRgst_type_code("11");
            rgstinfo.setRgst_way_code("11");
            rgstinfo.setVali_flag("1");
            medicalRecordRequest.setRgstinfo(rgstinfo);
            if (!dbPrescDrugs.isEmpty()) {
                ArrayList<RxInfo> rxInfoList = new ArrayList<RxInfo>();
                for (OutPrescriptionDrug prescDrug2 : dbPrescDrugs) {
                    RxInfo rxInfo = new RxInfo();
                    rxInfo.setBas_medn_flag("1");
                    rxInfo.setDrug_dosform(prescDrug2.getDosageForm());
                    rxInfo.setDrug_spec(prescDrug2.getSpecification());
                    rxInfo.setRx_no(prescDrug2.getPrescriptionNo());
                    rxInfo.setVali_flag("1");
                    rxInfo.setRx_item_type_code(prescDrug2.getInternalCode());
                    rxInfo.setRx_item_type_name(prescDrug2.getDrugName());
                    rxInfo.setMedc_days(prescDrug2.getMedicationDays());
                    rxInfoList.add(rxInfo);
                }
                medicalRecordRequest.setRxInfo(rxInfoList);
            }
            ResponseData responseData = this.hsServiceFeign.outTreatRecord(medicalRecordRequest);
            HsUploadLog hsUploadLog = new HsUploadLog();
            hsUploadLog.setHsUploadId(outOrderPayment.getSetlId());
            hsUploadLog.setHsUploadType("4301");
            hsUploadLog.setTenantId(outOrderPayment.getTenantId());
            hsUploadLog.setCreateId(outOrderPayment.getCheckerId());
            hsUploadLog.setCreateName(outOrderPayment.getCheckerName());
            hsUploadLog.setCreateTime(new Date());
            hsUploadLog.setUpdateTime(new Date());
            hsUploadLog.setParam(JSONObject.toJSONString((Object)medicalRecordRequest));
            hsUploadLog.setLogMessage(responseData.getMsg());
            hsUploadLog.setStatusCode(Integer.valueOf(responseData.isSuccess() ? 1 : 0));
            this.hsServiceFeign.hsUploadLogSave(hsUploadLog);
            System.out.println();
        }
    }

    private Feedetail setCommcon(AdmissionEntity admission, Integer size, OutOrderPayment outOrderPayment, OutOrder outOrder, Feedetail detail) {
        detail.setPsn_name(admission.getPatientName());
        detail.setBilg_dept_codg(String.valueOf(admission.getDeptId()));
        detail.setBilg_dept_name(admission.getDeptName());
        detail.setBilg_dr_codg(String.valueOf(admission.getDoctorId()));
        detail.setBilg_dr_name(admission.getDoctorName());
        detail.setAcord_dept_codg(String.valueOf(admission.getDeptId()));
        detail.setAcord_dept_name(admission.getDeptName());
        detail.setOrders_dr_code(String.valueOf(admission.getDoctorId()));
        detail.setOrders_dr_name(admission.getDoctorName());
        detail.setPsn_cert_type("1");
        detail.setCertno(admission.getPatientCardNo());
        detail.setChrg_bchno(outOrderPayment.getPayOrderNo());
        detail.setFeedetl_sn(outOrderPayment.getPayOrderNo());
        detail.setCnt(BigDecimal.valueOf(size.intValue()));
        detail.setDet_item_fee_sumamt(outOrderPayment.getTotalAmount() != null ? outOrderPayment.getTotalAmount().setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO);
        detail.setPric(outOrder.getTotalAmount() != null ? outOrder.getTotalAmount().setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO);
        detail.setDscg_tkdrug_flag("0");
        detail.setEtip_flag("0");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String paymentTimeStr = dateFormat.format(outOrderPayment.getPaymentTime());
        detail.setFee_ocur_time(paymentTimeStr);
        detail.setIpt_otp_no(admission.getOutpatientNo());
        detail.setMdtrt_sn(admission.getOutpatientNo());
        String orderType = outOrder.getOrderType();
        String hsOrderType = Optional.ofNullable(HsOrderTypeEnum.getHsValue((String)orderType)).map(HsOrderTypeEnum::getHsValue).orElse(null);
        detail.setMed_chrgitm_type(hsOrderType);
        detail.setMed_type("11");
        return detail;
    }

    private boolean isPrescriptionOrder(String orderType) {
        return OrderTypeEnum.PRESCRIPTION_WESTERN_MEDICINE_ORDERS.getValue().equals(orderType) || OrderTypeEnum.REGISTERED_TRADITIONAL_ORDERS.getValue().equals(orderType) || OrderTypeEnum.REGISTERED_CHINESE_PATENT_DRUG_ORDERS.getValue().equals(orderType);
    }

    private boolean isTreatmentOrder(String orderType) {
        return OrderTypeEnum.REGISTERED_INSPECTION_ORDERS.getValue().equals(orderType) || OrderTypeEnum.REGISTERED_INSPECT_ORDERS.getValue().equals(orderType) || OrderTypeEnum.REGISTERED_TREATMENT_ORDERS.getValue().equals(orderType) || OrderTypeEnum.REGISTERED_OPERATION_ORDERS.getValue().equals(orderType) || OrderTypeEnum.REGISTERED_ANAESTHESIA_ORDERS.getValue().equals(orderType) || OrderTypeEnum.REGISTERED_NURSING_ORDERS.getValue().equals(orderType) || OrderTypeEnum.REGISTERED_DIET_ORDERS.getValue().equals(orderType) || OrderTypeEnum.REGISTERED_OXYGEN_THERAPY_ORDERS.getValue().equals(orderType) || OrderTypeEnum.REGISTERED_MATERIAL_ORDERS.getValue().equals(orderType) || OrderTypeEnum.REGISTERED_PATROL_VEHICLE_ORDERS.getValue().equals(orderType) || OrderTypeEnum.REGISTERED_MATERIAL_PROJECTS_ORDERS.getValue().equals(orderType) || OrderTypeEnum.REGISTERED_SERVICER_ORDERS.getValue().equals(orderType) || OrderTypeEnum.REGISTERED_BLOOD_TRANSFUSION_ORDERS.getValue().equals(orderType) || OrderTypeEnum.REGISTERED_OTHER_PROJECTS_ORDERS.getValue().equals(orderType);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<PayRefundVo> firstPayRefund(PayRefundDto parameter) {
        ResponseData drugResponseData;
        boolean key = this.redisUtil.hasKey("outpatient-service:pay:order:Refund" + parameter.getPayOrderNo());
        if (key) {
            return ResponseData.error((String)"\u9000\u8d39\u4e2d\uff01\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4!");
        }
        this.redisUtil.set("outpatient-service:pay:order:Refund" + parameter.getPayOrderNo(), (Object)parameter.getPayOrderNo(), 30L);
        QueryWrapper queryrOrder = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryrOrder.in((Object)"order_no", (Collection)parameter.getOrderNoList())).eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"payment_status", (Object)PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        List outOrderList = this.outOrderMapper.selectList((Wrapper)queryrOrder);
        if (CollectionUtils.isEmpty((Collection)outOrderList) || outOrderList.size() != parameter.getOrderNoList().size()) {
            return ResponseData.error((String)"\u5df2\u652f\u4ed8\u8ba2\u5355\u4e0e\u9000\u6b3e\u8ba2\u5355\u6570\u91cf\u4e0d\u7b26\uff01\u8bf7\u91cd\u8bd5!");
        }
        ResponseData responseData = this.checkOrderList(outOrderList);
        if (!responseData.isSuccess()) {
            return ResponseData.error((String)responseData.getMsg());
        }
        ResponseData responseData1 = this.checkOnLineOFFLineList(outOrderList, parameter.getOperatorSource());
        if (!responseData1.isSuccess()) {
            return responseData1;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"pay_order_no", (Object)parameter.getPayOrderNo());
        OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)queryWrapper);
        if (ObjectUtils.isEmpty((Object)outOrderPayment)) {
            return ResponseData.error((String)"\u4e0d\u5b58\u5728\u8be5\u652f\u4ed8\u8ba2\u5355\uff01");
        }
        BigDecimal amount = outOrderList.stream().map(OutOrder::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal actualPayment = outOrderList.stream().map(OutOrder::getActualPayment).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (actualPayment.compareTo(parameter.getRefundableAmount()) != 0) {
            return ResponseData.error((String)"\u5b9e\u4ed8\u91d1\u989d\u4e0e\u5e94\u9000\u91d1\u989d\u4e0d\u4e00\u81f4\uff01");
        }
        if (amount.compareTo(parameter.getRefundAmount()) != 0) {
            return ResponseData.error((String)"\u8ba2\u5355\u603b\u91d1\u989d\u4e0e\u9000\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4\uff01");
        }
        if (outOrderPayment.getActualPayment().compareTo(parameter.getRefundAmount()) < 0) {
            return ResponseData.error((String)"\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u603b\u652f\u4ed8\u91d1\u989d\uff01");
        }
        PaymentMethodEnum paymentMethodEnum = PaymentMethodEnum.getEnum((Integer)outOrderPayment.getPaymentMethod());
        if (paymentMethodEnum == null) {
            return ResponseData.error((String)"\u6ca1\u6709\u5f53\u524d\u652f\u4ed8\u65b9\u5f0f\uff01");
        }
        PayService paymentService = PayFactory.getPaymentService((Integer)paymentMethodEnum.getValue());
        if (paymentService == null) {
            return ResponseData.error((String)"\u5f53\u524d\u652f\u4ed8\u65b9\u5f0f\u6682\u4e0d\u53ef\u7528\uff01");
        }
        List drugOrderList = (List)responseData.getData();
        if (!CollectionUtils.isEmpty((Collection)drugOrderList) && !(drugResponseData = this.outPrescriptionService.returnOfDrugInventoryQuantity(parameter.getTenantId(), drugOrderList, parameter.getOperatorName(), parameter.getOperatorId())).isSuccess()) {
            return ResponseData.error((String)drugResponseData.getMsg());
        }
        ResponseData payRefundVoResponseData = paymentService.firstPayRefund(parameter, paymentMethodEnum, outOrderPayment, outOrderList);
        this.redisUtil.del(new String[]{"outpatient-service:pay:order:Refund" + parameter.getPayOrderNo()});
        return payRefundVoResponseData;
    }

    private ResponseData<List<OutOrder>> checkOrderList(List<OutOrder> outOrderList) {
        List<String> orderTypeList = Arrays.asList(OrderTypeEnum.PRESCRIPTION_WESTERN_MEDICINE_ORDERS.getValue(), OrderTypeEnum.REGISTERED_CHINESE_PATENT_DRUG_ORDERS.getValue(), OrderTypeEnum.REGISTERED_TRADITIONAL_ORDERS.getValue());
        List orderList = outOrderList.stream().filter(x -> orderTypeList.contains(x.getOrderType())).collect(Collectors.toList());
        return ResponseData.success(orderList);
    }

    public ResponseData<String> paymentCallback(PayNotifyReqVO parameter) {
        if (!parameter.getResultCode().equals("SUCCESS")) {
            return ResponseData.error((String)"\u652f\u4ed8\u5931\u8d25\uff01");
        }
        QueryWrapper outOrderPaymentRecordQueryWrapper = new QueryWrapper();
        outOrderPaymentRecordQueryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
        outOrderPaymentRecordQueryWrapper.eq((Object)"operation_type", (Object)OperationTypeEnum.PAYMENT.getValue());
        outOrderPaymentRecordQueryWrapper.eq((Object)"transaction_number", (Object)parameter.getOutTradeNo());
        List outOrderPaymentRecords = this.outOrderPaymentRecordMapper.selectList((Wrapper)outOrderPaymentRecordQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)outOrderPaymentRecords)) {
            return ResponseData.error((String)"\u627e\u4e0d\u5230\u652f\u4ed8\u8bb0\u5f55\uff01");
        }
        OutOrderPaymentRecord outOrderPaymentRecord = (OutOrderPaymentRecord)outOrderPaymentRecords.get(0);
        if (!PaymentStatusEnum.PAYMENT_CONFIRMED.getValue().equals(outOrderPaymentRecord.getPaymentStatus()) && !PaymentStatusEnum.PAYMENT_REQUIRE_CUSTOMER_PASSWORD.getValue().equals(outOrderPaymentRecord.getPaymentStatus())) {
            return ResponseData.error((String)"\u8bb0\u5f55\u5df2\u5904\u7406\uff01");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"pay_order_no", (Object)outOrderPaymentRecord.getPayOrderNo());
        OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)queryWrapper);
        if (ObjectUtils.isEmpty((Object)outOrderPayment)) {
            return ResponseData.error((String)"\u4e0d\u5b58\u5728\u8be5\u652f\u4ed8\u8ba2\u5355\uff01");
        }
        List orderList = outOrderPaymentRecords.stream().map(OutOrderPaymentRecord::getOrderNo).collect(Collectors.toList());
        QueryWrapper queryrOrder = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryrOrder.in((Object)"order_no", orderList)).eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"payment_status", (Object)outOrderPayment.getPaymentStatus());
        List outOrderList = this.outOrderMapper.selectList((Wrapper)queryrOrder);
        if (CollectionUtils.isEmpty((Collection)outOrderList) || outOrderList.size() != outOrderPaymentRecords.size()) {
            return ResponseData.error((String)"\u652f\u4ed8\u8bb0\u5f55\u6570\u91cf\u4e0e\u8ba2\u5355\u6570\u91cf\u4e0d\u7b26\uff01");
        }
        PayService paymentService = PayFactory.getPaymentService((Integer)outOrderPayment.getPaymentMethod());
        if (paymentService == null) {
            return ResponseData.error((String)"\u5f53\u524d\u652f\u4ed8\u65b9\u5f0f\u6682\u4e0d\u53ef\u7528\uff01");
        }
        return paymentService.paymentCallback(parameter, outOrderList, outOrderPaymentRecords, outOrderPayment);
    }

    public ResponseData<String> refundCallback(RefundCallBackReqVo parameter) {
        if (!parameter.getReturnCode().equals("SUCCESS")) {
            return ResponseData.error((String)"\u9000\u6b3e\u5931\u8d25\uff01");
        }
        QueryWrapper outOrderPaymentRecordQueryWrapper = new QueryWrapper();
        outOrderPaymentRecordQueryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
        outOrderPaymentRecordQueryWrapper.eq((Object)"operation_type", (Object)OperationTypeEnum.PAYMENT_REFUND.getValue());
        outOrderPaymentRecordQueryWrapper.eq((Object)"transaction_number", (Object)parameter.getOutRefundNo());
        List outOrderPaymentRecords = this.outOrderPaymentRecordMapper.selectList((Wrapper)outOrderPaymentRecordQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)outOrderPaymentRecords)) {
            return ResponseData.error((String)"\u627e\u4e0d\u5230\u652f\u4ed8\u8bb0\u5f55\uff01");
        }
        OutOrderPaymentRecord outOrderPaymentRecord = (OutOrderPaymentRecord)outOrderPaymentRecords.get(0);
        if (!PaymentStatusEnum.PAYMENT_REFUND_CONFIRMED.getValue().equals(outOrderPaymentRecord.getPaymentStatus())) {
            return ResponseData.error((String)"\u8bb0\u5f55\u5df2\u5904\u7406\uff01");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"pay_order_no", (Object)outOrderPaymentRecord.getPayOrderNo());
        OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)queryWrapper);
        if (ObjectUtils.isEmpty((Object)outOrderPayment)) {
            return ResponseData.error((String)"\u4e0d\u5b58\u5728\u8be5\u652f\u4ed8\u8ba2\u5355\uff01");
        }
        List orderList = outOrderPaymentRecords.stream().map(OutOrderPaymentRecord::getOrderNo).collect(Collectors.toList());
        QueryWrapper queryrOrder = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryrOrder.in((Object)"order_no", orderList)).eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"payment_status", (Object)PaymentStatusEnum.PAYMENT_REFUND_CONFIRMED.getValue());
        List outOrderList = this.outOrderMapper.selectList((Wrapper)queryrOrder);
        if (CollectionUtils.isEmpty((Collection)outOrderList) || outOrderList.size() != outOrderPaymentRecords.size()) {
            return ResponseData.error((String)"\u9000\u6b3e\u8bb0\u5f55\u6570\u91cf\u4e0e\u8ba2\u5355\u6570\u91cf\u4e0d\u7b26\uff01");
        }
        PayService paymentService = PayFactory.getPaymentService((Integer)outOrderPayment.getPaymentMethod());
        if (paymentService == null) {
            return ResponseData.error((String)"\u5f53\u524d\u652f\u4ed8\u65b9\u5f0f\u6682\u4e0d\u53ef\u7528\uff01");
        }
        return paymentService.refundCallback(parameter, outOrderList, outOrderPaymentRecords, outOrderPayment);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<?> hsPreparePayment(HsPreparePayDto hsPreparePayDto) {
        if ("14".equals(hsPreparePayDto.getMedType()) && StrUtil.isBlank((CharSequence)hsPreparePayDto.getDiseCodg())) {
            return ResponseData.error((String)"\u9884\u7ed3\u7b97\u5931\u8d25\uff0c\u6162\u75c5\u7ed3\u7b97\u5907\u6848\u75c5\u79cd\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        QueryWrapper queryWrapperOrder = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapperOrder.in((Object)"order_no", (Collection)hsPreparePayDto.getOrderNoList())).eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"payment_status", (Object)PaymentStatusEnum.PAYMENT_PENDING.getValue());
        List outOrderList = this.outOrderMapper.selectList((Wrapper)queryWrapperOrder);
        List uniqueRemarks = outOrderList.stream().filter(item -> !OrderTypeEnum.REGISTERED_ORDINARY_ORDERS.getValue().equals(item.getOrderType())).filter(item -> !OrderSettleTypeEnum.HS_SELF.getCode().equals(item.getSettleTypeCode())).map(OutOrder::getSettleTypeName).distinct().collect(Collectors.toList());
        if (uniqueRemarks.size() > 1) {
            String aa = String.join((CharSequence)"\u3001", uniqueRemarks);
            return ResponseData.error((String)("\u9884\u7ed3\u7b97\u5931\u8d25\uff1a\u5f53\u524d\u8ba2\u5355\u5b58\u5728\u591a\u79cd\u652f\u4ed8\u65b9\u5f0f:" + aa + "\u4e0d\u53ef\u4e00\u8d77\u7ed3\u7b97\uff01"));
        }
        boolean hasCashSelfOrder = outOrderList.stream().anyMatch(item -> OrderSettleTypeEnum.CASH_SELF.getCode().equals(item.getSettleTypeCode()));
        if (hasCashSelfOrder) {
            return ResponseData.error((String)"\u9884\u7ed3\u7b97\u5931\u8d25\uff1a\u5f53\u524d\u8ba2\u5355\u5b58\u5728\u9700\u8981\u73b0\u91d1\u81ea\u8d39\u7684\u6536\u8d39\u9879\u76ee\u4e0d\u53ef\u53c2\u4e0e\u533b\u4fdd\u7ed3\u7b97\uff01");
        }
        if ("14".equals(hsPreparePayDto.getMedType())) {
            List registrationFee = outOrderList.stream().filter(item -> OrderTypeEnum.REGISTERED_ORDINARY_ORDERS.getValue().equals(item.getOrderType())).map(OutOrder::getSettleTypeName).distinct().collect(Collectors.toList());
            if (!registrationFee.isEmpty()) {
                return ResponseData.error((String)"\u9884\u7ed3\u7b97\u5931\u8d25\uff1a\u6302\u53f7\u8d39\u53ea\u80fd\u8d70\u666e\u901a\u95e8\u8bca\uff0c\u4e0d\u53ef\u6162\u75c5\u7ed3\u7b97");
            }
            List hsSelf = outOrderList.stream().filter(item -> OrderSettleTypeEnum.HS_SELF.getCode().equals(item.getSettleTypeCode())).map(OutOrder::getSettleTypeName).distinct().collect(Collectors.toList());
            if (!hsSelf.isEmpty()) {
                return ResponseData.error((String)"\u9884\u7ed3\u7b97\u5931\u8d25\uff1a\u5f53\u524d\u8ba2\u5355\u5b58\u5728\u533b\u4fdd\u81ea\u8d39\u7684\u6536\u8d39\u9879\u76ee\uff0c\u533b\u4fdd\u81ea\u8d39\u53ea\u80fd\u8d70\u666e\u901a\u95e8\u8bca\uff0c\u4e0d\u53ef\u6162\u75c5\u7ed3\u7b97");
            }
        }
        BigDecimal amount = outOrderList.stream().map(OutOrder::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalAmount = outOrderList.stream().map(OutOrder::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        FeeBillCreationDto feeBillCreationDto = new FeeBillCreationDto();
        feeBillCreationDto.setOrderNoList(hsPreparePayDto.getOrderNoList());
        feeBillCreationDto.setOperatorId(new Integer(hsPreparePayDto.getOpter()));
        feeBillCreationDto.setOperatorName(hsPreparePayDto.getOpter_name());
        feeBillCreationDto.setTenantId(hsPreparePayDto.getTenantId());
        feeBillCreationDto.setTotalAmount(totalAmount);
        feeBillCreationDto.setAmount(amount);
        feeBillCreationDto.setOutpatientNo(hsPreparePayDto.getOutpatientNo());
        feeBillCreationDto.setPayOrderName(hsPreparePayDto.getPayOrderName());
        if (!Objects.isNull(hsPreparePayDto.getInsuplcAdmdvs()) && "369900".equals(hsPreparePayDto.getInsuplcAdmdvs())) {
            feeBillCreationDto.setSettlementMethod(SettlementMethodEnum.STATUS_MEDICARE_STTLE_PRVN.getValue());
        } else if (!Objects.isNull(hsPreparePayDto.getInsuplcAdmdvs()) && hsPreparePayDto.getInsuplcAdmdvs().startsWith("36") && !hsPreparePayDto.getInsuplcAdmdvs().startsWith("3601")) {
            feeBillCreationDto.setSettlementMethod(SettlementMethodEnum.STATUS_MEDICARE_STTLE_PRVN_OTHER.getValue());
        } else if (!Objects.isNull(hsPreparePayDto.getInsuplcAdmdvs()) && !hsPreparePayDto.getInsuplcAdmdvs().startsWith("36")) {
            feeBillCreationDto.setSettlementMethod(SettlementMethodEnum.STATUS_MEDICARE_STTLE_OUT_PRVN_OTHER.getValue());
        } else {
            feeBillCreationDto.setSettlementMethod(SettlementMethodEnum.STATUS_MEDICARE_STTLE.getValue());
        }
        feeBillCreationDto.setOperatorSource(hsPreparePayDto.getOperatorSource());
        ResponseData orderCharge = this.orderCharge(feeBillCreationDto);
        if (Objects.isNull(orderCharge) || orderCharge.isError()) {
            return orderCharge;
        }
        hsPreparePayDto.setPayOrderNo(((FeeBillCreationVo)orderCharge.getData()).getPayOrderNo());
        RegPayInfoRequest regPayInfoRequest = new RegPayInfoRequest();
        BeanUtils.copyProperties((Object)hsPreparePayDto, (Object)regPayInfoRequest);
        RegistrationRequest registrationRequest = new RegistrationRequest();
        registrationRequest.setCard_sn(hsPreparePayDto.getCardSn());
        registrationRequest.setCertno(hsPreparePayDto.getCardNo());
        registrationRequest.setPsn_cert_type(hsPreparePayDto.getPsnCertType());
        registrationRequest.setMdtrt_cert_no(hsPreparePayDto.getMdtrtCertNo());
        registrationRequest.setMdtrt_cert_type(hsPreparePayDto.getMdtrtCertType());
        registrationRequest.setIpt_otp_no(hsPreparePayDto.getOutpatientNo());
        AdmissionEntity admission = this.admissionMapper.queryAdmissionByOutpatientNo(hsPreparePayDto.getOutpatientNo(), hsPreparePayDto.getTenantId());
        if (!hsPreparePayDto.getCardNo().equalsIgnoreCase(admission.getPatientCardNo()) || !hsPreparePayDto.getPatientName().equals(admission.getPatientName())) {
            return ResponseData.error((String)"\u9884\u7ed3\u7b97\u5931\u8d25\uff0c\u53c2\u4fdd\u4eba\u4fe1\u606f\u4e0e\u8ba2\u5355\u4fe1\u606f\u4e0d\u7b26\u5408\uff01");
        }
        admission.setMedicalType(String.valueOf(feeBillCreationDto.getSettlementMethod()));
        admission.setMedicalOutpatientType(hsPreparePayDto.getMedType());
        admission.setInsuplcAdmdvs(hsPreparePayDto.getInsuplcAdmdvs());
        this.admissionMapper.updateById((Object)admission);
        SysDoctorDto sysDoctorDto = new SysDoctorDto();
        sysDoctorDto.setId(admission.getDoctorId());
        ResponseData newSysDoctorIdVoResponseData = this.sysServiceFeign.newDoctorById(sysDoctorDto);
        if (Objects.isNull(newSysDoctorIdVoResponseData) || !newSysDoctorIdVoResponseData.isSuccess()) {
            return ResponseData.error((String)"\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u5931\u8d25");
        }
        ResponseData sysDoctorIdVoResponseData = this.sysServiceFeign.doctorById(sysDoctorDto);
        if (Objects.isNull(sysDoctorIdVoResponseData) || !sysDoctorIdVoResponseData.isSuccess()) {
            return ResponseData.error((String)("\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u5931\u8d25" + JSONObject.toJSONString((Object)sysDoctorIdVoResponseData)));
        }
        SysDoctorIdVo sysDoctorIdVo = (SysDoctorIdVo)sysDoctorIdVoResponseData.getData();
        if (Objects.isNull(sysDoctorIdVo.getHsCode()) || "".equals(sysDoctorIdVo.getHsCode())) {
            return ResponseData.error((String)"\u67e5\u8be2\u533b\u751f\u8d2f\u6807\u7801\u5931\u8d25\uff0c\u8bf7\u5b8c\u5584\u533b\u751f\u4fe1\u606f\uff01");
        }
        registrationRequest.setDept_code(sysDoctorIdVo.getDepartmentId());
        registrationRequest.setDept_name(sysDoctorIdVo.getDepartmentName());
        registrationRequest.setAtddr_no(sysDoctorIdVo.getHsCode());
        registrationRequest.setDr_name(sysDoctorIdVo.getUserName());
        registrationRequest.setPsn_name(hsPreparePayDto.getPatientName());
        registrationRequest.setPsn_no(hsPreparePayDto.getPsnNo());
        registrationRequest.setPsn_type(hsPreparePayDto.getPsnType());
        registrationRequest.setInsutype(hsPreparePayDto.getInsutype());
        registrationRequest.setInsuplc_admdvs(hsPreparePayDto.getInsuplcAdmdvs());
        registrationRequest.setBegntime(DateUtils.dateToFullString((Date)admission.getCreateTime()));
        MdtrtinfoRequest mdtrtinfo = new MdtrtinfoRequest();
        mdtrtinfo.setDise_codg(hsPreparePayDto.getDiseCodg());
        mdtrtinfo.setDise_name(hsPreparePayDto.getDiseName());
        mdtrtinfo.setPsn_no(hsPreparePayDto.getPsnNo());
        mdtrtinfo.setMed_type(hsPreparePayDto.getMedType());
        ArrayList<DiseinfoRequest> diseinfo = new ArrayList<DiseinfoRequest>();
        BigDecimal minpacuntDrugTracCnt = BigDecimal.ZERO;
        ArrayList<UploadInfoDetailRequest> uploadInfoDetailRequestList = new ArrayList<UploadInfoDetailRequest>();
        List orderNos = hsPreparePayDto.getOrderNoList();
        for (String orderNo : orderNos) {
            String feedetl_sn;
            UploadInfoDetailRequest uploadInfoDetailRequest;
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
            query.eq((Object)"order_no", (Object)orderNo);
            OutOrder outOrder = (OutOrder)this.outOrderMapper.selectOne((Wrapper)query);
            if (OrderTypeEnum.REGISTERED_ORDINARY_ORDERS.getValue().equals(outOrder.getOrderType())) {
                DiseinfoRequest diseinfoRequest = new DiseinfoRequest();
                diseinfoRequest.setDiag_srt_no("1");
                diseinfoRequest.setDiag_type("1");
                diseinfoRequest.setDiag_code("Z00.001");
                diseinfoRequest.setDiag_name("\u5065\u5eb7\u67e5\u4f53");
                diseinfoRequest.setDiag_dept(sysDoctorIdVo.getDepartmentName());
                diseinfoRequest.setDise_dor_name(sysDoctorIdVo.getUserName());
                diseinfoRequest.setDiag_time(DateUtils.dateFormat((Date)admission.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                diseinfoRequest.setVali_flag("1");
                diseinfoRequest.setDise_dor_no(sysDoctorIdVo.getHsCode());
                diseinfo.add(diseinfoRequest);
                UploadInfoDetailRequest uploadInfoDetailRequest2 = new UploadInfoDetailRequest();
                uploadInfoDetailRequest2.setChrg_bchno(hsPreparePayDto.getPayOrderNo());
                uploadInfoDetailRequest2.setFeedetl_sn(hsPreparePayDto.getPayOrderNo() + "_0");
                uploadInfoDetailRequest2.setPsn_no(hsPreparePayDto.getPsnNo());
                uploadInfoDetailRequest2.setRx_circ_flag("0");
                uploadInfoDetailRequest2.setDise_codg("Z00.001");
                uploadInfoDetailRequest2.setAcord_dept_codg(sysDoctorIdVo.getDepartmentId());
                uploadInfoDetailRequest2.setFee_ocur_time(DateUtils.getCurrentDate((String)"yyyy-MM-dd HH:mm:ss"));
                OutpatientTypeEntity outpatientTypeEntity = this.outpatientTypeMapper.queryOutpatientTypeByType(admission.getOutpatientType(), admission.getTenantId());
                uploadInfoDetailRequest2.setDet_item_fee_sumamt(outpatientTypeEntity.getRegFee().toString());
                uploadInfoDetailRequest2.setCnt("1");
                uploadInfoDetailRequest2.setPric(outpatientTypeEntity.getRegFee().toString());
                uploadInfoDetailRequest2.setBilg_dept_codg(sysDoctorIdVo.getDepartmentId());
                uploadInfoDetailRequest2.setBilg_dept_name(sysDoctorIdVo.getDepartmentName());
                uploadInfoDetailRequest2.setBilg_dr_codg(sysDoctorIdVo.getHsCode());
                uploadInfoDetailRequest2.setBilg_dr_name(sysDoctorIdVo.getUserName());
                uploadInfoDetailRequest2.setMed_list_codg(outpatientTypeEntity.getRegItemHsCode());
                uploadInfoDetailRequest2.setMedins_list_codg(outpatientTypeEntity.getOutpatientType());
                uploadInfoDetailRequest2.setHosp_appr_flag("0");
                uploadInfoDetailRequest2.setPrd_days("1");
                uploadInfoDetailRequestList.add(uploadInfoDetailRequest2);
                continue;
            }
            if (OrderTypeEnum.PRESCRIPTION_WESTERN_MEDICINE_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_TRADITIONAL_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_CHINESE_PATENT_DRUG_ORDERS.getValue().equals(outOrder.getOrderType())) {
                QueryWrapper queryDrugWrapper = new QueryWrapper();
                queryDrugWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
                queryDrugWrapper.eq((Object)"prescription_no", (Object)outOrder.getPrescriptionNo());
                List outPrescriptionDrugs = this.outPrescriptionDrugMapper.selectList((Wrapper)queryDrugWrapper);
                for (int i = 0; i < outPrescriptionDrugs.size(); ++i) {
                    OutPrescriptionDrug drug = (OutPrescriptionDrug)outPrescriptionDrugs.get(i);
                    uploadInfoDetailRequest = new UploadInfoDetailRequest();
                    uploadInfoDetailRequest.setChrg_bchno(hsPreparePayDto.getPayOrderNo());
                    feedetl_sn = hsPreparePayDto.getPayOrderNo() + "_" + RandomCodeUtils.sixRandom();
                    uploadInfoDetailRequest.setFeedetl_sn(feedetl_sn);
                    uploadInfoDetailRequest.setPsn_no(hsPreparePayDto.getPsnNo());
                    uploadInfoDetailRequest.setDise_codg(hsPreparePayDto.getDiseCodg());
                    uploadInfoDetailRequest.setRxno(drug.getPrescriptionNo());
                    uploadInfoDetailRequest.setRx_circ_flag("0");
                    uploadInfoDetailRequest.setFee_ocur_time(DateUtils.getCurrentDate((String)"yyyy-MM-dd HH:mm:ss"));
                    uploadInfoDetailRequest.setMed_list_codg(drug.getMedicalInsuranceCode());
                    uploadInfoDetailRequest.setMedins_list_codg(Objects.isNull(drug.getInternalCode()) ? drug.getDrugNo() : drug.getInternalCode());
                    uploadInfoDetailRequest.setDet_item_fee_sumamt(drug.getTotalDrugAmount().toString());
                    uploadInfoDetailRequest.setCnt(String.valueOf(drug.getQuantity()));
                    uploadInfoDetailRequest.setPric(String.valueOf(drug.getDrugPriceAmount()));
                    SysDrugEntity sysDrugEntity = new SysDrugEntity();
                    sysDrugEntity.setId(drug.getDrugNo());
                    ResponseData newSysDrugEntityResponseData = this.sysServiceFeign.newDrugIdDetails(sysDrugEntity, hsPreparePayDto.getTenantId());
                    if (Objects.isNull(newSysDrugEntityResponseData) || newSysDrugEntityResponseData.isError()) {
                        return ResponseData.error((String)("\u5f53\u524d\uff1a" + drug.getDrugName() + " \u836f\u54c1\u672a\u542f\u7528"));
                    }
                    ResponseData sysDrugEntityResponseData = this.sysServiceFeign.drugIdDetails(sysDrugEntity, hsPreparePayDto.getTenantId());
                    if (!Objects.isNull(sysDrugEntityResponseData) && sysDrugEntityResponseData.isSuccess()) {
                        SysDrugEntity result = (SysDrugEntity)sysDrugEntityResponseData.getData();
                        BigDecimal packSpecification = new BigDecimal(result.getPackSpecification());
                        uploadInfoDetailRequest.setCnt(String.valueOf(packSpecification.multiply(drug.getQuantity())));
                        uploadInfoDetailRequest.setMed_list_codg(result.getMedicalInsuranceCode());
                        uploadInfoDetailRequest.setPric(String.valueOf(drug.getDrugPriceAmount().divide(packSpecification, 6)));
                    }
                    uploadInfoDetailRequest.setPrd_days(String.valueOf(drug.getMedicationDays()));
                    uploadInfoDetailRequest.setBilg_dept_name(sysDoctorIdVo.getDepartmentName());
                    uploadInfoDetailRequest.setBilg_dept_codg(sysDoctorIdVo.getDepartmentId());
                    uploadInfoDetailRequest.setBilg_dr_name(sysDoctorIdVo.getHsCode());
                    uploadInfoDetailRequest.setBilg_dr_name(sysDoctorIdVo.getUserName());
                    uploadInfoDetailRequest.setBilg_dept_codg(sysDoctorIdVo.getDepartmentId());
                    uploadInfoDetailRequest.setBilg_dept_name(sysDoctorIdVo.getDepartmentName());
                    uploadInfoDetailRequest.setBilg_dr_codg(sysDoctorIdVo.getHsCode());
                    String insuranceAuditFlag = OrderSettleTypeEnum.HS_SELF.getCode().equals(outOrder.getSettleTypeCode()) ? "2" : drug.getMedicalInsuranceAuditFlag();
                    uploadInfoDetailRequest.setHosp_appr_flag(insuranceAuditFlag);
                    minpacuntDrugTracCnt = minpacuntDrugTracCnt.add(new BigDecimal(uploadInfoDetailRequest.getCnt()));
                    uploadInfoDetailRequestList.add(uploadInfoDetailRequest);
                }
                continue;
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"out_treatment_id", (Object)outOrder.getPrescriptionNo());
            List outTreatmentDetailsList = this.outTreatmentDetailsMapper.selectList((Wrapper)queryWrapper);
            for (int i = 0; i < outTreatmentDetailsList.size(); ++i) {
                OutTreatmentDetails outTreatmentDetails = (OutTreatmentDetails)outTreatmentDetailsList.get(i);
                uploadInfoDetailRequest = new UploadInfoDetailRequest();
                uploadInfoDetailRequest.setChrg_bchno(hsPreparePayDto.getPayOrderNo());
                feedetl_sn = hsPreparePayDto.getPayOrderNo() + "_" + RandomCodeUtils.sixRandom();
                uploadInfoDetailRequest.setFeedetl_sn(feedetl_sn);
                uploadInfoDetailRequest.setPsn_no(hsPreparePayDto.getPsnNo());
                uploadInfoDetailRequest.setDise_codg(hsPreparePayDto.getDiseCodg());
                uploadInfoDetailRequest.setRxno(outTreatmentDetails.getOutTreatmentId().toString());
                uploadInfoDetailRequest.setRx_circ_flag("0");
                uploadInfoDetailRequest.setFee_ocur_time(DateUtils.getCurrentDate((String)"yyyy-MM-dd HH:mm:ss"));
                uploadInfoDetailRequest.setMed_list_codg(outTreatmentDetails.getMedicalInsuranceCode());
                uploadInfoDetailRequest.setMedins_list_codg(Objects.isNull(outTreatmentDetails.getTreatmentCode()) ? String.valueOf(outTreatmentDetails.getOutTreatmentId()) : outTreatmentDetails.getTreatmentCode());
                uploadInfoDetailRequest.setDet_item_fee_sumamt(outTreatmentDetails.getTotalAmount().toString());
                uploadInfoDetailRequest.setCnt(outTreatmentDetails.getQuantity().toString());
                uploadInfoDetailRequest.setPric(outTreatmentDetails.getUnitPriceAmount().toString());
                uploadInfoDetailRequest.setPrd_days("1");
                uploadInfoDetailRequest.setBilg_dept_name(sysDoctorIdVo.getDepartmentName());
                uploadInfoDetailRequest.setBilg_dept_codg(sysDoctorIdVo.getDepartmentId());
                uploadInfoDetailRequest.setBilg_dr_name(sysDoctorIdVo.getHsCode());
                uploadInfoDetailRequest.setBilg_dr_name(sysDoctorIdVo.getUserName());
                uploadInfoDetailRequest.setBilg_dept_codg(sysDoctorIdVo.getDepartmentId());
                uploadInfoDetailRequest.setBilg_dept_name(sysDoctorIdVo.getDepartmentName());
                uploadInfoDetailRequest.setBilg_dr_codg(sysDoctorIdVo.getHsCode());
                String insuranceAuditFlag = OrderSettleTypeEnum.HS_SELF.getCode().equals(outOrder.getSettleTypeCode()) ? "2" : "1";
                uploadInfoDetailRequest.setHosp_appr_flag(insuranceAuditFlag);
                uploadInfoDetailRequestList.add(uploadInfoDetailRequest);
            }
        }
        List outMedicalRecordDiagnoses = this.outMedicalRecordDiagnosisService.queryMedicalRecordDiagnosisByOutpatientNo(hsPreparePayDto.getTenantId(), hsPreparePayDto.getOutpatientNo());
        for (int i = 0; i < outMedicalRecordDiagnoses.size(); ++i) {
            OutMedicalRecordDiagnosis outMedicalRecordDiagnosis = (OutMedicalRecordDiagnosis)outMedicalRecordDiagnoses.get(i);
            DiseinfoRequest diseinfoRequest = new DiseinfoRequest();
            diseinfoRequest.setDiag_srt_no(i + 2 + "");
            diseinfoRequest.setDiag_type("2".equals(outMedicalRecordDiagnosis.getDiagnosticType()) ? "3" : "1");
            if (Objects.isNull(outMedicalRecordDiagnosis.getHsIcdCode())) {
                QueryWrapper query = new QueryWrapper();
                query.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
                query.eq((Object)"icd_code", (Object)outMedicalRecordDiagnosis.getIcdCode());
                OutIcdItem outIcdItem = (OutIcdItem)this.outIcdItemMapper.selectOne((Wrapper)query);
                diseinfoRequest.setDiag_code(outIcdItem.getMedicalCode());
                diseinfoRequest.setDiag_name(outIcdItem.getMedicalName());
            } else {
                diseinfoRequest.setDiag_code(outMedicalRecordDiagnosis.getHsIcdCode());
                diseinfoRequest.setDiag_name(outMedicalRecordDiagnosis.getHsDiagnosis());
            }
            diseinfoRequest.setDiag_dept(sysDoctorIdVo.getDepartmentName());
            diseinfoRequest.setDise_dor_name(sysDoctorIdVo.getUserName());
            diseinfoRequest.setDiag_time(DateUtils.dateFormat((Date)admission.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            diseinfoRequest.setVali_flag("1");
            diseinfoRequest.setDise_dor_no(sysDoctorIdVo.getHsCode());
            diseinfo.add(diseinfoRequest);
        }
        regPayInfoRequest.setInsutype(hsPreparePayDto.getInsutype());
        regPayInfoRequest.setCard_sn(hsPreparePayDto.getCardSn());
        regPayInfoRequest.setPsn_setlway(Objects.isNull(hsPreparePayDto.getPsnSetlway()) ? "01" : hsPreparePayDto.getPsnSetlway());
        regPayInfoRequest.setAcct_used_flag(Objects.isNull(hsPreparePayDto.getAcctUsedFlag()) ? "1" : hsPreparePayDto.getAcctUsedFlag());
        regPayInfoRequest.setInsuplc_admdvs(hsPreparePayDto.getInsuplcAdmdvs());
        regPayInfoRequest.setRegistrationRequest(registrationRequest);
        regPayInfoRequest.setMdtrtinfo(mdtrtinfo);
        regPayInfoRequest.setUploadInfoDetailRequest(uploadInfoDetailRequestList);
        regPayInfoRequest.setDiseinfo(diseinfo);
        log.info("\u533b\u4fdd\u9884\u7ed3\u7b97\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)regPayInfoRequest));
        ResponseData responseData = this.hsServiceFeign.preparePayment(regPayInfoRequest);
        if (Objects.isNull(responseData) || responseData.isError()) {
            return responseData;
        }
        log.info("\u533b\u4fdd\u9884\u7ed3\u7b97\u51fa\u53c2{}", (Object)JSONObject.toJSONString((Object)responseData));
        PaymentResponse paymentResponse = (PaymentResponse)responseData.getData();
        paymentResponse.setPayOrderNo(hsPreparePayDto.getPayOrderNo());
        paymentResponse.setMdtrtCertNo(hsPreparePayDto.getMdtrtCertNo());
        paymentResponse.setInsuplcAdmdvs(hsPreparePayDto.getInsuplcAdmdvs());
        paymentResponse.setAcct_used_flag(regPayInfoRequest.getAcct_used_flag());
        paymentResponse.setPsn_setlway(regPayInfoRequest.getPsn_setlway());
        paymentResponse.setDiseCodg(hsPreparePayDto.getDiseCodg());
        paymentResponse.setDiseName(hsPreparePayDto.getDiseName());
        paymentResponse.setOperatorSource(hsPreparePayDto.getOperatorSource());
        paymentResponse.setPatientId(admission.getPatientId());
        paymentResponse.setMinpacuntDrugTracCnt(String.valueOf(minpacuntDrugTracCnt));
        this.redisUtil.set(hsPreparePayDto.getPayOrderNo(), (Object)JSONObject.toJSONString((Object)paymentResponse), 86400L);
        return responseData;
    }

    private void cancelHsPrePay(OutOrderPayment outOrderPayment) {
        RefundRequest refundRequest = new RefundRequest();
        refundRequest.setChrg_bchno(outOrderPayment.getPayOrderNo());
        refundRequest.setIpt_otp_no(outOrderPayment.getOutpatientNo());
        refundRequest.setPsn_no(outOrderPayment.getPsnNo());
        refundRequest.setMdtrt_id(outOrderPayment.getMdtrtId());
        refundRequest.setSetl_id(outOrderPayment.getSetlId());
        refundRequest.setOpter(String.valueOf(outOrderPayment.getCheckerId()));
        refundRequest.setOpter_name(outOrderPayment.getCheckerName());
        refundRequest.setOpter_type(this.nodeConfig.getOpterType());
        refundRequest.setSign_no("99999");
        refundRequest.setTenantId(outOrderPayment.getTenantId());
        refundRequest.setInsuplc_admdvs("");
        log.info("\u533b\u4fdd\u9884\u7ed3\u7b97\u64a4\u9500\u5165\u53c2+++{}", (Object)JSONObject.toJSONString((Object)refundRequest));
        ResponseData responseData = this.hsServiceFeign.cancelPreparePayment(refundRequest);
        log.info("\u533b\u4fdd\u9884\u7ed3\u7b97\u64a4\u9500\u51fa\u53c2---{}", (Object)JSONObject.toJSONString((Object)responseData));
    }

    public ResponseData<String> hsPayment(HsPayDto hsPayDto) {
        Object o = this.redisUtil.get(hsPayDto.getPayOrderNo());
        if (Objects.isNull(o)) {
            return ResponseData.error((String)"\u672a\u67e5\u5230\u9884\u7ed3\u7b97\u4fe1\u606f\uff01");
        }
        PaymentResponse paymentResponse = (PaymentResponse)JSONObject.parseObject((String)o.toString(), PaymentResponse.class);
        if (SourceEnum.ONLINE.getValue().equals(paymentResponse.getOperatorSource()) && !SourceEnum.ONLINE.getValue().equals(hsPayDto.getOperatorSource())) {
            return ResponseData.error((String)"\u62b1\u6b49\uff0c\u7ebf\u4e0a\u8ba2\u5355\u6682\u65f6\u65e0\u6cd5\u5728\u7ebf\u4e0b\u64cd\u4f5c\uff01");
        }
        OutpatientsettlementRequest outpatientsettlementRequest = this.generateOutpatientsettlment(paymentResponse, hsPayDto);
        outpatientsettlementRequest.setAcct_used_flag(Objects.isNull(paymentResponse.getAcct_used_flag()) ? "1" : paymentResponse.getAcct_used_flag());
        outpatientsettlementRequest.setPsn_setlway(Objects.isNull(paymentResponse.getPsn_setlway()) ? "01" : paymentResponse.getPsn_setlway());
        outpatientsettlementRequest.setMinpacunt_drug_trac_cnt(paymentResponse.getMinpacuntDrugTracCnt());
        ResponseData outpatientsettlement = this.hsServiceFeign.outpatientsettlement(outpatientsettlementRequest);
        log.info("\u7ed3\u7b97\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)outpatientsettlement));
        if (Objects.isNull(outpatientsettlement) || outpatientsettlement.isError()) {
            return ResponseData.error((String)"\u7ed3\u7b97\u5931\u8d25{}", (String)outpatientsettlement.getMsg());
        }
        PaymentResponse paymentSettlement = (PaymentResponse)JSONObject.parseObject((String)JSONObject.toJSONString((Object)outpatientsettlement.getData()), PaymentResponse.class);
        try {
            Setlinfo setlinfo2 = paymentSettlement.getSetlinfo();
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"pay_order_no", (Object)outpatientsettlementRequest.getChrg_bchno());
            OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)queryWrapper);
            outOrderPayment.setActualPayment(setlinfo2.getMedfee_sumamt());
            if (!Objects.isNull(outpatientsettlementRequest.getPaymentMethod()) && BigDecimal.ZERO.compareTo(outpatientsettlementRequest.getPsn_cash_pay()) < 0) {
                outOrderPayment.setPaymentMethod(outpatientsettlementRequest.getPaymentMethod());
                outOrderPayment.setPayChannel(PaymentMethodEnum.getEnum((Integer)outpatientsettlementRequest.getPaymentMethod()).getPayChannel());
            } else {
                outOrderPayment.setPaymentMethod(PaymentMethodEnum.PAY_MEDICAL_INSURANCE.getValue());
                outOrderPayment.setPayChannel(PaymentMethodEnum.PAY_MEDICAL_INSURANCE.getPayChannel());
            }
            outOrderPayment.setPaymentStatus(PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
            outOrderPayment.setPaymentType(PaymentTypeEnum.OFFLINE_PAYMENT.getValue());
            outOrderPayment.setHsPayInfo(JSONObject.toJSONString((Object)outpatientsettlement));
            outOrderPayment.setPsnNo(setlinfo2.getPsn_no());
            outOrderPayment.setMdtrtId(setlinfo2.getMdtrt_id());
            outOrderPayment.setSetlId(setlinfo2.getSetl_id());
            outOrderPayment.setPaymentTime(DateUtils.stringToFullDate((String)setlinfo2.getSetl_time()));
            outOrderPayment.setPayCost(setlinfo2.getAcct_pay());
            outOrderPayment.setPubCost(setlinfo2.getFund_pay_sumamt());
            outOrderPayment.setOwnCost(setlinfo2.getPsn_cash_pay());
            outOrderPayment.setPaymentTransactionNo(StrUtil.isBlank((CharSequence)hsPayDto.getPaymentTransactionNo()) ? setlinfo2.getSetl_id() : hsPayDto.getPaymentTransactionNo());
            outOrderPayment.setCheckerId(new Integer(hsPayDto.getOpter()));
            outOrderPayment.setCheckerName(hsPayDto.getOpter_name());
            outOrderPayment.setInsuplcAdmdvs(paymentResponse.getInsuplcAdmdvs());
            outOrderPayment.setInsutype(paymentResponse.getSetlinfo().getInsutype());
            this.outOrderPaymentMapper.updateById((Object)outOrderPayment);
            this.pushEtube(outOrderPayment);
            QueryWrapper queryOrderWrapper = new QueryWrapper();
            ((QueryWrapper)queryOrderWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"pay_order_no", (Object)outpatientsettlementRequest.getChrg_bchno());
            List outOrderList = this.outOrderMapper.selectList((Wrapper)queryOrderWrapper);
            ArrayList<OutOrderPaymentRecord> outOrderPaymentRecords = new ArrayList<OutOrderPaymentRecord>();
            for (OutOrder order : outOrderList) {
                List list;
                order.setPaymentStatus(PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
                order.setActualPayment(order.getTotalAmount());
                String transactionNo = UUIDUtils.getTransactionNo();
                int num = this.outOrderMapper.updateById((Object)order);
                if (num == 0) {
                    throw new RunDisplayException("\u53d8\u66f4\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
                }
                OutOrderPaymentRecord outOrderPaymentRecord = new OutOrderPaymentRecord();
                BeanUtils.copyProperties((Object)outOrderPayment, (Object)outOrderPaymentRecord);
                outOrderPaymentRecord.setId(null);
                outOrderPaymentRecord.setOrderNo(order.getOrderNo());
                outOrderPaymentRecord.setStatus(PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
                outOrderPaymentRecord.setAmount(order.getAmount());
                outOrderPaymentRecord.setTotalAmount(order.getAmount());
                outOrderPaymentRecord.setActualPayment(outOrderPaymentRecord.getTotalAmount());
                outOrderPaymentRecord.setPaymentStatus(PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
                outOrderPaymentRecord.setQuantity(Integer.valueOf(1));
                outOrderPaymentRecord.setOperationType(OperationTypeEnum.PAYMENT.getValue());
                outOrderPaymentRecord.setTransactionNumber(transactionNo);
                outOrderPaymentRecord.setCheckerName(hsPayDto.getOpter_name());
                outOrderPaymentRecord.setCheckerId(new Integer(hsPayDto.getOpter()));
                outOrderPaymentRecord.setCreateTime(null);
                this.outOrderPaymentRecordMapper.insert((Object)outOrderPaymentRecord);
                if (outOrderPaymentRecord.getId() == null && (list = this.outOrderPaymentRecordMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutOrderPaymentRecord::getTransactionNumber, (Object)transactionNo)).eq(OutOrderPaymentRecord::getPaymentStatus, (Object)outOrderPayment.getPaymentStatus())).eq(OutOrderPaymentRecord::getOrderNo, (Object)order.getOrderNo())).eq(OutOrderPaymentRecord::getAmount, (Object)order.getAmount())).eq(OutOrderPaymentRecord::getOperationType, (Object)OperationTypeEnum.PAYMENT.getValue()))).size() > 0) {
                    Integer id = ((OutOrderPaymentRecord)list.get(0)).getId();
                    outOrderPaymentRecord.setId(id);
                }
                outOrderPaymentRecords.add(outOrderPaymentRecord);
            }
            HsSettlementInfoEntity hsSettlementInfoEntity = new HsSettlementInfoEntity();
            BeanUtils.copyProperties((Object)paymentSettlement.getSetlinfo(), (Object)hsSettlementInfoEntity);
            hsSettlementInfoEntity.setSetldetail(JSONObject.toJSONString((Object)paymentSettlement.getSetldetail()));
            hsSettlementInfoEntity.setTenantId(hsPayDto.getTenantId());
            hsSettlementInfoEntity.setSettlmentStatus("1");
            hsSettlementInfoEntity.setInsuplc_admdvs(paymentResponse.getInsuplcAdmdvs());
            hsSettlementInfoEntity.setDise_codg(paymentResponse.getDiseCodg());
            hsSettlementInfoEntity.setDise_name(paymentResponse.getDiseName());
            log.info("\u63d2\u5165\u533b\u4fdd\u7ed3\u7b97\u4fe1\u606f\uff0c{}", (Object)JSONObject.toJSONString((Object)hsSettlementInfoEntity));
            this.outHsSettlementInfoMapper.insert((Object)hsSettlementInfoEntity);
            JSONArray jsonArray = JSONObject.parseArray((String)hsSettlementInfoEntity.getSetldetail());
            if (jsonArray != null && !jsonArray.isEmpty()) {
                ArrayList<OutHsSettlementInfoDetaiEntity> detailList = new ArrayList<OutHsSettlementInfoDetaiEntity>();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    OutHsSettlementInfoDetaiEntity detail = new OutHsSettlementInfoDetaiEntity();
                    detail.setTenantId(hsSettlementInfoEntity.getTenantId());
                    detail.setSetlId(hsSettlementInfoEntity.getSetl_id());
                    detail.setFundPayType(jsonObject.getString("fund_pay_type"));
                    if (!StrUtil.isBlank((CharSequence)detail.getFundPayType())) {
                        SysDictValueDTO sysDictValueDTO = new SysDictValueDTO();
                        sysDictValueDTO.setType("fund_pay_type");
                        sysDictValueDTO.setValue(detail.getFundPayType());
                        ResponseData pageResponseData = this.sysServiceFeign.sysDictValueById(sysDictValueDTO, hsSettlementInfoEntity.getTenantId() + "");
                        List data = ((Page)pageResponseData.getData()).getRecords();
                        detail.setFundPayTypeName(data == null || data.isEmpty() ? "" : ((SysDictValueVo)data.get(0)).getLabel());
                    }
                    detail.setFundPayamt(jsonObject.getBigDecimal("fund_payamt"));
                    detail.setInscpScpAmt(jsonObject.getBigDecimal("inscp_scp_amt"));
                    detail.setSetlProcInfo(jsonObject.getString("setl_proc_info"));
                    detailList.add(detail);
                }
                this.outHsSettlementInfoDetailMapper.insertList(detailList);
            }
            List strings = this.outOrderMapper.dispenseMedicineByOrder(outOrderList);
            for (String string : strings) {
                OutPrescriptionDto dto = new OutPrescriptionDto();
                dto.setPrescriptionNo(string);
                Integer tenant = this.commonRequest.getTenant();
                Integer userId = this.commonRequest.getUserId();
                String userName = this.commonRequest.getUserName();
                if (tenant == null) {
                    tenant = hsPayDto.getTenantId();
                }
                if (userId == null) {
                    userId = Integer.valueOf(hsPayDto.getOpter());
                }
                if (StringUtils.isBlank((CharSequence)userName)) {
                    userName = hsPayDto.getOpter_name();
                }
                dto.setTenantId(tenant);
                dto.setOperatorId(userId);
                dto.setOperatorName(userName);
                dto.setMethodType("\u3010outPayServiceImpl\u3011\uff1ahsPayment");
                this.outPrescriptionService.dispenseMedicine(dto);
            }
            try {
                List outOrderPayments;
                String payOrderNo;
                String source;
                outOrderPayment.setPaymentStatusStr(PaymentStatusEnum.getValueEnum((Integer)outOrderPayment.getPaymentStatus()).getDesc());
                outOrderPayment.setPaymentMethodName(PaymentMethodEnum.getValueEnum((Integer)outOrderPayment.getPaymentMethod()).getDesc());
                outOrderPayment.setSettlementMethodName(SettlementMethodEnum.getValueEnum((Integer)outOrderPayment.getSettlementMethod()).getDesc());
                switch (source = outOrderPayment.getSource() != null ? outOrderPayment.getSource() : "") {
                    case "1": {
                        outOrderPayment.setSource("\u7ebf\u4e0a");
                        break;
                    }
                    case "2": {
                        outOrderPayment.setSource("\u7ebf\u4e0b");
                    }
                }
                Integer status = outOrderPayment.getStatus();
                switch (status) {
                    case 0: {
                        outOrderPayment.setStatusName("\u5220\u9664");
                        break;
                    }
                    case 1: {
                        outOrderPayment.setStatusName("\u6b63\u5e38");
                        break;
                    }
                    case 2: {
                        outOrderPayment.setStatusName("\u5df2\u8fc7\u671f");
                        break;
                    }
                    case 3: {
                        outOrderPayment.setStatusName("\u5df2\u4f5c\u5e9f");
                    }
                }
                for (OutOrder outOrder : outOrderList) {
                    String source1;
                    switch (source1 = outOrder.getSource() != null ? outOrder.getSource() : "") {
                        case "1": {
                            outOrder.setSource("\u7ebf\u4e0a");
                            break;
                        }
                        case "2": {
                            outOrder.setSource("\u7ebf\u4e0b");
                        }
                    }
                    Integer status1 = outOrder.getStatus();
                    switch (status1) {
                        case 0: {
                            outOrder.setStatusName("\u5220\u9664");
                            break;
                        }
                        case 1: {
                            outOrder.setStatusName("\u6b63\u5e38");
                            break;
                        }
                        case 2: {
                            outOrder.setStatusName("\u5df2\u8fc7\u671f");
                            break;
                        }
                        case 3: {
                            outOrder.setStatusName("\u5df2\u4f5c\u5e9f");
                        }
                    }
                    outOrder.setPaymentStatusStr(PaymentStatusEnum.getValueEnum((Integer)outOrder.getPaymentStatus()).getDesc());
                    outOrder.setDeliveryStatusName(DeliveryStatusEnum.getValueEnum((Integer)(outOrder.getDeliveryStatus() != null ? outOrder.getDeliveryStatus() : 0)).getDesc());
                }
                for (OutOrderPaymentRecord record : outOrderPaymentRecords) {
                    Integer status1 = record.getStatus();
                    switch (status1) {
                        case 0: {
                            record.setStatusName("\u5220\u9664");
                            break;
                        }
                        case 1: {
                            record.setStatusName("\u6b63\u5e38");
                            break;
                        }
                        case 2: {
                            record.setStatusName("\u5df2\u8fc7\u671f");
                            break;
                        }
                        case 3: {
                            record.setStatusName("\u5df2\u4f5c\u5e9f");
                        }
                    }
                    record.setPaymentMethodName(PaymentMethodEnum.getValueEnum((Integer)record.getPaymentMethod()).getDesc());
                    record.setPaymentStatusName(PaymentStatusEnum.getValueEnum((Integer)record.getPaymentStatus()).getDesc());
                    if (record.getDeliveryStatus() != null) {
                        record.setDeliveryStatusName(DeliveryStatusEnum.getValueEnum((Integer)record.getDeliveryStatus()).getDesc());
                    }
                    if (record.getMedicalInsuranceType() != null) {
                        record.setMedicalInsuranceTypeName(MedicalInsuranceTypeEnum.getEnum((Integer)record.getMedicalInsuranceType()).getDesc());
                    }
                    record.setSettlementMethodName(SettlementMethodEnum.getValueEnum((Integer)record.getSettlementMethod()).getDesc());
                    Integer paymentType = record.getPaymentType();
                    switch (paymentType) {
                        case 1: {
                            record.setPaymentTypeName("\u5728\u7ebf\u652f\u4ed8");
                            break;
                        }
                        case 2: {
                            record.setPaymentTypeName("\u7ebf\u4e0b\u652f\u4ed8");
                        }
                    }
                    Integer operationType = record.getOperationType();
                    switch (operationType) {
                        case 1: {
                            record.setOperationTypeName("\u652f\u4ed8");
                            break;
                        }
                        case 2: {
                            record.setOperationTypeName("\u9000\u6b3e");
                        }
                    }
                }
                ArrayList<PatientEntity> patientList = new ArrayList<PatientEntity>();
                ArrayList<OutOrderPayment> orderPaymentList = new ArrayList<OutOrderPayment>();
                PatientEntity entity = new PatientEntity();
                if (outOrderPayment.getId() == null && StringUtils.isNotBlank((CharSequence)(payOrderNo = outOrderPayment.getPayOrderNo())) && (outOrderPayments = this.outOrderPaymentMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(OutOrderPayment::getPayOrderNo, (Object)payOrderNo))).size() > 0) {
                    outOrderPayment.setId(((OutOrderPayment)outOrderPayments.get(0)).getId());
                }
                entity.setMsg("OutPayServiceImpl.hsPayment-" + outOrderPayment.getId());
                entity.setId(outOrderPayment.getPatientId());
                outOrderPayment.setOrderList(outOrderList);
                outOrderPayment.setPaymentRecordList(outOrderPaymentRecords);
                orderPaymentList.add(outOrderPayment);
                entity.setPaymentList(orderPaymentList);
                patientList.add(entity);
                String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
                String msg = JSONObject.toJSONString(patientList);
                this.rocketMQProducer.asyncSendCallbackTimeoutLevel("rocketMQ-out-patientPaymentTopic", "TAG4", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            CompletableFuture.runAsync(() -> this.uploadHsFee(outOrderPayment, outOrderList));
            return ResponseData.success((Object)hsPayDto.getPayOrderNo());
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter stack = new StringWriter();
            e.printStackTrace(new PrintWriter(stack));
            log.info("\u7ed3\u7b97\u5931\u8d25\u652f\u4ed8\u5355\u53f7\u4e3a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)hsPayDto.getPayOrderNo(), StrUtil.isBlank((CharSequence)e.getMessage()) ? stack : e.getMessage());
            return ResponseData.error((String)"\u672c\u5730\u7ed3\u7b97\u5904\u7406\u5931\u8d25\uff01");
        }
    }

    private void FPrint(List<OutOrder> outOrderList) {
        SysEasyEntity sysEasyEntity = new SysEasyEntity();
        for (OutOrder outOrder : outOrderList) {
            String prescriptionNo;
            if (outOrder == null || !StringUtils.isNotBlank((CharSequence)(prescriptionNo = outOrder.getPrescriptionNo()))) continue;
            sysEasyEntity.setId(prescriptionNo);
            this.sdkServiceFeign.printerReceipt(sysEasyEntity);
        }
    }

    private OutpatientsettlementRequest generateOutpatientsettlment(PaymentResponse paymentResponse, HsPayDto hsPayDto) {
        Setlinfo preSetlinfo = paymentResponse.getSetlinfo();
        OutpatientsettlementRequest outpatientsettlementRequest = new OutpatientsettlementRequest();
        outpatientsettlementRequest.setPsn_no(preSetlinfo.getPsn_no());
        outpatientsettlementRequest.setMed_type(preSetlinfo.getMed_type());
        outpatientsettlementRequest.setMdtrt_cert_no(paymentResponse.getMdtrtCertNo());
        outpatientsettlementRequest.setMdtrt_cert_type(preSetlinfo.getMdtrt_cert_type());
        outpatientsettlementRequest.setMedfee_sumamt(preSetlinfo.getMedfee_sumamt().toString());
        outpatientsettlementRequest.setPsn_setlway(Objects.isNull(hsPayDto.getPsnSetlway()) ? "01" : hsPayDto.getPsnSetlway());
        outpatientsettlementRequest.setMdtrt_id(preSetlinfo.getMdtrt_id());
        outpatientsettlementRequest.setChrg_bchno(hsPayDto.getPayOrderNo());
        outpatientsettlementRequest.setInsutype(preSetlinfo.getInsutype());
        outpatientsettlementRequest.setAcct_used_flag(Objects.isNull(hsPayDto.getAcctUsedFlag()) ? "1" : hsPayDto.getAcctUsedFlag());
        outpatientsettlementRequest.setInvono("");
        outpatientsettlementRequest.setFulamt_ownpay_amt(preSetlinfo.getFulamt_ownpay_amt().toString());
        outpatientsettlementRequest.setOverlmt_selfpay(preSetlinfo.getOverlmt_selfpay().toString());
        outpatientsettlementRequest.setPreselfpay_amt(preSetlinfo.getPreselfpay_amt().toString());
        outpatientsettlementRequest.setInscp_scp_amt(preSetlinfo.getInscp_scp_amt().toString());
        outpatientsettlementRequest.setPsn_cert_type(preSetlinfo.getPsn_cert_type());
        outpatientsettlementRequest.setCertno(preSetlinfo.getCertno());
        outpatientsettlementRequest.setPsn_type(preSetlinfo.getPsn_type());
        outpatientsettlementRequest.setPsn_name(preSetlinfo.getPsn_name());
        outpatientsettlementRequest.setInsuplc_admdvs(paymentResponse.getInsuplcAdmdvs());
        outpatientsettlementRequest.setTenantId(hsPayDto.getTenantId());
        outpatientsettlementRequest.setOpter_type(hsPayDto.getOpter_type());
        outpatientsettlementRequest.setOpter(hsPayDto.getOpter());
        outpatientsettlementRequest.setOpter_name(hsPayDto.getOpter_name());
        outpatientsettlementRequest.setSign_no(hsPayDto.getSign_no());
        outpatientsettlementRequest.setPaymentMethod(hsPayDto.getPaymentMethod());
        outpatientsettlementRequest.setPsn_cash_pay(paymentResponse.getSetlinfo().getPsn_cash_pay());
        PatientEntity patientEntity = (PatientEntity)this.patientMapper.selectById((Serializable)paymentResponse.getPatientId());
        if (!Objects.isNull(patientEntity)) {
            outpatientsettlementRequest.setCard_sn(patientEntity.getCardSn());
        }
        return outpatientsettlementRequest;
    }

    @Transactional
    public ResponseData<?> hsRefund(HsRefundDto hsRefundDto) {
        ResponseData drugResponseData;
        PatientEntity entity = new PatientEntity();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"pay_order_no", (Object)hsRefundDto.getPayOrderNo())).eq((Object)"payment_status", (Object)PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)queryWrapper);
        if (Objects.isNull(outOrderPayment)) {
            return ResponseData.error((String)"\u672a\u67e5\u8be2\u5230\u6709\u6548\u8ba2\u5355\uff01");
        }
        Boolean isDrug = false;
        ArrayList<OutOrder> presOrderList = new ArrayList<OutOrder>();
        QueryWrapper queryOrderWrapper = new QueryWrapper();
        ((QueryWrapper)queryOrderWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"pay_order_no", (Object)hsRefundDto.getPayOrderNo());
        List outOrderList = this.outOrderMapper.selectList((Wrapper)queryOrderWrapper);
        ResponseData responseData1 = this.checkOnLineOFFLineList(outOrderList, hsRefundDto.getOperatorSource());
        if (!responseData1.isSuccess()) {
            return responseData1;
        }
        for (OutOrder order : outOrderList) {
            if (!"20".equals(order.getOrderType()) && !"30".equals(order.getOrderType()) && !"40".equals(order.getOrderType())) continue;
            isDrug = true;
            presOrderList.add(order);
        }
        if (isDrug.booleanValue() && !(drugResponseData = this.outPrescriptionService.returnOfDrugInventoryQuantity(hsRefundDto.getTenantId(), presOrderList, hsRefundDto.getOpterName(), new Integer(hsRefundDto.getOpter()))).isSuccess()) {
            return drugResponseData;
        }
        RefundRequest refundRequest = new RefundRequest();
        refundRequest.setChrg_bchno(hsRefundDto.getPayOrderNo());
        refundRequest.setIpt_otp_no(outOrderPayment.getOutpatientNo());
        refundRequest.setPsn_no(outOrderPayment.getPsnNo());
        refundRequest.setMdtrt_id(outOrderPayment.getMdtrtId());
        refundRequest.setSetl_id(outOrderPayment.getSetlId());
        refundRequest.setOpter(hsRefundDto.getOpter());
        refundRequest.setOpter_name(hsRefundDto.getOpterName());
        refundRequest.setOpter_type(hsRefundDto.getOpterType());
        refundRequest.setSign_no(hsRefundDto.getSign_no());
        refundRequest.setTenantId(hsRefundDto.getTenantId());
        refundRequest.setInsuplc_admdvs(outOrderPayment.getInsuplcAdmdvs());
        log.info("\u533b\u4fdd\u9000\u8d39\u5165\u53c2+++{}", (Object)JSONObject.toJSONString((Object)refundRequest));
        ResponseData responseData = this.hsServiceFeign.hsRefund(refundRequest);
        log.info("\u533b\u4fdd\u9000\u8d39\u8fd4\u56de==={}", (Object)JSONObject.toJSONString((Object)responseData));
        if (Objects.isNull(responseData) || responseData.isError()) {
            return responseData;
        }
        PaymentResponse paymentResponse = (PaymentResponse)JSONObject.parseObject((String)JSONObject.toJSONString((Object)responseData.getData()), PaymentResponse.class);
        Setlinfo setlinfo2 = paymentResponse.getSetlinfo();
        outOrderPayment.setRefundAmount(setlinfo2.getMedfee_sumamt().negate());
        outOrderPayment.setRefundTime(DateUtils.stringToFullDate((String)setlinfo2.getSetl_time()));
        outOrderPayment.setRefundTransactionNo(setlinfo2.getSetl_id());
        outOrderPayment.setRefundCheckerId(new Integer(hsRefundDto.getOpter()));
        outOrderPayment.setRefundCheckerName(hsRefundDto.getOpterName());
        outOrderPayment.setRefundSetlId(setlinfo2.getSetl_id());
        outOrderPayment.setPaymentStatus(PaymentStatusEnum.PAYMENT_REFUNDED.getValue());
        outOrderPayment.setActualPayment(outOrderPayment.getActualPayment().subtract(outOrderPayment.getRefundAmount()));
        this.outOrderPaymentMapper.updateById((Object)outOrderPayment);
        String transactionNo = UUIDUtils.getTransactionNo();
        Integer deliveryStatus = 10;
        ArrayList<OutOrderPaymentRecord> outOrderPaymentRecords = new ArrayList<OutOrderPaymentRecord>();
        for (OutOrder order : outOrderList) {
            Integer id;
            List list;
            order.setPaymentStatus(PaymentStatusEnum.PAYMENT_REFUNDED.getValue());
            order.setActualPayment(order.getTotalAmount());
            order.setRefundAmount(order.getTotalAmount());
            int num = this.outOrderMapper.updateById((Object)order);
            if (num == 0) {
                throw new RunDisplayException("\u53d8\u66f4\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
            }
            OutOrderPaymentRecord outOrderPaymentRecord = new OutOrderPaymentRecord();
            BeanUtils.copyProperties((Object)outOrderPayment, (Object)outOrderPaymentRecord);
            outOrderPaymentRecord.setPaymentTime(new Date());
            outOrderPaymentRecord.setId(null);
            outOrderPaymentRecord.setOrderNo(order.getOrderNo());
            outOrderPaymentRecord.setStatus(PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
            outOrderPaymentRecord.setAmount(order.getAmount().negate());
            outOrderPaymentRecord.setTotalAmount(order.getAmount());
            outOrderPaymentRecord.setActualPayment(outOrderPaymentRecord.getTotalAmount().negate());
            outOrderPaymentRecord.setPaymentStatus(PaymentStatusEnum.PAYMENT_REFUNDED.getValue());
            outOrderPaymentRecord.setQuantity(Integer.valueOf(-1));
            outOrderPaymentRecord.setOperationType(OperationTypeEnum.PAYMENT_REFUND.getValue());
            outOrderPaymentRecord.setTransactionNumber(transactionNo);
            outOrderPaymentRecord.setCheckerName(hsRefundDto.getOpterName());
            outOrderPaymentRecord.setCheckerId(new Integer(hsRefundDto.getOpter()));
            outOrderPaymentRecord.setCreateTime(null);
            this.outOrderPaymentRecordMapper.insert((Object)outOrderPaymentRecord);
            log.info("1\u533b\u4fdd\u9000\u6b3e\uff0c\u9000\u6b3e\u8bb0\u5f55id:" + outOrderPaymentRecord.getId());
            entity.setMsg("1\u533b\u4fdd\u9000\u6b3e\uff0c\u9000\u6b3e\u8bb0\u5f55id:" + outOrderPaymentRecord.getId());
            if (outOrderPaymentRecord.getId() == null && (list = this.outOrderPaymentRecordMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutOrderPaymentRecord::getTransactionNumber, (Object)transactionNo)).eq(OutOrderPaymentRecord::getPaymentStatus, (Object)outOrderPayment.getPaymentStatus())).eq(OutOrderPaymentRecord::getOrderNo, (Object)order.getOrderNo())).eq(OutOrderPaymentRecord::getOperationType, (Object)OperationTypeEnum.PAYMENT.getValue()))).size() > 0 && (id = ((OutOrderPaymentRecord)list.get(0)).getId()) != null) {
                outOrderPaymentRecord.setId(id);
            }
            log.info("2\u533b\u4fdd\u9000\u6b3e\uff0c\u9000\u6b3e\u8bb0\u5f55id:" + outOrderPaymentRecord.getId());
            entity.setMsg(entity.getMsg() + "--->2\u533b\u4fdd\u9000\u6b3e\uff0c\u9000\u6b3e\u8bb0\u5f55id:" + outOrderPaymentRecord.getId());
            outOrderPaymentRecords.add(outOrderPaymentRecord);
            if (!"20".equals(order.getOrderType()) && !"30".equals(order.getOrderType()) && !"40".equals(order.getOrderType())) continue;
            presOrderList.add(order);
        }
        HsSettlementInfoEntity hsSettlementInfoEntity = new HsSettlementInfoEntity();
        BeanUtils.copyProperties((Object)paymentResponse.getSetlinfo(), (Object)hsSettlementInfoEntity);
        hsSettlementInfoEntity.setSetldetail(JSONObject.toJSONString((Object)paymentResponse.getSetldetail()));
        hsSettlementInfoEntity.setTenantId(hsRefundDto.getTenantId());
        hsSettlementInfoEntity.setSettlmentStatus("2");
        hsSettlementInfoEntity.setInsuplc_admdvs(outOrderPayment.getInsuplcAdmdvs());
        hsSettlementInfoEntity.setRefdSetlFlag(Integer.valueOf(1));
        this.outHsSettlementInfoMapper.insert((Object)hsSettlementInfoEntity);
        HsSettlementInfoEntity originalChargeHsSettlement = new HsSettlementInfoEntity();
        originalChargeHsSettlement.setRefdSetlFlag(Integer.valueOf(1));
        this.outHsSettlementInfoMapper.update((Object)originalChargeHsSettlement, (Wrapper)Wrappers.lambdaQuery().eq(HsSettlementInfoEntity::getSetl_id, (Object)outOrderPayment.getSetlId()));
        JSONArray jsonArray = JSONObject.parseArray((String)hsSettlementInfoEntity.getSetldetail());
        if (jsonArray != null && !jsonArray.isEmpty()) {
            ArrayList<OutHsSettlementInfoDetaiEntity> detailList = new ArrayList<OutHsSettlementInfoDetaiEntity>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                Object jsonObject = jsonArray.getJSONObject(i);
                OutHsSettlementInfoDetaiEntity detail = new OutHsSettlementInfoDetaiEntity();
                detail.setTenantId(hsSettlementInfoEntity.getTenantId());
                detail.setSetlId(hsSettlementInfoEntity.getSetl_id());
                detail.setFundPayType(jsonObject.getString("fund_pay_type"));
                if (!StrUtil.isBlank((CharSequence)detail.getFundPayType())) {
                    SysDictValueDTO sysDictValueDTO = new SysDictValueDTO();
                    sysDictValueDTO.setType("fund_pay_type");
                    sysDictValueDTO.setValue(detail.getFundPayType());
                    ResponseData pageResponseData = this.sysServiceFeign.sysDictValueById(sysDictValueDTO, hsSettlementInfoEntity.getTenantId() + "");
                    Object data = ((Page)pageResponseData.getData()).getRecords();
                    detail.setFundPayTypeName(data == null || data.isEmpty() ? "" : ((SysDictValueVo)data.get(0)).getLabel());
                }
                detail.setFundPayamt(jsonObject.getBigDecimal("fund_payamt"));
                detail.setInscpScpAmt(jsonObject.getBigDecimal("inscp_scp_amt"));
                detail.setSetlProcInfo(jsonObject.getString("setl_proc_info"));
                detailList.add(detail);
            }
            this.outHsSettlementInfoDetailMapper.insertList(detailList);
        }
        PayVo payVo = new PayVo();
        BeanUtils.copyProperties((Object)outOrderPayment, (Object)payVo);
        payVo.setName(outOrderPayment.getPatientName());
        payVo.setTransactionNumber(transactionNo);
        payVo.setOperationType(OperationTypeEnum.PAYMENT_REFUND.getValue());
        try {
            List outOrderPayments;
            String payOrderNo;
            outOrderPayment.setPaymentStatusStr(PaymentStatusEnum.getValueEnum((Integer)outOrderPayment.getPaymentStatus()).getDesc());
            outOrderPayment.setPaymentMethodName(PaymentMethodEnum.getValueEnum((Integer)outOrderPayment.getPaymentMethod()).getDesc());
            outOrderPayment.setSettlementMethodName(SettlementMethodEnum.getValueEnum((Integer)outOrderPayment.getSettlementMethod()).getDesc());
            String source = outOrderPayment.getSource() != null ? outOrderPayment.getSource() : "";
            switch (source) {
                case "1": {
                    outOrderPayment.setSource("\u7ebf\u4e0a");
                    break;
                }
                case "2": {
                    outOrderPayment.setSource("\u7ebf\u4e0b");
                }
            }
            Integer status = outOrderPayment.getStatus();
            switch (status) {
                case 0: {
                    outOrderPayment.setStatusName("\u5220\u9664");
                    break;
                }
                case 1: {
                    outOrderPayment.setStatusName("\u6b63\u5e38");
                    break;
                }
                case 2: {
                    outOrderPayment.setStatusName("\u5df2\u8fc7\u671f");
                    break;
                }
                case 3: {
                    outOrderPayment.setStatusName("\u5df2\u4f5c\u5e9f");
                }
            }
            for (OutOrder outOrder : outOrderList) {
                String source1 = outOrder.getSource() != null ? outOrder.getSource() : "";
                switch (source1) {
                    case "1": {
                        outOrder.setSource("\u7ebf\u4e0a");
                        break;
                    }
                    case "2": {
                        outOrder.setSource("\u7ebf\u4e0b");
                    }
                }
                Integer status1 = outOrder.getStatus();
                switch (status1) {
                    case 0: {
                        outOrder.setStatusName("\u5220\u9664");
                        break;
                    }
                    case 1: {
                        outOrder.setStatusName("\u6b63\u5e38");
                        break;
                    }
                    case 2: {
                        outOrder.setStatusName("\u5df2\u8fc7\u671f");
                        break;
                    }
                    case 3: {
                        outOrder.setStatusName("\u5df2\u4f5c\u5e9f");
                    }
                }
                outOrder.setPaymentStatusStr(PaymentStatusEnum.getValueEnum((Integer)outOrder.getPaymentStatus()).getDesc());
                outOrder.setDeliveryStatusName(DeliveryStatusEnum.getValueEnum((Integer)(outOrder.getDeliveryStatus() != null ? outOrder.getDeliveryStatus() : 0)).getDesc());
            }
            for (OutOrderPaymentRecord record : outOrderPaymentRecords) {
                log.info("3\u533b\u4fdd\u9000\u6b3e\uff0c\u9000\u6b3e\u8bb0\u5f55id:" + record.getId());
                entity.setMsg(entity.getMsg() + "--->3\u533b\u4fdd\u9000\u6b3e\uff0c\u9000\u6b3e\u8bb0\u5f55id:" + record.getId());
                Integer status1 = record.getStatus();
                switch (status1) {
                    case 0: {
                        record.setStatusName("\u5220\u9664");
                        break;
                    }
                    case 1: {
                        record.setStatusName("\u6b63\u5e38");
                        break;
                    }
                    case 2: {
                        record.setStatusName("\u5df2\u8fc7\u671f");
                        break;
                    }
                    case 3: {
                        record.setStatusName("\u5df2\u4f5c\u5e9f");
                    }
                }
                record.setPaymentMethodName(PaymentMethodEnum.getValueEnum((Integer)record.getPaymentMethod()).getDesc());
                record.setPaymentStatusName(PaymentStatusEnum.getValueEnum((Integer)record.getPaymentStatus()).getDesc());
                if (record.getDeliveryStatus() != null) {
                    record.setDeliveryStatusName(DeliveryStatusEnum.getValueEnum((Integer)record.getDeliveryStatus()).getDesc());
                }
                if (record.getMedicalInsuranceType() != null) {
                    record.setMedicalInsuranceTypeName(MedicalInsuranceTypeEnum.getEnum((Integer)record.getMedicalInsuranceType()).getDesc());
                }
                record.setSettlementMethodName(SettlementMethodEnum.getValueEnum((Integer)record.getSettlementMethod()).getDesc());
                Integer paymentType = record.getPaymentType();
                switch (paymentType) {
                    case 1: {
                        record.setPaymentTypeName("\u5728\u7ebf\u652f\u4ed8");
                        break;
                    }
                    case 2: {
                        record.setPaymentTypeName("\u7ebf\u4e0b\u652f\u4ed8");
                    }
                }
                Integer operationType = record.getOperationType();
                switch (operationType) {
                    case 1: {
                        record.setOperationTypeName("\u652f\u4ed8");
                        break;
                    }
                    case 2: {
                        record.setOperationTypeName("\u9000\u6b3e");
                    }
                }
            }
            ArrayList<PatientEntity> patientList = new ArrayList<PatientEntity>();
            ArrayList<OutOrderPayment> orderPaymentList = new ArrayList<OutOrderPayment>();
            if (outOrderPayment.getId() == null && StringUtils.isNotBlank((CharSequence)(payOrderNo = outOrderPayment.getPayOrderNo())) && (outOrderPayments = this.outOrderPaymentMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(OutOrderPayment::getPayOrderNo, (Object)payOrderNo))).size() > 0) {
                outOrderPayment.setId(((OutOrderPayment)outOrderPayments.get(0)).getId());
            }
            entity.setMsg("OutPayServiceImpl.hsRefund-" + outOrderPayment.getId());
            entity.setId(outOrderPayment.getPatientId());
            outOrderPayment.setOrderList(outOrderList);
            if (outOrderPaymentRecords.size() > 0) {
                Integer id;
                List list;
                log.info("3\u533b\u4fdd\u9000\u6b3e\uff0c\u9000\u6b3e\u8bb0\u5f55id:" + ((OutOrderPaymentRecord)outOrderPaymentRecords.get(0)).getId());
                entity.setMsg(entity.getMsg() + "--->4\u533b\u4fdd\u9000\u6b3e\uff0c\u9000\u6b3e\u8bb0\u5f55id:" + ((OutOrderPaymentRecord)outOrderPaymentRecords.get(0)).getId());
                if (((OutOrderPaymentRecord)outOrderPaymentRecords.get(0)).getId() == null && (list = this.outOrderPaymentRecordMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutOrderPaymentRecord::getTransactionNumber, (Object)transactionNo)).eq(OutOrderPaymentRecord::getPaymentStatus, (Object)outOrderPayment.getPaymentStatus())).eq(OutOrderPaymentRecord::getOrderNo, (Object)((OutOrderPaymentRecord)outOrderPaymentRecords.get(0)).getOrderNo())).eq(OutOrderPaymentRecord::getOperationType, (Object)OperationTypeEnum.PAYMENT.getValue()))).size() > 0 && (id = ((OutOrderPaymentRecord)list.get(0)).getId()) != null) {
                    ((OutOrderPaymentRecord)outOrderPaymentRecords.get(0)).setId(id);
                }
            }
            outOrderPayment.setPaymentRecordList(outOrderPaymentRecords);
            orderPaymentList.add(outOrderPayment);
            entity.setPaymentList(orderPaymentList);
            patientList.add(entity);
            String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
            String msg = JSONObject.toJSONString(patientList);
            log.info("4\u533b\u4fdd\u9000\u6b3e\uff0c\u9000\u6b3e\u7684json:" + msg);
            entity.setMsg(entity.getMsg() + "--->4\u533b\u4fdd\u9000\u6b3e\uff0c\u9000\u6b3e\u7684json:" + msg);
            this.rocketMQProducer.asyncSendCallbackTimeoutLevel("rocketMQ-out-patientPaymentTopic", "TAG4", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ResponseData.success((Object)payVo);
    }

    public ResponseData onLineHsPay(OnlineHsPayDto onlineHsPayDto) {
        AdmissionEntity admission = this.admissionMapper.queryAdmissionByOutpatientNo(onlineHsPayDto.getOutpatientNo(), onlineHsPayDto.getTenantId());
        admission.setMedicalOutpatientType(onlineHsPayDto.getSetlinfo().getMed_type());
        admission.setInsuplcAdmdvs(onlineHsPayDto.getInsuplcAdmdvs());
        this.admissionMapper.updateById((Object)admission);
        PaymentResponse paymentResponse = new PaymentResponse();
        paymentResponse.setSetlinfo(onlineHsPayDto.getSetlinfo());
        paymentResponse.setMdtrtCertNo(onlineHsPayDto.getMdtrtCertNo());
        paymentResponse.setInsuplcAdmdvs(onlineHsPayDto.getInsuplcAdmdvs());
        OutpatientsettlementRequest outpatientsettlementRequest = this.generateOutpatientsettlment(paymentResponse, (HsPayDto)onlineHsPayDto);
        outpatientsettlementRequest.setAcct_used_flag(Objects.isNull(paymentResponse.getAcct_used_flag()) ? "1" : paymentResponse.getAcct_used_flag());
        outpatientsettlementRequest.setPsn_setlway(Objects.isNull(paymentResponse.getPsn_setlway()) ? "01" : paymentResponse.getPsn_setlway());
        BaseResponse outpatientsettlement = BaseResponse.success((Object)paymentResponse);
        Setlinfo setlinfo2 = onlineHsPayDto.getSetlinfo();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"pay_order_no", (Object)onlineHsPayDto.getPayOrderNo());
        OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)queryWrapper);
        outOrderPayment.setSettlementMethod(onlineHsPayDto.getSettlementMethod());
        outOrderPayment.setActualPayment(setlinfo2.getMedfee_sumamt());
        if (!Objects.isNull(outpatientsettlementRequest.getPaymentMethod()) && BigDecimal.ZERO.compareTo(outpatientsettlementRequest.getPsn_cash_pay()) < 0) {
            outOrderPayment.setPaymentMethod(outpatientsettlementRequest.getPaymentMethod());
            outOrderPayment.setPayChannel(PaymentMethodEnum.getEnum((Integer)outpatientsettlementRequest.getPaymentMethod()).getPayChannel());
        } else {
            outOrderPayment.setPaymentMethod(PaymentMethodEnum.PAY_MEDICAL_INSURANCE.getValue());
            outOrderPayment.setPayChannel(PaymentMethodEnum.PAY_MEDICAL_INSURANCE.getPayChannel());
        }
        outOrderPayment.setPaymentStatus(PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        outOrderPayment.setPaymentType(PaymentTypeEnum.OFFLINE_PAYMENT.getValue());
        outOrderPayment.setHsPayInfo(JSONObject.toJSONString((Object)outpatientsettlement));
        outOrderPayment.setPsnNo(setlinfo2.getPsn_no());
        outOrderPayment.setMdtrtId(setlinfo2.getMdtrt_id());
        outOrderPayment.setSetlId(setlinfo2.getSetl_id());
        outOrderPayment.setPaymentTime(DateUtils.stringToFullDate((String)setlinfo2.getSetl_time()));
        outOrderPayment.setPayCost(setlinfo2.getAcct_pay());
        outOrderPayment.setPubCost(setlinfo2.getFund_pay_sumamt());
        outOrderPayment.setOwnCost(setlinfo2.getPsn_cash_pay());
        outOrderPayment.setPaymentTransactionNo(setlinfo2.getSetl_id());
        outOrderPayment.setCheckerId(new Integer(onlineHsPayDto.getOpter()));
        outOrderPayment.setCheckerName(onlineHsPayDto.getOpter_name());
        outOrderPayment.setInsuplcAdmdvs(paymentResponse.getInsuplcAdmdvs());
        outOrderPayment.setInsutype(paymentResponse.getSetlinfo().getInsutype());
        this.outOrderPaymentMapper.updateById((Object)outOrderPayment);
        this.pushEtube(outOrderPayment);
        QueryWrapper queryOrderWrapper = new QueryWrapper();
        ((QueryWrapper)queryOrderWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"pay_order_no", (Object)outpatientsettlementRequest.getChrg_bchno());
        List outOrderList = this.outOrderMapper.selectList((Wrapper)queryOrderWrapper);
        ArrayList<OutOrderPaymentRecord> outOrderPaymentRecords = new ArrayList<OutOrderPaymentRecord>();
        String transactionNo = UUIDUtils.getTransactionNo();
        for (OutOrder order : outOrderList) {
            List list;
            order.setPaymentStatus(PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
            order.setActualPayment(order.getTotalAmount());
            int num = this.outOrderMapper.updateById((Object)order);
            if (num == 0) {
                throw new RunDisplayException("\u53d8\u66f4\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
            }
            OutOrderPaymentRecord outOrderPaymentRecord = new OutOrderPaymentRecord();
            BeanUtils.copyProperties((Object)outOrderPayment, (Object)outOrderPaymentRecord);
            outOrderPaymentRecord.setId(null);
            outOrderPaymentRecord.setOrderNo(order.getOrderNo());
            outOrderPaymentRecord.setStatus(PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
            outOrderPaymentRecord.setAmount(order.getAmount());
            outOrderPaymentRecord.setTotalAmount(order.getAmount());
            outOrderPaymentRecord.setActualPayment(outOrderPaymentRecord.getTotalAmount());
            outOrderPaymentRecord.setPaymentStatus(PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
            outOrderPaymentRecord.setQuantity(Integer.valueOf(1));
            outOrderPaymentRecord.setOperationType(OperationTypeEnum.PAYMENT.getValue());
            outOrderPaymentRecord.setTransactionNumber(transactionNo);
            outOrderPaymentRecord.setCheckerName(onlineHsPayDto.getOpter_name());
            outOrderPaymentRecord.setCheckerId(new Integer(onlineHsPayDto.getOpter()));
            outOrderPaymentRecord.setCreateTime(null);
            this.outOrderPaymentRecordMapper.insert((Object)outOrderPaymentRecord);
            if (outOrderPaymentRecord.getId() == null && (list = this.outOrderPaymentRecordMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutOrderPaymentRecord::getTransactionNumber, (Object)transactionNo)).eq(OutOrderPaymentRecord::getPaymentStatus, (Object)outOrderPayment.getPaymentStatus())).eq(OutOrderPaymentRecord::getOrderNo, (Object)order.getOrderNo())).eq(OutOrderPaymentRecord::getAmount, (Object)order.getAmount())).eq(OutOrderPaymentRecord::getOperationType, (Object)OperationTypeEnum.PAYMENT.getValue()))).size() > 0) {
                Integer id = ((OutOrderPaymentRecord)list.get(0)).getId();
                outOrderPaymentRecord.setId(id);
            }
            outOrderPaymentRecords.add(outOrderPaymentRecord);
        }
        HsSettlementInfoEntity hsSettlementInfoEntity = new HsSettlementInfoEntity();
        BeanUtils.copyProperties((Object)paymentResponse.getSetlinfo(), (Object)hsSettlementInfoEntity);
        hsSettlementInfoEntity.setSetldetail(JSONObject.toJSONString((Object)onlineHsPayDto.getSetldetail()));
        hsSettlementInfoEntity.setTenantId(onlineHsPayDto.getTenantId());
        hsSettlementInfoEntity.setSettlmentStatus("1");
        hsSettlementInfoEntity.setInsuplc_admdvs(paymentResponse.getInsuplcAdmdvs());
        hsSettlementInfoEntity.setDise_codg(paymentResponse.getDiseCodg());
        hsSettlementInfoEntity.setDise_name(paymentResponse.getDiseName());
        log.info("\u63d2\u5165\u533b\u4fdd\u7ed3\u7b97\u4fe1\u606f\uff0c{}", (Object)JSONObject.toJSONString((Object)hsSettlementInfoEntity));
        this.outHsSettlementInfoMapper.insert((Object)hsSettlementInfoEntity);
        JSONArray jsonArray = JSONObject.parseArray((String)hsSettlementInfoEntity.getSetldetail());
        if (jsonArray != null && !jsonArray.isEmpty()) {
            ArrayList<OutHsSettlementInfoDetaiEntity> detailList = new ArrayList<OutHsSettlementInfoDetaiEntity>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                OutHsSettlementInfoDetaiEntity detail = new OutHsSettlementInfoDetaiEntity();
                detail.setTenantId(hsSettlementInfoEntity.getTenantId());
                detail.setSetlId(hsSettlementInfoEntity.getSetl_id());
                detail.setFundPayType(jsonObject.getString("fund_pay_type"));
                if (!StrUtil.isBlank((CharSequence)detail.getFundPayType())) {
                    SysDictValueDTO sysDictValueDTO = new SysDictValueDTO();
                    sysDictValueDTO.setType("fund_pay_type");
                    sysDictValueDTO.setValue(detail.getFundPayType());
                    ResponseData pageResponseData = this.sysServiceFeign.sysDictValueById(sysDictValueDTO, hsSettlementInfoEntity.getTenantId() + "");
                    List data = ((Page)pageResponseData.getData()).getRecords();
                    detail.setFundPayTypeName(data == null || data.isEmpty() ? "" : ((SysDictValueVo)data.get(0)).getLabel());
                }
                detail.setFundPayamt(jsonObject.getBigDecimal("fund_payamt"));
                detail.setInscpScpAmt(jsonObject.getBigDecimal("inscp_scp_amt"));
                detail.setSetlProcInfo(jsonObject.getString("setl_proc_info"));
                detailList.add(detail);
            }
            this.outHsSettlementInfoDetailMapper.insertList(detailList);
        }
        List strings = this.outOrderMapper.dispenseMedicineByOrder(outOrderList);
        for (String string : strings) {
            OutPrescriptionDto dto = new OutPrescriptionDto();
            dto.setPrescriptionNo(string);
            Integer tenant = this.commonRequest.getTenant();
            Integer userId = this.commonRequest.getUserId();
            String userName = this.commonRequest.getUserName();
            if (tenant == null) {
                tenant = onlineHsPayDto.getTenantId();
            }
            if (userId == null) {
                userId = Integer.valueOf(onlineHsPayDto.getOpter());
            }
            if (StringUtils.isBlank((CharSequence)userName)) {
                userName = onlineHsPayDto.getOpter_name();
            }
            dto.setTenantId(tenant);
            dto.setOperatorId(userId);
            dto.setOperatorName(userName);
            dto.setMethodType("\u3010outPayServiceImpl\u3011\uff1aonLineHsPay");
            this.outPrescriptionService.dispenseMedicine(dto);
        }
        try {
            List outOrderPayments;
            String payOrderNo;
            String source;
            outOrderPayment.setPaymentStatusStr(PaymentStatusEnum.getValueEnum((Integer)outOrderPayment.getPaymentStatus()).getDesc());
            outOrderPayment.setPaymentMethodName(PaymentMethodEnum.getValueEnum((Integer)outOrderPayment.getPaymentMethod()).getDesc());
            outOrderPayment.setSettlementMethodName(SettlementMethodEnum.getValueEnum((Integer)outOrderPayment.getSettlementMethod()).getDesc());
            switch (source = outOrderPayment.getSource() != null ? outOrderPayment.getSource() : "") {
                case "1": {
                    outOrderPayment.setSource("\u7ebf\u4e0a");
                    break;
                }
                case "2": {
                    outOrderPayment.setSource("\u7ebf\u4e0b");
                }
            }
            Integer status = outOrderPayment.getStatus();
            switch (status) {
                case 0: {
                    outOrderPayment.setStatusName("\u5220\u9664");
                    break;
                }
                case 1: {
                    outOrderPayment.setStatusName("\u6b63\u5e38");
                    break;
                }
                case 2: {
                    outOrderPayment.setStatusName("\u5df2\u8fc7\u671f");
                    break;
                }
                case 3: {
                    outOrderPayment.setStatusName("\u5df2\u4f5c\u5e9f");
                }
            }
            for (OutOrder outOrder : outOrderList) {
                String source1;
                switch (source1 = outOrder.getSource() != null ? outOrder.getSource() : "") {
                    case "1": {
                        outOrder.setSource("\u7ebf\u4e0a");
                        break;
                    }
                    case "2": {
                        outOrder.setSource("\u7ebf\u4e0b");
                    }
                }
                Integer status1 = outOrder.getStatus();
                switch (status1) {
                    case 0: {
                        outOrder.setStatusName("\u5220\u9664");
                        break;
                    }
                    case 1: {
                        outOrder.setStatusName("\u6b63\u5e38");
                        break;
                    }
                    case 2: {
                        outOrder.setStatusName("\u5df2\u8fc7\u671f");
                        break;
                    }
                    case 3: {
                        outOrder.setStatusName("\u5df2\u4f5c\u5e9f");
                    }
                }
                outOrder.setPaymentStatusStr(PaymentStatusEnum.getValueEnum((Integer)outOrder.getPaymentStatus()).getDesc());
                outOrder.setDeliveryStatusName(DeliveryStatusEnum.getValueEnum((Integer)(outOrder.getDeliveryStatus() != null ? outOrder.getDeliveryStatus() : 0)).getDesc());
            }
            for (OutOrderPaymentRecord record : outOrderPaymentRecords) {
                Integer status1 = record.getStatus();
                switch (status1) {
                    case 0: {
                        record.setStatusName("\u5220\u9664");
                        break;
                    }
                    case 1: {
                        record.setStatusName("\u6b63\u5e38");
                        break;
                    }
                    case 2: {
                        record.setStatusName("\u5df2\u8fc7\u671f");
                        break;
                    }
                    case 3: {
                        record.setStatusName("\u5df2\u4f5c\u5e9f");
                    }
                }
                record.setPaymentMethodName(PaymentMethodEnum.getValueEnum((Integer)record.getPaymentMethod()).getDesc());
                record.setPaymentStatusName(PaymentStatusEnum.getValueEnum((Integer)record.getPaymentStatus()).getDesc());
                if (record.getDeliveryStatus() != null) {
                    record.setDeliveryStatusName(DeliveryStatusEnum.getValueEnum((Integer)record.getDeliveryStatus()).getDesc());
                }
                if (record.getMedicalInsuranceType() != null) {
                    record.setMedicalInsuranceTypeName(MedicalInsuranceTypeEnum.getEnum((Integer)record.getMedicalInsuranceType()).getDesc());
                }
                record.setSettlementMethodName(SettlementMethodEnum.getValueEnum((Integer)record.getSettlementMethod()).getDesc());
                Integer paymentType = record.getPaymentType();
                switch (paymentType) {
                    case 1: {
                        record.setPaymentTypeName("\u5728\u7ebf\u652f\u4ed8");
                        break;
                    }
                    case 2: {
                        record.setPaymentTypeName("\u7ebf\u4e0b\u652f\u4ed8");
                    }
                }
                Integer operationType = record.getOperationType();
                switch (operationType) {
                    case 1: {
                        record.setOperationTypeName("\u652f\u4ed8");
                        break;
                    }
                    case 2: {
                        record.setOperationTypeName("\u9000\u6b3e");
                    }
                }
            }
            ArrayList<PatientEntity> patientList = new ArrayList<PatientEntity>();
            ArrayList<OutOrderPayment> orderPaymentList = new ArrayList<OutOrderPayment>();
            PatientEntity entity = new PatientEntity();
            if (outOrderPayment.getId() == null && StringUtils.isNotBlank((CharSequence)(payOrderNo = outOrderPayment.getPayOrderNo())) && (outOrderPayments = this.outOrderPaymentMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(OutOrderPayment::getPayOrderNo, (Object)payOrderNo))).size() > 0) {
                outOrderPayment.setId(((OutOrderPayment)outOrderPayments.get(0)).getId());
            }
            entity.setMsg("OutPayServiceImpl.onLineHsPay-" + outOrderPayment.getId());
            entity.setId(outOrderPayment.getPatientId());
            outOrderPayment.setOrderList(outOrderList);
            outOrderPayment.setPaymentRecordList(outOrderPaymentRecords);
            orderPaymentList.add(outOrderPayment);
            entity.setPaymentList(orderPaymentList);
            patientList.add(entity);
            String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
            String msg = JSONObject.toJSONString(patientList);
            this.rocketMQProducer.asyncSendCallbackTimeoutLevel("rocketMQ-out-patientPaymentTopic", "TAG4", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ResponseData.success((Object)transactionNo);
    }

    public ResponseData onlineHsRefund(OnlineHsRefundDto onlineHsRefundDto) {
        ResponseData drugResponseData;
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"pay_order_no", (Object)onlineHsRefundDto.getPayOrderNo())).eq((Object)"payment_status", (Object)PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)queryWrapper);
        if (Objects.isNull(outOrderPayment)) {
            return ResponseData.error((String)"\u672a\u67e5\u8be2\u5230\u6709\u6548\u8ba2\u5355\uff01");
        }
        Boolean isDrug = false;
        ArrayList<OutOrder> presOrderList = new ArrayList<OutOrder>();
        QueryWrapper queryOrderWrapper = new QueryWrapper();
        ((QueryWrapper)queryOrderWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"pay_order_no", (Object)onlineHsRefundDto.getPayOrderNo());
        List outOrderList = this.outOrderMapper.selectList((Wrapper)queryOrderWrapper);
        ResponseData responseData1 = this.checkOnLineOFFLineList(outOrderList, onlineHsRefundDto.getOperatorSource());
        if (!responseData1.isSuccess()) {
            return responseData1;
        }
        for (OutOrder order : outOrderList) {
            if (!"20".equals(order.getOrderType()) && !"30".equals(order.getOrderType()) && !"40".equals(order.getOrderType())) continue;
            isDrug = true;
            presOrderList.add(order);
        }
        if (isDrug.booleanValue() && !(drugResponseData = this.outPrescriptionService.returnOfDrugInventoryQuantity(onlineHsRefundDto.getTenantId(), presOrderList, onlineHsRefundDto.getOpterName(), new Integer(onlineHsRefundDto.getOpter()))).isSuccess()) {
            return drugResponseData;
        }
        Setlinfo setlinfo2 = onlineHsRefundDto.getSetlinfo();
        List setldetail2 = onlineHsRefundDto.getSetldetail();
        outOrderPayment.setRefundAmount(setlinfo2.getMedfee_sumamt().negate());
        outOrderPayment.setRefundTime(DateUtils.stringToFullDate((String)setlinfo2.getSetl_time()));
        outOrderPayment.setRefundTransactionNo(setlinfo2.getSetl_id());
        outOrderPayment.setRefundCheckerId(new Integer(onlineHsRefundDto.getOpter()));
        outOrderPayment.setRefundCheckerName(onlineHsRefundDto.getOpterName());
        outOrderPayment.setRefundSetlId(setlinfo2.getSetl_id());
        outOrderPayment.setPaymentStatus(PaymentStatusEnum.PAYMENT_REFUNDED.getValue());
        outOrderPayment.setActualPayment(outOrderPayment.getActualPayment().subtract(setlinfo2.getMedfee_sumamt()));
        this.outOrderPaymentMapper.updateById((Object)outOrderPayment);
        String transactionNo = UUIDUtils.getTransactionNo();
        ArrayList<OutOrderPaymentRecord> outOrderPaymentRecords = new ArrayList<OutOrderPaymentRecord>();
        for (OutOrder order : outOrderList) {
            List list;
            order.setPaymentStatus(PaymentStatusEnum.PAYMENT_REFUNDED.getValue());
            order.setActualPayment(order.getTotalAmount());
            int num = this.outOrderMapper.updateById((Object)order);
            if (num == 0) {
                throw new RunDisplayException("\u53d8\u66f4\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
            }
            OutOrderPaymentRecord outOrderPaymentRecord = new OutOrderPaymentRecord();
            BeanUtils.copyProperties((Object)outOrderPayment, (Object)outOrderPaymentRecord);
            outOrderPaymentRecord.setPaymentTime(new Date());
            outOrderPaymentRecord.setId(null);
            outOrderPaymentRecord.setOrderNo(order.getOrderNo());
            outOrderPaymentRecord.setStatus(PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
            outOrderPaymentRecord.setAmount(order.getAmount().negate());
            outOrderPaymentRecord.setTotalAmount(order.getAmount());
            outOrderPaymentRecord.setActualPayment(outOrderPaymentRecord.getTotalAmount().negate());
            outOrderPaymentRecord.setPaymentStatus(PaymentStatusEnum.PAYMENT_REFUNDED.getValue());
            outOrderPaymentRecord.setQuantity(Integer.valueOf(-1));
            outOrderPaymentRecord.setOperationType(OperationTypeEnum.PAYMENT_REFUND.getValue());
            outOrderPaymentRecord.setTransactionNumber(transactionNo);
            outOrderPaymentRecord.setCheckerName(onlineHsRefundDto.getOpterName());
            outOrderPaymentRecord.setCheckerId(new Integer(onlineHsRefundDto.getOpter()));
            outOrderPaymentRecord.setCreateTime(null);
            this.outOrderPaymentRecordMapper.insert((Object)outOrderPaymentRecord);
            if (outOrderPaymentRecord.getId() == null && (list = this.outOrderPaymentRecordMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutOrderPaymentRecord::getTransactionNumber, (Object)transactionNo)).eq(OutOrderPaymentRecord::getPaymentStatus, (Object)outOrderPayment.getPaymentStatus())).eq(OutOrderPaymentRecord::getOrderNo, (Object)order.getOrderNo())).eq(OutOrderPaymentRecord::getAmount, (Object)order.getAmount())).eq(OutOrderPaymentRecord::getOperationType, (Object)OperationTypeEnum.PAYMENT.getValue()))).size() > 0) {
                Integer id = ((OutOrderPaymentRecord)list.get(0)).getId();
                outOrderPaymentRecord.setId(id);
            }
            outOrderPaymentRecords.add(outOrderPaymentRecord);
            if (!"20".equals(order.getOrderType()) && !"30".equals(order.getOrderType()) && !"40".equals(order.getOrderType())) continue;
            presOrderList.add(order);
        }
        HsSettlementInfoEntity hsSettlementInfoEntity = new HsSettlementInfoEntity();
        BeanUtils.copyProperties((Object)setlinfo2, (Object)hsSettlementInfoEntity);
        hsSettlementInfoEntity.setSetldetail(JSONObject.toJSONString((Object)setldetail2));
        hsSettlementInfoEntity.setTenantId(onlineHsRefundDto.getTenantId());
        hsSettlementInfoEntity.setSettlmentStatus("2");
        hsSettlementInfoEntity.setInsuplc_admdvs(outOrderPayment.getInsuplcAdmdvs());
        this.outHsSettlementInfoMapper.insert((Object)hsSettlementInfoEntity);
        try {
            List outOrderPayments;
            String payOrderNo;
            String source;
            outOrderPayment.setPaymentStatusStr(PaymentStatusEnum.getValueEnum((Integer)outOrderPayment.getPaymentStatus()).getDesc());
            outOrderPayment.setPaymentMethodName(PaymentMethodEnum.getValueEnum((Integer)outOrderPayment.getPaymentMethod()).getDesc());
            outOrderPayment.setSettlementMethodName(SettlementMethodEnum.getValueEnum((Integer)outOrderPayment.getSettlementMethod()).getDesc());
            switch (source = outOrderPayment.getSource() != null ? outOrderPayment.getSource() : "") {
                case "1": {
                    outOrderPayment.setSource("\u7ebf\u4e0a");
                    break;
                }
                case "2": {
                    outOrderPayment.setSource("\u7ebf\u4e0b");
                }
            }
            Integer status = outOrderPayment.getStatus();
            switch (status) {
                case 0: {
                    outOrderPayment.setStatusName("\u5220\u9664");
                    break;
                }
                case 1: {
                    outOrderPayment.setStatusName("\u6b63\u5e38");
                    break;
                }
                case 2: {
                    outOrderPayment.setStatusName("\u5df2\u8fc7\u671f");
                    break;
                }
                case 3: {
                    outOrderPayment.setStatusName("\u5df2\u4f5c\u5e9f");
                }
            }
            for (OutOrder outOrder : outOrderList) {
                String source1;
                switch (source1 = outOrder.getSource() != null ? outOrder.getSource() : "") {
                    case "1": {
                        outOrder.setSource("\u7ebf\u4e0a");
                        break;
                    }
                    case "2": {
                        outOrder.setSource("\u7ebf\u4e0b");
                    }
                }
                Integer status1 = outOrder.getStatus();
                switch (status1) {
                    case 0: {
                        outOrder.setStatusName("\u5220\u9664");
                        break;
                    }
                    case 1: {
                        outOrder.setStatusName("\u6b63\u5e38");
                        break;
                    }
                    case 2: {
                        outOrder.setStatusName("\u5df2\u8fc7\u671f");
                        break;
                    }
                    case 3: {
                        outOrder.setStatusName("\u5df2\u4f5c\u5e9f");
                    }
                }
                outOrder.setPaymentStatusStr(PaymentStatusEnum.getValueEnum((Integer)outOrder.getPaymentStatus()).getDesc());
                outOrder.setDeliveryStatusName(DeliveryStatusEnum.getValueEnum((Integer)(outOrder.getDeliveryStatus() != null ? outOrder.getDeliveryStatus() : 0)).getDesc());
            }
            for (OutOrderPaymentRecord record : outOrderPaymentRecords) {
                Integer status1 = record.getStatus();
                switch (status1) {
                    case 0: {
                        record.setStatusName("\u5220\u9664");
                        break;
                    }
                    case 1: {
                        record.setStatusName("\u6b63\u5e38");
                        break;
                    }
                    case 2: {
                        record.setStatusName("\u5df2\u8fc7\u671f");
                        break;
                    }
                    case 3: {
                        record.setStatusName("\u5df2\u4f5c\u5e9f");
                    }
                }
                record.setPaymentMethodName(PaymentMethodEnum.getValueEnum((Integer)record.getPaymentMethod()).getDesc());
                record.setPaymentStatusName(PaymentStatusEnum.getValueEnum((Integer)record.getPaymentStatus()).getDesc());
                if (record.getDeliveryStatus() != null) {
                    record.setDeliveryStatusName(DeliveryStatusEnum.getValueEnum((Integer)record.getDeliveryStatus()).getDesc());
                }
                if (record.getMedicalInsuranceType() != null) {
                    record.setMedicalInsuranceTypeName(MedicalInsuranceTypeEnum.getEnum((Integer)record.getMedicalInsuranceType()).getDesc());
                }
                record.setSettlementMethodName(SettlementMethodEnum.getValueEnum((Integer)record.getSettlementMethod()).getDesc());
                Integer paymentType = record.getPaymentType();
                switch (paymentType) {
                    case 1: {
                        record.setPaymentTypeName("\u5728\u7ebf\u652f\u4ed8");
                        break;
                    }
                    case 2: {
                        record.setPaymentTypeName("\u7ebf\u4e0b\u652f\u4ed8");
                    }
                }
                Integer operationType = record.getOperationType();
                switch (operationType) {
                    case 1: {
                        record.setOperationTypeName("\u652f\u4ed8");
                        break;
                    }
                    case 2: {
                        record.setOperationTypeName("\u9000\u6b3e");
                    }
                }
            }
            ArrayList<PatientEntity> patientList = new ArrayList<PatientEntity>();
            ArrayList<OutOrderPayment> orderPaymentList = new ArrayList<OutOrderPayment>();
            PatientEntity entity = new PatientEntity();
            if (outOrderPayment.getId() == null && StringUtils.isNotBlank((CharSequence)(payOrderNo = outOrderPayment.getPayOrderNo())) && (outOrderPayments = this.outOrderPaymentMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(OutOrderPayment::getPayOrderNo, (Object)payOrderNo))).size() > 0) {
                outOrderPayment.setId(((OutOrderPayment)outOrderPayments.get(0)).getId());
            }
            entity.setMsg("OutPayServiceImpl.onlineHsRefund-" + outOrderPayment.getId());
            entity.setId(outOrderPayment.getPatientId());
            outOrderPayment.setOrderList(outOrderList);
            outOrderPayment.setPaymentRecordList(outOrderPaymentRecords);
            orderPaymentList.add(outOrderPayment);
            entity.setPaymentList(orderPaymentList);
            patientList.add(entity);
            String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
            String msg = JSONObject.toJSONString(patientList);
            this.rocketMQProducer.asyncSendCallbackTimeoutLevel("rocketMQ-out-patientPaymentTopic", "TAG4", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PayVo payVo = new PayVo();
        BeanUtils.copyProperties((Object)outOrderPayment, (Object)payVo);
        payVo.setName(outOrderPayment.getPatientName());
        payVo.setTransactionNumber(transactionNo);
        payVo.setOperationType(OperationTypeEnum.PAYMENT.getValue());
        return ResponseData.success((Object)payVo);
    }

    public ResponseData wisdomPay(HsPayDto hsPayDto) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"pay_order_no", (Object)hsPayDto.getPayOrderNo());
        OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)queryWrapper);
        outOrderPayment.setActualPayment(hsPayDto.getActualPayment());
        outOrderPayment.setPaymentMethod(hsPayDto.getPaymentMethod());
        outOrderPayment.setPayChannel(PaymentMethodEnum.getEnum((Integer)hsPayDto.getPaymentMethod()).getPayChannel());
        outOrderPayment.setPaymentStatus(PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        outOrderPayment.setPaymentType(PaymentTypeEnum.OFFLINE_PAYMENT.getValue());
        outOrderPayment.setPaymentTime(DateUtils.stringToFullDate((String)hsPayDto.getPaymentTime()));
        outOrderPayment.setCheckerId(new Integer(hsPayDto.getOpter()));
        outOrderPayment.setCheckerName(hsPayDto.getOpter_name());
        this.outOrderPaymentMapper.updateById((Object)outOrderPayment);
        QueryWrapper queryOrderWrapper = new QueryWrapper();
        ((QueryWrapper)queryOrderWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"pay_order_no", (Object)hsPayDto.getPayOrderNo());
        List outOrderList = this.outOrderMapper.selectList((Wrapper)queryOrderWrapper);
        for (OutOrder order : outOrderList) {
            order.setPaymentStatus(PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
            order.setActualPayment(order.getTotalAmount());
            String transactionNo = UUIDUtils.getTransactionNo();
            int num = this.outOrderMapper.updateById((Object)order);
            if (num == 0) {
                throw new RunDisplayException("\u53d8\u66f4\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
            }
            OutOrderPaymentRecord outOrderPaymentRecord = new OutOrderPaymentRecord();
            BeanUtils.copyProperties((Object)outOrderPayment, (Object)outOrderPaymentRecord);
            outOrderPaymentRecord.setId(null);
            outOrderPaymentRecord.setOrderNo(order.getOrderNo());
            outOrderPaymentRecord.setStatus(PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
            outOrderPaymentRecord.setAmount(order.getAmount());
            outOrderPaymentRecord.setTotalAmount(order.getAmount());
            outOrderPaymentRecord.setActualPayment(outOrderPaymentRecord.getTotalAmount());
            outOrderPaymentRecord.setPaymentStatus(PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
            outOrderPaymentRecord.setQuantity(Integer.valueOf(1));
            outOrderPaymentRecord.setOperationType(OperationTypeEnum.PAYMENT.getValue());
            outOrderPaymentRecord.setTransactionNumber(transactionNo);
            outOrderPaymentRecord.setCheckerName(hsPayDto.getOpter_name());
            outOrderPaymentRecord.setCheckerId(new Integer(hsPayDto.getOpter()));
            outOrderPaymentRecord.setCreateTime(null);
            this.outOrderPaymentRecordMapper.insert((Object)outOrderPaymentRecord);
        }
        return ResponseData.success((Object)hsPayDto.getPayOrderNo());
    }

    public ResponseData<?> wisHsPreparePayment(HsPreparePayDto hsPreparePayDto) {
        String outpatientNo = hsPreparePayDto.getOutpatientNo();
        LambdaQueryWrapper outOrderLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)outOrderLambdaQueryWrapper.eq(OutOrder::getOrderNo, (Object)outpatientNo)).eq(OutOrder::getPaymentStatus, (Object)10)).eq(OutOrder::getStatus, (Object)1)).last("limit 1");
        OutOrder outOrder = (OutOrder)this.outOrderMapper.selectOne((Wrapper)outOrderLambdaQueryWrapper);
        if (Objects.isNull(outOrder)) {
            throw new RunDisplayException("\u672a\u67e5\u8be2\u5230\u5f85\u7f34\u8d39\u8ba2\u5355\uff01");
        }
        LambdaQueryWrapper outPrescriptionLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)outPrescriptionLambdaQueryWrapper.eq(OutPrescription::getPrescriptionNo, (Object)outOrder.getPrescriptionNo())).eq(OutPrescription::getPrescriptionStatus, (Object)1)).last("limit 1");
        OutPrescription outPrescription = (OutPrescription)this.outPrescriptionMapper.selectOne((Wrapper)outPrescriptionLambdaQueryWrapper);
        hsPreparePayDto.setMedType("11");
        if (!(Objects.isNull(outPrescription) || Objects.isNull(outPrescription.getDiagCode()) || Objects.isNull(outPrescription.getDiagName()) || "".equals(outPrescription.getDiagCode()) || "".equals(outPrescription.getDiagName()) || "1".equals(outPrescription.getDiagCode()))) {
            hsPreparePayDto.setMedType("14");
            hsPreparePayDto.setDiseCodg(outPrescription.getDiagCode());
            hsPreparePayDto.setDiseName(outPrescription.getDiagName());
        }
        hsPreparePayDto.setOutpatientNo(outOrder.getOutpatientNo());
        return this.hsPreparePayment(hsPreparePayDto);
    }

    public ResponseData<?> ihosHsPreparePayment(HsPreparePayDto hsPreparePayDto) {
        QueryWrapper outPrescriptionQueryWrapper = new QueryWrapper();
        outPrescriptionQueryWrapper.eq((Object)"prescription_no", (Object)hsPreparePayDto.getPrescriptionNo());
        outPrescriptionQueryWrapper.last("limit 1");
        OutPrescription outPrescription = (OutPrescription)this.outPrescriptionMapper.selectOne((Wrapper)outPrescriptionQueryWrapper);
        QueryWrapper mainQueryWrapper = new QueryWrapper();
        mainQueryWrapper.eq((Object)"main_id", (Object)outPrescription.getMainId());
        List outPrescriptions = this.outPrescriptionMapper.selectList((Wrapper)mainQueryWrapper);
        List prescriptionNoList = outPrescriptions.stream().map(OutPrescription::getPrescriptionNo).collect(Collectors.toList());
        if (!Objects.isNull(outPrescription.getDiagCode())) {
            hsPreparePayDto.setMedType("14");
            hsPreparePayDto.setDiseName(outPrescription.getDiagName());
            hsPreparePayDto.setDiseCodg(outPrescription.getDiagCode());
        }
        QueryWrapper queryWrapperOrder = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapperOrder.in((Object)"prescription_no", prescriptionNoList)).eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"payment_status", (Object)PaymentStatusEnum.PAYMENT_PENDING.getValue());
        List outOrderList = this.outOrderMapper.selectList((Wrapper)queryWrapperOrder);
        List orderNoList = outOrderList.stream().map(OutOrder::getOrderNo).collect(Collectors.toList());
        hsPreparePayDto.setOrderNoList(orderNoList);
        hsPreparePayDto.setOutpatientNo(((OutOrder)outOrderList.get(0)).getOutpatientNo());
        return this.hsPreparePayment(hsPreparePayDto);
    }

    private static OutOrderPayment getOutOrderPaymentRecord(AdmissionEntity admissionEntity, FeeBillCreationDto parameter, List<OutOrder> outOrderList) {
        BigDecimal amount = outOrderList.stream().map(OutOrder::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalAmount = outOrderList.stream().map(OutOrder::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        String payOrderNo = UUIDUtils.getPayOrderNo();
        log.info("\u8ba2\u5355\u521b\u5efa-->>\u751f\u6210\u7684\u652f\u4ed8\u5355\u53f7:{}", (Object)payOrderNo);
        OutOrderPayment outOrderPayment = new OutOrderPayment();
        outOrderPayment.setPatientId(admissionEntity.getPatientId());
        outOrderPayment.setPatientName(admissionEntity.getPatientName());
        outOrderPayment.setTenantId(parameter.getTenantId());
        outOrderPayment.setPayOrderNo(payOrderNo);
        outOrderPayment.setOutpatientNo(parameter.getOutpatientNo());
        outOrderPayment.setPayOrderName(parameter.getPayOrderName() + "\u8ba2\u5355");
        outOrderPayment.setStatus(PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
        outOrderPayment.setPaymentExpirationTime((Date)DateUtil.offset((Date)new Date(), (DateField)DateField.MINUTE, (int)30));
        outOrderPayment.setAmount(amount);
        outOrderPayment.setActualPreferentialPayment(new BigDecimal("0"));
        outOrderPayment.setTotalAmount(totalAmount.subtract(outOrderPayment.getActualPreferentialPayment()));
        outOrderPayment.setPaymentStatus(PaymentStatusEnum.PAYMENT_PENDING.getValue());
        outOrderPayment.setSettlementMethod(parameter.getSettlementMethod());
        outOrderPayment.setRemark(parameter.getRemark());
        outOrderPayment.setSource(parameter.getSource());
        return outOrderPayment;
    }

    public void pushEtube(OutOrderPayment outOrderPayment) {
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<?> moveHsPreparePayment(HsPreparePayDto hsPreparePayDto) {
        hsPreparePayDto.setTenantId(Integer.valueOf(1));
        log.info("\u7ebf\u4e0a\u533b\u4fdd\u9884\u7ed3\u7b97\u5165\u53c2hsPreparePayDto:{}", (Object)JSON.toJSONString((Object)hsPreparePayDto));
        log.info("\u533b\u4fdd\u9884\u7ed3\u7b97\u4eba\u5458\u7f16\u53f7{},medType\uff1a{},\u5f53\u524d\u5907\u6848\u75c5\u79cd\uff1a{}", new Object[]{hsPreparePayDto.getPayOrderNo(), hsPreparePayDto.getMedType(), hsPreparePayDto.getDiseName()});
        if ("14".equals(hsPreparePayDto.getMedType()) && StrUtil.isBlank((CharSequence)hsPreparePayDto.getDiseCodg())) {
            return ResponseData.error((String)"\u9884\u7ed3\u7b97\u5931\u8d25\uff0c\u6162\u75c5\u7ed3\u7b97\u5907\u6848\u75c5\u79cd\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        QueryWrapper queryWrapperOrder = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapperOrder.in((Object)"order_no", (Collection)hsPreparePayDto.getOrderNoList())).eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"payment_status", (Object)PaymentStatusEnum.PAYMENT_PENDING.getValue());
        List outOrderList = this.outOrderMapper.selectList((Wrapper)queryWrapperOrder);
        List uniqueRemarks = outOrderList.stream().filter(item -> !OrderTypeEnum.REGISTERED_ORDINARY_ORDERS.getValue().equals(item.getOrderType())).filter(item -> !OrderSettleTypeEnum.HS_SELF.getCode().equals(item.getSettleTypeCode())).map(OutOrder::getSettleTypeName).distinct().collect(Collectors.toList());
        if (uniqueRemarks.size() > 1) {
            String aa = String.join((CharSequence)"\u3001", uniqueRemarks);
            return ResponseData.error((String)("\u9884\u7ed3\u7b97\u5931\u8d25\uff1a\u5f53\u524d\u8ba2\u5355\u5b58\u5728\u591a\u79cd\u652f\u4ed8\u65b9\u5f0f:" + aa + "\u4e0d\u53ef\u4e00\u8d77\u7ed3\u7b97\uff01"));
        }
        boolean hasCashSelfOrder = outOrderList.stream().anyMatch(item -> OrderSettleTypeEnum.CASH_SELF.getCode().equals(item.getSettleTypeCode()));
        if (hasCashSelfOrder) {
            return ResponseData.error((String)"\u9884\u7ed3\u7b97\u5931\u8d25\uff1a\u5f53\u524d\u8ba2\u5355\u5b58\u5728\u9700\u8981\u73b0\u91d1\u81ea\u8d39\u7684\u6536\u8d39\u9879\u76ee\u4e0d\u53ef\u53c2\u4e0e\u533b\u4fdd\u7ed3\u7b97\uff01");
        }
        BigDecimal amount = outOrderList.stream().map(OutOrder::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalAmount = outOrderList.stream().map(OutOrder::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        PatientInfoRequest patientInfoRequest = new PatientInfoRequest();
        patientInfoRequest.setCertno(hsPreparePayDto.getCardNo());
        patientInfoRequest.setMdtrt_cert_no(hsPreparePayDto.getCardNo());
        patientInfoRequest.setMdtrt_cert_type("02");
        patientInfoRequest.setTenantId(hsPreparePayDto.getTenantId());
        log.info("1101\u83b7\u53d6\u53c2\u4fdd\u4fe1\u606f\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)patientInfoRequest));
        ResponseData hsPatientInfo = this.hsServiceFeign.hsPatientInfo(patientInfoRequest);
        log.info("1101\u83b7\u53d6\u53c2\u4fdd\u4fe1\u606f\u51fa\u53c2:{}", (Object)JSONObject.toJSONString((Object)hsPatientInfo));
        if (Objects.isNull(hsPatientInfo) || !hsPatientInfo.isSuccess()) {
            return ResponseData.error((String)((HsBaseResponse)hsPatientInfo.getData()).getErr_msg());
        }
        BaseinfoEntity baseinfo = ((HsPatientInfoResponse)((HsBaseResponse)hsPatientInfo.getData()).getOutput()).getBaseinfo();
        List insuinfo = ((HsPatientInfoResponse)((HsBaseResponse)hsPatientInfo.getData()).getOutput()).getInsuinfo();
        List insuinfos = insuinfo.stream().filter(o -> "1".equals(o.getPsn_insu_stas())).sorted(Comparator.comparing(Insuinfo::getBalc, Comparator.comparing(BigDecimal::new)).reversed()).collect(Collectors.toList());
        Insuinfo insuinfo1 = (Insuinfo)insuinfos.get(0);
        log.info("\u9009\u4e2d\u7684\u53c2\u4fdd\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)insuinfo1));
        hsPreparePayDto.setInsuplcAdmdvs(insuinfo1.getInsuplc_admdvs());
        hsPreparePayDto.setInsutype(insuinfo1.getInsutype());
        hsPreparePayDto.setPsnType(insuinfo1.getPsn_type());
        hsPreparePayDto.setPsnNo(baseinfo.getPsn_no());
        hsPreparePayDto.setPatientName(baseinfo.getPsn_name());
        hsPreparePayDto.setPsnCertType(baseinfo.getPsn_cert_type());
        hsPreparePayDto.setMdtrtCertType("01");
        hsPreparePayDto.setMdtrtCertNo(hsPreparePayDto.getCardNo());
        FeeBillCreationDto feeBillCreationDto = new FeeBillCreationDto();
        feeBillCreationDto.setOrderNoList(hsPreparePayDto.getOrderNoList());
        feeBillCreationDto.setOperatorId(new Integer(hsPreparePayDto.getOpter()));
        feeBillCreationDto.setOperatorName(hsPreparePayDto.getOpter_name());
        feeBillCreationDto.setTenantId(hsPreparePayDto.getTenantId());
        feeBillCreationDto.setTotalAmount(totalAmount);
        feeBillCreationDto.setAmount(amount);
        feeBillCreationDto.setOutpatientNo(hsPreparePayDto.getOutpatientNo());
        feeBillCreationDto.setPayOrderName(hsPreparePayDto.getPayOrderName());
        feeBillCreationDto.setSource("4");
        if (!Objects.isNull(hsPreparePayDto.getInsuplcAdmdvs()) && "369900".equals(hsPreparePayDto.getInsuplcAdmdvs())) {
            feeBillCreationDto.setSettlementMethod(SettlementMethodEnum.STATUS_MEDICARE_STTLE_PRVN.getValue());
        } else if (!Objects.isNull(hsPreparePayDto.getInsuplcAdmdvs()) && hsPreparePayDto.getInsuplcAdmdvs().startsWith("36") && !hsPreparePayDto.getInsuplcAdmdvs().startsWith("3601")) {
            feeBillCreationDto.setSettlementMethod(SettlementMethodEnum.STATUS_MEDICARE_STTLE_PRVN_OTHER.getValue());
        } else if (!Objects.isNull(hsPreparePayDto.getInsuplcAdmdvs()) && !hsPreparePayDto.getInsuplcAdmdvs().startsWith("36")) {
            feeBillCreationDto.setSettlementMethod(SettlementMethodEnum.STATUS_MEDICARE_STTLE_OUT_PRVN_OTHER.getValue());
        } else {
            feeBillCreationDto.setSettlementMethod(SettlementMethodEnum.STATUS_MEDICARE_STTLE.getValue());
        }
        feeBillCreationDto.setOperatorSource(hsPreparePayDto.getOperatorSource());
        ResponseData orderCharge = this.orderCharge(feeBillCreationDto);
        if (Objects.isNull(orderCharge) || orderCharge.isError()) {
            return orderCharge;
        }
        hsPreparePayDto.setPayOrderNo(((FeeBillCreationVo)orderCharge.getData()).getPayOrderNo());
        RegMovePayInfoRequest regMovePayInfoRequest = new RegMovePayInfoRequest();
        BeanUtils.copyProperties((Object)hsPreparePayDto, (Object)regMovePayInfoRequest);
        RegistrationRequest registrationRequest = new RegistrationRequest();
        registrationRequest.setCard_sn(hsPreparePayDto.getCardSn());
        registrationRequest.setCertno(hsPreparePayDto.getCardNo());
        registrationRequest.setPsn_cert_type(hsPreparePayDto.getPsnCertType());
        registrationRequest.setMdtrt_cert_no(hsPreparePayDto.getMdtrtCertNo());
        registrationRequest.setMdtrt_cert_type(hsPreparePayDto.getMdtrtCertType());
        registrationRequest.setIpt_otp_no(hsPreparePayDto.getOutpatientNo());
        registrationRequest.setTenantId(hsPreparePayDto.getTenantId());
        AdmissionEntity admission = this.admissionMapper.queryAdmissionByOutpatientNo(hsPreparePayDto.getOutpatientNo(), hsPreparePayDto.getTenantId());
        if (!hsPreparePayDto.getCardNo().equalsIgnoreCase(admission.getPatientCardNo()) || !hsPreparePayDto.getPatientName().equals(admission.getPatientName())) {
            return ResponseData.error((String)"\u9884\u7ed3\u7b97\u5931\u8d25\uff0c\u53c2\u4fdd\u4eba\u4fe1\u606f\u4e0e\u8ba2\u5355\u4fe1\u606f\u4e0d\u7b26\u5408\uff01");
        }
        admission.setMedicalType(String.valueOf(feeBillCreationDto.getSettlementMethod()));
        admission.setMedicalOutpatientType(hsPreparePayDto.getMedType());
        admission.setInsuplcAdmdvs(insuinfo1.getInsuplc_admdvs());
        this.admissionMapper.updateById((Object)admission);
        SysDoctorDto sysDoctorDto = new SysDoctorDto();
        sysDoctorDto.setId(admission.getDoctorId());
        ResponseData newSysDoctorIdVoResponseData = this.sysServiceFeign.newDoctorById(sysDoctorDto);
        if (Objects.isNull(newSysDoctorIdVoResponseData) || !newSysDoctorIdVoResponseData.isSuccess()) {
            return ResponseData.error((String)"\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u5931\u8d25");
        }
        ResponseData sysDoctorIdVoResponseData = this.sysServiceFeign.doctorById(sysDoctorDto);
        if (Objects.isNull(sysDoctorIdVoResponseData) || !sysDoctorIdVoResponseData.isSuccess()) {
            return ResponseData.error((String)("\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u5931\u8d25" + JSONObject.toJSONString((Object)sysDoctorIdVoResponseData)));
        }
        SysDoctorIdVo sysDoctorIdVo = (SysDoctorIdVo)sysDoctorIdVoResponseData.getData();
        if (Objects.isNull(sysDoctorIdVo.getHsCode()) || "".equals(sysDoctorIdVo.getHsCode())) {
            return ResponseData.error((String)"\u67e5\u8be2\u533b\u751f\u8d2f\u6807\u7801\u5931\u8d25\uff0c\u8bf7\u5b8c\u5584\u533b\u751f\u4fe1\u606f\uff01");
        }
        registrationRequest.setDept_code(sysDoctorIdVo.getDepartmentId());
        registrationRequest.setDept_name(sysDoctorIdVo.getDepartmentName());
        registrationRequest.setAtddr_no(sysDoctorIdVo.getHsCode());
        registrationRequest.setDr_name(sysDoctorIdVo.getUserName());
        registrationRequest.setPsn_name(hsPreparePayDto.getPatientName());
        registrationRequest.setPsn_no(hsPreparePayDto.getPsnNo());
        registrationRequest.setPsn_type(hsPreparePayDto.getPsnType());
        registrationRequest.setInsutype(hsPreparePayDto.getInsutype());
        registrationRequest.setInsuplc_admdvs(hsPreparePayDto.getInsuplcAdmdvs());
        registrationRequest.setBegntime(DateUtils.dateToFullString((Date)admission.getCreateTime()));
        registrationRequest.setCaty(sysDoctorIdVo.getDepartmentId());
        MoveMdtrtinfoRequest moveMdtrtinfo = new MoveMdtrtinfoRequest();
        moveMdtrtinfo.setDiseCodg(hsPreparePayDto.getDiseCodg());
        moveMdtrtinfo.setDiseName(hsPreparePayDto.getDiseName());
        moveMdtrtinfo.setPsnNo(hsPreparePayDto.getPsnNo());
        moveMdtrtinfo.setMedType(hsPreparePayDto.getMedType());
        ArrayList<MoveUploadInfoDiseinfoListRequest> diseinfo = new ArrayList<MoveUploadInfoDiseinfoListRequest>();
        ArrayList<MoveUploadInfoFeedetailListRequest> feedetailList = new ArrayList<MoveUploadInfoFeedetailListRequest>();
        List orderNos = hsPreparePayDto.getOrderNoList();
        for (String orderNo : orderNos) {
            String feedetl_sn;
            MoveUploadInfoFeedetailListRequest moveUploadInfoFeedetailListRequest;
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
            query.eq((Object)"order_no", (Object)orderNo);
            OutOrder outOrder = (OutOrder)this.outOrderMapper.selectOne((Wrapper)query);
            if (OrderTypeEnum.REGISTERED_ORDINARY_ORDERS.getValue().equals(outOrder.getOrderType())) {
                MoveUploadInfoDiseinfoListRequest moveUploadInfoDiseinfoListRequest = new MoveUploadInfoDiseinfoListRequest();
                moveUploadInfoDiseinfoListRequest.setDiagSrtNo("1");
                moveUploadInfoDiseinfoListRequest.setDiagType("1");
                moveUploadInfoDiseinfoListRequest.setDiagCode("Z00.001");
                moveUploadInfoDiseinfoListRequest.setDiagName("\u5065\u5eb7\u67e5\u4f53");
                moveUploadInfoDiseinfoListRequest.setDiagDept(sysDoctorIdVo.getDepartmentName());
                moveUploadInfoDiseinfoListRequest.setDiseDorName(sysDoctorIdVo.getUserName());
                moveUploadInfoDiseinfoListRequest.setDiagTime(DateUtils.dateFormat((Date)admission.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                moveUploadInfoDiseinfoListRequest.setValiFlag("1");
                moveUploadInfoDiseinfoListRequest.setDiseDorNo(sysDoctorIdVo.getHsCode());
                diseinfo.add(moveUploadInfoDiseinfoListRequest);
                MoveUploadInfoFeedetailListRequest moveUploadInfoFeedetailListRequest2 = new MoveUploadInfoFeedetailListRequest();
                moveUploadInfoFeedetailListRequest2.setChrgBchno(hsPreparePayDto.getPayOrderNo());
                moveUploadInfoFeedetailListRequest2.setFeedetlSn(hsPreparePayDto.getPayOrderNo() + "_0");
                moveUploadInfoFeedetailListRequest2.setPsnNo(hsPreparePayDto.getPsnNo());
                moveUploadInfoFeedetailListRequest2.setRxCircFlag("0");
                moveUploadInfoFeedetailListRequest2.setDiseCodg("Z00.001");
                moveUploadInfoFeedetailListRequest2.setAcordDeptCodg(sysDoctorIdVo.getDepartmentId());
                moveUploadInfoFeedetailListRequest2.setFeeOcurTime(DateUtils.getCurrentDate((String)"yyyy-MM-dd HH:mm:ss"));
                OutpatientTypeEntity outpatientTypeEntity = this.outpatientTypeMapper.queryOutpatientTypeByType(admission.getOutpatientType(), admission.getTenantId());
                moveUploadInfoFeedetailListRequest2.setDetItemFeeSumamt(outpatientTypeEntity.getRegFee().toString());
                moveUploadInfoFeedetailListRequest2.setCnt("1");
                moveUploadInfoFeedetailListRequest2.setPric(outpatientTypeEntity.getRegFee().toString());
                moveUploadInfoFeedetailListRequest2.setAcordDeptCodg(sysDoctorIdVo.getDepartmentId());
                moveUploadInfoFeedetailListRequest2.setAcordDeptName(sysDoctorIdVo.getDepartmentName());
                moveUploadInfoFeedetailListRequest2.setBilgDeptCodg(sysDoctorIdVo.getDepartmentId());
                moveUploadInfoFeedetailListRequest2.setBilgDeptName(sysDoctorIdVo.getDepartmentName());
                moveUploadInfoFeedetailListRequest2.setBilgDrCodg(sysDoctorIdVo.getHsCode());
                moveUploadInfoFeedetailListRequest2.setBilgDrName(sysDoctorIdVo.getUserName());
                moveUploadInfoFeedetailListRequest2.setMedListCodg(outpatientTypeEntity.getRegItemHsCode());
                moveUploadInfoFeedetailListRequest2.setMedinsListCodg(outpatientTypeEntity.getOutpatientType());
                moveUploadInfoFeedetailListRequest2.setOrdersDrCode(sysDoctorIdVo.getHsCode());
                moveUploadInfoFeedetailListRequest2.setOrdersDrName(sysDoctorIdVo.getUserName());
                moveUploadInfoFeedetailListRequest2.setMedType("11");
                moveUploadInfoFeedetailListRequest2.setMedListName("\u6302\u53f7\u8d39");
                moveUploadInfoFeedetailListRequest2.setMedListSpc("");
                moveUploadInfoFeedetailListRequest2.setHospApprFlag("0");
                feedetailList.add(moveUploadInfoFeedetailListRequest2);
                continue;
            }
            if (OrderTypeEnum.PRESCRIPTION_WESTERN_MEDICINE_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_TRADITIONAL_ORDERS.getValue().equals(outOrder.getOrderType()) || OrderTypeEnum.REGISTERED_CHINESE_PATENT_DRUG_ORDERS.getValue().equals(outOrder.getOrderType())) {
                QueryWrapper queryDrugWrapper = new QueryWrapper();
                queryDrugWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
                queryDrugWrapper.eq((Object)"prescription_no", (Object)outOrder.getPrescriptionNo());
                List outPrescriptionDrugs = this.outPrescriptionDrugMapper.selectList((Wrapper)queryDrugWrapper);
                for (int i = 0; i < outPrescriptionDrugs.size(); ++i) {
                    OutPrescriptionDrug drug = (OutPrescriptionDrug)outPrescriptionDrugs.get(i);
                    moveUploadInfoFeedetailListRequest = new MoveUploadInfoFeedetailListRequest();
                    moveUploadInfoFeedetailListRequest.setChrgBchno(hsPreparePayDto.getPayOrderNo());
                    feedetl_sn = hsPreparePayDto.getPayOrderNo() + "_" + RandomCodeUtils.sixRandom();
                    moveUploadInfoFeedetailListRequest.setFeedetlSn(feedetl_sn);
                    moveUploadInfoFeedetailListRequest.setPsnNo(hsPreparePayDto.getPsnNo());
                    moveUploadInfoFeedetailListRequest.setDiseCodg(hsPreparePayDto.getDiseCodg());
                    moveUploadInfoFeedetailListRequest.setRxCircFlag("0");
                    moveUploadInfoFeedetailListRequest.setFeeOcurTime(DateUtils.getCurrentDate((String)"yyyy-MM-dd HH:mm:ss"));
                    moveUploadInfoFeedetailListRequest.setMedListCodg(drug.getMedicalInsuranceCode());
                    moveUploadInfoFeedetailListRequest.setMedinsListCodg(Objects.isNull(drug.getInternalCode()) ? drug.getDrugNo() : drug.getInternalCode());
                    moveUploadInfoFeedetailListRequest.setMedType(hsPreparePayDto.getMedType());
                    moveUploadInfoFeedetailListRequest.setMedListName(drug.getDrugName());
                    moveUploadInfoFeedetailListRequest.setMedListSpc("");
                    moveUploadInfoFeedetailListRequest.setDetItemFeeSumamt(drug.getTotalDrugAmount().toString());
                    moveUploadInfoFeedetailListRequest.setCnt(String.valueOf(drug.getQuantity()));
                    moveUploadInfoFeedetailListRequest.setPric(String.valueOf(drug.getDrugPriceAmount()));
                    SysDrugEntity sysDrugEntity = new SysDrugEntity();
                    sysDrugEntity.setId(drug.getDrugNo());
                    ResponseData newSysDrugEntityResponseData = this.sysServiceFeign.newDrugIdDetails(sysDrugEntity, hsPreparePayDto.getTenantId());
                    if (Objects.isNull(newSysDrugEntityResponseData) || newSysDrugEntityResponseData.isError()) {
                        return ResponseData.error((String)("\u5f53\u524d\uff1a" + drug.getDrugName() + " \u836f\u54c1\u672a\u542f\u7528"));
                    }
                    ResponseData sysDrugEntityResponseData = this.sysServiceFeign.drugIdDetails(sysDrugEntity, hsPreparePayDto.getTenantId());
                    if (!Objects.isNull(sysDrugEntityResponseData) && sysDrugEntityResponseData.isSuccess()) {
                        SysDrugEntity result = (SysDrugEntity)sysDrugEntityResponseData.getData();
                        BigDecimal packSpecification = new BigDecimal(result.getPackSpecification());
                        moveUploadInfoFeedetailListRequest.setCnt(String.valueOf(packSpecification.multiply(drug.getQuantity())));
                        moveUploadInfoFeedetailListRequest.setMedinsListCodg(result.getMedicalInsuranceCode());
                        moveUploadInfoFeedetailListRequest.setPric(String.valueOf(drug.getDrugPriceAmount().divide(packSpecification, 6)));
                    }
                    moveUploadInfoFeedetailListRequest.setAcordDeptCodg(sysDoctorIdVo.getDepartmentId());
                    moveUploadInfoFeedetailListRequest.setAcordDeptName(sysDoctorIdVo.getDepartmentName());
                    moveUploadInfoFeedetailListRequest.setBilgDeptName(sysDoctorIdVo.getDepartmentName());
                    moveUploadInfoFeedetailListRequest.setBilgDeptName(sysDoctorIdVo.getDepartmentId());
                    moveUploadInfoFeedetailListRequest.setBilgDrCodg(sysDoctorIdVo.getHsCode());
                    moveUploadInfoFeedetailListRequest.setBilgDrName(sysDoctorIdVo.getUserName());
                    moveUploadInfoFeedetailListRequest.setBilgDeptCodg(sysDoctorIdVo.getDepartmentId());
                    moveUploadInfoFeedetailListRequest.setBilgDeptName(sysDoctorIdVo.getDepartmentName());
                    moveUploadInfoFeedetailListRequest.setBilgDrCodg(sysDoctorIdVo.getHsCode());
                    moveUploadInfoFeedetailListRequest.setOrdersDrCode(sysDoctorIdVo.getHsCode());
                    moveUploadInfoFeedetailListRequest.setOrdersDrName(sysDoctorIdVo.getUserName());
                    String insuranceAuditFlag = OrderSettleTypeEnum.HS_SELF.getCode().equals(outOrder.getSettleTypeCode()) ? "2" : drug.getMedicalInsuranceAuditFlag();
                    moveUploadInfoFeedetailListRequest.setHospApprFlag(insuranceAuditFlag);
                    feedetailList.add(moveUploadInfoFeedetailListRequest);
                }
                continue;
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"out_treatment_id", (Object)outOrder.getPrescriptionNo());
            List outTreatmentDetailsList = this.outTreatmentDetailsMapper.selectList((Wrapper)queryWrapper);
            for (int i = 0; i < outTreatmentDetailsList.size(); ++i) {
                OutTreatmentDetails outTreatmentDetails = (OutTreatmentDetails)outTreatmentDetailsList.get(i);
                moveUploadInfoFeedetailListRequest = new MoveUploadInfoFeedetailListRequest();
                moveUploadInfoFeedetailListRequest.setChrgBchno(hsPreparePayDto.getPayOrderNo());
                feedetl_sn = hsPreparePayDto.getPayOrderNo() + "_" + RandomCodeUtils.sixRandom();
                moveUploadInfoFeedetailListRequest.setFeedetlSn(feedetl_sn);
                moveUploadInfoFeedetailListRequest.setPsnNo(hsPreparePayDto.getPsnNo());
                moveUploadInfoFeedetailListRequest.setDiseCodg(hsPreparePayDto.getDiseCodg());
                moveUploadInfoFeedetailListRequest.setRxCircFlag("0");
                moveUploadInfoFeedetailListRequest.setFeeOcurTime(DateUtils.getCurrentDate((String)"yyyy-MM-dd HH:mm:ss"));
                moveUploadInfoFeedetailListRequest.setMedListCodg(outTreatmentDetails.getMedicalInsuranceCode());
                moveUploadInfoFeedetailListRequest.setMedinsListCodg(Objects.isNull(outTreatmentDetails.getTreatmentCode()) ? String.valueOf(outTreatmentDetails.getOutTreatmentId()) : outTreatmentDetails.getTreatmentCode());
                moveUploadInfoFeedetailListRequest.setMedType(hsPreparePayDto.getMedType());
                moveUploadInfoFeedetailListRequest.setMedListName(outTreatmentDetails.getTreatmentName());
                moveUploadInfoFeedetailListRequest.setMedListSpc("");
                moveUploadInfoFeedetailListRequest.setDetItemFeeSumamt(outTreatmentDetails.getTotalAmount().toString());
                moveUploadInfoFeedetailListRequest.setCnt(outTreatmentDetails.getQuantity().toString());
                moveUploadInfoFeedetailListRequest.setPric(outTreatmentDetails.getUnitPriceAmount().toString());
                moveUploadInfoFeedetailListRequest.setAcordDeptCodg(sysDoctorIdVo.getDepartmentId());
                moveUploadInfoFeedetailListRequest.setAcordDeptName(sysDoctorIdVo.getDepartmentName());
                moveUploadInfoFeedetailListRequest.setBilgDeptName(sysDoctorIdVo.getDepartmentName());
                moveUploadInfoFeedetailListRequest.setBilgDeptCodg(sysDoctorIdVo.getDepartmentId());
                moveUploadInfoFeedetailListRequest.setBilgDrCodg(sysDoctorIdVo.getHsCode());
                moveUploadInfoFeedetailListRequest.setBilgDrName(sysDoctorIdVo.getUserName());
                moveUploadInfoFeedetailListRequest.setBilgDeptCodg(sysDoctorIdVo.getDepartmentId());
                moveUploadInfoFeedetailListRequest.setBilgDeptName(sysDoctorIdVo.getDepartmentName());
                moveUploadInfoFeedetailListRequest.setBilgDrCodg(sysDoctorIdVo.getHsCode());
                moveUploadInfoFeedetailListRequest.setOrdersDrCode(sysDoctorIdVo.getHsCode());
                moveUploadInfoFeedetailListRequest.setOrdersDrName(sysDoctorIdVo.getUserName());
                String insuranceAuditFlag = OrderSettleTypeEnum.HS_SELF.getCode().equals(outOrder.getSettleTypeCode()) ? "2" : "1";
                moveUploadInfoFeedetailListRequest.setHospApprFlag(insuranceAuditFlag);
                feedetailList.add(moveUploadInfoFeedetailListRequest);
            }
        }
        List outMedicalRecordDiagnoses = this.outMedicalRecordDiagnosisService.queryMedicalRecordDiagnosisByOutpatientNo(hsPreparePayDto.getTenantId(), hsPreparePayDto.getOutpatientNo());
        for (int i = 0; i < outMedicalRecordDiagnoses.size(); ++i) {
            OutMedicalRecordDiagnosis outMedicalRecordDiagnosis = (OutMedicalRecordDiagnosis)outMedicalRecordDiagnoses.get(i);
            MoveUploadInfoDiseinfoListRequest moveUploadInfoDiseinfoListRequest = new MoveUploadInfoDiseinfoListRequest();
            moveUploadInfoDiseinfoListRequest.setDiagSrtNo(i + 2 + "");
            moveUploadInfoDiseinfoListRequest.setDiagType("2".equals(outMedicalRecordDiagnosis.getDiagnosticType()) ? "3" : "1");
            if (Objects.isNull(outMedicalRecordDiagnosis.getHsIcdCode())) {
                QueryWrapper query = new QueryWrapper();
                query.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
                query.eq((Object)"icd_code", (Object)outMedicalRecordDiagnosis.getIcdCode());
                OutIcdItem outIcdItem = (OutIcdItem)this.outIcdItemMapper.selectOne((Wrapper)query);
                moveUploadInfoDiseinfoListRequest.setDiagCode(outIcdItem.getMedicalCode());
                moveUploadInfoDiseinfoListRequest.setDiagName(outIcdItem.getMedicalName());
            } else {
                moveUploadInfoDiseinfoListRequest.setDiagCode(outMedicalRecordDiagnosis.getHsIcdCode());
                moveUploadInfoDiseinfoListRequest.setDiagName(outMedicalRecordDiagnosis.getHsDiagnosis());
            }
            moveUploadInfoDiseinfoListRequest.setDiagDept(sysDoctorIdVo.getDepartmentName());
            moveUploadInfoDiseinfoListRequest.setDiseDorName(sysDoctorIdVo.getUserName());
            moveUploadInfoDiseinfoListRequest.setDiagTime(DateUtils.dateFormat((Date)admission.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            moveUploadInfoDiseinfoListRequest.setValiFlag("1");
            moveUploadInfoDiseinfoListRequest.setDiseDorNo(sysDoctorIdVo.getHsCode());
            diseinfo.add(moveUploadInfoDiseinfoListRequest);
        }
        regMovePayInfoRequest.setAcctUsedFlag(Objects.isNull(hsPreparePayDto.getAcctUsedFlag()) ? "1" : hsPreparePayDto.getAcctUsedFlag());
        regMovePayInfoRequest.setInsuplc_admdvs(insuinfo1.getInsuplc_admdvs());
        regMovePayInfoRequest.setRegistrationRequest(registrationRequest);
        regMovePayInfoRequest.setMdtrtinfo(moveMdtrtinfo);
        regMovePayInfoRequest.setFeedetailList(feedetailList);
        regMovePayInfoRequest.setDiseinfoList(diseinfo);
        regMovePayInfoRequest.setPayAuthNo(hsPreparePayDto.getPayAuthNo());
        regMovePayInfoRequest.setChrgBchno(hsPreparePayDto.getPayOrderNo());
        regMovePayInfoRequest.setPayOrderNo(hsPreparePayDto.getPayOrderNo());
        log.info("moveHsPreparePayment\u533b\u4fdd\u9884\u7ed3\u7b97\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)regMovePayInfoRequest));
        ResponseData responseData = this.hsServiceFeign.movePreparePayment(regMovePayInfoRequest);
        log.info("moveHsPreparePayment\u533b\u4fdd\u9884\u7ed3\u7b97\u51fa\u53c2{}", (Object)JSONObject.toJSONString((Object)responseData));
        if (Objects.isNull(responseData) || responseData.isError()) {
            return ResponseData.error((String)responseData.getMsg());
        }
        ((MoveCreateOrderResponse)responseData.getData()).setPayOrderNo(((FeeBillCreationVo)orderCharge.getData()).getPayOrderNo());
        return responseData;
    }

    @Transactional
    public ResponseData<?> moveOrderInfo(MoveOrderInfoRequest moveOrderInfoRequest) {
        ResponseData responseData = this.hsServiceFeign.moveOrderInfo(moveOrderInfoRequest);
        log.info("\u79fb\u52a8\u7aef\u533b\u4fdd\u8ba2\u5355\u7ed3\u7b97\u7ed3\u679c\u67e5\u8be2\u51fa\u53c2{}", (Object)responseData);
        if (Objects.isNull(responseData) || responseData.isError()) {
            return responseData;
        }
        return ResponseData.success((Object)responseData.getData());
    }

    public ResponseData<?> payNotify(MoveOrderInfoRequest moveOrderInfoRequest) {
        log.info("payNotify:{}", (Object)JSONObject.toJSONString((Object)moveOrderInfoRequest));
        ResponseData responseData = this.hsServiceFeign.moveOrderInfo(moveOrderInfoRequest);
        log.info("\u79fb\u52a8\u7aef\u533b\u4fdd\u8ba2\u5355\u7ed3\u7b97\u7ed3\u679c\u67e5\u8be2\u51fa\u53c2{}", (Object)responseData);
        if (Objects.isNull(responseData) || responseData.isError()) {
            return responseData;
        }
        MoveOrderInfoResponse response = (MoveOrderInfoResponse)responseData.getData();
        String ordStas = response.getOrdStas();
        if (!ordStas.equals("6")) {
            return ResponseData.error((String)"\u652f\u4ed8\u5931\u8d25\uff01");
        }
        String extData = response.getExtData();
        JSONObject extDataJson = JSON.parseObject((String)extData);
        String setlinfo2 = extDataJson.getString("setlinfo");
        MoveSetlinfo moveSetlinfo = (MoveSetlinfo)JSON.parseObject((String)setlinfo2, MoveSetlinfo.class);
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"pay_order_no", (Object)moveOrderInfoRequest.getPayOrderNo());
        OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)queryWrapper);
        if (outOrderPayment.getPaymentStatus().equals(PaymentStatusEnum.PAYMENT_COMPLETED.getValue())) {
            return ResponseData.success((Object)"\u652f\u4ed8\u6210\u529f,\u652f\u4ed8\u72b6\u6001\u5df2\u66f4\u65b0");
        }
        AdmissionEntity admission = this.admissionMapper.queryAdmissionByOutpatientNo(outOrderPayment.getOutpatientNo(), outOrderPayment.getTenantId());
        BaseResponse outpatientsettlement = BaseResponse.success((Object)moveSetlinfo);
        outOrderPayment.setHsPayInfo(JSONObject.toJSONString((Object)outpatientsettlement));
        if (BigDecimal.ZERO.compareTo(moveSetlinfo.getPsnCashPay()) < 0) {
            outOrderPayment.setPaymentMethod(PaymentMethodEnum.PAY_WECHAT.getValue());
            outOrderPayment.setPayChannel("WX");
        } else {
            outOrderPayment.setPaymentMethod(PaymentMethodEnum.PAY_MEDICAL_INSURANCE.getValue());
            outOrderPayment.setPayChannel(PaymentMethodEnum.PAY_MEDICAL_INSURANCE.getPayChannel());
        }
        HsSettlementInfoEntity hsSettlementInfoEntity = new HsSettlementInfoEntity();
        outOrderPayment.setPaymentStatus(PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        hsSettlementInfoEntity.setSettlmentStatus("1");
        outOrderPayment.setPaymentType(PaymentTypeEnum.ONLINE_PAYMENT.getValue());
        outOrderPayment.setPsnNo(moveSetlinfo.getPsnNo());
        outOrderPayment.setMdtrtId(moveSetlinfo.getMdtrtId());
        outOrderPayment.setSetlId(moveSetlinfo.getSetlId());
        outOrderPayment.setPaymentTime(DateUtils.stringToFullDate((String)moveSetlinfo.getSetlTime()));
        outOrderPayment.setPayCost(moveSetlinfo.getAcctPay());
        outOrderPayment.setPubCost(moveSetlinfo.getFundPaySumamt());
        outOrderPayment.setActualPayment(moveSetlinfo.getMedfeeSumamt());
        outOrderPayment.setOwnCost(moveSetlinfo.getPsnCashPay());
        outOrderPayment.setPaymentTransactionNo(moveSetlinfo.getSetlId());
        outOrderPayment.setCheckerId(Integer.valueOf(9001));
        outOrderPayment.setCheckerName("XHY");
        outOrderPayment.setInsuplcAdmdvs(admission.getInsuplcAdmdvs());
        outOrderPayment.setInsutype(moveSetlinfo.getInsutype());
        this.outOrderPaymentMapper.updateById((Object)outOrderPayment);
        QueryWrapper queryOrderWrapper = new QueryWrapper();
        ((QueryWrapper)queryOrderWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"pay_order_no", (Object)moveOrderInfoRequest.getPayOrderNo());
        List outOrderList = this.outOrderMapper.selectList((Wrapper)queryOrderWrapper);
        ArrayList<OutOrderPaymentRecord> outOrderPaymentRecords = new ArrayList<OutOrderPaymentRecord>();
        for (OutOrder order : outOrderList) {
            List list;
            order.setPaymentStatus(PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
            order.setDeliveryStatus(DeliveryStatusEnum.DELIVERY_SHIPPED.getValue());
            int num = this.outOrderMapper.updateById((Object)order);
            if (num == 0) {
                throw new RunDisplayException("\u53d8\u66f4\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
            }
            String transactionNo = UUIDUtils.getTransactionNo();
            OutOrderPaymentRecord outOrderPaymentRecord = new OutOrderPaymentRecord();
            BeanUtils.copyProperties((Object)outOrderPayment, (Object)outOrderPaymentRecord);
            outOrderPaymentRecord.setDeliveryStatus(order.getDeliveryStatus());
            outOrderPaymentRecord.setOrderNo(order.getOrderNo());
            outOrderPaymentRecord.setStatus(PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
            outOrderPaymentRecord.setAmount(order.getAmount());
            outOrderPaymentRecord.setTotalAmount(order.getAmount());
            outOrderPaymentRecord.setActualPayment(outOrderPaymentRecord.getTotalAmount());
            outOrderPaymentRecord.setPaymentStatus(outOrderPayment.getPaymentStatus());
            outOrderPaymentRecord.setQuantity(Integer.valueOf(1));
            outOrderPaymentRecord.setOperationType(OperationTypeEnum.PAYMENT.getValue());
            outOrderPaymentRecord.setTransactionNumber(transactionNo);
            if (outOrderPaymentRecord.getId() == null && (list = this.outOrderPaymentRecordMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutOrderPaymentRecord::getTransactionNumber, (Object)transactionNo)).eq(OutOrderPaymentRecord::getPaymentStatus, (Object)outOrderPayment.getPaymentStatus())).eq(OutOrderPaymentRecord::getOrderNo, (Object)order.getOrderNo())).eq(OutOrderPaymentRecord::getAmount, (Object)order.getAmount())).eq(OutOrderPaymentRecord::getOperationType, (Object)OperationTypeEnum.PAYMENT.getValue()))).size() > 0) {
                Integer id = ((OutOrderPaymentRecord)list.get(0)).getId();
                outOrderPaymentRecord.setId(id);
            }
            outOrderPaymentRecords.add(outOrderPaymentRecord);
        }
        Integer recordSize = this.outOrderPaymentRecordMapper.batchInsert(outOrderPaymentRecords);
        if (recordSize.intValue() != outOrderList.size()) {
            throw new RunDisplayException("\u8bb0\u5f55\u652f\u4ed8\u8bb0\u5f55\u5931\u8d25");
        }
        String SETLINFO = extDataJson.getString("SETLINFO");
        Setlinfo setlinfo1 = (Setlinfo)JSON.parseObject((String)SETLINFO, Setlinfo.class);
        BeanUtils.copyProperties((Object)setlinfo1, (Object)hsSettlementInfoEntity);
        hsSettlementInfoEntity.setSetldetail(extDataJson.getString("setldetail"));
        hsSettlementInfoEntity.setTenantId(Integer.valueOf(1));
        hsSettlementInfoEntity.setInsuplc_admdvs(admission.getInsuplcAdmdvs());
        log.info("\u652f\u4ed8\u63d2\u5165\u533b\u4fdd\u7ed3\u7b97\u4fe1\u606f\uff0c{}", (Object)JSONObject.toJSONString((Object)hsSettlementInfoEntity));
        this.outHsSettlementInfoMapper.insert((Object)hsSettlementInfoEntity);
        JSONArray jsonArray = JSONObject.parseArray((String)hsSettlementInfoEntity.getSetldetail());
        if (jsonArray != null && !jsonArray.isEmpty()) {
            ArrayList<OutHsSettlementInfoDetaiEntity> detailList = new ArrayList<OutHsSettlementInfoDetaiEntity>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                OutHsSettlementInfoDetaiEntity detail = new OutHsSettlementInfoDetaiEntity();
                detail.setTenantId(hsSettlementInfoEntity.getTenantId());
                detail.setSetlId(hsSettlementInfoEntity.getSetl_id());
                detail.setFundPayType(jsonObject.getString("fund_pay_type"));
                if (!StrUtil.isBlank((CharSequence)detail.getFundPayType())) {
                    SysDictValueDTO sysDictValueDTO = new SysDictValueDTO();
                    sysDictValueDTO.setType("fund_pay_type");
                    sysDictValueDTO.setValue(detail.getFundPayType());
                    ResponseData pageResponseData = this.sysServiceFeign.sysDictValueById(sysDictValueDTO, hsSettlementInfoEntity.getTenantId() + "");
                    List data = ((Page)pageResponseData.getData()).getRecords();
                    detail.setFundPayTypeName(data == null || data.isEmpty() ? "" : ((SysDictValueVo)data.get(0)).getLabel());
                }
                detail.setFundPayamt(jsonObject.getBigDecimal("fund_payamt"));
                detail.setInscpScpAmt(jsonObject.getBigDecimal("inscp_scp_amt"));
                detail.setSetlProcInfo(jsonObject.getString("setl_proc_info"));
                detailList.add(detail);
            }
            this.outHsSettlementInfoDetailMapper.insertList(detailList);
        }
        log.info("\u81ea\u52a8\u53d1\u836f\u5f00\u59cb\uff1a{}", (Object)JSONObject.toJSONString((Object)outOrderList));
        List strings = this.outOrderMapper.dispenseMedicineByOrder(outOrderList);
        log.info("\u81ea\u52a8\u53d1\u836fstrings:{}", (Object)strings);
        for (String string : strings) {
            OutPrescriptionDto dto = new OutPrescriptionDto();
            dto.setPrescriptionNo(string);
            dto.setTenantId(Integer.valueOf(1));
            dto.setOperatorId(Integer.valueOf(9001));
            dto.setOperatorName("XHY");
            log.info("\u81ea\u52a8\u53d1\u836fdto:{}", (Object)JSON.toJSONString((Object)dto));
            dto.setMethodType("\u3010outPayServiceImpl\u3011\uff1apayNotify");
            ResponseData dispenseMedicineResponse = this.outPrescriptionService.dispenseMedicine(dto);
            log.info("\u81ea\u52a8\u53d1\u836f\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)dispenseMedicineResponse));
        }
        log.info("\u81ea\u52a8\u53d1\u836f\u7ed3\u675f");
        if (moveOrderInfoRequest.getDeliverystationno() != null && (moveOrderInfoRequest.getDeliverystationno() == 2 || moveOrderInfoRequest.getDeliverystationno() == 4)) {
            QueryWrapper orderQueryWrapper = new QueryWrapper();
            orderQueryWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
            orderQueryWrapper.eq((Object)"pay_order_no", (Object)moveOrderInfoRequest.getPayOrderNo());
            OutOrder outOrder = (OutOrder)this.outOrderMapper.selectOne((Wrapper)orderQueryWrapper);
            if (outOrder != null) {
                SysEasyEntity sysEasyEntity = new SysEasyEntity();
                sysEasyEntity.setId(outOrder.getOutpatientNo());
                ArrayList<String> list = new ArrayList<String>();
                list.add(outOrder.getPrescriptionNo());
                sysEasyEntity.setIds(list.toArray(new String[list.size()]));
                if (moveOrderInfoRequest.getDeliverystationno() == 2) {
                    sysEasyEntity.setBakValue(moveOrderInfoRequest.getBakValue());
                    sysEasyEntity.setSourceName(moveOrderInfoRequest.getSourceName());
                    this.sdkServiceFeign.printerReceiptByHy(sysEasyEntity);
                } else if (moveOrderInfoRequest.getDeliverystationno() == 4) {
                    sysEasyEntity.setBakJsonStr(moveOrderInfoRequest.getBakJsonStr());
                    this.sdkServiceFeign.printerReceiptDelivery(sysEasyEntity);
                }
            }
        }
        return ResponseData.success();
    }

    public ResponseData<?> refundNotify(MoveOrderInfoRequest moveOrderInfoRequest) {
        ResponseData drugResponseData;
        log.info("\u5fae\u4fe1\u533b\u4fdd\u9000\u8d39\u56de\u8c03\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)moveOrderInfoRequest));
        MoveOrderInfoRequest moveOrderInfoRequest1 = new MoveOrderInfoRequest();
        moveOrderInfoRequest1.setPayOrdId(moveOrderInfoRequest.getPayOrdId());
        moveOrderInfoRequest1.setPayToken(moveOrderInfoRequest.getPayToken());
        moveOrderInfoRequest1.setIdNo(moveOrderInfoRequest.getIdNo());
        moveOrderInfoRequest1.setUserName(moveOrderInfoRequest.getUserName());
        moveOrderInfoRequest1.setIdType(moveOrderInfoRequest.getIdType());
        moveOrderInfoRequest1.setPayOrderNo(moveOrderInfoRequest.getPayOrderNo());
        log.info("\u5fae\u4fe1\u533b\u4fdd\u9000\u8d39\u5904\u7406\u540e\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)moveOrderInfoRequest1));
        ResponseData responseData = this.hsServiceFeign.moveOrderInfo(moveOrderInfoRequest1);
        log.info("\u79fb\u52a8\u7aef-\u9000\u8d39-\u533b\u4fdd\u8ba2\u5355\u7ed3\u7b97\u7ed3\u679c\u67e5\u8be2\u51fa\u53c2{}", (Object)responseData);
        if (Objects.isNull(responseData) || responseData.isError()) {
            return responseData;
        }
        MoveOrderInfoResponse response = (MoveOrderInfoResponse)responseData.getData();
        String ordStas = response.getOrdStas();
        if (!ordStas.equals("7")) {
            return ResponseData.error((String)"\u9000\u6b3e\u5931\u8d25!");
        }
        String extData = response.getExtData();
        JSONObject extDataJson = JSON.parseObject((String)extData);
        String setlinfo2 = extDataJson.getString("setlinfo");
        MoveSetlinfo moveSetlinfo = (MoveSetlinfo)JSON.parseObject((String)setlinfo2, MoveSetlinfo.class);
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"pay_order_no", (Object)moveOrderInfoRequest.getPayOrderNo());
        OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)queryWrapper);
        if (outOrderPayment.getPaymentStatus().equals(PaymentStatusEnum.PAYMENT_REFUNDED.getValue())) {
            return ResponseData.success((Object)"\u9000\u6b3e\u6210\u529f,\u652f\u4ed8\u72b6\u6001\u5df2\u66f4\u65b0");
        }
        AdmissionEntity admission = this.admissionMapper.queryAdmissionByOutpatientNo(outOrderPayment.getOutpatientNo(), outOrderPayment.getTenantId());
        BaseResponse outpatientsettlement = BaseResponse.success((Object)moveSetlinfo);
        outOrderPayment.setHsPayInfo(JSONObject.toJSONString((Object)outpatientsettlement));
        outOrderPayment.setActualPayment(moveSetlinfo.getMedfeeSumamt());
        HsSettlementInfoEntity hsSettlementInfoEntity = new HsSettlementInfoEntity();
        outOrderPayment.setPaymentStatus(PaymentStatusEnum.PAYMENT_REFUNDED.getValue());
        hsSettlementInfoEntity.setSettlmentStatus("2");
        outOrderPayment.setRefundCheckerId(Integer.valueOf(9001));
        outOrderPayment.setRefundCheckerName("XHY");
        outOrderPayment.setRefundTime(new Date());
        outOrderPayment.setRefundSetlId(response.getHiRefdSn());
        outOrderPayment.setActualPayment(BigDecimal.ZERO);
        outOrderPayment.setRefundAmount(response.getFeeSumamt());
        this.outOrderPaymentMapper.updateById((Object)outOrderPayment);
        Boolean isDrug = false;
        ArrayList<Object> presOrderList = new ArrayList<Object>();
        QueryWrapper queryOrderWrapper = new QueryWrapper();
        ((QueryWrapper)queryOrderWrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"pay_order_no", (Object)moveOrderInfoRequest.getPayOrderNo());
        List outOrderList = this.outOrderMapper.selectList((Wrapper)queryOrderWrapper);
        for (Object order : outOrderList) {
            if (!"20".equals(order.getOrderType()) && !"30".equals(order.getOrderType()) && !"40".equals(order.getOrderType())) continue;
            isDrug = true;
            presOrderList.add(order);
        }
        if (isDrug.booleanValue() && !(drugResponseData = this.outPrescriptionService.returnOfDrugInventoryQuantity(moveOrderInfoRequest.getTenantId(), presOrderList, moveOrderInfoRequest.getOpter_name(), new Integer(moveOrderInfoRequest.getOpter()))).isSuccess()) {
            return drugResponseData;
        }
        ArrayList<OutOrderPaymentRecord> outOrderPaymentRecords = new ArrayList<OutOrderPaymentRecord>();
        for (OutOrder order : outOrderList) {
            List list;
            order.setPaymentStatus(PaymentStatusEnum.PAYMENT_REFUNDED.getValue());
            int num = this.outOrderMapper.updateById((Object)order);
            if (num == 0) {
                throw new RunDisplayException("\u53d8\u66f4\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
            }
            String transactionNo = UUIDUtils.getTransactionNo();
            OutOrderPaymentRecord outOrderPaymentRecord = new OutOrderPaymentRecord();
            BeanUtils.copyProperties((Object)outOrderPayment, (Object)outOrderPaymentRecord);
            outOrderPaymentRecord.setDeliveryStatus(order.getDeliveryStatus());
            outOrderPaymentRecord.setOrderNo(order.getOrderNo());
            outOrderPaymentRecord.setStatus(PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
            outOrderPaymentRecord.setAmount(order.getAmount().negate());
            outOrderPaymentRecord.setTotalAmount(order.getAmount());
            outOrderPaymentRecord.setActualPayment(order.getRefundAmount().negate());
            outOrderPaymentRecord.setPaymentStatus(PaymentStatusEnum.PAYMENT_REFUND_CONFIRMED.getValue());
            outOrderPaymentRecord.setQuantity(Integer.valueOf(-1));
            outOrderPaymentRecord.setOperationType(OperationTypeEnum.PAYMENT_REFUND.getValue());
            outOrderPaymentRecord.setTransactionNumber(transactionNo);
            if (outOrderPaymentRecord.getId() == null && (list = this.outOrderPaymentRecordMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutOrderPaymentRecord::getTransactionNumber, (Object)transactionNo)).eq(OutOrderPaymentRecord::getPaymentStatus, (Object)outOrderPayment.getPaymentStatus())).eq(OutOrderPaymentRecord::getOrderNo, (Object)order.getOrderNo())).eq(OutOrderPaymentRecord::getAmount, (Object)order.getAmount())).eq(OutOrderPaymentRecord::getOperationType, (Object)OperationTypeEnum.PAYMENT.getValue()))).size() > 0) {
                Integer id = ((OutOrderPaymentRecord)list.get(0)).getId();
                outOrderPaymentRecord.setId(id);
            }
            outOrderPaymentRecords.add(outOrderPaymentRecord);
        }
        Integer recordSize = this.outOrderPaymentRecordMapper.batchInsert(outOrderPaymentRecords);
        if (recordSize.intValue() != outOrderList.size()) {
            throw new RunDisplayException("\u8bb0\u5f55\u652f\u4ed8\u8bb0\u5f55\u5931\u8d25");
        }
        String SETLINFO = moveOrderInfoRequest.getExpContent();
        Setlinfo setlinfo1 = (Setlinfo)JSON.parseObject((String)SETLINFO, Setlinfo.class);
        BeanUtils.copyProperties((Object)setlinfo1, (Object)hsSettlementInfoEntity);
        hsSettlementInfoEntity.setSetldetail(SETLINFO);
        hsSettlementInfoEntity.setTenantId(Integer.valueOf(1));
        hsSettlementInfoEntity.setRefdSetlFlag(Integer.valueOf(1));
        hsSettlementInfoEntity.setInsuplc_admdvs(admission.getInsuplcAdmdvs());
        log.info("\u9000\u6b3e\u533b\u4fdd\u7ed3\u7b97\u4fe1\u606f\uff0c{}", (Object)JSONObject.toJSONString((Object)hsSettlementInfoEntity));
        this.outHsSettlementInfoMapper.insert((Object)hsSettlementInfoEntity);
        JSONArray jsonArray = JSONObject.parseArray((String)hsSettlementInfoEntity.getSetldetail());
        if (jsonArray != null && !jsonArray.isEmpty()) {
            ArrayList<OutHsSettlementInfoDetaiEntity> detailList = new ArrayList<OutHsSettlementInfoDetaiEntity>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                OutHsSettlementInfoDetaiEntity detail = new OutHsSettlementInfoDetaiEntity();
                detail.setTenantId(hsSettlementInfoEntity.getTenantId());
                detail.setSetlId(hsSettlementInfoEntity.getSetl_id());
                detail.setFundPayType(jsonObject.getString("fund_pay_type"));
                if (!StrUtil.isBlank((CharSequence)detail.getFundPayType())) {
                    SysDictValueDTO sysDictValueDTO = new SysDictValueDTO();
                    sysDictValueDTO.setType("fund_pay_type");
                    sysDictValueDTO.setValue(detail.getFundPayType());
                    ResponseData pageResponseData = this.sysServiceFeign.sysDictValueById(sysDictValueDTO, hsSettlementInfoEntity.getTenantId() + "");
                    List data = ((Page)pageResponseData.getData()).getRecords();
                    detail.setFundPayTypeName(data == null || data.isEmpty() ? "" : ((SysDictValueVo)data.get(0)).getLabel());
                }
                detail.setFundPayamt(jsonObject.getBigDecimal("fund_payamt"));
                detail.setInscpScpAmt(jsonObject.getBigDecimal("inscp_scp_amt"));
                detail.setSetlProcInfo(jsonObject.getString("setl_proc_info"));
                detailList.add(detail);
            }
            this.outHsSettlementInfoDetailMapper.insertList(detailList);
        }
        return ResponseData.success();
    }

    public ResponseData wxPayRefundNotify(JSONObject jsonObject) {
        log.info("\u5fae\u4fe1\u652f\u4ed8\u9000\u8d39\u56de\u8c03\u5165\u53c2\uff1a{}", (Object)jsonObject.toJSONString());
        String payOrderNo = jsonObject.getString("payOrderNo");
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"payment_status", (Object)PaymentStatusEnum.PAYMENT_COMPLETED.getValue())).eq((Object)"pay_order_no", (Object)payOrderNo);
        OutOrder outOrder = (OutOrder)this.outOrderMapper.selectOne((Wrapper)queryWrapper);
        if (outOrder != null) {
            OutOrder order = new OutOrder();
            order.setId(outOrder.getId());
            order.setPaymentStatus(PaymentStatusEnum.PAYMENT_REFUNDED.getValue());
            order.setActualPayment(new BigDecimal("0"));
            order.setRefundAmount(outOrder.getTotalAmount());
            int t = this.outOrderMapper.updateById((Object)order);
            if (t == 0) {
                throw new RunDisplayException("\u53d8\u66f4\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
            }
            String orderType = order.getOrderType();
            if (OrderTypeEnum.REGISTERED_ORDINARY_ORDERS.getValue().equals(orderType)) {
                AdmissionEntity admissionEntity = new AdmissionEntity();
                admissionEntity.setStatus(AdmissionStatusEnum.RETIRMENT.getValue());
                this.admissionMapper.update((Object)admissionEntity, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(AdmissionEntity::getTenantId, (Object)order.getTenantId())).eq(AdmissionEntity::getOutpatientNo, (Object)order.getOutpatientNo()));
            }
        }
        QueryWrapper paymentWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)paymentWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"pay_order_no", (Object)payOrderNo)).eq((Object)"payment_status", (Object)PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        OutOrderPayment outOrderPayment = (OutOrderPayment)this.outOrderPaymentMapper.selectOne((Wrapper)paymentWrapper);
        if (outOrderPayment != null) {
            OutOrderPayment orderPayment = new OutOrderPayment();
            orderPayment.setId(outOrderPayment.getId());
            orderPayment.setPaymentStatus(PaymentStatusEnum.PAYMENT_REFUNDED.getValue());
            orderPayment.setActualPayment(new BigDecimal("0"));
            orderPayment.setRefundAmount(outOrderPayment.getTotalAmount());
            orderPayment.setRefundCheckerId(Integer.valueOf(9001));
            orderPayment.setRefundCheckerName("XHY");
            orderPayment.setRefundTime(new Date());
            int t = this.outOrderPaymentMapper.updateById((Object)orderPayment);
            if (t == 0) {
                throw new RunDisplayException("\u53d8\u66f4\u652f\u4ed8\u4fe1\u606f\u5931\u8d25");
            }
        }
        QueryWrapper paymentRecordWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)paymentRecordWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"pay_order_no", (Object)payOrderNo)).eq((Object)"payment_status", (Object)PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        OutOrderPaymentRecord outOrderPaymentRecord = (OutOrderPaymentRecord)this.outOrderPaymentRecordMapper.selectOne((Wrapper)paymentRecordWrapper);
        if (outOrderPaymentRecord != null) {
            OutOrderPaymentRecord orderPaymentRecord = new OutOrderPaymentRecord();
            orderPaymentRecord.setId(outOrderPaymentRecord.getId());
            orderPaymentRecord.setPaymentStatus(PaymentStatusEnum.PAYMENT_REFUNDED.getValue());
            orderPaymentRecord.setActualPayment(new BigDecimal("0"));
            int t = this.outOrderPaymentRecordMapper.updateById((Object)orderPaymentRecord);
            if (t == 0) {
                throw new RunDisplayException("\u53d8\u66f4\u652f\u4ed8\u4fe1\u606f\u5931\u8d25");
            }
        }
        return ResponseData.success();
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

