/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.model.OutEtubePatientInfoEntity;
import com.byh.outpatient.api.model.OutEtubeStudioInfoEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.vo.SysDoctorEntity;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutEtubeStudioInfoService;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class OutEtubeStudioInfoController {
    @Autowired
    private OutEtubeStudioInfoService outEtubeStudioInfoService;
    @Autowired
    private CommonRequest commonRequest;

    @RequestMapping(value={"/out/etube/studio/info/save"})
    public ResponseData outEtubeStudioInfoSave(@RequestBody @Valid OutEtubeStudioInfoEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timeStr = format.format(new Date());
        entity.setCreateTime(timeStr);
        this.outEtubeStudioInfoService.outEtubeStudioInfoSave(entity);
        return ResponseData.success().save();
    }

    @RequestMapping(value={"/out/etube/studio/info/select"})
    public ResponseData<List<OutEtubeStudioInfoEntity>> outEtubeStudioInfoSelect(@RequestBody @Valid OutEtubeStudioInfoEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        List list = this.outEtubeStudioInfoService.outEtubeStudioInfoSelect(entity);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/out/etube/studio/info/update"})
    public ResponseData outEtubeStudioInfoUpdate(@RequestBody @Valid OutEtubeStudioInfoEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        this.outEtubeStudioInfoService.outEtubeStudioInfoUpdate(entity);
        return ResponseData.success().update();
    }

    @RequestMapping(value={"/out/etube/studio/info/delete"})
    public ResponseData outEtubeStudioInfoDelete(@RequestBody @Valid OutEtubeStudioInfoEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        return this.outEtubeStudioInfoService.outEtubeStudioInfoDelete(entity);
    }

    @PostMapping(value={"/out/etube/studio/info/queryPeopleGroupStudio"})
    public ResponseData queryPeopleGroupStudio(@RequestBody @Valid OutEtubeStudioInfoEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        return this.outEtubeStudioInfoService.queryPeopleGroupStudio(entity);
    }

    @PostMapping(value={"/out/etube/studio/info/queryRelatedStudio"})
    public ResponseData<PageInfo<OutEtubeStudioInfoEntity>> queryRelatedStudio(@RequestBody @Valid OutEtubeStudioInfoEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        return this.outEtubeStudioInfoService.queryRelatedStudio(entity);
    }

    @PostMapping(value={"/out/etube/studio/info/queryPatientByStudio"})
    public ResponseData<PageInfo<OutEtubePatientInfoEntity>> queryPatientByStudio(@RequestBody @Valid OutEtubeStudioInfoEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        return this.outEtubeStudioInfoService.queryPatientByStudio(entity);
    }

    @PostMapping(value={"/out/etube/studio/info/queryDoctorByStudio"})
    public ResponseData<PageInfo<SysDoctorEntity>> queryDoctorByStudio(@RequestBody @Valid OutEtubeStudioInfoEntity entity) {
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        return this.outEtubeStudioInfoService.queryDoctorByStudio(entity);
    }
}

