/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.excel.OutFollowUpSettingsImportListener;
import com.byh.outpatient.api.model.OutCustomerServiceSettingsEntity;
import com.byh.outpatient.api.model.OutFollowUpSettingsImportVo;
import com.byh.outpatient.api.util.EasyExcelUtil;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutCustomerServiceSettingsService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class OutCustomerServiceSettingsController {
    @Autowired
    private OutCustomerServiceSettingsService outCustomerServiceSettingsService;
    @Autowired
    private CommonRequest commonRequest;
    public SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @PostMapping(value={"/out/follow/up/settings/importPatient"})
    public ResponseData importPatient(@RequestPart(value="file") MultipartFile file) throws IOException {
        List list = EasyExcelUtil.importExcel((MultipartFile)file, (Object)new OutFollowUpSettingsImportVo(), (Object)new OutFollowUpSettingsImportListener());
        this.outCustomerServiceSettingsService.importPatient(list);
        return ResponseData.success();
    }

    @ApiOperation(value="\u4fdd\u5b58\u5ba2\u670d\u8bbe\u7f6e", httpMethod="POST", notes="\u4fdd\u5b58\u5ba2\u670d\u8bbe\u7f6e")
    @RequestMapping(value={"/out/customer/service/settings/save"})
    public ResponseData outCustomerServiceSettingsSave(@RequestBody @Valid OutCustomerServiceSettingsEntity entity) {
        List patientIds = entity.getPatientIds();
        if (patientIds == null || patientIds.size() == 0) {
            return ResponseData.error((String)"\u60a3\u8005id\u4e3a\u7a7a");
        }
        Integer userId = this.commonRequest.getUserId();
        Integer tenant = this.commonRequest.getTenant();
        String changeRecord = entity.getChangeRecord();
        entity.setTenantId(tenant);
        entity.setChangeRecord(StringUtils.isNotBlank((CharSequence)changeRecord) ? changeRecord + "->" + userId : "" + userId);
        this.outCustomerServiceSettingsService.outCustomerServiceSettingsSave(entity);
        return ResponseData.success().save();
    }

    @ApiOperation(value="\u67e5\u8be2\u5ba2\u670d\u8bbe\u7f6e", httpMethod="POST", notes="\u67e5\u8be2\u5ba2\u670d\u8bbe\u7f6e")
    @RequestMapping(value={"/out/customer/service/settings/select"})
    public ResponseData<OutCustomerServiceSettingsEntity> outCustomerServiceSettingsSelect(@RequestBody @Valid OutCustomerServiceSettingsEntity entity) {
        entity.setTenantId(this.commonRequest.getTenant());
        PageInfo list = this.outCustomerServiceSettingsService.outCustomerServiceSettingsSelect(entity);
        return ResponseData.success((Object)list);
    }

    @ApiOperation(value="\u7f16\u8f91\u5ba2\u670d\u8bbe\u7f6e", httpMethod="POST", notes="\u7f16\u8f91\u5ba2\u670d\u8bbe\u7f6e")
    @RequestMapping(value={"/out/customer/service/settings/update"})
    public ResponseData outCustomerServiceSettingsUpdate(@RequestBody @Valid OutCustomerServiceSettingsEntity entity) {
        List patientIds = entity.getPatientIds();
        Integer oldUserId = entity.getOldUserId();
        Integer newUserId = entity.getNewUserId();
        if (!(patientIds != null && patientIds.size() != 0 || oldUserId != null && newUserId != null)) {
            return ResponseData.error((String)"\u53c2\u6570\u4e0d\u5b8c\u6574");
        }
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        this.outCustomerServiceSettingsService.outCustomerServiceSettingsUpdate(entity);
        return ResponseData.success().save();
    }

    @ApiOperation(value="\u5220\u9664\u5ba2\u670d\u8bbe\u7f6e", httpMethod="POST", notes="\u5220\u9664\u5ba2\u670d\u8bbe\u7f6e")
    @RequestMapping(value={"/out/customer/service/settings/delete"})
    public ResponseData outCustomerServiceSettingsDelete(@RequestBody @Valid OutCustomerServiceSettingsEntity entity) {
        List patientIds = entity.getPatientIds();
        if (patientIds == null || patientIds.size() == 0) {
            return ResponseData.error((String)"\u60a3\u8005id\u4e3a\u7a7a");
        }
        Integer tenant = this.commonRequest.getTenant();
        entity.setTenantId(tenant);
        this.outCustomerServiceSettingsService.outCustomerServiceSettingsDelete(entity);
        return ResponseData.success().delete();
    }
}

