/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.rocket;

import org.apache.rocketmq.spring.support.DefaultRocketMQListenerContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
public class EnvironmentIsolationConfig
implements BeanPostProcessor {
    private static Logger logger = LoggerFactory.getLogger(EnvironmentIsolationConfig.class);
    @Value(value="${rocketmq.environment.enabledIsolation:true}")
    private boolean enabledIsolation;
    @Value(value="${rocketmq.environment.name}")
    private String environmentName;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        logger.info("============rocketMQ\u5207\u6362\u73af\u5883==============" + this.enabledIsolation + "------" + this.environmentName);
        if (bean instanceof DefaultRocketMQListenerContainer) {
            logger.info("============\u5f00\u59cb\u8fdb\u5165==============");
            DefaultRocketMQListenerContainer container = (DefaultRocketMQListenerContainer)bean;
            if (this.enabledIsolation && StringUtils.hasText((String)this.environmentName)) {
                container.setTopic(String.join((CharSequence)"_", container.getTopic(), this.environmentName));
                container.setConsumerGroup(String.join((CharSequence)"_", container.getConsumerGroup(), this.environmentName));
            }
            return container;
        }
        logger.info("============\u8df3\u51fa==============");
        return bean;
    }
}

