/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.dto.drugSell.GenerateDrugSellDto;
import com.byh.outpatient.api.dto.drugSell.QueryDrugSellDto;
import com.byh.outpatient.api.model.drugSell.OutDrugSellEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutDrugSellService;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/outDrugSell"})
public class OutDrugSellController {
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private OutDrugSellService outDrugSellService;

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u5bfc\u51fa\u836f\u54c1\u9500\u552e\u5217\u8868")
    @PostMapping(value={"/exportDrugSellList"})
    public void exportDrugSellList(HttpServletResponse response, @RequestBody QueryDrugSellDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.outDrugSellService.exportDrugSellList(response, dto);
    }

    @ApiOperation(value="\u83b7\u53d6\u751f\u4ea7\u5382\u5546\u3001\u533b\u751f\u59d3\u540d\u3001\u5ba2\u670d\u59d3\u540d\u5206\u7ec4\u5217\u8868\u4fe1\u606f")
    @PostMapping(value={"/selectGroupList"})
    public ResponseData selectGroupList() {
        return ResponseData.success((Object)this.outDrugSellService.selectGroupList(this.commonRequest.getTenant()));
    }

    @ApiOperation(value="\u4fee\u6539\u836f\u54c1\u9500\u552e\u4fe1\u606f")
    @PostMapping(value={"/update"})
    public ResponseData update(@RequestBody OutDrugSellEntity entity) {
        entity.setCreateId(this.commonRequest.getUserId());
        entity.setCreateName(this.commonRequest.getUserName());
        this.outDrugSellService.update(entity);
        return ResponseData.success((Object)"\u66f4\u65b0\u6210\u529f");
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u836f\u54c1\u9500\u552e\u5217\u8868\u4fe1\u606f")
    @PostMapping(value={"/selectPageList"})
    public ResponseData selectPageList(@RequestBody QueryDrugSellDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.outDrugSellService.selectPageList(dto));
    }

    @ApiOperation(value="\u751f\u6210\u6307\u5b9a\u65f6\u95f4\u5185\u7684\u836f\u54c1\u9500\u552e\u60c5\u51b5")
    @PostMapping(value={"/generateDrugSell"})
    public ResponseData generateDrugSell(@RequestBody GenerateDrugSellDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setCreateId(this.commonRequest.getUserId());
        dto.setCreateName(this.commonRequest.getUserName());
        this.outDrugSellService.generateDrugSell(dto);
        return ResponseData.success((Object)"\u751f\u6210\u6210\u529f");
    }
}

